/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kdoc.parser;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.PsiParser;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.kdoc.parser.KDocElementTypes;
import org.jetbrains.kotlin.kdoc.parser.KDocKnownTag;

public class KDocParser
implements PsiParser {
    @Override
    @NotNull
    public ASTNode parse(IElementType root2, PsiBuilder builder) {
        PsiBuilder.Marker rootMarker = builder.mark();
        if (builder.getTokenType() == KDocTokens.START) {
            builder.advanceLexer();
        }
        PsiBuilder.Marker currentSectionMarker = builder.mark();
        while (!builder.eof()) {
            if (builder.getTokenType() == KDocTokens.TAG_NAME) {
                currentSectionMarker = KDocParser.parseTag(builder, currentSectionMarker);
                continue;
            }
            if (builder.getTokenType() == KDocTokens.END) {
                if (currentSectionMarker != null) {
                    currentSectionMarker.done(KDocElementTypes.KDOC_SECTION);
                    currentSectionMarker = null;
                }
                builder.advanceLexer();
                continue;
            }
            builder.advanceLexer();
        }
        if (currentSectionMarker != null) {
            currentSectionMarker.done(KDocElementTypes.KDOC_SECTION);
        }
        rootMarker.done(root2);
        ASTNode aSTNode = builder.getTreeBuilt();
        if (aSTNode == null) {
            KDocParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static PsiBuilder.Marker parseTag(PsiBuilder builder, PsiBuilder.Marker currentSectionMarker) {
        String tagName = builder.getTokenText();
        KDocKnownTag knownTag = KDocKnownTag.Companion.findByTagName(tagName);
        if (knownTag != null && knownTag.isSectionStart()) {
            currentSectionMarker.done(KDocElementTypes.KDOC_SECTION);
            currentSectionMarker = builder.mark();
        }
        PsiBuilder.Marker tagStart = builder.mark();
        builder.advanceLexer();
        while (!builder.eof() && !KDocParser.isAtEndOfTag(builder)) {
            builder.advanceLexer();
        }
        tagStart.done(KDocElementTypes.KDOC_TAG);
        return currentSectionMarker;
    }

    private static boolean isAtEndOfTag(PsiBuilder builder) {
        if (builder.getTokenType() == KDocTokens.END) {
            return true;
        }
        if (builder.getTokenType() == KDocTokens.LEADING_ASTERISK) {
            int lookAheadCount = 1;
            if (builder.lookAhead(1) == KDocTokens.TEXT) {
                ++lookAheadCount;
            }
            if (builder.lookAhead(lookAheadCount) == KDocTokens.TAG_NAME) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/kdoc/parser/KDocParser", "parse"));
    }
}

