/* Generated by wayland-scanner 1.21.0 */

#ifndef HARDWARE_INTEGRATION_SERVER_PROTOCOL_H
#define HARDWARE_INTEGRATION_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_hardware_integration The hardware_integration protocol
 * @section page_ifaces_hardware_integration Interfaces
 * - @subpage page_iface_qt_hardware_integration - compostors communicates supported buffer sharing extensions
 * @section page_copyright_hardware_integration Copyright
 * <pre>
 *
 * Copyright (C) 2015 The Qt Company Ltd.
 * SPDX-License-Identifier: LicenseRef-Qt-Commercial OR BSD-3-Clause
 * </pre>
 */
struct qt_hardware_integration;

#ifndef QT_HARDWARE_INTEGRATION_INTERFACE
#define QT_HARDWARE_INTEGRATION_INTERFACE
/**
 * @page page_iface_qt_hardware_integration qt_hardware_integration
 * @section page_iface_qt_hardware_integration_desc Description
 *
 * Using this protocol the compositor can signal to clients which buffer sharing extensions
 * the client should use
 * @section page_iface_qt_hardware_integration_api API
 * See @ref iface_qt_hardware_integration.
 */
/**
 * @defgroup iface_qt_hardware_integration The qt_hardware_integration interface
 *
 * Using this protocol the compositor can signal to clients which buffer sharing extensions
 * the client should use
 */
extern const struct wl_interface qt_hardware_integration_interface;
#endif

#define QT_HARDWARE_INTEGRATION_CLIENT_BACKEND 0
#define QT_HARDWARE_INTEGRATION_SERVER_BACKEND 1

/**
 * @ingroup iface_qt_hardware_integration
 */
#define QT_HARDWARE_INTEGRATION_CLIENT_BACKEND_SINCE_VERSION 1
/**
 * @ingroup iface_qt_hardware_integration
 */
#define QT_HARDWARE_INTEGRATION_SERVER_BACKEND_SINCE_VERSION 1


/**
 * @ingroup iface_qt_hardware_integration
 * Sends an client_backend event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_hardware_integration_send_client_backend(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, QT_HARDWARE_INTEGRATION_CLIENT_BACKEND, name);
}

/**
 * @ingroup iface_qt_hardware_integration
 * Sends an server_backend event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
qt_hardware_integration_send_server_backend(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, QT_HARDWARE_INTEGRATION_SERVER_BACKEND, name);
}

#ifdef  __cplusplus
}
#endif

#endif
