"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupIndexRoutes = setupIndexRoutes;

var _constants = require("../utils/constants");

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function setupIndexRoutes(services, router) {
  const {
    indexService
  } = services;
  router.get({
    path: _constants.API.INDICES_BASE,
    validate: {}
  }, indexService.getIndices);
  router.post({
    path: `${_constants.API.INDICES_BASE}`,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.getIndexFields);
  router.post({
    path: _constants.API.UPDATE_ALIASES,
    validate: {
      body: _configSchema.schema.any()
    }
  }, indexService.updateAliases);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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