"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregateFunction = void 0;

var _node = require("../node");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class AggregateFunction extends _node.PPLNode {
  constructor(name, children, statsFunctionName, valueExpression, percentileAggFunction) {
    super(name, children);
    this.statsFunctionName = statsFunctionName;
    this.valueExpression = valueExpression;
    this.percentileAggFunction = percentileAggFunction;
  }

  getTokens() {
    return {
      name: this.statsFunctionName,
      value_expression: this.valueExpression,
      percentile_agg_function: this.percentileAggFunction
    };
  }

  toString() {
    if (this.statsFunctionName && this.valueExpression) {
      return `${this.statsFunctionName}(${this.valueExpression})`;
    } else if (this.statsFunctionName) {
      return `${this.statsFunctionName}()`;
    } else if (this.percentileAggFunction) {
      return `${this.percentileAggFunction}`;
    }

    return '';
  }

}

exports.AggregateFunction = AggregateFunction;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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