/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.srtp.crypto;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jitsi.srtp.crypto.CipherFactory;
import org.jitsi.srtp.crypto.JitsiOpenSslProvider;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public class Aes {
    private static final Logger logger = new LoggerImpl(Aes.class.getName());
    private static final int BLOCK_SIZE = 16;
    private static final String CIPHER_FACTORY_SIMPLE_CLASS_NAME = CipherFactory.class.getSimpleName();
    private static final CipherFactory DEFAULT_FACTORY = new SunJCECipherFactory();
    private static CipherFactory[] factories;
    private static final Map<String, CipherFactory> fastestFactories;
    private static String FACTORY_CLASS_NAME;
    private static final Class<?>[] FACTORY_CLASSES;
    private static Class<? extends CipherFactory> factoryClass;
    private static final int BENCHMARK_SIZE = 1250;
    private static final int NUM_WARMUPS = 11000;
    private static final int NUM_BENCHMARKS = 10;
    private static final byte[] in;
    private static final byte[] out;
    private static final Random random;

    public static synchronized void setFactoryClassName(String name) {
        FACTORY_CLASS_NAME = name;
        factoryClass = null;
    }

    private static CipherFactory benchmark(CipherFactory[] factories, int keySize, String transformation) {
        long minTime = Long.MAX_VALUE;
        CipherFactory minFactory = null;
        StringBuilder log = new StringBuilder();
        for (int f = 0; f < factories.length; ++f) {
            CipherFactory factory = factories[f];
            if (factory == null) continue;
            boolean chosenFactoryClass = factory.getClass().equals(factoryClass);
            try {
                Cipher cipher = factory.createCipher(transformation);
                if (cipher == null) {
                    factories[f] = null;
                    continue;
                }
                int numWarmups = chosenFactoryClass ? 0 : 11000;
                int numBenchmarks = chosenFactoryClass ? 1 : 10;
                BenchmarkOperation benchmark = BenchmarkOperation.getBenchmark(transformation, keySize);
                if (!chosenFactoryClass) {
                    for (int i = 0; i < numWarmups; ++i) {
                        benchmark.run(cipher);
                    }
                }
                long startTime = System.nanoTime();
                for (int i = 0; i < numBenchmarks; ++i) {
                    benchmark.run(cipher);
                }
                long endTime = System.nanoTime();
                long time = (endTime - startTime) / (long)numBenchmarks;
                if (chosenFactoryClass) {
                    return factory;
                }
                if (time < minTime) {
                    minTime = time;
                    minFactory = factory;
                }
                if (log.length() != 0) {
                    log.append(", ");
                }
                log.append(Aes.getSimpleClassName(factory)).append(' ').append(time);
                continue;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (t instanceof ThreadDeath) {
                    throw (ThreadDeath)t;
                }
                logger.warn("Chosen factory class \"" + FACTORY_CLASS_NAME + "\" not working for " + transformation + ": " + t.getMessage());
            }
        }
        if (log.length() != 0) {
            logger.info(() -> "AES benchmark (of execution times expressed in nanoseconds): " + log + " for " + transformation);
        }
        return minFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cipher createCipher(String transformation) {
        Class<Aes> clazz = Aes.class;
        synchronized (Aes.class) {
            CipherFactory factory = fastestFactories.getOrDefault(transformation, null);
            boolean warmup = true;
            if (factory == null) {
                try {
                    factory = Aes.getCipherFactory(transformation, warmup);
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    } else {
                        if (t instanceof ThreadDeath) {
                            throw (ThreadDeath)t;
                        }
                        logger.warn(() -> "Failed to initialize an optimized AES implementation: " + t.getLocalizedMessage());
                    }
                }
                finally {
                    CipherFactory oldFactory;
                    if (factory == null) {
                        factory = fastestFactories.getOrDefault(transformation, DEFAULT_FACTORY);
                    }
                    if ((oldFactory = fastestFactories.put(transformation, factory)) != factory) {
                        logger.info("Will employ AES implemented by " + Aes.getSimpleClassName(factory) + " for " + transformation + ".");
                    }
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            try {
                return factory.createCipher(transformation);
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
    }

    private static String getEffectiveFactoryClassName() {
        Object factoryClassName = FACTORY_CLASS_NAME;
        if (factoryClassName == null || ((String)factoryClassName).length() == 0) {
            return null;
        }
        if (Character.isUpperCase(((String)factoryClassName).charAt(0)) && !((String)factoryClassName).contains(".") && !((String)factoryClassName).endsWith(CIPHER_FACTORY_SIMPLE_CLASS_NAME)) {
            factoryClassName = Aes.class.getName() + "$" + (String)factoryClassName + CIPHER_FACTORY_SIMPLE_CLASS_NAME;
        }
        return factoryClassName;
    }

    private static CipherFactory[] createCipherFactories() {
        String factoryClassName;
        Class<CipherFactory> factoryClass = Aes.factoryClass;
        Class<?>[] factoryClasses = FACTORY_CLASSES;
        boolean add = true;
        if (factoryClass == null && (factoryClassName = Aes.getEffectiveFactoryClassName()) != null) {
            for (Class<?> clazz : factoryClasses) {
                if (clazz == null || !clazz.getName().equals(factoryClassName) || !CipherFactory.class.isAssignableFrom(clazz)) continue;
                Aes.factoryClass = factoryClass = clazz;
                add = false;
                break;
            }
            if (add) {
                try {
                    Class<?> clazz = Class.forName(factoryClassName);
                    if (CipherFactory.class.isAssignableFrom(clazz)) {
                        Aes.factoryClass = factoryClass = clazz;
                    }
                }
                catch (Throwable t) {
                    if (t instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    if (t instanceof ThreadDeath) {
                        throw (ThreadDeath)t;
                    }
                    logger.warn(() -> "Failed to employ class " + factoryClassName + " as an AES implementation: " + t.getLocalizedMessage());
                }
            }
        }
        if (factoryClass != null) {
            Class[] newFactoryClasses;
            if (add) {
                for (Class<?> clazz : factoryClasses) {
                    if (!factoryClass.equals(clazz)) continue;
                    add = false;
                    break;
                }
                if (add) {
                    newFactoryClasses = new Class[1 + factoryClasses.length];
                    newFactoryClasses[0] = factoryClass;
                    System.arraycopy(factoryClasses, 0, newFactoryClasses, 1, factoryClasses.length);
                }
            } else {
                newFactoryClasses = new Class[factoryClasses.length];
                newFactoryClasses[0] = factoryClass;
                int i = 1;
                for (Class<?> clazz : factoryClasses) {
                    if (factoryClass.equals(clazz)) continue;
                    newFactoryClasses[i] = clazz;
                    ++i;
                }
                factoryClasses = newFactoryClasses;
            }
        }
        return Aes.createCipherFactories(factoryClasses);
    }

    private static CipherFactory[] createCipherFactories(Class<?>[] classes2) {
        CipherFactory[] factories = new CipherFactory[classes2.length];
        int i = 0;
        for (Class<?> clazz : classes2) {
            try {
                if (!CipherFactory.class.isAssignableFrom(clazz)) continue;
                CipherFactory factory = DEFAULT_FACTORY.getClass().equals(clazz) ? DEFAULT_FACTORY : (CipherFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                factories[i++] = factory;
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    continue;
                }
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        return factories;
    }

    private static CipherFactory getCipherFactory(String transformation, boolean warmup) {
        CipherFactory[] factories = Aes.factories;
        int keySize = 16;
        if (factories == null) {
            factories = Aes.createCipherFactories();
            Aes.factories = factories;
        }
        CipherFactory minFactory = Aes.benchmark(factories, 16, transformation);
        return minFactory;
    }

    private static String getSimpleClassName(CipherFactory factory) {
        String suffix;
        Class<?> clazz = factory.getClass();
        String className = clazz.getSimpleName();
        if (className.length() == 0) {
            className = clazz.getName();
        }
        if (className.endsWith(suffix = CIPHER_FACTORY_SIMPLE_CLASS_NAME)) {
            String prefix;
            String simpleClassName = className.substring(0, className.length() - suffix.length());
            if (simpleClassName.startsWith(prefix = Aes.class.getName() + "$")) {
                className = simpleClassName.substring(prefix.length());
            } else if (simpleClassName.contains(".")) {
                Package pkg = Aes.class.getPackage();
                if (pkg != null && simpleClassName.startsWith(prefix = pkg.getName() + ".")) {
                    className = simpleClassName.substring(prefix.length());
                }
            } else {
                className = simpleClassName;
            }
        }
        return className;
    }

    static {
        fastestFactories = new HashMap<String, CipherFactory>();
        FACTORY_CLASS_NAME = null;
        FACTORY_CLASSES = new Class[]{OpenSSLCipherFactory.class, SunJCECipherFactory.class, BouncyCastleCipherFactory.class, SunPKCS11CipherFactory.class};
        in = new byte[1250];
        out = new byte[1266];
        random = new Random();
    }

    public static class SunPKCS11CipherFactory
    extends CipherFactory {
        private static Provider provider;
        private static boolean useProvider;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static synchronized Provider getProvider() throws Exception {
            Provider provider = SunPKCS11CipherFactory.provider;
            if (provider == null && useProvider) {
                try {
                    Class<?> clazz = Class.forName("sun.security.pkcs11.SunPKCS11");
                    if (Provider.class.isAssignableFrom(clazz)) {
                        Constructor<?> contructor = clazz.getConstructor(String.class);
                        String name = null;
                        Package pkg = Aes.class.getPackage();
                        if (pkg != null) {
                            name = pkg.getName();
                        }
                        if (name == null || name.length() == 0) {
                            name = "org.jitsi.srtp";
                        }
                        provider = (Provider)contructor.newInstance("--name=" + name + "\\nnssDbMode=noDb\\nattributes=compatibility");
                    }
                }
                finally {
                    if (provider == null) {
                        useProvider = false;
                    } else {
                        SunPKCS11CipherFactory.provider = provider;
                    }
                }
            }
            return provider;
        }

        public SunPKCS11CipherFactory() throws Exception {
            super(SunPKCS11CipherFactory.getProvider());
        }

        static {
            useProvider = true;
        }
    }

    public static class SunJCECipherFactory
    extends CipherFactory {
        public SunJCECipherFactory() {
            super("SunJCE");
        }
    }

    public static class BouncyCastleCipherFactory
    extends CipherFactory {
        public BouncyCastleCipherFactory() {
            super(new BouncyCastleProvider());
        }
    }

    public static class OpenSSLCipherFactory
    extends CipherFactory {
        private boolean trySuperApi = true;
        private Constructor<Cipher> cipherConstructor;
        private Field cipherProviderField;

        public OpenSSLCipherFactory() {
            super(new JitsiOpenSslProvider());
        }

        private synchronized void getMethods() throws NoSuchAlgorithmException {
            if (this.cipherConstructor == null || this.cipherProviderField == null) {
                try {
                    this.cipherConstructor = Cipher.class.getDeclaredConstructor(CipherSpi.class, String.class);
                    this.cipherConstructor.setAccessible(true);
                    this.cipherProviderField = Cipher.class.getDeclaredField("provider");
                    this.cipherProviderField.setAccessible(true);
                }
                catch (NoSuchFieldException | NoSuchMethodException e) {
                    this.cipherConstructor = null;
                    this.cipherProviderField = null;
                    throw new NoSuchAlgorithmException("Cannot instantiate OpenSSL Cipher");
                }
            }
        }

        @Override
        public Cipher createCipher(String transformation) throws Exception {
            if (this.trySuperApi) {
                try {
                    return super.createCipher(transformation);
                }
                catch (SecurityException e) {
                    this.trySuperApi = false;
                }
            }
            this.getMethods();
            Provider.Service s2 = this.provider.getService("Cipher", transformation);
            CipherSpi spi = (CipherSpi)s2.newInstance(null);
            Cipher cipher = this.cipherConstructor.newInstance(spi, transformation);
            this.cipherProviderField.set(cipher, this.provider);
            return cipher;
        }
    }

    private static class EcbBenchmark
    extends BenchmarkOperation {
        private final Key keySpec;

        public EcbBenchmark(int keySize) {
            byte[] key = new byte[keySize];
            Random random = Aes.random;
            random.nextBytes(key);
            random.nextBytes(in);
            this.keySpec = new SecretKeySpec(key, "AES");
        }

        @Override
        public void run(Cipher cipher) throws Exception {
            cipher.init(1, this.keySpec);
            cipher.update(in, 0, in.length, out, 0);
        }
    }

    private static class GcmBenchmark
    extends BenchmarkOperation {
        private static final int AAD_SIZE = 20;
        private final Key keySpec;
        private final byte[] aad = new byte[20];
        private final byte[] iv = new byte[12];

        public GcmBenchmark(int keySize) {
            byte[] key = new byte[keySize];
            Random random = Aes.random;
            random.nextBytes(key);
            random.nextBytes(this.iv);
            random.nextBytes(this.aad);
            random.nextBytes(in);
            this.keySpec = new SecretKeySpec(key, "AES");
        }

        @Override
        public void run(Cipher cipher) throws Exception {
            this.iv[0] = (byte)(this.iv[0] ^ 1);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, this.iv);
            cipher.init(1, this.keySpec, gcmSpec);
            cipher.updateAAD(this.aad, 0, this.aad.length);
            cipher.doFinal(in, 0, in.length, out, 0);
        }
    }

    private static class CtrBenchmark
    extends BenchmarkOperation {
        private final Key keySpec;
        private final IvParameterSpec ivSpec;

        public CtrBenchmark(int keySize) {
            byte[] key = new byte[keySize];
            byte[] iv = new byte[16];
            Random random = Aes.random;
            random.nextBytes(key);
            random.nextBytes(iv);
            random.nextBytes(in);
            this.keySpec = new SecretKeySpec(key, "AES");
            this.ivSpec = new IvParameterSpec(iv);
        }

        @Override
        public void run(Cipher cipher) throws Exception {
            cipher.init(1, this.keySpec, this.ivSpec);
            cipher.doFinal(in, 0, in.length, out, 0);
        }
    }

    private static abstract class BenchmarkOperation {
        private BenchmarkOperation() {
        }

        abstract void run(Cipher var1) throws Exception;

        static BenchmarkOperation getBenchmark(String transformation, int keySize) throws Exception {
            if (transformation.contains("/CTR/")) {
                return new CtrBenchmark(keySize);
            }
            if (transformation.contains("/GCM")) {
                return new GcmBenchmark(keySize);
            }
            if (transformation.contains("/ECB/")) {
                return new EcbBenchmark(keySize);
            }
            throw new NoSuchAlgorithmException("Unsupported transformation " + transformation + " for benchmark");
        }
    }
}

