/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.hibernate.jpa.spi.JpaCompliance;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.query.criteria.JpaFrom;
import org.hibernate.query.criteria.JpaJoin;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.hql.spi.SqmPathRegistry;
import org.hibernate.query.sqm.AliasCollisionException;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.SqmTreeCreationLogger;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.select.SqmAliasedNode;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;
import org.hibernate.spi.NavigablePath;

public class SqmPathRegistryImpl
implements SqmPathRegistry {
    private final SqmCreationProcessingState associatedProcessingState;
    private final JpaCompliance jpaCompliance;
    private final Map<NavigablePath, SqmPath<?>> sqmPathByPath = new HashMap();
    private final Map<NavigablePath, SqmFrom<?, ?>> sqmFromByPath = new HashMap();
    private final Map<String, SqmFrom<?, ?>> sqmFromByAlias = new HashMap();
    private final List<SqmAliasedNode<?>> simpleSelectionNodes = new ArrayList();

    public SqmPathRegistryImpl(SqmCreationProcessingState associatedProcessingState) {
        this.associatedProcessingState = associatedProcessingState;
        this.jpaCompliance = associatedProcessingState.getCreationState().getCreationContext().getJpaMetamodel().getJpaCompliance();
    }

    @Override
    public void register(SqmPath<?> sqmPath) {
        SqmPath<?> previousPath;
        SqmTreeCreationLogger.LOGGER.tracef("SqmProcessingIndex#register(SqmPath) : %s", (Object)sqmPath.getNavigablePath());
        if (sqmPath instanceof SqmFrom) {
            String aliasToUse;
            SqmFrom previousFrom;
            SqmFrom sqmFrom = (SqmFrom)sqmPath;
            String alias = sqmPath.getExplicitAlias();
            if (alias != null && (previousFrom = this.sqmFromByAlias.put(aliasToUse = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias, sqmFrom)) != null) {
                throw new AliasCollisionException(String.format(Locale.ENGLISH, "Alias [%s] used for multiple from-clause elements : %s, %s", alias, previousFrom, sqmPath));
            }
            SqmFrom previousFromByPath = this.sqmFromByPath.put(sqmPath.getNavigablePath(), sqmFrom);
            if (previousFromByPath != null) {
                throw new ParsingException(String.format(Locale.ROOT, "Registration for SqmFrom [%s] overrode previous registration: %s -> %s", sqmPath.getNavigablePath(), previousFromByPath, sqmFrom));
            }
        }
        if ((previousPath = this.sqmPathByPath.put(sqmPath.getNavigablePath(), sqmPath)) instanceof SqmFrom) {
            throw new ParsingException(String.format(Locale.ROOT, "Registration for path [%s] overrode previous registration: %s -> %s", sqmPath.getNavigablePath(), previousPath, sqmPath));
        }
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromByPath(NavigablePath navigablePath) {
        return (X)this.sqmFromByPath.get(navigablePath);
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromByAlias(String alias, boolean searchParent) {
        String localAlias = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias;
        SqmFrom<?, ?> registered = this.sqmFromByAlias.get(localAlias);
        if (registered != null) {
            return (X)registered;
        }
        SqmCreationProcessingState parentProcessingState = this.associatedProcessingState.getParentProcessingState();
        if (searchParent && parentProcessingState != null) {
            Object parentRegistered;
            do {
                parentRegistered = parentProcessingState.getPathRegistry().findFromByAlias(alias, false);
            } while ((parentProcessingState = parentProcessingState.getParentProcessingState()) != null && parentRegistered == null);
            if (parentRegistered != null) {
                JpaFrom correlated;
                SqmSubQuery selectQuery = (SqmSubQuery)this.associatedProcessingState.getProcessingQuery();
                if (parentRegistered instanceof Root) {
                    correlated = selectQuery.correlate((Root)parentRegistered);
                } else if (parentRegistered instanceof Join) {
                    correlated = selectQuery.correlate((Join)parentRegistered);
                } else if (parentRegistered instanceof SqmCrossJoin) {
                    correlated = selectQuery.correlate((SqmCrossJoin)parentRegistered);
                } else if (parentRegistered instanceof SqmEntityJoin) {
                    correlated = selectQuery.correlate((SqmEntityJoin)parentRegistered);
                } else {
                    throw new UnsupportedOperationException("Can't correlate from node: " + parentRegistered);
                }
                this.register((SqmPath<?>)((Object)correlated));
                return (X)correlated;
            }
        }
        return null;
    }

    @Override
    public <X extends SqmFrom<?, ?>> X findFromExposing(String navigableName) {
        SqmFrom<?, ?> found = null;
        for (Map.Entry<NavigablePath, SqmFrom<?, ?>> entry : this.sqmFromByPath.entrySet()) {
            SqmFrom<?, ?> fromElement = entry.getValue();
            if (!this.definesAttribute(fromElement.getReferencedPathSource(), navigableName)) continue;
            if (found != null) {
                throw new IllegalStateException("Multiple from-elements expose unqualified attribute : " + navigableName);
            }
            found = fromElement;
        }
        if (found == null && this.associatedProcessingState.getParentProcessingState() != null) {
            HqlLogging.QUERY_LOGGER.debugf("Unable to resolve unqualified attribute [%s] in local from-clause; checking parent ", navigableName);
            found = (SqmFrom<?, ?>)this.associatedProcessingState.getParentProcessingState().getPathRegistry().findFromExposing(navigableName);
        }
        HqlLogging.QUERY_LOGGER.debugf("Unable to resolve unqualified attribute [%s] in local from-clause", navigableName);
        return (X)found;
    }

    @Override
    public <X extends SqmFrom<?, ?>> X resolveFrom(NavigablePath navigablePath, Function<NavigablePath, SqmFrom<?, ?>> creator) {
        SqmTreeCreationLogger.LOGGER.tracef("SqmProcessingIndex#resolvePath(NavigablePath) : %s", (Object)navigablePath);
        SqmFrom<?, ?> existing = this.sqmFromByPath.get(navigablePath);
        if (existing != null) {
            return (X)existing;
        }
        SqmFrom<?, ?> sqmFrom = creator.apply(navigablePath);
        this.register(sqmFrom);
        return (X)sqmFrom;
    }

    @Override
    public <X extends SqmFrom<?, ?>> X resolveFrom(SqmPath<?> path) {
        SqmTreeCreationLogger.LOGGER.tracef("SqmProcessingIndex#resolvePath(SqmPath) : %s", path);
        SqmFrom<?, ?> existing = this.sqmFromByPath.get(path.getNavigablePath());
        if (existing != null) {
            return (X)existing;
        }
        JpaJoin sqmFrom = this.resolveFrom((SqmPath<?>)path.getLhs()).join(path.getNavigablePath().getLocalName());
        this.register((SqmPath<?>)((Object)sqmFrom));
        return (X)sqmFrom;
    }

    private boolean definesAttribute(SqmPathSource<?> containerType, String name) {
        return !(containerType.getSqmPathType() instanceof BasicDomainType) && containerType.findSubPathSource(name) != null;
    }

    @Override
    public SqmAliasedNode<?> findAliasedNodeByAlias(String alias) {
        assert (alias != null);
        String aliasToUse = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias;
        for (int i = 0; i < this.simpleSelectionNodes.size(); ++i) {
            SqmAliasedNode<?> node = this.simpleSelectionNodes.get(i);
            if (!aliasToUse.equals(node.getAlias())) continue;
            return node;
        }
        return null;
    }

    @Override
    public Integer findAliasedNodePosition(String alias) {
        if (alias == null) {
            return null;
        }
        String aliasToUse = this.jpaCompliance.isJpaQueryComplianceEnabled() ? alias.toLowerCase(Locale.getDefault()) : alias;
        for (int i = 0; i < this.simpleSelectionNodes.size(); ++i) {
            SqmAliasedNode<?> node = this.simpleSelectionNodes.get(i);
            if (!aliasToUse.equals(node.getAlias())) continue;
            return i + 1;
        }
        return null;
    }

    @Override
    public SqmAliasedNode<?> findAliasedNodeByPosition(int position) {
        return this.simpleSelectionNodes.get(position - 1);
    }

    @Override
    public void register(SqmAliasedNode<?> node) {
        this.checkResultVariable(node);
        this.simpleSelectionNodes.add(node);
    }

    private void checkResultVariable(SqmAliasedNode<?> selection) {
        String alias = selection.getAlias();
        if (alias == null) {
            return;
        }
        Integer position = this.findAliasedNodePosition(alias);
        if (position != null) {
            throw new AliasCollisionException(String.format(Locale.ENGLISH, "Alias [%s] is already used in same select clause [position=%s]", alias, position));
        }
    }
}

