/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm;

import jakarta.persistence.metamodel.Bindable;
import java.util.Locale;
import org.hibernate.metamodel.model.domain.DomainType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.SqmExpressible;
import org.hibernate.query.sqm.tree.SqmExpressibleAccessor;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public interface SqmPathSource<J>
extends SqmExpressible<J>,
Bindable<J>,
SqmExpressibleAccessor<J> {
    public String getPathName();

    public DomainType<?> getSqmPathType();

    public SqmPathSource<?> findSubPathSource(String var1);

    default public SqmPathSource<?> getSubPathSource(String name) {
        SqmPathSource<?> subPathSource = this.findSubPathSource(name);
        if (subPathSource == null) {
            throw new IllegalArgumentException((Throwable)((Object)new SemanticException(String.format(Locale.ROOT, "Could not resolve attribute '%s' of '%s'", name, this.getExpressible().getExpressibleJavaType().getJavaType().getTypeName()))));
        }
        return subPathSource;
    }

    default public SqmPathSource<?> getIntermediatePathSource(SqmPathSource<?> pathSource) {
        return null;
    }

    public SqmPath<J> createSqmPath(SqmPath<?> var1, SqmPathSource<?> var2);

    @Override
    default public SqmExpressible<J> getExpressible() {
        return this.getSqmPathType();
    }

    default public boolean isGeneric() {
        return false;
    }
}

