/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import oracle.jdbc.driver.parser.Cell;
import oracle.jdbc.driver.parser.Earley;
import oracle.jdbc.driver.parser.LexerToken;
import oracle.jdbc.driver.parser.Matriceable;
import oracle.jdbc.driver.parser.Matrix;
import oracle.jdbc.driver.parser.ParseNode;
import oracle.jdbc.driver.parser.Parseable;
import oracle.jdbc.driver.parser.Parser;
import oracle.jdbc.driver.parser.RuleTuple;
import oracle.jdbc.driver.parser.Token;
import oracle.jdbc.driver.parser.Tuple;
import oracle.jdbc.driver.parser.UnifiedRules;
import oracle.jdbc.driver.parser.util.Array;
import oracle.jdbc.driver.parser.util.Service;

public abstract class SqlEarley
extends Earley
implements Parseable {
    public static String[] keywords = new String[]{"'WITH'", "'SELECT'", "'FROM'", "'WHERE'", "'AND'", "'OR'", "'NOT'", "'DISTINCT'", "'UNION'", "'ALL'", "'INNER'", "'NATURAL'", "'ON'", "'INSERT'", "'UPDATE'", "'CREATE'", "'ALTER'", "'TABLE'", "'VALUES'", "'VARCHAR2'", "'INTEGER'", "'MULTISET'", "'WHEN'"};
    private int as;
    private int aliased_dml_table_expression_clause;
    private int at_sign;
    private int basic_decl_item;
    private int begin;
    private int body;
    private int boolean_primary;
    private int compound_expression;
    public int CONNECT;
    private int dbtools_command;
    private int dotted_name;
    public int decl_id;
    private int distinct;
    private int ELSE;
    private int expr;
    public int multiset_except;
    private int pkg_spec;
    private int pls_expr;
    public int query_block;
    public int select;
    public int simple_expression;
    public int sim_stmt;
    public int sql_statement;
    public int sql_statements;
    private int start;
    public int stmt;
    public int table_reference;
    private int unlabeled_nonblock_stmt;
    private static final Set<RuleTuple> origRules;
    private static final SqlEarley instance;
    private int[] whatToRecognize = new int[0];
    boolean oldSkipRanges = this.skipRanges;
    private Set<Integer> _keywords = new TreeSet<Integer>();

    public static SqlEarley getInstance() {
        return instance;
    }

    public static SqlEarley newPartialRecognizer() {
        return SqlEarley.newPartialRecognizer(new String[]{"sql_statement"});
    }

    public static SqlEarley newPartialRecognizer(String[] what2Recognize) {
        SqlEarley ret = new SqlEarley((Set)origRules){
            private int at_sign = this.getSymbol("at_sign");

            @Override
            protected boolean lookaheadOK(Tuple t, int pos, Matrix matrix) {
                return true;
            }

            @Override
            protected boolean scan(Matrix matrix, List<LexerToken> src) {
                boolean ret = super.scan(matrix, src);
                matrix.LAsuspect = null;
                return ret;
            }
        };
        for (String symbol : what2Recognize) {
            ret.addSymbol2Recognize(symbol);
        }
        return ret;
    }

    private SqlEarley(Set<RuleTuple> rules) {
        super(rules);
        this.initProperties();
        this.precomputePredictions();
    }

    private void initProperties() {
        this.initKeywords();
        this.as = this.getSymbol("'AS'");
        this.aliased_dml_table_expression_clause = this.getSymbol("aliased_dml_table_expression_clause");
        this.at_sign = this.getSymbol("at_sign");
        this.basic_decl_item = this.getSymbol("basic_decl_item");
        this.begin = this.getSymbol("'BEGIN'");
        this.body = this.getSymbol("'BODY'");
        this.boolean_primary = this.getSymbol("boolean_primary");
        this.compound_expression = this.getSymbol("compound_expression");
        this.CONNECT = this.getSymbol("CONNECT");
        this.dbtools_command = this.getSymbol("dbtools_command");
        this.dotted_name = this.getSymbol("dotted_name");
        this.decl_id = this.getSymbol("decl_id");
        this.distinct = this.getSymbol("'DISTINCT'");
        this.ELSE = this.getSymbol("'ELSE'");
        this.expr = this.getSymbol("expr");
        this.multiset_except = this.getSymbol("multiset_except");
        this.pkg_spec = this.getSymbol("pkg_spec");
        this.pls_expr = this.getSymbol("pls_expr");
        this.query_block = this.getSymbol("query_block");
        this.select = this.getSymbol("select");
        this.simple_expression = this.getSymbol("simple_expression");
        this.sim_stmt = this.getSymbol("sim_stmt");
        this.sql_statement = this.getSymbol("sql_statement");
        this.sql_statements = this.getSymbol("sql_statements");
        this.start = this.getSymbol("'START'");
        this.stmt = this.getSymbol("stmt");
        this.table_reference = this.getSymbol("table_reference");
        this.unlabeled_nonblock_stmt = this.getSymbol("unlabeled_nonblock_stmt");
        this.prioritizeRules();
    }

    private void prioritizeRules() {
        this.prioritizeRules(this.getSymbol("alter_pluggable_database[17,43)#"), new int[]{this.getSymbol("pdb_datafile_clause"), this.getSymbol("pdb_change_state_from_root")});
        this.prioritizeRules(this.getSymbol("alter_table[20,39)"), new int[]{this.getSymbol("constraint_clauses"), this.getSymbol("column_clauses"), this.getSymbol("alter_external_table")});
        this.prioritizeRules(this.getSymbol("analytic_function"), new int[]{this.getSymbol("count"), this.getSymbol("nth_value"), this.getSymbol("first_last_value"), this.getSymbol("listagg"), this.getSymbol("lag"), this.getSymbol("lead"), this.getSymbol("sum"), this.getSymbol("min"), this.getSymbol("max"), this.getSymbol("a_f")});
        String plsRule = "assoc_arg:  assoc_name_list  '='  '>'  pls_expr;";
        String sqlRule = "assoc_arg:  sim_expr  '='  '>'  expr;";
        this.swapRules(plsRule, sqlRule);
        this.prioritizeRules(this.getSymbol("basic_d"), new int[]{this.getSymbol("subprg_i"), this.getSymbol("object_d")});
        this.prioritizeRules(this.basic_decl_item, new int[]{this.getSymbol("pragma"), this.getSymbol("basic_d")});
        this.prioritizeRules(this.boolean_primary, new int[]{this.getSymbol("sim_expr"), this.getSymbol("condition"), this.getSymbol("function_expression")});
        String simExprRule = "boolean_primary:  sim_expr;";
        String boolPriRule = "boolean_primary:  condition;";
        this.swapRules(simExprRule, boolPriRule);
        this.prioritizeRules(this.getSymbol("cell_assignment[13,37)"), new int[]{this.getSymbol("multi_column_for_loop"), this.getSymbol("cell_assignment[14,21)")});
        this.prioritizeRules(this.getSymbol("col_properties"), new int[]{this.getSymbol("out_of_line_ref_constraint"), this.getSymbol("out_of_line_constraint"), this.getSymbol("column_definition")});
        this.prioritizeRules(this.getSymbol("column_definition[72,82)"), new int[]{this.getSymbol("inline_ref_constraint"), this.getSymbol("inline_constraint")});
        String rule2 = "insert_into_clause:  'INTO'  aliased_dml_table_expression_clause;";
        String rule3 = "insert_into_clause:  'INTO'  aliased_dml_table_expression_clause  insert_into_clause[13,25);";
        this.swapRules(rule2, rule3);
        this.prioritizeRules(this.getSymbol("comparison_condition"), new int[]{this.getSymbol("between_condition"), this.getSymbol("group_comparison_condition"), this.getSymbol("simple_comparison_condition")});
        this.prioritizeRules(this.compound_expression, new int[]{this.getSymbol("expr"), this.getSymbol("compound_expression[8,22)")});
        this.prioritizeRules(this.getSymbol("datetime_expression[32,57)"), new int[]{this.getSymbol("'DBTIMEZONE'"), this.getSymbol("string_literal"), this.expr});
        this.prioritizeRules(this.getSymbol("expr#"), new int[]{this.simple_expression, this.getSymbol("function_expression"), this.getSymbol("model_expression"), this.getSymbol("object_access_expression"), this.getSymbol("type_constructor_expression"), this.getSymbol("JSON_object_access_expr")});
        this.prioritizeRules(this.getSymbol("function_expression"), new int[]{this.getSymbol("function"), this.getSymbol("function_call")});
        this.prioritizeRules(this.getSymbol("function"), new int[]{this.getSymbol("aggregate_function"), this.getSymbol("analytic_function"), this.getSymbol("single_row_function"), this.getSymbol("user_defined_function"), this.getSymbol("object_reference_function")});
        this.prioritizeRules(this.getSymbol("group_by_col"), new int[]{this.getSymbol("rollup_cube_clause"), this.getSymbol("expr")});
        this.prioritizeRules(this.getSymbol("modify_column_clauses[14,21)"), new int[]{this.getSymbol("modify_col_visibility"), this.getSymbol("modify_col_properties"), this.getSymbol("virtual_column_definition")});
        this.prioritizeRules(this.pls_expr, new int[]{this.getSymbol("pls_expr"), this.getSymbol("and_expr")});
        this.prioritizeRules(this.getSymbol("query_table_expression"), new int[]{this.getSymbol("xmltable"), this.getSymbol("table_collection_expression"), this.getSymbol("function_expression")});
        this.prioritizeRules(this.getSymbol("select_term"), new int[]{this.expr, this.getSymbol("\"aliased_expr\"")});
        this.prioritizeRules(this.simple_expression, new int[]{this.getSymbol("'NULL'"), this.getSymbol("'CONNECT_BY_ROOT'"), this.getSymbol("'ROWID'"), this.getSymbol("'ROWNUM'"), this.getSymbol("'CONNECT_BY_ISCYCLE'"), this.getSymbol("'CONNECT_BY_ISLEAF'"), this.getSymbol("identifier"), this.getSymbol("column")});
        this.prioritizeRules(this.sim_stmt, new int[]{this.getSymbol("null_stmt"), this.getSymbol("exit_stmt"), this.getSymbol("continue_stmt"), this.getSymbol("raise_stmt"), this.getSymbol("return_stmt"), this.getSymbol("procedure_call")});
        this.prioritizeRules(this.getSymbol("ty_def"), new int[]{this.getSymbol("array_ty_def"), this.getSymbol("tbl_ty_def")});
        this.prioritizeRules(this.getSymbol("unconstrained_type_wo_datetime_wo_national"), new int[]{this.getSymbol("pls_number_datatypes"), this.getSymbol("link_expanded_n")});
        this.prioritizeRules(this.unlabeled_nonblock_stmt, new int[]{this.getSymbol("sql_stmt"), this.sim_stmt});
        this.prioritizeRules(this.getSymbol("values_clause[12,20)"), new int[]{this.getSymbol("par_expr_list"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause[31,73)"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
        this.prioritizeRules(this.getSymbol("windowing_clause[81,123)"), new int[]{this.getSymbol("'UNBOUNDED'"), this.expr});
    }

    private void prioritizeRules(int head, int[] symbols) {
        int[] ruleNumbers = new int[symbols.length];
        block0: for (int i = 0; i < this.rules.length; ++i) {
            Tuple t = this.rules[i];
            if (t.head != head || t.rhs.length != 1 && t.head != this.boolean_primary && t.head != this.basic_decl_item && t.head != this.compound_expression && t.head != this.simple_expression && t.head != this.pls_expr && t.head != this.unlabeled_nonblock_stmt && t.head != this.sim_stmt) continue;
            for (int j = 0; j < symbols.length; ++j) {
                if (t.rhs[0] != symbols[j]) continue;
                ruleNumbers[j] = i;
                continue block0;
            }
        }
        Tuple[] tuples = new Tuple[symbols.length];
        for (int j = 0; j < symbols.length; ++j) {
            tuples[j] = this.rules[ruleNumbers[j]];
        }
        Arrays.sort(ruleNumbers);
        for (int i = 0; i < ruleNumbers.length; ++i) {
            this.rules[ruleNumbers[i]] = tuples[i];
        }
    }

    public void addSymbol2Recognize(String additionalSymbol) {
        this.addSymbol2Recognize(this.getSymbol(additionalSymbol));
    }

    public void addSymbol2Recognize(int additionalSymbol) {
        int[] tmp = new int[this.whatToRecognize.length + 1];
        for (int i = 0; i < this.whatToRecognize.length; ++i) {
            if (this.whatToRecognize[i] == additionalSymbol) {
                return;
            }
            tmp[i] = this.whatToRecognize[i];
        }
        tmp[this.whatToRecognize.length] = additionalSymbol;
        this.whatToRecognize = tmp;
    }

    @Override
    protected void initCell00(List<LexerToken> src, Matrix matrix) {
        matrix.initCells(src.size());
        this.initCell(matrix, this.whatToRecognize, 0);
        LexerToken LAtoken = src.get(0);
        matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
    }

    @Override
    protected boolean scan(Matrix matrix, List<LexerToken> src) {
        int y = matrix.lastY();
        if (src.size() <= y) {
            return false;
        }
        LexerToken token = src.get(y);
        String tokUpper = token.content.toUpperCase();
        if ("@".equals(tokUpper)) {
            this.oldSkipRanges = this.skipRanges;
            this.skipRanges = false;
        }
        if (this.skipRanges != this.oldSkipRanges && (";".equals(tokUpper) || ",".equals(tokUpper))) {
            this.skipRanges = this.oldSkipRanges;
        }
        Integer suspect = (Integer)this.symbolIndexes.get("'" + tokUpper + "'");
        matrix.LAsuspect = null;
        if (y + 1 < src.size()) {
            LexerToken LAtoken = src.get(y + 1);
            matrix.LAsuspect = (Integer)this.symbolIndexes.get("'" + LAtoken.content.toUpperCase() + "'");
        }
        boolean ret = false;
        for (int i = matrix.allXs.length - 1; 0 <= i; --i) {
            int x = matrix.allXs[i];
            if (!this.scan(matrix, y, src, x, suspect)) continue;
            ret = true;
        }
        if (this.scan(matrix, y, src, y, suspect)) {
            ret = true;
        }
        return ret;
    }

    private boolean scan(Matrix matrix, int y, List<LexerToken> src, int x, Integer suspect) {
        long[] content = null;
        Cell candidateRules = matrix.get(x, y);
        if (candidateRules == null) {
            return false;
        }
        for (int j = 0; j < candidateRules.size(); ++j) {
            int pos = candidateRules.getPosition(j);
            int ruleNo = candidateRules.getRule(j);
            Tuple t = this.rules[ruleNo];
            if (t.size() - 1 < pos || !this.isScannedSymbol(y, src, pos, t, suspect) || !this.lookaheadOK(t, pos + 1, matrix)) continue;
            long cellElem = SqlEarley.makeMatrixCellElem(ruleNo, pos + 1, t);
            content = Array.insert(content, cellElem);
            if (t.rhs.length != pos + 1) continue;
            matrix.enqueue(Service.lPair(x, t.head));
        }
        if (content == null) {
            return false;
        }
        matrix.put(x, y + 1, new Parser.EarleyCell(content));
        matrix.allXs = Array.insert(matrix.allXs, x);
        return true;
    }

    @Override
    protected boolean isIdentifier(int y, List<LexerToken> src, int symbol, Integer suspect) {
        LexerToken next;
        if (symbol != this.identifier) {
            return false;
        }
        if (suspect != null && this._keywords.contains(suspect)) {
            return false;
        }
        LexerToken token = src.get(y);
        if (token.type == Token.DQUOTED_STRING) {
            return true;
        }
        if (token.type != Token.IDENTIFIER) {
            return false;
        }
        if (suspect == null) {
            return true;
        }
        LexerToken prior = null;
        if (0 < y) {
            prior = src.get(y - 1);
        }
        if ("TO".equalsIgnoreCase(token.content) && prior != null && ("YEAR".equalsIgnoreCase(prior.content) || "HOUR".equalsIgnoreCase(prior.content) || "MINUTE".equalsIgnoreCase(prior.content))) {
            return false;
        }
        if ("BY".equalsIgnoreCase(token.content) && prior != null && "CONNECT".equalsIgnoreCase(prior.content)) {
            return false;
        }
        if ("CASE".equalsIgnoreCase(token.content) && y + 1 < src.size() && "WHEN".equalsIgnoreCase(src.get((int)(y + 1)).content)) {
            return false;
        }
        if ("LEFT".equalsIgnoreCase(token.content) && y < src.size() - 1) {
            LexerToken next2 = src.get(y + 1);
            return !"JOIN".equalsIgnoreCase(next2.content);
        }
        if (prior != null && "FROM".equalsIgnoreCase(prior.content) && ("FIRST".equalsIgnoreCase(token.content) || "LAST".equalsIgnoreCase(token.content))) {
            next = null;
            if (y < src.size()) {
                next = src.get(y + 1);
            }
            if (next != null && ("OVER".equalsIgnoreCase(next.content) || "IGNORE".equalsIgnoreCase(next.content))) {
                return false;
            }
        }
        if ("NUMBER".equalsIgnoreCase(token.content)) {
            if (prior != null && "'.'".equalsIgnoreCase(prior.content)) {
                return false;
            }
            next = null;
            if (y < src.size()) {
                next = src.get(y + 1);
            }
            if (next != null && "'('".equalsIgnoreCase(next.content)) {
                LexerToken next2 = null;
                if (y < src.size() - 1) {
                    next2 = src.get(y + 2);
                }
                if (next2 != null && "')'".equalsIgnoreCase(next.content)) {
                    return false;
                }
            }
        }
        return !"AS".equalsIgnoreCase(token.content) || prior == null || !"@".equalsIgnoreCase(prior.content);
    }

    @Override
    protected boolean isScannedSymbol(int y, List<LexerToken> src, int pos, Tuple t, Integer suspect) {
        if (t.head == this.at_sign && "@".equals(src.get((int)y).content) && 0 <= src.get((int)(y + 1)).content.indexOf(58)) {
            return false;
        }
        int symbol = t.content(pos);
        if (symbol == this.dbtools_command) {
            LexerToken token = src.get(y);
            if (token.type == Token.DBTOOLS_COMMAND) {
                return true;
            }
        }
        return super.isScannedSymbol(y, src, pos, t, suspect);
    }

    @Override
    protected boolean notConfusedAsId(int suspect, int head, int pos) {
        return !(suspect == this.begin && (head == this.dotted_name || head == this.decl_id) && pos == 0 || suspect == this.start && head == this.table_reference && pos == 1 || suspect == this.distinct && head == this.multiset_except && pos == 3 || suspect == this.body && head == this.pkg_spec && pos == 1 || suspect == this.as && head == this.table_reference && pos == 1 || suspect == this.ELSE && head == this.aliased_dml_table_expression_clause && pos == 1);
    }

    @Override
    public void parse(List<LexerToken> src, Matriceable matrix) {
        super.parse(src, matrix);
    }

    private void initKeywords() {
        for (String k : keywords) {
            this._keywords.add(this.getSymbol(k));
        }
    }

    @Override
    public ParseNode treeForACell(List<LexerToken> src, Matrix m, Cell cell, int x, int y) {
        int rule = -1;
        int pos = -1;
        for (int i = 0; i < cell.size(); ++i) {
            rule = cell.getRule(i);
            Tuple t = this.rules[rule];
            if (t.head != this.sql_statements && t.head != this.select || this.rules[rule].rhs.length != (pos = cell.getPosition(i))) continue;
            return this.tree(src, m, x, y, rule, pos);
        }
        return super.treeForACell(src, m, cell, x, y);
    }

    static {
        try {
            origRules = UnifiedRules.getRules();
            instance = SqlEarley.newPartialRecognizer();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize SQL parser");
        }
    }
}

