/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.realm.entity;

import java.util.List;
import java.util.Map;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.utils.KeycloakModelUtils;

@DeepCloner.Root
public interface MapComponentEntity
extends UpdatableEntity,
AbstractEntity {
    public static MapComponentEntity fromModel(ComponentModel model) {
        MapComponentEntity entity = DeepCloner.DUMB_CLONER.newInstance(MapComponentEntity.class);
        String id = model.getId() == null ? KeycloakModelUtils.generateId() : model.getId();
        entity.setId(id);
        entity.setName(model.getName());
        entity.setProviderId(model.getProviderId());
        entity.setProviderType(model.getProviderType());
        entity.setSubType(model.getSubType());
        entity.setParentId(model.getParentId());
        entity.setConfig((Map<String, List<String>>)model.getConfig());
        return entity;
    }

    public static ComponentModel toModel(MapComponentEntity entity) {
        ComponentModel model = new ComponentModel();
        model.setId(entity.getId());
        model.setName(entity.getName());
        model.setProviderId(entity.getProviderId());
        model.setProviderType(entity.getProviderType());
        model.setSubType(entity.getSubType());
        model.setParentId(entity.getParentId());
        Map<String, List<String>> config = entity.getConfig();
        model.setConfig(config == null ? new MultivaluedHashMap() : new MultivaluedHashMap(config));
        return model;
    }

    public String getName();

    public void setName(String var1);

    public String getProviderId();

    public void setProviderId(String var1);

    public String getProviderType();

    public void setProviderType(String var1);

    public String getSubType();

    public void setSubType(String var1);

    public String getParentId();

    public void setParentId(String var1);

    public Map<String, List<String>> getConfig();

    public void setConfig(Map<String, List<String>> var1);
}

