/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.database.model.AutonomousContainerDatabaseSummary;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListAutonomousContainerDatabasesRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String autonomousExadataInfrastructureId;
    private String autonomousVmClusterId;
    private AutonomousContainerDatabaseSummary.InfrastructureType infrastructureType;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private AutonomousContainerDatabaseSummary.LifecycleState lifecycleState;
    private String availabilityDomain;
    private String displayName;
    private String serviceLevelAgreementType;
    private String cloudAutonomousVmClusterId;

    @ConstructorProperties(value={"compartmentId", "autonomousExadataInfrastructureId", "autonomousVmClusterId", "infrastructureType", "limit", "page", "sortBy", "sortOrder", "lifecycleState", "availabilityDomain", "displayName", "serviceLevelAgreementType", "cloudAutonomousVmClusterId"})
    ListAutonomousContainerDatabasesRequest(String compartmentId, String autonomousExadataInfrastructureId, String autonomousVmClusterId, AutonomousContainerDatabaseSummary.InfrastructureType infrastructureType, Integer limit, String page, SortBy sortBy, SortOrder sortOrder, AutonomousContainerDatabaseSummary.LifecycleState lifecycleState, String availabilityDomain, String displayName, String serviceLevelAgreementType, String cloudAutonomousVmClusterId) {
        this.compartmentId = compartmentId;
        this.autonomousExadataInfrastructureId = autonomousExadataInfrastructureId;
        this.autonomousVmClusterId = autonomousVmClusterId;
        this.infrastructureType = infrastructureType;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.lifecycleState = lifecycleState;
        this.availabilityDomain = availabilityDomain;
        this.displayName = displayName;
        this.serviceLevelAgreementType = serviceLevelAgreementType;
        this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).autonomousExadataInfrastructureId(this.autonomousExadataInfrastructureId).autonomousVmClusterId(this.autonomousVmClusterId).infrastructureType(this.infrastructureType).limit(this.limit).page(this.page).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).availabilityDomain(this.availabilityDomain).displayName(this.displayName).serviceLevelAgreementType(this.serviceLevelAgreementType).cloudAutonomousVmClusterId(this.cloudAutonomousVmClusterId);
    }

    public String toString() {
        return "ListAutonomousContainerDatabasesRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", autonomousExadataInfrastructureId=" + this.getAutonomousExadataInfrastructureId() + ", autonomousVmClusterId=" + this.getAutonomousVmClusterId() + ", infrastructureType=" + (Object)((Object)this.getInfrastructureType()) + ", limit=" + this.getLimit() + ", page=" + this.getPage() + ", sortBy=" + (Object)((Object)this.getSortBy()) + ", sortOrder=" + (Object)((Object)this.getSortOrder()) + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", availabilityDomain=" + this.getAvailabilityDomain() + ", displayName=" + this.getDisplayName() + ", serviceLevelAgreementType=" + this.getServiceLevelAgreementType() + ", cloudAutonomousVmClusterId=" + this.getCloudAutonomousVmClusterId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ListAutonomousContainerDatabasesRequest)) {
            return false;
        }
        ListAutonomousContainerDatabasesRequest other = (ListAutonomousContainerDatabasesRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$autonomousExadataInfrastructureId = this.getAutonomousExadataInfrastructureId();
        String other$autonomousExadataInfrastructureId = other.getAutonomousExadataInfrastructureId();
        if (this$autonomousExadataInfrastructureId == null ? other$autonomousExadataInfrastructureId != null : !this$autonomousExadataInfrastructureId.equals(other$autonomousExadataInfrastructureId)) {
            return false;
        }
        String this$autonomousVmClusterId = this.getAutonomousVmClusterId();
        String other$autonomousVmClusterId = other.getAutonomousVmClusterId();
        if (this$autonomousVmClusterId == null ? other$autonomousVmClusterId != null : !this$autonomousVmClusterId.equals(other$autonomousVmClusterId)) {
            return false;
        }
        AutonomousContainerDatabaseSummary.InfrastructureType this$infrastructureType = this.getInfrastructureType();
        AutonomousContainerDatabaseSummary.InfrastructureType other$infrastructureType = other.getInfrastructureType();
        if (this$infrastructureType == null ? other$infrastructureType != null : !((Object)((Object)this$infrastructureType)).equals((Object)other$infrastructureType)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        SortBy this$sortBy = this.getSortBy();
        SortBy other$sortBy = other.getSortBy();
        if (this$sortBy == null ? other$sortBy != null : !((Object)((Object)this$sortBy)).equals((Object)other$sortBy)) {
            return false;
        }
        SortOrder this$sortOrder = this.getSortOrder();
        SortOrder other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        AutonomousContainerDatabaseSummary.LifecycleState this$lifecycleState = this.getLifecycleState();
        AutonomousContainerDatabaseSummary.LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$availabilityDomain = this.getAvailabilityDomain();
        String other$availabilityDomain = other.getAvailabilityDomain();
        if (this$availabilityDomain == null ? other$availabilityDomain != null : !this$availabilityDomain.equals(other$availabilityDomain)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$serviceLevelAgreementType = this.getServiceLevelAgreementType();
        String other$serviceLevelAgreementType = other.getServiceLevelAgreementType();
        if (this$serviceLevelAgreementType == null ? other$serviceLevelAgreementType != null : !this$serviceLevelAgreementType.equals(other$serviceLevelAgreementType)) {
            return false;
        }
        String this$cloudAutonomousVmClusterId = this.getCloudAutonomousVmClusterId();
        String other$cloudAutonomousVmClusterId = other.getCloudAutonomousVmClusterId();
        return !(this$cloudAutonomousVmClusterId == null ? other$cloudAutonomousVmClusterId != null : !this$cloudAutonomousVmClusterId.equals(other$cloudAutonomousVmClusterId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ListAutonomousContainerDatabasesRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $autonomousExadataInfrastructureId = this.getAutonomousExadataInfrastructureId();
        result = result * 59 + ($autonomousExadataInfrastructureId == null ? 43 : $autonomousExadataInfrastructureId.hashCode());
        String $autonomousVmClusterId = this.getAutonomousVmClusterId();
        result = result * 59 + ($autonomousVmClusterId == null ? 43 : $autonomousVmClusterId.hashCode());
        AutonomousContainerDatabaseSummary.InfrastructureType $infrastructureType = this.getInfrastructureType();
        result = result * 59 + ($infrastructureType == null ? 43 : ((Object)((Object)$infrastructureType)).hashCode());
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        SortBy $sortBy = this.getSortBy();
        result = result * 59 + ($sortBy == null ? 43 : ((Object)((Object)$sortBy)).hashCode());
        SortOrder $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        AutonomousContainerDatabaseSummary.LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $availabilityDomain = this.getAvailabilityDomain();
        result = result * 59 + ($availabilityDomain == null ? 43 : $availabilityDomain.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $serviceLevelAgreementType = this.getServiceLevelAgreementType();
        result = result * 59 + ($serviceLevelAgreementType == null ? 43 : $serviceLevelAgreementType.hashCode());
        String $cloudAutonomousVmClusterId = this.getCloudAutonomousVmClusterId();
        result = result * 59 + ($cloudAutonomousVmClusterId == null ? 43 : $cloudAutonomousVmClusterId.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getAutonomousExadataInfrastructureId() {
        return this.autonomousExadataInfrastructureId;
    }

    public String getAutonomousVmClusterId() {
        return this.autonomousVmClusterId;
    }

    public AutonomousContainerDatabaseSummary.InfrastructureType getInfrastructureType() {
        return this.infrastructureType;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public AutonomousContainerDatabaseSummary.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getServiceLevelAgreementType() {
        return this.serviceLevelAgreementType;
    }

    public String getCloudAutonomousVmClusterId() {
        return this.cloudAutonomousVmClusterId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAutonomousContainerDatabasesRequest, Void> {
        private String compartmentId;
        private String autonomousExadataInfrastructureId;
        private String autonomousVmClusterId;
        private AutonomousContainerDatabaseSummary.InfrastructureType infrastructureType;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrder sortOrder;
        private AutonomousContainerDatabaseSummary.LifecycleState lifecycleState;
        private String availabilityDomain;
        private String displayName;
        private String serviceLevelAgreementType;
        private String cloudAutonomousVmClusterId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAutonomousContainerDatabasesRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.autonomousExadataInfrastructureId(o.getAutonomousExadataInfrastructureId());
            this.autonomousVmClusterId(o.getAutonomousVmClusterId());
            this.infrastructureType(o.getInfrastructureType());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.displayName(o.getDisplayName());
            this.serviceLevelAgreementType(o.getServiceLevelAgreementType());
            this.cloudAutonomousVmClusterId(o.getCloudAutonomousVmClusterId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAutonomousContainerDatabasesRequest build() {
            ListAutonomousContainerDatabasesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder autonomousExadataInfrastructureId(String autonomousExadataInfrastructureId) {
            this.autonomousExadataInfrastructureId = autonomousExadataInfrastructureId;
            return this;
        }

        public Builder autonomousVmClusterId(String autonomousVmClusterId) {
            this.autonomousVmClusterId = autonomousVmClusterId;
            return this;
        }

        public Builder infrastructureType(AutonomousContainerDatabaseSummary.InfrastructureType infrastructureType) {
            this.infrastructureType = infrastructureType;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(AutonomousContainerDatabaseSummary.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder serviceLevelAgreementType(String serviceLevelAgreementType) {
            this.serviceLevelAgreementType = serviceLevelAgreementType;
            return this;
        }

        public Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            return this;
        }

        public ListAutonomousContainerDatabasesRequest buildWithoutInvocationCallback() {
            return new ListAutonomousContainerDatabasesRequest(this.compartmentId, this.autonomousExadataInfrastructureId, this.autonomousVmClusterId, this.infrastructureType, this.limit, this.page, this.sortBy, this.sortOrder, this.lifecycleState, this.availabilityDomain, this.displayName, this.serviceLevelAgreementType, this.cloudAutonomousVmClusterId);
        }

        public String toString() {
            return "ListAutonomousContainerDatabasesRequest.Builder(compartmentId=" + this.compartmentId + ", autonomousExadataInfrastructureId=" + this.autonomousExadataInfrastructureId + ", autonomousVmClusterId=" + this.autonomousVmClusterId + ", infrastructureType=" + (Object)((Object)this.infrastructureType) + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", availabilityDomain=" + this.availabilityDomain + ", displayName=" + this.displayName + ", serviceLevelAgreementType=" + this.serviceLevelAgreementType + ", cloudAutonomousVmClusterId=" + this.cloudAutonomousVmClusterId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Displayname("DISPLAYNAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

