/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.formatter;

import com.vladsch.flexmark.ast.BlockQuote;
import com.vladsch.flexmark.formatter.NodeFormatterContext;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.format.MarkdownWriterBase;
import java.util.function.Consumer;

public class MarkdownWriter
extends MarkdownWriterBase<MarkdownWriter, Node, NodeFormatterContext> {
    public MarkdownWriter() {
        this(0);
    }

    public MarkdownWriter(int formatOptions) {
        super(formatOptions);
    }

    public boolean isLastBlockQuoteChild() {
        Node node = (Node)((NodeFormatterContext)this.context).getCurrentNode();
        Node parent = node.getParent();
        return parent instanceof BlockQuote && parent.getLastChild() == node;
    }

    public MarkdownWriter tailBlankLine(int count) {
        if (this.isLastBlockQuoteChild()) {
            CharSequence prefix = this.getPrefix();
            this.popPrefix();
            this.blankLine(count);
            this.pushPrefix();
            this.setPrefix(prefix, false);
        } else {
            this.blankLine(count);
        }
        return this;
    }

    public MarkdownWriter appendNonTranslating(CharSequence csq) {
        return this.appendNonTranslating(null, csq, null, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq) {
        return this.appendNonTranslating(prefix, csq, null, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix) {
        return this.appendNonTranslating(prefix, csq, suffix, null);
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2) {
        if (((NodeFormatterContext)this.context).isTransformingText()) {
            this.append(((NodeFormatterContext)this.context).transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    public MarkdownWriter appendNonTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2, Consumer<String> placeholderConsumer) {
        if (((NodeFormatterContext)this.context).isTransformingText()) {
            this.append(((NodeFormatterContext)this.context).transformNonTranslating(prefix, csq, suffix, suffix2));
        } else {
            this.append(csq);
        }
        return this;
    }

    public MarkdownWriter appendTranslating(CharSequence csq) {
        return this.appendTranslating(null, csq, null, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq) {
        return this.appendTranslating(prefix, csq, null, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix) {
        return this.appendTranslating(prefix, csq, suffix, null);
    }

    public MarkdownWriter appendTranslating(CharSequence prefix, CharSequence csq, CharSequence suffix, CharSequence suffix2) {
        if (((NodeFormatterContext)this.context).isTransformingText()) {
            this.append(((NodeFormatterContext)this.context).transformTranslating(prefix, csq, suffix, suffix2));
        } else {
            if (prefix != null) {
                this.append(prefix);
            }
            this.append(csq);
            if (suffix != null) {
                this.append(suffix);
            }
        }
        return this;
    }
}

