/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.repository;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitTag;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.GitRepositories;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.branch.BranchSynchronizer;
import org.netbeans.modules.git.ui.branch.CreateBranchAction;
import org.netbeans.modules.git.ui.branch.DeleteBranchAction;
import org.netbeans.modules.git.ui.branch.SetTrackingAction;
import org.netbeans.modules.git.ui.checkout.CheckoutRevisionAction;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.fetch.FetchAction;
import org.netbeans.modules.git.ui.fetch.PullAction;
import org.netbeans.modules.git.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.ui.history.SearchIncomingAction;
import org.netbeans.modules.git.ui.history.SearchOutgoingAction;
import org.netbeans.modules.git.ui.merge.MergeRevisionAction;
import org.netbeans.modules.git.ui.push.PushAction;
import org.netbeans.modules.git.ui.push.PushMapping;
import org.netbeans.modules.git.ui.push.PushToUpstreamAction;
import org.netbeans.modules.git.ui.repository.Bundle;
import org.netbeans.modules.git.ui.repository.ControlToolbar;
import org.netbeans.modules.git.ui.repository.OpenRepositoryAction;
import org.netbeans.modules.git.ui.repository.RepositoryBrowserAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.repository.Revision;
import org.netbeans.modules.git.ui.repository.RevisionListPanel;
import org.netbeans.modules.git.ui.repository.remote.RemoveRemoteConfig;
import org.netbeans.modules.git.ui.stash.ApplyStashAction;
import org.netbeans.modules.git.ui.stash.SaveStashAction;
import org.netbeans.modules.git.ui.stash.Stash;
import org.netbeans.modules.git.ui.tag.CreateTagAction;
import org.netbeans.modules.git.ui.tag.ManageTagsAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Actions;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;

public class RepositoryBrowserPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener,
ListSelectionListener,
MouseListener {
    private int sliderPos;
    AbstractNode root;
    private static final RequestProcessor RP = new RequestProcessor("RepositoryPanel", 1);
    private static final Logger LOG = Logger.getLogger(RepositoryBrowserPanel.class.getName());
    private final ExplorerManager manager;
    private final EnumSet<Option> options;
    private Revision currRevision;
    private File currRepository;
    public static final String PROP_REVISION_CHANGED = "RepositoryBrowserPanel.revision";
    public static final String PROP_REVISION_ACCEPTED = "RepositoryBrowserPanel.acceptedRevision";
    private final File[] roots;
    private String branchMergeWith;
    private static final String PROP_DELETE_ACTION = "RepoBrowser.deleteAction";
    public static final EnumSet<Option> OPTIONS_INSIDE_PANEL = EnumSet.of(Option.DISPLAY_BRANCHES_LOCAL, new Option[]{Option.DISPLAY_BRANCHES_REMOTE, Option.DISPLAY_REVISIONS, Option.EXPAND_BRANCHES, Option.EXPAND_TAGS, Option.SELECT_ACTIVE_BRANCH, Option.DISPLAY_TAGS});
    private static final HashMap<String, Image> cachedIcons = new HashMap(2);
    private JSplitPane jSplitPane1;
    final RevisionListPanel revisionsPanel1 = new RevisionListPanel();
    private final ControlToolbar toolbar = new ControlToolbar();
    private final BeanTreeView tree = new BeanTreeView();

    public RepositoryBrowserPanel() {
        this(EnumSet.complementOf(EnumSet.of(Option.DISPLAY_REVISIONS, Option.EXPAND_BRANCHES, Option.EXPAND_TAGS)), null, new File[0], null);
    }

    public RepositoryBrowserPanel(final EnumSet<Option> options, File repository, File[] roots, RepositoryInfo info) {
        Parameters.notNull((CharSequence)"roots", (Object)roots);
        this.currRepository = repository;
        this.root = options.contains((Object)Option.DISPLAY_ALL_REPOSITORIES) ? new AbstractNode((Children)new RepositoriesChildren()){

            public Action[] getActions(boolean context) {
                if (options.contains((Object)Option.ENABLE_POPUP)) {
                    return new Action[]{new OpenRepositoryAction()};
                }
                return super.getActions(context);
            }
        } : new RepositoryNode(repository, info);
        this.manager = new ExplorerManager();
        this.options = options;
        this.roots = roots;
        this.initComponents();
        if (!options.contains((Object)Option.DISPLAY_TOOLBAR)) {
            this.toolbar.setVisible(false);
        }
        this.tree.setRootVisible(false);
        this.tree.setVerticalScrollBarPolicy(22);
        if (!options.contains((Object)Option.DISPLAY_REVISIONS)) {
            this.remove(this.jSplitPane1);
            this.add((Component)this.tree, "Center");
        }
        if (options.contains((Object)Option.ENABLE_POPUP)) {
            this.getInputMap(1).put(KeyStroke.getKeyStroke(127, 0), "delete");
            this.getActionMap().put("delete", new DeleteAction());
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.getExplorerManager().setRootContext((Node)this.root);
        this.getExplorerManager().addPropertyChangeListener((PropertyChangeListener)this);
        if (this.toolbar.isVisible()) {
            this.attachToolbarListeners();
        }
        this.revisionsPanel1.lstRevisions.addListSelectionListener(this);
        this.revisionsPanel1.lstRevisions.addMouseListener(this);
        if (this.options.contains((Object)Option.DISPLAY_REVISIONS)) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
            this.revisionsPanel1.updateHistory(this.currRepository, this.roots, this.currRevision);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int width = RepositoryBrowserPanel.this.revisionsPanel1.getPreferredSize().width;
                    int leftPanelWidth = ((RepositoryBrowserPanel)RepositoryBrowserPanel.this).jSplitPane1.getPreferredSize().width - width;
                    RepositoryBrowserPanel.this.jSplitPane1.setDividerLocation(Math.min(200, leftPanelWidth));
                    if (RepositoryBrowserPanel.this.sliderPos > 0) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RepositoryBrowserPanel.this.jSplitPane1.setDividerLocation(RepositoryBrowserPanel.this.sliderPos);
                            }
                        });
                    }
                }
            });
        }
        if (this.options.contains((Object)Option.EXPAND_BRANCHES) || this.options.contains((Object)Option.EXPAND_TAGS)) {
            this.tree.expandNode((Node)this.root);
        }
    }

    @Override
    public void removeNotify() {
        if (this.options.contains((Object)Option.DISPLAY_REVISIONS)) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
        }
        this.revisionsPanel1.lstRevisions.removeListSelectionListener(this);
        this.getExplorerManager().removePropertyChangeListener((PropertyChangeListener)this);
        if (this.toolbar.isVisible()) {
            this.detachToolbarListeners();
        }
        super.removeNotify();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.revisionsPanel1.lstRevisions && e.getClickCount() == 2 && this.currRevision != null) {
            e.consume();
            this.firePropertyChange(PROP_REVISION_ACCEPTED, null, this.currRevision);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Component compNew;
        if (evt.getPropertyName() == "selectedNodes") {
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this);
            if (tc != null) {
                tc.setActivatedNodes(this.getExplorerManager().getSelectedNodes());
            }
            this.currRepository = null;
            Revision oldRevision = this.currRevision;
            this.currRevision = null;
            if (this.getExplorerManager().getSelectedNodes().length == 1) {
                Node selectedNode = this.getExplorerManager().getSelectedNodes()[0];
                this.currRevision = (Revision)selectedNode.getLookup().lookup(Revision.class);
                this.currRepository = this.lookupRepository(selectedNode);
            }
            if (!(this.currRevision == null && oldRevision == null || this.currRevision != null && oldRevision != null && this.currRevision.equals(oldRevision))) {
                this.firePropertyChange(PROP_REVISION_CHANGED, oldRevision, this.currRevision);
            }
            if (this.options.contains((Object)Option.DISPLAY_REVISIONS) && this.currRevision != null) {
                this.revisionsPanel1.updateHistory(this.currRepository, this.roots, this.currRevision);
            }
        } else if (this.options.contains((Object)Option.DISPLAY_REVISIONS) && "focusOwner".equals(evt.getPropertyName()) && (compNew = (Component)evt.getNewValue()) != null) {
            int selection;
            if (SwingUtilities.getAncestorOfClass(this.tree.getClass(), compNew) != null) {
                if (this.getExplorerManager().getSelectedNodes().length == 1) {
                    this.propertyChange(new PropertyChangeEvent(this.tree, "selectedNodes", this.getExplorerManager().getSelectedNodes(), this.getExplorerManager().getSelectedNodes()));
                }
            } else if (this.revisionsPanel1.lstRevisions == compNew && (selection = this.revisionsPanel1.lstRevisions.getSelectedIndex()) != -1) {
                this.valueChanged(new ListSelectionEvent(this.revisionsPanel1.lstRevisions, selection, selection, false));
            }
        }
    }

    private File lookupRepository(Node selectedNode) {
        while (!(selectedNode instanceof RepositoryNode) && selectedNode != null) {
            selectedNode = selectedNode.getParentNode();
        }
        return selectedNode == null ? null : ((RepositoryNode)selectedNode).getRepository();
    }

    public void selectRepository(File repository) {
        Node[] nodes;
        for (Node node : nodes = this.root.getChildren().getNodes()) {
            if (!(node instanceof RepositoryNode) || !repository.equals(node.getLookup().lookup(File.class))) continue;
            this.tree.expandNode(node);
            try {
                this.getExplorerManager().setSelectedNodes(new Node[]{node});
            }
            catch (PropertyVetoException propertyVetoException) {}
            break;
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.tree.requestFocusInWindow();
    }

    void setSliderPosition(int pos) {
        assert (this.options.contains((Object)Option.DISPLAY_REVISIONS));
        this.sliderPos = pos;
        this.jSplitPane1.setDividerLocation(pos);
    }

    int getSliderPosition() {
        assert (this.options.contains((Object)Option.DISPLAY_REVISIONS));
        return this.jSplitPane1.getDividerLocation();
    }

    private void attachToolbarListeners() {
    }

    private void detachToolbarListeners() {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting() && this.revisionsPanel1.lstRevisions.isFocusOwner()) {
            Revision newRev;
            GitRevisionInfo selectedRevision = this.revisionsPanel1.getSelectedRevision();
            Revision oldRevision = this.currRevision;
            if (selectedRevision == null && this.currRevision != null) {
                this.currRevision = null;
                this.firePropertyChange(PROP_REVISION_CHANGED, oldRevision, this.currRevision);
            } else if (selectedRevision != null && !(newRev = new Revision(selectedRevision.getRevision(), selectedRevision.getRevision(), selectedRevision.getShortMessage(), selectedRevision.getFullMessage())).equals(oldRevision)) {
                this.currRevision = newRev;
                this.firePropertyChange(PROP_REVISION_CHANGED, oldRevision, this.currRevision);
            }
        }
    }

    void displayBrancheMergedStatus(String revision) {
        this.branchMergeWith = revision;
    }

    private static GitBranch getTrackedBranch(RepositoryInfo info) {
        GitBranch activeBranch = info.getActiveBranch();
        if (activeBranch == null) {
            return null;
        }
        GitBranch trackedBranch = activeBranch.getTrackedBranch();
        if (trackedBranch == null) {
            return null;
        }
        if (!trackedBranch.isRemote()) {
            return null;
        }
        return trackedBranch;
    }

    private static String getContextDisplayName(File repo) {
        return Utils.getContextDisplayName((VCSContext)GitUtils.getContextForFile(repo));
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "First");
        this.jSplitPane1.setResizeWeight(0.5);
        this.tree.setSelectionMode(1);
        this.jSplitPane1.setLeftComponent((Component)this.tree);
        this.jSplitPane1.setRightComponent(this.revisionsPanel1);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private class RemoteUriNode
    extends RepositoryBrowserNode {
        private final RemoteUri uri;
        private final GitRemoteConfig remote;

        public RemoteUriNode(File repository, RemoteUri uri, GitRemoteConfig remote) {
            super(Children.LEAF, repository);
            this.uri = uri;
            this.remote = remote;
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/remote_" + (uri.push ? "push" : "fetch") + ".png");
        }

        public String getName() {
            return this.uri.uri;
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            if (this.uri.push) {
                actions.add(new AbstractAction(NbBundle.getMessage(PushAction.class, (String)"LBL_PushAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PushAction action = (PushAction)SystemAction.get(PushAction.class);
                        RepositoryInfo info = RepositoryInfo.getInstance(RepositoryBrowserPanel.this.currRepository);
                        GitBranch activeBranch = info.getActiveBranch();
                        GitBranch tracked = RepositoryBrowserPanel.getTrackedBranch(info);
                        if (tracked != null) {
                            LinkedList<PushMapping> pushMappings = new LinkedList<PushMapping>();
                            String remoteBranchName = PushToUpstreamAction.guessRemoteBranchName(RemoteUriNode.this.remote.getFetchRefSpecs(), tracked.getName(), RemoteUriNode.this.remote.getRemoteName());
                            if (remoteBranchName != null) {
                                pushMappings.add(new PushMapping.PushBranchMapping(remoteBranchName, tracked.getId(), activeBranch, false, false));
                                action.push(RepositoryBrowserPanel.this.currRepository, ((RemoteUriNode)RemoteUriNode.this).uri.uri, pushMappings, RemoteUriNode.this.remote.getFetchRefSpecs(), null);
                                return;
                            }
                        }
                        action.push(RepositoryBrowserPanel.this.currRepository);
                    }
                });
            } else {
                actions.add(new AbstractAction(NbBundle.getMessage(FetchAction.class, (String)"LBL_FetchAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FetchAction action = (FetchAction)SystemAction.get(FetchAction.class);
                        action.fetch(RepositoryBrowserPanel.this.currRepository, ((RemoteUriNode)RemoteUriNode.this).uri.uri, RemoteUriNode.this.remote.getFetchRefSpecs(), null);
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(PullAction.class, (String)"LBL_PullAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PullAction action = (PullAction)SystemAction.get(PullAction.class);
                        GitBranch tracked = RepositoryBrowserPanel.getTrackedBranch(RepositoryInfo.getInstance(RepositoryBrowserPanel.this.currRepository));
                        action.pull(RepositoryBrowserPanel.this.currRepository, ((RemoteUriNode)RemoteUriNode.this).uri.uri, RemoteUriNode.this.remote.getFetchRefSpecs(), tracked == null ? null : tracked.getName(), null);
                    }
                });
            }
            return actions.toArray(new Action[actions.size()]);
        }
    }

    private class RemoteChildren
    extends Children.Keys<RemoteUri> {
        private final GitRemoteConfig remote;

        public RemoteChildren(GitRemoteConfig remote) {
            this.remote = remote;
        }

        protected void addNotify() {
            super.addNotify();
            ArrayList<RemoteUri> urls = new ArrayList<RemoteUri>(this.remote.getPushUris().size() + this.remote.getUris().size());
            for (String s : this.remote.getUris()) {
                urls.add(new RemoteUri(s, false));
            }
            if (this.remote.getPushUris().isEmpty() && !this.remote.getUris().isEmpty()) {
                urls.add(new RemoteUri((String)this.remote.getUris().get(0), true));
            } else {
                for (String s : this.remote.getPushUris()) {
                    urls.add(new RemoteUri(s, true));
                }
            }
            Collections.sort(urls, new Comparator<RemoteUri>(){

                @Override
                public int compare(RemoteUri o1, RemoteUri o2) {
                    return o1.uri.compareTo(o2.uri);
                }
            });
            this.setKeys(urls);
        }

        protected Node[] createNodes(RemoteUri key) {
            return new Node[]{new RemoteUriNode(RepositoryBrowserPanel.this.lookupRepository(this.getNode()), key, this.remote)};
        }
    }

    private class RemoteUri {
        final String uri;
        final boolean push;

        public RemoteUri(String url, boolean push) {
            this.uri = url;
            this.push = push;
        }
    }

    private class RemoteNode
    extends RepositoryBrowserNode {
        private final String remoteName;
        private final File repository;

        public RemoteNode(File repository, GitRemoteConfig remote) {
            super((Children)new RemoteChildren(remote), repository, Lookups.fixed((Object[])new Object[]{remote}));
            this.repository = repository;
            this.remoteName = remote.getRemoteName();
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/remote.png");
        }

        public String getName() {
            return this.remoteName;
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            actions.add(new AbstractAction(NbBundle.getMessage(FetchAction.class, (String)"LBL_FetchAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FetchAction action = (FetchAction)SystemAction.get(FetchAction.class);
                    action.fetch(RemoteNode.this.repository, (GitRemoteConfig)RemoteNode.this.getLookup().lookup(GitRemoteConfig.class));
                }
            });
            actions.add(new AbstractAction(NbBundle.getMessage(PullAction.class, (String)"LBL_PullAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PullAction action = (PullAction)SystemAction.get(PullAction.class);
                    GitBranch tracked = RepositoryBrowserPanel.getTrackedBranch(RepositoryInfo.getInstance(RepositoryBrowserPanel.this.currRepository));
                    action.pull(RepositoryBrowserPanel.this.currRepository, (GitRemoteConfig)RemoteNode.this.getLookup().lookup(GitRemoteConfig.class), tracked == null ? null : tracked.getName());
                }
            });
            actions.add(null);
            actions.add(new AbstractAction(NbBundle.getMessage(PushAction.class, (String)"LBL_PushAction_PopupName")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PushAction action = (PushAction)SystemAction.get(PushAction.class);
                    RepositoryInfo info = RepositoryInfo.getInstance(RepositoryBrowserPanel.this.currRepository);
                    GitBranch activeBranch = info.getActiveBranch();
                    GitBranch tracked = RepositoryBrowserPanel.getTrackedBranch(info);
                    if (tracked != null) {
                        GitRemoteConfig remote = (GitRemoteConfig)RemoteNode.this.getLookup().lookup(GitRemoteConfig.class);
                        LinkedList<PushMapping> pushMappings = new LinkedList<PushMapping>();
                        String remoteBranchName = PushToUpstreamAction.guessRemoteBranchName(remote.getFetchRefSpecs(), tracked.getName(), remote.getRemoteName());
                        if (remoteBranchName != null) {
                            pushMappings.add(new PushMapping.PushBranchMapping(remoteBranchName, tracked.getId(), activeBranch, false, false));
                            action.push(RepositoryBrowserPanel.this.currRepository, remote, pushMappings);
                            return;
                        }
                    }
                    action.push(RepositoryBrowserPanel.this.currRepository);
                }
            });
            actions.add(null);
            actions.add(new AbstractAction(NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.RemoteNode.remove")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new RemoveRemoteConfig().removeRemote(RemoteNode.this.repository, RemoteNode.this.remoteName);
                        }
                    });
                }
            });
            return actions.toArray(new Action[actions.size()]);
        }
    }

    private class AllRemotesChildren
    extends Children.Keys<GitRemoteConfig>
    implements PropertyChangeListener {
        private final File repository;
        private boolean refreshing;

        private AllRemotesChildren(File repository) {
            this.repository = repository;
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            if (info == null) {
                LOG.log(Level.INFO, "AllRemotesChildren() : Null info for {0}", repository);
            } else {
                info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info));
            }
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshRemotes();
        }

        private void refreshRemotes() {
            new GitProgressSupport.NoOutputLogging(){

                @Override
                protected void perform() {
                    RepositoryInfo info = RepositoryInfo.getInstance(AllRemotesChildren.this.repository);
                    if (info == null) {
                        LOG.log(Level.INFO, "AllRemotesChildren.refreshRemotes() : Null info for {0}", AllRemotesChildren.this.repository);
                        return;
                    }
                    AllRemotesChildren.this.refreshing = true;
                    try {
                        info.refreshRemotes();
                        Map<String, GitRemoteConfig> remotes = info.getRemotes();
                        if (!this.isCanceled()) {
                            AllRemotesChildren.this.refreshRemotes(remotes);
                        }
                    }
                    catch (GitException ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                    finally {
                        AllRemotesChildren.this.refreshing = false;
                    }
                }
            }.start(RP, this.repository, NbBundle.getMessage(BranchesTopChildren.class, (String)"MSG_RepositoryPanel.refreshingRemotes"));
        }

        private void refreshRemotes(Map<String, GitRemoteConfig> remotes) {
            this.setKeys(remotes.values());
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if (!this.refreshing && "prop.remotes".equals(evt.getPropertyName())) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        AllRemotesChildren.this.refreshRemotes((Map)evt.getNewValue());
                    }
                });
            }
        }

        protected Node[] createNodes(GitRemoteConfig key) {
            return new Node[]{new RemoteNode(this.repository, key)};
        }
    }

    private class RemotesNode
    extends RepositoryBrowserNode {
        public RemotesNode(File repository) {
            super((Children)new AllRemotesChildren(repository), repository);
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/repository.png");
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.RemotesNode.name");
        }
    }

    private class StashNode
    extends RepositoryBrowserNode {
        private final Stash item;

        public StashNode(File repository, Stash item) {
            super(Children.LEAF, repository);
            this.item = item;
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/stash.png");
        }

        public String getDisplayName() {
            return this.getName(false);
        }

        public String getHtmlDisplayName() {
            return this.getName(true);
        }

        public String getName() {
            return this.getName(false);
        }

        public String getName(boolean html) {
            String retval = Bundle.CTL_StashNode_name(this.item.getName(), this.item.getInfo().getShortMessage());
            if (retval.length() > 75) {
                retval = retval.substring(0, 72) + "...";
            }
            return retval;
        }

        public String getShortDescription() {
            return this.item.getInfo().getFullMessage();
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<Action> actions = new LinkedList<Action>();
            if (RepositoryBrowserPanel.this.currRepository != null && this.item != null) {
                final Stash stash = this.item;
                actions.add(stash.getApplyAction());
                AbstractAction a = new AbstractAction(Bundle.LBL_StashNode_drop_action()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (JOptionPane.showConfirmDialog(RepositoryBrowserPanel.this, Bundle.MSG_StashNode_drop_confirmation(stash.getName()), Bundle.LBL_StashNode_drop_confirmation(), 0, 3) == 0) {
                                    new GitProgressSupport(){

                                        @Override
                                        protected void perform() {
                                            try {
                                                this.getClient().stashDrop(stash.getIndex(), GitUtils.NULL_PROGRESS_MONITOR);
                                                RepositoryInfo.getInstance(RepositoryBrowserPanel.this.currRepository).refreshStashes();
                                            }
                                            catch (GitException ex) {
                                                GitClientExceptionHandler.notifyException((Exception)((Object)ex), false);
                                            }
                                        }
                                    }.start(Git.getInstance().getRequestProcessor(RepositoryBrowserPanel.this.currRepository), RepositoryBrowserPanel.this.currRepository, Bundle.MSG_StashNode_drop_progress());
                                }
                            }
                        });
                    }
                };
                a.putValue(RepositoryBrowserPanel.PROP_DELETE_ACTION, Boolean.TRUE);
                actions.add(null);
                actions.add(a);
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public Action getPreferredAction() {
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.ENABLE_POPUP) && RepositoryBrowserPanel.this.currRepository != null && this.item != null) {
                final File repo = RepositoryBrowserPanel.this.currRepository;
                final int index = this.item.getIndex();
                return new AbstractAction(NbBundle.getMessage(ApplyStashAction.class, (String)"LBL_ApplyStashAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((ApplyStashAction)SystemAction.get(ApplyStashAction.class)).applyStash(repo, index, false);
                    }
                };
            }
            return null;
        }
    }

    private class StashesChildren
    extends Children.Keys<Stash>
    implements PropertyChangeListener {
        private final File repository;

        private StashesChildren(File repository) {
            this.repository = repository;
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            if (info == null) {
                LOG.log(Level.INFO, "StashesNode() : Null info for {0}", repository);
            } else {
                info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info));
            }
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshStashes();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(Stash key) {
            return new Node[]{new StashNode(this.repository, key)};
        }

        private void refreshStashes() {
            new GitProgressSupport.NoOutputLogging(){

                @Override
                protected void perform() {
                    RepositoryInfo info = RepositoryInfo.getInstance(StashesChildren.this.repository);
                    try {
                        List<GitRevisionInfo> stash = info.refreshStashes();
                        if (!this.isCanceled()) {
                            StashesChildren.this.refreshStash(stash);
                        }
                    }
                    catch (GitException ex) {
                        LOG.log(Level.INFO, null, ex);
                    }
                }
            }.start(RP, this.repository, Bundle.MSG_RepositoryPanel_refreshingStashes());
        }

        private void refreshStash(List<GitRevisionInfo> stash) {
            List<Stash> items = Stash.create(this.repository, stash);
            this.setKeys(items);
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if ("prop.stashes".equals(evt.getPropertyName())) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        StashesChildren.this.refreshStash((List)evt.getNewValue());
                    }
                });
            }
        }
    }

    private class StashesNode
    extends RepositoryBrowserNode {
        public StashesNode(File repository) {
            super((Children)new StashesChildren(repository), repository);
            assert (repository != null);
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/stashes.png");
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return Bundle.LBL_RepositoryPanel_StashesNode_name();
        }

        @Override
        public Action[] getPopupActions(boolean context) {
            if (RepositoryBrowserPanel.this.currRepository != null) {
                return new Action[]{new AbstractAction(Bundle.LBL_RepositoryPanel_RefreshStashesAction_name()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ((StashesChildren)StashesNode.this.getChildren()).refreshStashes();
                    }
                }, new AbstractAction(NbBundle.getMessage(SaveStashAction.class, (String)"LBL_SaveStashAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Utils.post((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ((SaveStashAction)SystemAction.get(SaveStashAction.class)).saveStash(RepositoryBrowserPanel.this.currRepository);
                            }
                        });
                    }
                }};
            }
            return new Action[0];
        }
    }

    private class TagNode
    extends RepositoryBrowserNode {
        private boolean active;
        private final String tagName;
        private String revisionId;
        private final String message;
        private final PropertyChangeListener list;

        public TagNode(File repository, GitTag tag) {
            super(Children.LEAF, repository, Lookups.singleton((Object)new Revision(tag.getTaggedObjectId(), tag.getTagName())));
            this.tagName = tag.getTagName();
            this.message = tag.getMessage();
            this.revisionId = tag.getTaggedObjectId();
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/tag.png");
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            if (info == null) {
                LOG.log(Level.INFO, "TagNode() : Null info for {0}", repository);
                this.list = null;
            } else {
                this.list = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("prop.activeBranch".equals(evt.getPropertyName()) || "prop.head".equals(evt.getPropertyName())) {
                            TagNode.this.refreshActiveBranch((GitBranch)evt.getNewValue());
                        }
                    }
                };
                info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.list, (Object)info));
                this.refreshActiveBranch(info.getActiveBranch());
            }
        }

        public String getDisplayName() {
            return this.getName(false);
        }

        public String getHtmlDisplayName() {
            return this.getName(true);
        }

        public String getName() {
            return this.getName(false);
        }

        public String getName(boolean html) {
            StringBuilder sb = new StringBuilder();
            if (this.active && html) {
                sb.append("<html><strong>").append(this.tagName).append("</strong>");
            } else {
                sb.append(this.tagName);
            }
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_COMMIT_IDS)) {
                sb.append(" - ").append(this.revisionId);
            }
            return sb.toString();
        }

        private void refreshActiveBranch(GitBranch activeBranch) {
            String oldHtmlName = this.getHtmlDisplayName();
            this.active = activeBranch.getId().equals(this.revisionId);
            String newHtmlName = this.getHtmlDisplayName();
            if (!oldHtmlName.equals(newHtmlName)) {
                this.fireDisplayNameChange(null, null);
            }
        }

        public String getShortDescription() {
            return this.message;
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            if (RepositoryBrowserPanel.this.currRepository != null && this.tagName != null) {
                final File repo = RepositoryBrowserPanel.this.currRepository;
                final String tag = this.tagName;
                actions.add(new AbstractAction(NbBundle.getMessage(RepositoryBrowserAction.class, (String)"LBL_RepositoryBrowser.tagNode.showDetails")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Utils.postParallel((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ManageTagsAction action = (ManageTagsAction)SystemAction.get(ManageTagsAction.class);
                                action.showTagManager(repo, tag);
                            }
                        }, (int)0);
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Utils.postParallel((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CheckoutRevisionAction action = (CheckoutRevisionAction)SystemAction.get(CheckoutRevisionAction.class);
                                action.checkoutRevision(repo, tag);
                            }
                        }, (int)0);
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(CreateBranchAction.class, (String)"LBL_CreateBranchAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Utils.postParallel((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CreateBranchAction action = (CreateBranchAction)SystemAction.get(CreateBranchAction.class);
                                action.createBranch(repo, tag);
                            }
                        }, (int)0);
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(MergeRevisionAction.class, (String)"LBL_MergeRevisionAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Utils.postParallel((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MergeRevisionAction action = (MergeRevisionAction)SystemAction.get(MergeRevisionAction.class);
                                action.mergeRevision(repo, tag);
                            }
                        }, (int)0);
                    }

                    @Override
                    public boolean isEnabled() {
                        return !TagNode.this.active;
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(SearchHistoryAction.class, (String)"LBL_SearchHistoryAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchHistoryAction.openSearch(repo, repo, RepositoryBrowserPanel.getContextDisplayName(repo), null, tag);
                            }
                        });
                    }
                });
                AbstractAction a = new AbstractAction(Bundle.CTL_TagNode_deleteTag_action()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (JOptionPane.showConfirmDialog(RepositoryBrowserPanel.this, Bundle.MSG_TagNode_deleteTag_confirmation(tag), Bundle.LBL_TagNode_deleteTag_confirmation(), 0, 3) == 0) {
                                    new GitProgressSupport(){

                                        @Override
                                        protected void perform() {
                                            try {
                                                this.getClient().deleteTag(tag, GitUtils.NULL_PROGRESS_MONITOR);
                                            }
                                            catch (GitException ex) {
                                                GitClientExceptionHandler.notifyException((Exception)((Object)ex), false);
                                            }
                                        }
                                    }.start(Git.getInstance().getRequestProcessor(RepositoryBrowserPanel.this.currRepository), RepositoryBrowserPanel.this.currRepository, Bundle.MSG_TagNode_deleteTag_progress());
                                }
                            }
                        });
                    }
                };
                a.putValue(RepositoryBrowserPanel.PROP_DELETE_ACTION, Boolean.TRUE);
                actions.add(a);
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public Action getPreferredAction() {
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.ENABLE_POPUP)) {
                if (RepositoryBrowserPanel.this.currRepository != null && this.tagName != null) {
                    final File repo = RepositoryBrowserPanel.this.currRepository;
                    final String tag = this.tagName;
                    return new AbstractAction(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction_PopupName")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Utils.postParallel((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CheckoutRevisionAction action = (CheckoutRevisionAction)SystemAction.get(CheckoutRevisionAction.class);
                                    action.checkoutRevision(repo, tag);
                                }
                            }, (int)0);
                        }
                    };
                }
            } else if (RepositoryBrowserPanel.this.currRevision != null) {
                return new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RepositoryBrowserPanel.this.firePropertyChange(RepositoryBrowserPanel.PROP_REVISION_ACCEPTED, null, RepositoryBrowserPanel.this.currRevision);
                    }
                };
            }
            return null;
        }
    }

    private class TagChildren
    extends Children.Keys<GitTag>
    implements PropertyChangeListener {
        private final Map<String, GitTag> tags = new TreeMap<String, GitTag>();
        private final File repository;

        private TagChildren(File repository) {
            this.repository = repository;
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            if (info == null) {
                LOG.log(Level.INFO, "TagChildren() : Null info for {0}", repository);
            } else {
                info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info));
            }
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshTags();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(GitTag key) {
            return new Node[]{new TagNode(this.repository, key)};
        }

        private void refreshTags() {
            new GitProgressSupport.NoOutputLogging(){

                @Override
                protected void perform() {
                    RepositoryInfo info = RepositoryInfo.getInstance(TagChildren.this.repository);
                    if (info == null) {
                        LOG.log(Level.INFO, "TagChildren.refreshTags() : Null info for {0}", TagChildren.this.repository);
                        return;
                    }
                    info.refresh();
                    Map<String, GitTag> tags = info.getTags();
                    if (!this.isCanceled()) {
                        TagChildren.this.refreshTags(tags);
                    }
                }
            }.start(RP, this.repository, NbBundle.getMessage(BranchesTopChildren.class, (String)"MSG_RepositoryPanel.refreshingTags"));
        }

        private void refreshTags(Map<String, GitTag> tags) {
            if (tags.isEmpty()) {
                this.tags.clear();
            } else {
                tags = new HashMap<String, GitTag>(tags);
                this.tags.keySet().retainAll(tags.keySet());
                for (Map.Entry<String, GitTag> e : this.tags.entrySet()) {
                    GitTag newTagInfo = tags.get(e.getKey());
                    if (newTagInfo == null || !newTagInfo.getTaggedObjectId().equals(e.getValue().getTaggedObjectId()) || !newTagInfo.getMessage().equals(e.getValue().getMessage())) continue;
                    tags.remove(e.getKey());
                }
                this.tags.putAll(tags);
            }
            this.setKeys(this.tags.values().toArray(new GitTag[this.tags.values().size()]));
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if ("prop.tags".equals(evt.getPropertyName())) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        TagChildren.this.refreshTags((Map)evt.getNewValue());
                    }
                });
            }
        }
    }

    private class TagsNode
    extends RepositoryBrowserNode {
        public TagsNode(File repository) {
            super((Children)new TagChildren(repository), repository);
            assert (repository != null);
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/tags.png");
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.TagsNode.name");
        }

        @Override
        public Action[] getPopupActions(boolean context) {
            return new Action[]{new AbstractAction(NbBundle.getMessage(BranchesTopNode.class, (String)"LBL_RepositoryPanel.RefreshTagsAction.name")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((TagChildren)TagsNode.this.getChildren()).refreshTags();
                }
            }};
        }
    }

    private class BranchNode
    extends RepositoryBrowserNode {
        private PropertyChangeListener list;
        private boolean active;
        private final String branchName;
        private String branchId;
        private final GitBranch trackedBranch;
        private String lastTrackingMyId;
        private String lastTrackingOtherId;
        private final Boolean mergeStatus;
        private final boolean remote;
        private String trackingStatus;
        private Boolean autoSyncState;

        public BranchNode(File repository, GitBranchInfo branchInfo) {
            super(Children.LEAF, repository, Lookups.singleton((Object)new Revision.BranchReference(branchInfo.branch)));
            GitBranch branch = branchInfo.branch;
            this.branchName = branch.getName();
            this.mergeStatus = branchInfo.mergedStatus;
            this.autoSyncState = branchInfo.autoSyncState;
            this.branchId = branch.getId();
            this.trackedBranch = branch.getTrackedBranch();
            this.remote = branch.isRemote();
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/branch.png");
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            if (info == null) {
                LOG.log(Level.INFO, "BranchNode() : Null info for {0}", repository);
            } else {
                this.list = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if ("prop.activeBranch".equals(evt.getPropertyName()) || "prop.head".equals(evt.getPropertyName())) {
                            BranchNode.this.refreshActiveBranch((GitBranch)evt.getNewValue());
                        }
                    }
                };
                info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.list, (Object)info));
                this.refreshActiveBranch(info.getActiveBranch());
            }
            this.refreshTracking(branch.getTrackedBranch(), repository);
        }

        public String getDisplayName() {
            return this.getName(false);
        }

        public String getHtmlDisplayName() {
            return this.getName(true);
        }

        public String getName() {
            return this.getName(false);
        }

        public String getName(boolean html) {
            StringBuilder sb = new StringBuilder();
            if (this.active && html) {
                sb.append("<html><strong>").append(this.branchName).append("</strong>");
            } else {
                sb.append(this.branchName).append(this.getMergeStatus(this.mergeStatus));
            }
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_COMMIT_IDS)) {
                if (this.trackingStatus != null) {
                    sb.append(Bundle.LBL_BranchNode_trackingStatus(this.trackingStatus));
                } else if (this.trackedBranch != null) {
                    sb.append(Bundle.LBL_BranchNode_basedOn(this.trackedBranch.getName()));
                }
                sb.append(" - ").append(this.branchId.substring(0, 10));
            }
            return sb.toString();
        }

        private void refreshActiveBranch(GitBranch activeBranch) {
            String newHtmlName;
            String oldHtmlName = this.getHtmlDisplayName();
            boolean oldActive = this.active;
            if (activeBranch.getName().equals(this.branchName)) {
                this.active = true;
                this.branchId = activeBranch.getId();
                this.refreshTracking(activeBranch.getTrackedBranch(), RepositoryBrowserPanel.this.lookupRepository((Node)this));
            } else {
                this.active = false;
            }
            if (this.active != oldActive) {
                this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/" + (this.active ? "active_branch" : "branch") + ".png");
            }
            if (!oldHtmlName.equals(newHtmlName = this.getHtmlDisplayName())) {
                this.fireDisplayNameChange(null, null);
            }
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            LinkedList<AbstractAction> actions = new LinkedList<AbstractAction>();
            if (RepositoryBrowserPanel.this.currRepository != null && this.branchName != null) {
                final File repo = RepositoryBrowserPanel.this.currRepository;
                final String branch = this.branchName;
                actions.add(new AbstractAction(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Utils.postParallel((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CheckoutRevisionAction action = (CheckoutRevisionAction)SystemAction.get(CheckoutRevisionAction.class);
                                action.checkoutRevision(repo, branch);
                            }
                        }, (int)0);
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(CreateBranchAction.class, (String)"LBL_CreateBranchAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Utils.postParallel((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                CreateBranchAction action = (CreateBranchAction)SystemAction.get(CreateBranchAction.class);
                                action.createBranch(repo, branch);
                            }
                        }, (int)0);
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(CreateTagAction.class, (String)"LBL_CreateTagAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CreateTagAction action = (CreateTagAction)SystemAction.get(CreateTagAction.class);
                                action.createTag(repo, branch);
                            }
                        });
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(MergeRevisionAction.class, (String)"LBL_MergeRevisionAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Utils.postParallel((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MergeRevisionAction action = (MergeRevisionAction)SystemAction.get(MergeRevisionAction.class);
                                action.mergeRevision(repo, branch);
                            }
                        }, (int)0);
                    }

                    @Override
                    public boolean isEnabled() {
                        return !BranchNode.this.active;
                    }
                });
                actions.add(new AbstractAction(NbBundle.getMessage(SearchHistoryAction.class, (String)"LBL_SearchHistoryAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SearchHistoryAction.openSearch(repo, new File[]{repo}, branch, Utils.getContextDisplayName((VCSContext)GitUtils.getContextForFile(repo)));
                            }
                        });
                    }
                });
                AbstractAction a = new AbstractAction(NbBundle.getMessage(DeleteBranchAction.class, (String)"LBL_DeleteBranchAction_PopupName")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DeleteBranchAction action = (DeleteBranchAction)SystemAction.get(DeleteBranchAction.class);
                                action.deleteBranch(repo, branch);
                            }
                        });
                    }

                    @Override
                    public boolean isEnabled() {
                        return !BranchNode.this.active;
                    }
                };
                a.putValue(RepositoryBrowserPanel.PROP_DELETE_ACTION, Boolean.TRUE);
                actions.add(a);
                if (!this.remote) {
                    actions.add(null);
                    if (this.trackedBranch != null) {
                        actions.add(new AbstractAction(Bundle.LBL_DiffToTrackedBranchAction_PopupName(this.trackedBranch.getName())){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ((DiffAction)SystemAction.get(DiffAction.class)).diff(GitUtils.getContextForFile(repo), new Revision.BranchReference(BranchNode.this.branchName, BranchNode.this.branchId), new Revision.BranchReference(BranchNode.this.trackedBranch));
                            }
                        });
                        actions.add(new AbstractAction(Bundle.LBL_SyncBranchAction_PopupName(this.trackedBranch.getName())){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        new BranchSynchronizer().syncBranches(repo, new String[]{branch}, true);
                                    }
                                });
                            }
                        });
                        class AutoSyncAction
                        extends AbstractAction
                        implements Presenter.Popup {
                            AutoSyncAction() {
                            }

                            @Override
                            public void actionPerformed(ActionEvent e) {
                            }

                            public JMenuItem getPopupPresenter() {
                                final JCheckBoxMenuItem item = new JCheckBoxMenuItem();
                                item.setState(BranchNode.this.autoSyncState);
                                AbstractAction a = new AbstractAction(Bundle.LBL_AutosyncBranchAction_PopupName(BranchNode.this.trackedBranch.getName())){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        final boolean autoSync = item.getState();
                                        BranchNode.this.autoSyncState = autoSync;
                                        new GitProgressSupport(){

                                            @Override
                                            protected void perform() {
                                                GitModuleConfig.getDefault().setAutoSyncBranch(repo, branch, autoSync);
                                                if (autoSync) {
                                                    new BranchSynchronizer().syncBranches(repo, new String[]{branch}, false);
                                                }
                                            }
                                        }.start(Git.getInstance().getRequestProcessor(repo), repo, Bundle.MSG_AutosyncBranchAction_progress(branch, BranchNode.this.trackedBranch.getName()));
                                    }
                                };
                                Actions.connect((JCheckBoxMenuItem)item, (Action)a, (boolean)true);
                                return item;
                            }
                        }
                        actions.add(new AutoSyncAction());
                    }
                    actions.add(new AbstractAction(Bundle.LBL_SetTrackedBranchAction_PopupName()){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ((SetTrackingAction)SystemAction.get(SetTrackingAction.class)).setupTrackedBranch(repo, branch, BranchNode.this.trackedBranch == null ? null : BranchNode.this.trackedBranch.getName());
                                }
                            });
                        }
                    });
                }
                if (this.trackedBranch != null && this.trackedBranch.isRemote() || this.remote) {
                    actions.add(null);
                    actions.add(new AbstractAction(NbBundle.getMessage(SearchIncomingAction.class, (String)"LBL_SearchIncomingAction_PopupName")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Utils.post((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ((SearchIncomingAction)SystemAction.get(SearchIncomingAction.class)).openSearch(repo, new File[]{repo}, branch, RepositoryBrowserPanel.getContextDisplayName(repo));
                                }
                            });
                        }
                    });
                    if (this.trackedBranch != null && this.trackedBranch.isRemote() && !this.remote) {
                        actions.add(new AbstractAction(NbBundle.getMessage(SearchOutgoingAction.class, (String)"LBL_SearchOutgoingAction_PopupName")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Utils.post((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ((SearchOutgoingAction)SystemAction.get(SearchOutgoingAction.class)).openSearch(repo, new File[]{repo}, branch, RepositoryBrowserPanel.getContextDisplayName(repo));
                                    }
                                });
                            }
                        });
                    }
                }
            }
            return actions.toArray(new Action[actions.size()]);
        }

        public Action getPreferredAction() {
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.ENABLE_POPUP)) {
                if (RepositoryBrowserPanel.this.currRepository != null && this.branchName != null) {
                    final File repo = RepositoryBrowserPanel.this.currRepository;
                    final String branch = this.branchName;
                    return new AbstractAction(NbBundle.getMessage(CheckoutRevisionAction.class, (String)"LBL_CheckoutRevisionAction_PopupName")){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Utils.postParallel((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    CheckoutRevisionAction action = (CheckoutRevisionAction)SystemAction.get(CheckoutRevisionAction.class);
                                    action.checkoutRevision(repo, branch);
                                }
                            }, (int)0);
                        }
                    };
                }
            } else if (RepositoryBrowserPanel.this.currRevision != null) {
                return new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RepositoryBrowserPanel.this.firePropertyChange(RepositoryBrowserPanel.PROP_REVISION_ACCEPTED, null, RepositoryBrowserPanel.this.currRevision);
                    }
                };
            }
            return null;
        }

        private void refreshTracking(final GitBranch trackedBranch, final File repository) {
            if (!(trackedBranch == null || repository == null || !RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_COMMIT_IDS) || this.branchId.equals(this.lastTrackingMyId) && trackedBranch.getId().equals(this.lastTrackingOtherId))) {
                this.lastTrackingMyId = this.branchId;
                this.lastTrackingOtherId = trackedBranch.getId();
                if (trackedBranch.getId().equals(this.branchId)) {
                    String oldName = this.getHtmlDisplayName();
                    this.trackingStatus = Bundle.MSG_BranchNode_trackingStatus_inSync(trackedBranch.getName());
                    this.setShortDescription(NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"MSG_BranchNode.tracking.inSync", (Object)trackedBranch.getName()));
                    this.fireDisplayNameChange(oldName, this.getHtmlDisplayName());
                } else {
                    final String id = this.branchId;
                    RP.post(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            String tt = null;
                            GitClient client = null;
                            try {
                                client = Git.getInstance().getClient(repository);
                                GitRevisionInfo info = client.getCommonAncestor(new String[]{id, trackedBranch.getId()}, GitUtils.NULL_PROGRESS_MONITOR);
                                if (info == null || !info.getRevision().equals(id) && !info.getRevision().equals(trackedBranch.getId())) {
                                    tt = NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"MSG_BranchNode.tracking.mergeNeeded", (Object)trackedBranch.getName());
                                    this.setTrackingStatus(Bundle.MSG_BranchNode_trackingStatus_merge(trackedBranch.getName()));
                                } else {
                                    if (info.getRevision().equals(trackedBranch.getId())) {
                                        this.setTrackingStatus(Bundle.MSG_BranchNode_trackingStatus_ahead(trackedBranch.getName()));
                                    } else if (info.getRevision().equals(id)) {
                                        this.setTrackingStatus(Bundle.MSG_BranchNode_trackingStatus_behind(trackedBranch.getName()));
                                    }
                                    SearchCriteria crit = new SearchCriteria();
                                    if (info.getRevision().equals(trackedBranch.getId())) {
                                        crit.setRevisionFrom(trackedBranch.getId());
                                        crit.setRevisionTo(id);
                                    } else if (info.getRevision().equals(id)) {
                                        crit.setRevisionFrom(id);
                                        crit.setRevisionTo(trackedBranch.getId());
                                    }
                                    GitRevisionInfo[] revs = client.log(crit, false, GitUtils.NULL_PROGRESS_MONITOR);
                                    int diff = revs.length - 1;
                                    if (info.getRevision().equals(trackedBranch.getId())) {
                                        tt = NbBundle.getMessage(RepositoryBrowserPanel.class, (String)(diff == 1 ? "MSG_BranchNode.tracking.ahead.commit" : "MSG_BranchNode.tracking.ahead.commits"), (Object)trackedBranch.getName(), (Object)diff);
                                    } else if (info.getRevision().equals(id)) {
                                        tt = NbBundle.getMessage(RepositoryBrowserPanel.class, (String)(diff == 1 ? "MSG_BranchNode.tracking.behind.commit" : "MSG_BranchNode.tracking.behind.commits"), (Object)trackedBranch.getName(), (Object)diff);
                                    }
                                }
                            }
                            catch (GitException ex) {
                                LOG.log(Level.INFO, null, ex);
                            }
                            finally {
                                if (client != null) {
                                    client.release();
                                }
                            }
                            final String toolTip = tt;
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BranchNode.this.setShortDescription(toolTip);
                                }
                            });
                        }

                        private void setTrackingStatus(final String status) {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    String oldName = BranchNode.this.getHtmlDisplayName();
                                    BranchNode.this.trackingStatus = status;
                                    BranchNode.this.fireDisplayNameChange(oldName, BranchNode.this.getHtmlDisplayName());
                                }
                            });
                        }
                    });
                }
            }
        }

        private String getMergeStatus(Boolean mergedStatus) {
            if (Boolean.TRUE.equals(mergedStatus)) {
                return Bundle.MSG_BranchMergeStatus_merged();
            }
            return "";
        }
    }

    private class BranchesChildren
    extends Children.Keys<GitBranchInfo> {
        private final BranchNodeType type;
        private final Map<String, GitBranchInfo> branches;

        private BranchesChildren(BranchNodeType type, Map<String, GitBranchInfo> branches) {
            this.type = type;
            this.branches = branches;
        }

        protected void addNotify() {
            super.addNotify();
            RP.post(new Runnable(){

                @Override
                public void run() {
                    BranchesChildren.this.refreshKeys();
                }
            });
        }

        protected Node[] createNodes(GitBranchInfo key) {
            Node node = this.getNode();
            while (!(node instanceof RepositoryNode)) {
                node = node.getParentNode();
            }
            File repository = ((RepositoryNode)node).getRepository();
            final BranchNode n = new BranchNode(repository, key);
            if (RepositoryBrowserPanel.this.options.containsAll(EnumSet.of(Option.EXPAND_BRANCHES, Option.SELECT_ACTIVE_BRANCH)) && n.active) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RepositoryBrowserPanel.this.getExplorerManager().setSelectedNodes(new Node[]{n});
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                });
            }
            return new Node[]{n};
        }

        private void refreshKeys() {
            AbstractList keys = new LinkedList();
            for (Map.Entry<String, GitBranchInfo> e : this.branches.entrySet()) {
                GitBranchInfo branchInfo = e.getValue();
                if ((this.type != BranchNodeType.REMOTE || !branchInfo.branch.isRemote()) && (this.type != BranchNodeType.LOCAL || branchInfo.branch.isRemote())) continue;
                keys.add(branchInfo);
            }
            if (RepositoryBrowserPanel.this.branchMergeWith != null) {
                keys = new ArrayList(keys);
                Collections.sort(keys, new Comparator<GitBranchInfo>(){

                    @Override
                    public int compare(GitBranchInfo i1, GitBranchInfo i2) {
                        assert (i1.mergedStatus != null);
                        assert (i2.mergedStatus != null);
                        int res = i1.mergedStatus.compareTo(i2.mergedStatus);
                        if (res == 0) {
                            res = i1.branch.getName().compareToIgnoreCase(i2.branch.getName());
                        }
                        return res;
                    }
                });
            }
            this.setKeys(keys);
        }
    }

    private class BranchesNode
    extends RepositoryBrowserNode {
        private final BranchNodeType type;

        private BranchesNode(File repository, BranchNodeType type, Map<String, GitBranchInfo> branches) {
            super((Children)new BranchesChildren(type, branches), repository);
            this.type = type;
        }

        private void refresh() {
            ((BranchesChildren)this.getChildren()).refreshKeys();
        }

        public String getName() {
            return this.type.toString();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public Image getIcon(int type) {
            return this.getFolderIcon(type);
        }

        public Image getOpenedIcon(int type) {
            return this.getOpenedFolderIcon(type);
        }
    }

    private class BranchesTopChildren
    extends Children.Keys<BranchNodeType>
    implements PropertyChangeListener {
        private final File repository;
        private final Map<String, GitBranchInfo> branches = new TreeMap<String, GitBranchInfo>();
        private BranchesNode local;
        private BranchesNode remote;

        private BranchesTopChildren(File repository) {
            this.repository = repository;
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            if (info == null) {
                LOG.log(Level.INFO, "BranchesTopChildren() : Null info for {0}", repository);
            } else {
                info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info));
            }
        }

        protected void addNotify() {
            super.addNotify();
            LinkedList<BranchNodeType> keys = new LinkedList<BranchNodeType>();
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_BRANCHES_LOCAL)) {
                keys.add(BranchNodeType.LOCAL);
            }
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_BRANCHES_REMOTE)) {
                keys.add(BranchNodeType.REMOTE);
            }
            this.setKeys(keys);
            this.refreshBranches();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(BranchNodeType key) {
            BranchesNode node;
            switch (key) {
                case LOCAL: {
                    node = this.local = new BranchesNode(this.repository, key, this.branches);
                    break;
                }
                case REMOTE: {
                    node = this.remote = new BranchesNode(this.repository, key, this.branches);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            if (RepositoryBrowserPanel.this.options.contains((Object)Option.EXPAND_BRANCHES)) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryBrowserPanel.this.tree.expandNode((Node)node);
                    }
                });
            }
            return new Node[]{node};
        }

        private void refreshBranches() {
            new GitProgressSupport.NoOutputLogging(){

                @Override
                protected void perform() {
                    RepositoryInfo info = RepositoryInfo.getInstance(BranchesTopChildren.this.repository);
                    if (info == null) {
                        LOG.log(Level.INFO, "BranchesTopChildren.refreshBranches() : Null info for {0}", BranchesTopChildren.this.repository);
                        return;
                    }
                    info.refresh();
                    Map<String, GitBranch> branches = info.getBranches();
                    if (!this.isCanceled()) {
                        BranchesTopChildren.this.refreshBranches(branches);
                    }
                }
            }.start(RP, this.repository, NbBundle.getMessage(BranchesTopChildren.class, (String)"MSG_RepositoryPanel.refreshingBranches"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshBranches(Map<String, GitBranch> branches) {
            assert (!EventQueue.isDispatchThread());
            if (branches.isEmpty()) {
                this.branches.clear();
            } else {
                branches = new HashMap<String, GitBranch>(branches);
                this.branches.keySet().retainAll(branches.keySet());
                for (Map.Entry<String, GitBranchInfo> e : this.branches.entrySet()) {
                    GitBranch gitBranch = branches.get(e.getKey());
                    if (gitBranch == null || !gitBranch.getId().equals(((GitBranchInfo)e.getValue()).branch.getId()) || gitBranch.isActive() != ((GitBranchInfo)e.getValue()).branch.isActive() || !this.equalTracking(gitBranch, ((GitBranchInfo)e.getValue()).branch)) continue;
                    branches.remove(e.getKey());
                }
                GitClient client = null;
                try {
                    if (RepositoryBrowserPanel.this.branchMergeWith != null) {
                        client = Git.getInstance().getClient(this.repository);
                    }
                    for (Map.Entry entry : branches.entrySet()) {
                        Boolean mergedStatus = null;
                        if (RepositoryBrowserPanel.this.branchMergeWith != null) {
                            GitRevisionInfo commonAncestor = client.getCommonAncestor(new String[]{RepositoryBrowserPanel.this.branchMergeWith, ((GitBranch)entry.getValue()).getId()}, GitUtils.NULL_PROGRESS_MONITOR);
                            mergedStatus = commonAncestor != null && commonAncestor.getRevision().equals(((GitBranch)entry.getValue()).getId());
                        }
                        boolean autoSyncState = GitModuleConfig.getDefault().getAutoSyncBranch(this.repository, (String)entry.getKey());
                        this.branches.put((String)entry.getKey(), new GitBranchInfo((GitBranch)entry.getValue(), mergedStatus, autoSyncState));
                    }
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
            }
            if (this.local != null) {
                this.local.refresh();
            }
            if (this.remote != null) {
                this.remote.refresh();
            }
        }

        private boolean equalTracking(GitBranch newBranchInfo, GitBranch branch) {
            GitBranch tracked2;
            boolean equal;
            GitBranch tracked1 = newBranchInfo.getTrackedBranch();
            boolean bl = equal = tracked1 == (tracked2 = branch.getTrackedBranch());
            if (!equal) {
                equal = tracked1 != null && tracked2 != null && tracked1.getName().equals(tracked2.getName()) && tracked1.getId().equals(tracked2.getId());
            }
            return equal;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent evt) {
            if ("prop.branches".equals(evt.getPropertyName())) {
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        BranchesTopChildren.this.refreshBranches((Map)evt.getNewValue());
                    }
                });
            }
        }
    }

    private static class GitBranchInfo {
        private final GitBranch branch;
        private final Boolean mergedStatus;
        private final Boolean autoSyncState;

        public GitBranchInfo(GitBranch branch, Boolean mergedStatus, Boolean autoSyncState) {
            this.branch = branch;
            this.mergedStatus = mergedStatus;
            this.autoSyncState = autoSyncState;
        }
    }

    private static enum BranchNodeType {
        LOCAL{

            public String toString() {
                return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.BranchesChildren.LocalNode.name");
            }
        }
        ,
        REMOTE{

            public String toString() {
                return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.BranchesChildren.RemoteNode.name");
            }
        };

    }

    private class BranchesTopNode
    extends RepositoryBrowserNode {
        public BranchesTopNode(File repository) {
            super((Children)new BranchesTopChildren(repository), repository);
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/branches.png");
        }

        public String getDisplayName() {
            return this.getName();
        }

        public String getName() {
            return NbBundle.getMessage(RepositoryBrowserPanel.class, (String)"LBL_RepositoryPanel.BranchesNode.name");
        }

        @Override
        public Action[] getPopupActions(boolean context) {
            return new Action[]{new AbstractAction(NbBundle.getMessage(BranchesTopNode.class, (String)"LBL_RepositoryPanel.RefreshBranchesAction.name")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((BranchesTopChildren)BranchesTopNode.this.getChildren()).refreshBranches();
                }
            }};
        }
    }

    private class RepositoryChildren
    extends Children.Keys<AbstractNode> {
        boolean initialized = false;

        private RepositoryChildren() {
        }

        protected void addNotify() {
            super.addNotify();
            if (!this.initialized) {
                this.initialized = true;
                LinkedList<RepositoryBrowserNode> keys = new LinkedList<RepositoryBrowserNode>();
                if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_BRANCHES_LOCAL) || RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_BRANCHES_REMOTE)) {
                    keys.add(new BranchesTopNode(((RepositoryNode)this.getNode()).getRepository()));
                }
                if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_TAGS)) {
                    keys.add(new TagsNode(((RepositoryNode)this.getNode()).getRepository()));
                }
                if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_STASH)) {
                    keys.add(new StashesNode(((RepositoryNode)this.getNode()).getRepository()));
                }
                if (RepositoryBrowserPanel.this.options.contains((Object)Option.DISPLAY_REMOTES)) {
                    keys.add(new RemotesNode(((RepositoryNode)this.getNode()).getRepository()));
                }
                this.setKeys(keys);
            }
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        protected Node[] createNodes(AbstractNode key) {
            Object toExpand = RepositoryBrowserPanel.this.options.contains((Object)Option.EXPAND_BRANCHES) && key instanceof BranchesTopNode ? key : (RepositoryBrowserPanel.this.options.contains((Object)Option.EXPAND_TAGS) && key instanceof TagsNode ? key : null);
            if (toExpand != null) {
                EventQueue.invokeLater(new Runnable((Node)toExpand){
                    final /* synthetic */ Node val$toExpand;
                    {
                        this.val$toExpand = node;
                    }

                    @Override
                    public void run() {
                        RepositoryBrowserPanel.this.tree.expandNode(this.val$toExpand);
                    }
                });
            }
            return new Node[]{key};
        }
    }

    private class RepositoryNode
    extends RepositoryBrowserNode
    implements PropertyChangeListener {
        private PropertyChangeListener list;
        private final File repository;

        public RepositoryNode(final File repository, RepositoryInfo info) {
            super((Children)new RepositoryChildren(), repository);
            this.repository = repository;
            this.setIconBaseWithExtension("org/netbeans/modules/git/resources/icons/repository.png");
            if (info == null) {
                this.setDisplayName(repository.getName());
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        RepositoryInfo info = RepositoryInfo.getInstance(repository);
                        if (info == null) {
                            LOG.log(Level.INFO, "RepositoryNode() : Null info for {0}", repository);
                        } else {
                            RepositoryNode.this.setName(info);
                            info.addPropertyChangeListener(RepositoryNode.this.list = WeakListeners.propertyChange((PropertyChangeListener)RepositoryNode.this, (Object)info));
                        }
                    }
                });
            } else {
                this.setName(info);
                this.list = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)info);
                info.addPropertyChangeListener(this.list);
            }
        }

        private void setName(RepositoryInfo info) {
            GitRepositoryState repositoryState;
            String branchLabel = "";
            GitBranch branch = info.getActiveBranch();
            if (branch != null && (branchLabel = branch.getName()) == "(no branch)") {
                Map<String, GitTag> tags = info.getTags();
                StringBuilder tagLabel = new StringBuilder();
                for (GitTag tag : tags.values()) {
                    if (!tag.getTaggedObjectId().equals(branch.getId())) continue;
                    tagLabel.append(",").append(tag.getTagName());
                }
                if (tagLabel.length() <= 1) {
                    branchLabel = branch.getId();
                    if (branchLabel.length() > 7) {
                        branchLabel = branchLabel.substring(0, 7) + "...";
                    }
                } else {
                    tagLabel.delete(0, 1);
                    branchLabel = tagLabel.toString();
                }
            }
            String annotation = (repositoryState = info.getRepositoryState()) != GitRepositoryState.SAFE ? repositoryState.toString() + " - " + branchLabel : branchLabel;
            this.setDisplayName(info.getName() + " [" + annotation + "]");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof RepositoryInfo) {
                this.setName((RepositoryInfo)evt.getSource());
            }
        }

        public String toString() {
            return this.getDisplayName();
        }

        public File getRepository() {
            return this.repository;
        }

        @Override
        protected Action[] getPopupActions(boolean context) {
            VCSContext ctx = VCSContext.forNodes((Node[])new Node[]{this});
            Action[] actions = Git.getInstance().getVCSAnnotator().getActions(ctx, VCSAnnotator.ActionDestination.PopupMenu);
            actions = Arrays.copyOf(actions, actions.length + 2);
            actions[actions.length - 1] = new AbstractAction(Bundle.CTL_CloseRepositoryAction_name()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GitRepositories.getInstance().remove(RepositoryNode.this.repository, true);
                }
            };
            return actions;
        }

        public String getShortDescription() {
            return this.repository.getAbsolutePath();
        }
    }

    private class RepositoriesChildren
    extends Children.SortedMap<File> {
        private final PropertyChangeListener list;
        private boolean initialized = false;

        public RepositoriesChildren() {
            this.setComparator(new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    int result;
                    if (o1 instanceof RepositoryNode && o2 instanceof RepositoryNode) {
                        File repo1 = ((RepositoryNode)o1).getRepository();
                        File repo2 = ((RepositoryNode)o2).getRepository();
                        result = repo1.getName().compareTo(repo2.getName());
                        if (result == 0 && !repo1.equals(repo2)) {
                            result = repo1.getAbsolutePath().compareTo(repo2.getAbsolutePath());
                        }
                    } else {
                        result = o1.toString().compareTo(o2.toString());
                    }
                    return result;
                }
            });
            this.list = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    Set oldValues = (Set)evt.getOldValue();
                    final Set newValues = (Set)evt.getNewValue();
                    if (oldValues.size() > newValues.size()) {
                        oldValues.removeAll(newValues);
                        RepositoriesChildren.this.removeAll(oldValues);
                    } else if (oldValues.size() < newValues.size()) {
                        newValues.removeAll(oldValues);
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                HashMap<File, RepositoryNode> nodes = new HashMap<File, RepositoryNode>();
                                for (File r : newValues) {
                                    RepositoryInfo info = RepositoryInfo.getInstance(r);
                                    if (info == null) {
                                        LOG.log(Level.INFO, "RepositoriesChildren.propertyChange() : Null info for {0}", r);
                                        continue;
                                    }
                                    nodes.put(r, new RepositoryNode(r, info));
                                }
                                RepositoriesChildren.this.putAll(nodes);
                                if (RepositoryBrowserPanel.this.options.contains((Object)Option.EXPAND_BRANCHES) || RepositoryBrowserPanel.this.options.contains((Object)Option.EXPAND_TAGS)) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            for (Node n : RepositoriesChildren.this.getNodes()) {
                                                RepositoryBrowserPanel.this.tree.expandNode(n);
                                            }
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            };
            GitRepositories.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.list, (Object)GitRepositories.getInstance()));
        }

        protected void addNotify() {
            super.addNotify();
            if (!this.initialized) {
                this.initialized = true;
                this.list.propertyChange(new PropertyChangeEvent(GitRepositories.getInstance(), "GitRepositories.repositories", Collections.emptySet(), GitRepositories.getInstance().getKnownRepositories()));
            }
        }
    }

    private abstract class RepositoryBrowserNode
    extends AbstractNode {
        protected RepositoryBrowserNode(Children children, File repository) {
            this(children, repository, null);
        }

        protected RepositoryBrowserNode(Children children, File repository, Lookup lookup) {
            super(children, (Lookup)(lookup == null ? Lookups.singleton((Object)repository) : new ProxyLookup(new Lookup[]{Lookups.singleton((Object)repository), lookup})));
        }

        public final Action[] getActions(boolean context) {
            return RepositoryBrowserPanel.this.options.contains((Object)Option.ENABLE_POPUP) ? this.getPopupActions(context) : this.getDefaultActions();
        }

        protected Action[] getPopupActions(boolean context) {
            return this.getDefaultActions();
        }

        protected Image getFolderIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = this.findIcon("Nb.Explorer.Folder.icon", "Tree.closedIcon");
            }
            if (img == null) {
                img = super.getIcon(type);
            }
            return img;
        }

        protected Image getOpenedFolderIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = this.findIcon("Nb.Explorer.Folder.openedIcon", "Tree.openIcon");
            }
            if (img == null) {
                img = super.getOpenedIcon(type);
            }
            return img;
        }

        private Image findIcon(String key1, String key2) {
            Image img;
            Image image = img = cachedIcons.containsKey(key1) ? (Image)cachedIcons.get(key1) : null;
            if (img == null) {
                img = this.findIcon(key1);
                if (img == null) {
                    img = this.findIcon(key2);
                }
                cachedIcons.put(key1, img);
            }
            return img;
        }

        private Image findIcon(String key) {
            Object obj = UIManager.get(key);
            if (obj instanceof Image) {
                return (Image)obj;
            }
            if (obj instanceof Icon) {
                Icon icon = (Icon)obj;
                return ImageUtilities.icon2Image((Icon)icon);
            }
            return null;
        }

        private Action[] getDefaultActions() {
            return new Action[0];
        }
    }

    private class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(Bundle.RepoBrowserPanel_DeleteAction_name());
        }

        @Override
        public boolean isEnabled() {
            return !this.getDeleteDelegates().isEmpty();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Action> delegetaActions = this.getDeleteDelegates();
            for (Action a : delegetaActions) {
                a.actionPerformed(e);
            }
        }

        private List<Action> getDeleteDelegates() {
            Node[] nodes = RepositoryBrowserPanel.this.getExplorerManager().getSelectedNodes();
            Action delegate = null;
            if (nodes.length == 1) {
                Action[] actions;
                for (Action a : actions = nodes[0].getActions(true)) {
                    if (a == null || !Boolean.TRUE.equals(a.getValue(RepositoryBrowserPanel.PROP_DELETE_ACTION)) || !a.isEnabled()) continue;
                    delegate = a;
                }
            }
            return delegate == null ? Collections.emptyList() : Arrays.asList(delegate);
        }
    }

    public static enum Option {
        DISPLAY_ALL_REPOSITORIES,
        DISPLAY_BRANCHES_LOCAL,
        DISPLAY_BRANCHES_REMOTE,
        DISPLAY_COMMIT_IDS,
        DISPLAY_REMOTES,
        DISPLAY_REVISIONS,
        DISPLAY_STASH,
        DISPLAY_TAGS,
        DISPLAY_TOOLBAR,
        EXPAND_BRANCHES,
        EXPAND_TAGS,
        SELECT_ACTIVE_BRANCH,
        ENABLE_POPUP;

    }
}

