/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VersioningQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.RenameRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.text.PositionBounds;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PackageRename
implements RefactoringPluginFactory {
    private static final Logger LOG = Logger.getLogger(PackageRename.class.getName());

    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        NonRecursiveFolder folder;
        if (refactoring instanceof RenameRefactoring && (folder = (NonRecursiveFolder)refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)) != null) {
            return new PackageRenamePlugin((RenameRefactoring)refactoring, folder);
        }
        return null;
    }

    public class PackageRenamePlugin
    implements RefactoringPlugin {
        private final RenameRefactoring refactoring;
        private final NonRecursiveFolder nonRecursiveFolder;

        public PackageRenamePlugin(RenameRefactoring refactoring, NonRecursiveFolder nonRecursiveFolder) {
            this.refactoring = refactoring;
            this.nonRecursiveFolder = nonRecursiveFolder;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem prepare(RefactoringElementsBag elements) {
            elements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new RenameNonRecursiveFolder((NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class), elements));
            return null;
        }

        public Problem fastCheckParameters() {
            FileObject ownerRoot;
            String newName = this.refactoring.getNewName();
            if (!RefactoringUtils.isValidPackageName(newName)) {
                String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_InvalidPackage")).format(new Object[]{newName});
                return new Problem(true, msg);
            }
            FileObject folder = this.nonRecursiveFolder.getFolder();
            ClassPath projectClassPath = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
            FileObject fo = projectClassPath.findResource(newName.replace('.', '/'));
            if (fo != null && (ownerRoot = projectClassPath.findOwnerRoot(folder)) != null && ownerRoot.equals(projectClassPath.findOwnerRoot(fo))) {
                FileObject parent;
                String relativePath;
                if (fo.isFolder() && fo.getChildren().length == 1 && (relativePath = FileUtil.getRelativePath((FileObject)(parent = fo.getChildren()[0]), (FileObject)this.nonRecursiveFolder.getFolder())) != null) {
                    return null;
                }
                String msg = new MessageFormat(NbBundle.getMessage(RenameRefactoringPlugin.class, (String)"ERR_PackageExists")).format(new Object[]{newName});
                return new Problem(true, msg);
            }
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        private class RenameNonRecursiveFolder
        extends SimpleRefactoringElementImplementation {
            private FileObject folder;
            private RefactoringElementsBag session;
            private String oldName;
            private FileObject root;
            private String currentName;

            public RenameNonRecursiveFolder(NonRecursiveFolder nrfo, RefactoringElementsBag session) {
                this.folder = nrfo.getFolder();
                this.session = session;
                ClassPath cp = ClassPath.getClassPath((FileObject)this.folder, (String)"classpath/source");
                this.oldName = this.currentName = cp.getResourceName(this.folder, '.', false);
                this.root = cp.findOwnerRoot(this.folder);
            }

            public String getText() {
                return NbBundle.getMessage(PackageRename.class, (String)"TXT_RenamePackage") + this.folder.getNameExt();
            }

            public String getDisplayText() {
                return this.getText();
            }

            public void performChange() {
                this.atomicSetName(PackageRenamePlugin.this.refactoring.getNewName());
            }

            public void undoChange() {
                this.atomicSetName(this.oldName);
            }

            private void atomicSetName(final String name) {
                try {
                    this.folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() throws IOException {
                            RenameNonRecursiveFolder.this.setName(name);
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }

            public Lookup getLookup() {
                return Lookups.singleton((Object)this.folder.getParent());
            }

            public FileObject getParentFile() {
                return this.folder.getParent();
            }

            public PositionBounds getPosition() {
                return null;
            }

            public void setName(String name) {
                int index;
                int i;
                if (this.currentName.equals(name)) {
                    return;
                }
                name = name.replace('.', '/') + '/';
                this.currentName = this.currentName.replace('.', '/') + '/';
                for (i = 0; i < this.currentName.length() && i < name.length() && this.currentName.charAt(i) == name.charAt(i); ++i) {
                }
                String commonPrefix = (index = this.currentName.lastIndexOf(47, --i)) == -1 ? null : this.currentName.substring(0, index);
                String toCreate = index + 1 == name.length() ? "" : name.substring(index + 1);
                try {
                    FileObject commonFolder;
                    FileObject destination = commonFolder = commonPrefix == null ? this.root : this.root.getFileObject(commonPrefix);
                    StringTokenizer dtk = new StringTokenizer(toCreate, "/");
                    while (dtk.hasMoreTokens()) {
                        String pathElement = dtk.nextToken();
                        FileObject tmp = destination.getFileObject(pathElement);
                        if (tmp == null) {
                            tmp = destination.createFolder(pathElement);
                        }
                        destination = tmp;
                    }
                    if (!this.folder.isValid()) {
                        FileObject toFileObject = FileUtil.toFileObject((File)new File(this.folder.getPath()));
                        if (toFileObject == null) {
                            LOG.log(Level.INFO, "Invalid folder: {0}", this.folder.getPath());
                            return;
                        }
                        this.folder = toFileObject;
                    }
                    FileObject folder = this.folder;
                    FileUtil.toFileObject((File)new File(this.folder.getPath()));
                    DataFolder sourceFolder = DataFolder.findFolder((FileObject)folder);
                    DataFolder destinationFolder = DataFolder.findFolder((FileObject)destination);
                    DataObject[] children = sourceFolder.getChildren();
                    for (int j = 0; j < children.length; ++j) {
                        if (!children[j].getPrimaryFile().isData()) continue;
                        children[j].move(destinationFolder);
                    }
                    while (!commonFolder.equals(folder) && this.isEmpty(folder)) {
                        FileObject tmp = folder;
                        folder = folder.getParent();
                        tmp.delete();
                    }
                    this.folder = destinationFolder.getPrimaryFile();
                    this.selectInProjectsView(destinationFolder);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
                this.currentName = name;
            }

            private boolean isEmpty(FileObject folder) {
                boolean isVersioned = VersioningQuery.isManaged((URI)folder.toURI());
                if (isVersioned) {
                    for (FileObject child : folder.getChildren()) {
                        if (!VisibilityQuery.getDefault().isVisible(child)) continue;
                        return false;
                    }
                    return true;
                }
                return folder.getChildren().length == 0;
            }

            private void selectInProjectsView(final DataFolder destinationFolder) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContextAwareAction action = (ContextAwareAction)FileUtil.getConfigObject((String)"Actions/Window/SelectDocumentNode/org-netbeans-modules-project-ui-SelectInProjects.instance", ContextAwareAction.class);
                        if (action != null) {
                            Action contextAction = action.createContextAwareInstance(Lookups.fixed((Object[])new Object[]{destinationFolder}));
                            contextAction.actionPerformed(new ActionEvent(this, 1001, null));
                        }
                    }
                });
            }
        }
    }
}

