/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.swing.Action;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.java.RefactoringUtils;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.api.WhereUsedQueryConstants;
import org.netbeans.modules.refactoring.java.plugins.Bundle;
import org.netbeans.modules.refactoring.java.plugins.DeleteTransformer;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.OverriddenAbsMethodFinder;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.spi.ProblemDetailsFactory;
import org.netbeans.modules.refactoring.spi.ProblemDetailsImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class SafeDeleteRefactoringPlugin
extends JavaRefactoringPlugin {
    private static final String DOT = ".";
    private static final String JAVA_EXTENSION = "java";
    private final ArrayList<TreePathHandle> grips;
    private final SafeDeleteRefactoring refactoring;
    private WhereUsedQuery[] whereUsedQueries;
    private HashSet<ElementHandle<ExecutableElement>> allMethods;

    public SafeDeleteRefactoringPlugin(SafeDeleteRefactoring refactoring) {
        this.refactoring = refactoring;
        this.grips = new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Problem checkParameters() {
        void var2_8;
        this.grips.clear();
        for (FileObject fileObject : this.lookupJavaFileObjects()) {
            JavaSource source = JavaSource.forFileObject((FileObject)fileObject);
            if (source == null) continue;
            try {
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                    }

                    public void run(CompilationController co) throws Exception {
                        co.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        CompilationUnitTree cut = co.getCompilationUnit();
                        for (Tree tree : cut.getTypeDecls()) {
                            TreePathHandle handle;
                            if (tree.getKind() == Tree.Kind.EMPTY_STATEMENT || SafeDeleteRefactoringPlugin.this.containsHandle(handle = TreePathHandle.create((TreePath)TreePath.getPath(cut, tree), (CompilationInfo)co), (CompilationInfo)co)) continue;
                            SafeDeleteRefactoringPlugin.this.grips.add(handle);
                        }
                    }
                }, true);
            }
            catch (IOException | IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.grips.addAll(this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class));
        this.whereUsedQueries = new WhereUsedQuery[this.grips.size()];
        for (int i = 0; i < this.whereUsedQueries.length; ++i) {
            final TreePathHandle treePathHandle = this.grips.get(i);
            final WhereUsedQuery q = new WhereUsedQuery(Lookups.singleton((Object)treePathHandle));
            for (Object o : this.refactoring.getContext().lookupAll(Object.class)) {
                q.getContext().add(o);
            }
            q.getContext().add((Object)this.refactoring);
            q.getContext().add((Object)this);
            if (Tree.Kind.METHOD == treePathHandle.getKind()) {
                JavaSource source = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
                try {
                    final int index = i;
                    source.runUserActionTask((Task)new Task<CompilationController>(){

                        public void run(CompilationController info) throws Exception {
                            Collection<ExecutableElement> overridens;
                            info.toPhase(JavaSource.Phase.RESOLVED);
                            Element element = treePathHandle.resolveElement((CompilationInfo)info);
                            if (element == null) {
                                throw new NullPointerException(String.format("#145291: Cannot resolve handle: %s\n%s", treePathHandle, info.getClasspathInfo()));
                            }
                            ElementKind kind = element.getKind();
                            if (kind == ElementKind.METHOD && !(overridens = JavaRefactoringUtils.getOverriddenMethods((ExecutableElement)element, (CompilationInfo)info)).isEmpty()) {
                                ExecutableElement el = overridens.iterator().next();
                                assert (el != null);
                                TreePathHandle basem = TreePathHandle.create((Element)el, (CompilationInfo)info);
                                q.setRefactoringSource(Lookups.fixed((Object[])new Object[]{basem}));
                                SafeDeleteRefactoringPlugin.this.grips.remove(index);
                                SafeDeleteRefactoringPlugin.this.grips.add(index, basem);
                            }
                        }
                    }, true);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                q.putValue((Object)WhereUsedQueryConstants.SEARCH_FROM_BASECLASS, (Object)true);
                q.putValue((Object)WhereUsedQueryConstants.FIND_OVERRIDING_METHODS, (Object)false);
            }
            q.putValue((Object)"SEARCH_IN_COMMENTS", (Object)this.refactoring.isCheckInComments());
            this.whereUsedQueries[i] = q;
        }
        boolean bl = false;
        while (var2_8 < this.whereUsedQueries.length) {
            Problem problemFromUsage = this.whereUsedQueries[var2_8].checkParameters();
            if (problemFromUsage != null) {
                return problemFromUsage;
            }
            ++var2_8;
        }
        return null;
    }

    @Override
    public Problem fastCheckParameters() {
        return null;
    }

    @Override
    public Problem preCheck() {
        this.cancelRequest = false;
        this.cancelRequested.set(false);
        final Problem[] problem = new Problem[1];
        Collection handles = this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
        for (final TreePathHandle tph : handles) {
            FileObject fileObject = tph.getFileObject();
            if (fileObject == null || !fileObject.isValid()) {
                return new Problem(true, NbBundle.getMessage(FindVisitor.class, (String)"DSC_ElNotAvail"));
            }
            JavaSource js = JavaSource.forFileObject((FileObject)fileObject);
            if (js == null) continue;
            try {
                js.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController javac) throws Exception {
                        javac.toPhase(JavaSource.Phase.RESOLVED);
                        TreePath selectedTree = tph.resolve((CompilationInfo)javac);
                        if (selectedTree != null && selectedTree.getParentPath() != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)selectedTree.getParentPath().getLeaf().getKind()) && selectedTree.getParentPath().getLeaf().getKind() != Tree.Kind.COMPILATION_UNIT && selectedTree.getLeaf().getKind() == Tree.Kind.VARIABLE) {
                            switch (selectedTree.getParentPath().getLeaf().getKind()) {
                                case BLOCK: 
                                case METHOD: {
                                    break;
                                }
                                default: {
                                    problem[0] = new Problem(true, Bundle.ERR_VarNotInBlockOrMethod(selectedTree.getLeaf().toString()));
                                }
                            }
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return problem[0];
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        Collection<? extends FileObject> files;
        HashSet<TreePathHandle> refactoredObjects = new HashSet<TreePathHandle>();
        RefactoringSession usages = RefactoringSession.create((String)"delete");
        Problem problem = this.findUsagesAndDelete(refactoredObjects, usages, files = this.lookupJavaFileObjects(), refactoringElements);
        if (problem != null && problem.isFatal()) {
            return problem;
        }
        for (RefactoringElement refacElem : usages.getRefactoringElements()) {
            ElementGrip elem = (ElementGrip)refacElem.getLookup().lookup(ElementGrip.class);
            if (files.contains(refacElem.getParentFile()) || SafeDeleteRefactoringPlugin.isPendingDelete(elem, refactoredObjects)) continue;
            problem = JavaPluginUtils.chainProblems(problem, new Problem(false, NbBundle.getMessage(SafeDeleteRefactoringPlugin.class, (String)"ERR_ReferencesFound"), ProblemDetailsFactory.createProblemDetails((ProblemDetailsImplementation)new ProblemDetailsImplemen(new WhereUsedQueryUI(elem != null ? elem.getHandle() : null, this.getWhereUsedItemNames(), (AbstractRefactoring)this.refactoring), usages))));
            break;
        }
        this.fireProgressListenerStop();
        return problem;
    }

    private boolean containsHandle(TreePathHandle handle, CompilationInfo info) {
        Element wanted = handle.resolveElement(info);
        for (TreePathHandle current : this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class)) {
            if (wanted != current.resolveElement(info)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Problem findUsagesAndDelete(Set<TreePathHandle> refactoredObjects, RefactoringSession usages, Collection<? extends FileObject> files, RefactoringElementsBag refactoringElements) throws IllegalArgumentException {
        this.fireProgressListenerStart(2, this.whereUsedQueries.length + 1);
        Problem problem = null;
        try {
            for (int i = 0; i < this.whereUsedQueries.length; ++i) {
                TreePathHandle refactoredObject = (TreePathHandle)this.whereUsedQueries[i].getRefactoringSource().lookup(TreePathHandle.class);
                refactoredObjects.add(refactoredObject);
                this.whereUsedQueries[i].prepare(usages);
                TreePathHandle treePathHandle = this.grips.get(i);
                Set<FileObject> relevant = this.getRelevantFiles(treePathHandle);
                if (Tree.Kind.METHOD == treePathHandle.getKind()) {
                    OverriddenAbsMethodFinder finder = new OverriddenAbsMethodFinder(this.allMethods);
                    JavaSource javaSrc = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
                    try {
                        javaSrc.runUserActionTask((Task)finder, true);
                    }
                    catch (IOException ioException) {
                        ErrorManager.getDefault().notify(this.cancelRequested.get() ? 1 : 0, (Throwable)ioException);
                    }
                    problem = finder.getProblem();
                }
                JavaRefactoringPlugin.TransformTask task = new JavaRefactoringPlugin.TransformTask(this, new DeleteTransformer(this.allMethods, files), treePathHandle);
                problem = JavaPluginUtils.chainProblems(this.createAndAddElements(relevant, task, refactoringElements, (AbstractRefactoring)this.refactoring), problem);
                this.fireProgressListenerStep();
            }
        }
        finally {
            usages.finished();
        }
        return problem;
    }

    private Set<FileObject> getRelevantFiles(final TreePathHandle tph) {
        if (tph.getKind() == Tree.Kind.METHOD) {
            ClasspathInfo cpInfo = RefactoringUtils.getClasspathInfoFor(tph);
            final LinkedHashSet<FileObject> set = new LinkedHashSet<FileObject>();
            set.add(tph.getFileObject());
            JavaSource source = JavaSource.create((ClasspathInfo)cpInfo, (FileObject[])new FileObject[]{tph.getFileObject()});
            try {
                source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                    public void cancel() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }

                    public void run(CompilationController info) throws Exception {
                        ElementHandle encl;
                        ElementHandle handle;
                        ClassIndex idx = info.getClasspathInfo().getClassIndex();
                        info.toPhase(JavaSource.Phase.RESOLVED);
                        ElementUtilities elmUtils = info.getElementUtilities();
                        ExecutableElement el = (ExecutableElement)tph.resolveElement((CompilationInfo)info);
                        ElementHandle methodHandle = ElementHandle.create((Element)el);
                        ElementHandle enclosingType = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)el));
                        SafeDeleteRefactoringPlugin.this.allMethods = new HashSet();
                        SafeDeleteRefactoringPlugin.this.allMethods.add(methodHandle);
                        for (ExecutableElement e : JavaRefactoringUtils.getOverridingMethods(el, (CompilationInfo)info, SafeDeleteRefactoringPlugin.this.cancelRequested)) {
                            handle = ElementHandle.create((Element)e);
                            set.add(SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo()));
                            encl = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)e));
                            set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                            SafeDeleteRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                        }
                        for (ExecutableElement e : JavaRefactoringUtils.getOverriddenMethods(el, (CompilationInfo)info)) {
                            handle = ElementHandle.create((Element)e);
                            set.add(SourceUtils.getFile((ElementHandle)handle, (ClasspathInfo)info.getClasspathInfo()));
                            encl = ElementHandle.create((Element)elmUtils.enclosingTypeElement((Element)e));
                            set.addAll(idx.getResources(encl, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                            SafeDeleteRefactoringPlugin.this.allMethods.add(ElementHandle.create((Element)e));
                        }
                        set.addAll(idx.getResources(enclosingType, EnumSet.of(ClassIndex.SearchKind.METHOD_REFERENCES), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
                        set.add(SourceUtils.getFile((ElementHandle)methodHandle, (ClasspathInfo)info.getClasspathInfo()));
                    }
                }, true);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return set;
        }
        return Collections.singleton(tph.getFileObject());
    }

    private String getWhereUsedItemNames() {
        final StringBuilder b = new StringBuilder();
        for (final TreePathHandle handle : this.grips) {
            try {
                JavaSource.forFileObject((FileObject)handle.getFileObject()).runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController parameter) throws Exception {
                        parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        if (b.length() > 0) {
                            b.append(", ");
                        }
                        b.append(handle.resolveElement((CompilationInfo)parameter).getSimpleName());
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return b.toString();
    }

    private Collection<? extends FileObject> lookupJavaFileObjects() {
        Collection<FileObject> javaFiles;
        Lookup lkp = this.refactoring.getRefactoringSource();
        NonRecursiveFolder folder = (NonRecursiveFolder)lkp.lookup(NonRecursiveFolder.class);
        if (folder != null) {
            javaFiles = SafeDeleteRefactoringPlugin.getJavaFileObjects(folder.getFolder(), false);
        } else {
            ArrayList<FileObject> javaFileObjects = new ArrayList<FileObject>();
            for (FileObject fileObject : lkp.lookupAll(FileObject.class)) {
                if (fileObject.isFolder()) {
                    javaFileObjects.addAll(SafeDeleteRefactoringPlugin.getJavaFileObjects(fileObject, true));
                    continue;
                }
                if (!JavaRefactoringUtils.isRefactorable(fileObject)) continue;
                javaFileObjects.add(fileObject);
            }
            javaFiles = javaFileObjects;
        }
        return javaFiles;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        return null;
    }

    private static void addSourcesInDir(FileObject dirFileObject, boolean isRecursive, Collection<FileObject> javaSrcFiles) {
        for (FileObject childFileObject : dirFileObject.getChildren()) {
            if (childFileObject.isData() && JAVA_EXTENSION.equalsIgnoreCase(childFileObject.getExt())) {
                javaSrcFiles.add(childFileObject);
                continue;
            }
            if (!childFileObject.isFolder() || !isRecursive) continue;
            SafeDeleteRefactoringPlugin.addSourcesInDir(childFileObject, true, javaSrcFiles);
        }
    }

    private static Collection<FileObject> getJavaFileObjects(FileObject dirFileObject, boolean isRecursive) {
        ArrayList<FileObject> javaSrcFiles = new ArrayList<FileObject>();
        SafeDeleteRefactoringPlugin.addSourcesInDir(dirFileObject, isRecursive, javaSrcFiles);
        return javaSrcFiles;
    }

    private static String getMethodName(final TreePathHandle methodHandle) {
        JavaSource javaSrc = JavaSource.forFileObject((FileObject)methodHandle.getFileObject());
        final String[] methodNameString = new String[1];
        try {
            javaSrc.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    ExecutableElement execElem = (ExecutableElement)methodHandle.resolveElement((CompilationInfo)compilationController);
                    TypeElement type = (TypeElement)execElem.getEnclosingElement();
                    methodNameString[0] = type.getQualifiedName() + SafeDeleteRefactoringPlugin.DOT + execElem.toString();
                }
            }, true);
        }
        catch (IOException ioException) {
            ErrorManager.getDefault().notify((Throwable)ioException);
        }
        return methodNameString[0];
    }

    private static boolean isPendingDelete(ElementGrip elementGrip, Set<TreePathHandle> refactoredObjects) {
        ElementGrip parent = elementGrip;
        if (parent != null) {
            do {
                if (!refactoredObjects.contains(parent.getHandle())) continue;
                return true;
            } while ((parent = parent.getParent()) != null);
        }
        return false;
    }

    private class ProblemDetailsImplemen
    implements ProblemDetailsImplementation {
        private RefactoringUI ui;
        private RefactoringSession rs;

        public ProblemDetailsImplemen(RefactoringUI ui, RefactoringSession rs) {
            this.ui = ui;
            this.rs = rs;
        }

        public void showDetails(Action callback, Cancellable parent) {
            parent.cancel();
            UI.openRefactoringUI((RefactoringUI)this.ui, (RefactoringSession)this.rs, (Action)callback);
        }

        public String getDetailsHint() {
            return NbBundle.getMessage(SafeDeleteRefactoringPlugin.class, (String)"LBL_ShowUsages");
        }
    }
}

