/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.toml;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.languages.toml.TomlTokenId;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.tomlj.Toml;
import org.tomlj.TomlParseResult;

public class TomlCompletionProvider
implements CompletionProvider {
    private static final Set<TomlTokenId> DOT_OR_KEY = EnumSet.of(TomlTokenId.DOT, TomlTokenId.KEY);

    public CompletionTask createTask(int queryType, JTextComponent component) {
        return new AsyncCompletionTask((AsyncCompletionQuery)new TomlCompletionQuery(), component);
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    static String matchKey(String key, String prefix) {
        String ret = null;
        int keyStart = key.indexOf(prefix);
        if (keyStart == 0 || keyStart > 0 && key.charAt(keyStart - 1) == '.') {
            int lastDot = prefix.lastIndexOf(46);
            String m = key.substring(keyStart + lastDot + 1);
            int dot = m.indexOf(46);
            ret = dot > -1 ? m.substring(0, dot) : m;
        }
        return ret;
    }

    static int keyPrefixOffset(Document doc, int offset) throws BadLocationException {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence();
        ts.move(offset);
        ts.movePrevious();
        while (ts.token() != null && DOT_OR_KEY.contains(ts.token().id())) {
            ts.movePrevious();
        }
        ts.moveNext();
        return ts.offset();
    }

    private class TomlCompletionQuery
    extends AsyncCompletionQuery {
        private TomlCompletionQuery() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void query(CompletionResultSet resultSet, Document document, int caretOffset) {
            HashSet<String> candidates = new HashSet<String>();
            try {
                StringBuilder toml;
                String simplePrefix;
                String prefix;
                AbstractDocument doc = (AbstractDocument)document;
                doc.readLock();
                try {
                    int prefixOfs = TomlCompletionProvider.keyPrefixOffset(doc, caretOffset);
                    prefix = doc.getText(prefixOfs, caretOffset - prefixOfs);
                    int lastDot = prefix.lastIndexOf(46);
                    simplePrefix = lastDot != -1 ? prefix.substring(lastDot + 1) : prefix;
                    toml = new StringBuilder(doc.getLength());
                    toml.append(doc.getText(0, prefixOfs));
                    toml.append(doc.getText(caretOffset, doc.getLength() - caretOffset));
                }
                finally {
                    doc.readUnlock();
                }
                TomlParseResult parse = Toml.parse((String)toml.toString());
                for (String key : parse.dottedKeySet()) {
                    String candidate = TomlCompletionProvider.matchKey(key, prefix);
                    if (candidate == null) continue;
                    candidates.add(candidate);
                }
                for (String candidate : candidates) {
                    String insert = candidate.substring(simplePrefix.length());
                    resultSet.addItem(CompletionUtilities.newCompletionItemBuilder((String)insert).leftHtmlText(candidate).sortText((CharSequence)candidate).build());
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                resultSet.finish();
            }
        }
    }
}

