/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.codehaus.plexus.util.FileUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.libraries.LibrariesCustomizer;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.maven.actions.Bundle;
import org.netbeans.modules.maven.actions.CreateLibraryPanel;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.embedder.exec.ProgressTransferListener;
import org.netbeans.spi.java.project.support.JavadocAndSourceRootDetection;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class CreateLibraryAction
extends AbstractAction
implements LookupListener {
    private final Lookup lookup;
    private final Lookup.Result<DependencyNode> result;
    private static final String LIBRARIES_ICON = "org/netbeans/modules/maven/actions/libraries.gif";
    private boolean createRunning;

    public CreateLibraryAction(Lookup lkp) {
        this.lookup = lkp;
        this.putValue("Name", Bundle.ACT_Library());
        this.putValue("SmallIcon", ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)LIBRARIES_ICON, (boolean)true)));
        this.putValue("iconBase", LIBRARIES_ICON);
        this.result = this.lookup.lookupResult(DependencyNode.class);
        this.setEnabled(this.result.allInstances().size() > 0);
        this.result.addLookupListener((LookupListener)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Iterator roots = this.result.allInstances().iterator();
        if (!roots.hasNext()) {
            return;
        }
        DependencyNode root = (DependencyNode)roots.next();
        final MavenProject project = (MavenProject)this.lookup.lookup(MavenProject.class);
        final CreateLibraryPanel pnl = new CreateLibraryPanel(root);
        DialogDescriptor dd = new DialogDescriptor((Object)pnl, Bundle.LBL_CreateLibrary());
        pnl.createValidations(dd);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
            this.createRunning = true;
            this.setEnabled();
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        Library lib = CreateLibraryAction.createLibrary(pnl.getLibraryManager(), pnl.getLibraryName(), pnl.getIncludeArtifacts(), pnl.isAllSourceAndJavadoc(), project, pnl.getCopyDirectory());
                        if (lib != null) {
                            LibrariesCustomizer.showCustomizer((Library)lib, (LibraryManager)pnl.getLibraryManager());
                        }
                    }
                    finally {
                        CreateLibraryAction.this.createRunning = false;
                        CreateLibraryAction.this.setEnabled();
                    }
                }
            });
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnabled();
    }

    private void setEnabled() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CreateLibraryAction.this.setEnabled(!CreateLibraryAction.this.createRunning && CreateLibraryAction.this.result.allInstances().size() > 0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    @CheckForNull
    private static Library createLibrary(LibraryManager libraryManager, String libraryName, List<Artifact> includeArtifacts, boolean allSourceAndJavadoc, MavenProject project, String copyTo) {
        block37: {
            ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.MSG_Create_Library(), (Cancellable)ProgressTransferListener.cancellable());
            int count = includeArtifacts.size() * (allSourceAndJavadoc ? 3 : 1) + 5;
            handle.start(count);
            try {
                Object base;
                MavenEmbedder online2 = EmbedderFactory.getOnlineEmbedder();
                int index = 1;
                ArrayList<URI> classpathVolume = new ArrayList<URI>();
                ArrayList<URI> javadocVolume = new ArrayList<URI>();
                ArrayList<URI> sourceVolume = new ArrayList<URI>();
                HashMap<String, String> properties = new HashMap<String, String>();
                HashMap<String, ArrayList<URI>> volumes = new HashMap<String, ArrayList<URI>>();
                File baseFolder = null;
                File nonDefaultLibBase = null;
                if (copyTo != null) {
                    URL libRoot = libraryManager.getLocation();
                    if (libRoot != null) {
                        try {
                            base = Utilities.toFile((URI)libRoot.toURI());
                            base = ((File)base).getParentFile();
                            nonDefaultLibBase = base;
                        }
                        catch (URISyntaxException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                            base = new File(System.getProperty("netbeans.user"), "libraries");
                        }
                    } else {
                        base = new File(System.getProperty("netbeans.user"), "libraries");
                    }
                    base = FileUtil.normalizeFile((File)base);
                    baseFolder = FileUtilities.resolveFilePath((File)base, copyTo);
                    baseFolder.mkdirs();
                }
                volumes.put("classpath", classpathVolume);
                if (allSourceAndJavadoc) {
                    volumes.put("javadoc", javadocVolume);
                    volumes.put("src", sourceVolume);
                }
                StringBuilder mavendeps = new StringBuilder();
                for (Artifact a : includeArtifacts) {
                    block35: {
                        AtomicBoolean cancel;
                        block36: {
                            block34: {
                                Library library;
                                if (mavendeps.length() > 0) {
                                    mavendeps.append(" ");
                                }
                                mavendeps.append(a.getGroupId()).append(":").append(a.getArtifactId()).append(":").append(a.getVersion()).append(":");
                                if (a.hasClassifier()) {
                                    mavendeps.append(a.getClassifier()).append(":");
                                }
                                mavendeps.append(a.getType());
                                handle.progress(Bundle.MSG_Downloading(a.getId()), index);
                                online2.resolve(a, project.getRemoteArtifactRepositories(), online2.getLocalRepository());
                                cancel = ProgressTransferListener.activeListener().cancel;
                                if (cancel != null && cancel.get()) {
                                    library = null;
                                    return library;
                                }
                                if (a.getFile().exists()) break block34;
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MSG_NoJar(a.getId()), 2));
                                library = null;
                                return library;
                            }
                            classpathVolume.add(CreateLibraryAction.getJarUri(a, baseFolder, nonDefaultLibBase, ClassifierType.BINARY));
                            if (!allSourceAndJavadoc) break block35;
                            handle.progress(Bundle.MSG_Downloading_javadoc(a.getId()), index + 1);
                            Artifact javadoc = online2.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), "javadoc");
                            online2.resolve(javadoc, project.getRemoteArtifactRepositories(), online2.getLocalRepository());
                            cancel = ProgressTransferListener.activeListener().cancel;
                            if (cancel != null && cancel.get()) {
                                Library library = null;
                                return library;
                            }
                            if (!javadoc.getFile().exists()) break block36;
                            URI javadocUri = CreateLibraryAction.getJarUri(javadoc, baseFolder, nonDefaultLibBase, ClassifierType.JAVADOC);
                            javadocVolume.add(javadocUri);
                        }
                        handle.progress(Bundle.MSG_Downloading_sources(a.getId()), index + 2);
                        Artifact sources = online2.createArtifactWithClassifier(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType(), "sources");
                        online2.resolve(sources, project.getRemoteArtifactRepositories(), online2.getLocalRepository());
                        cancel = ProgressTransferListener.activeListener().cancel;
                        if (cancel != null && cancel.get()) {
                            Library library = null;
                            return library;
                        }
                        try {
                            try {
                                if (sources.getFile().exists()) {
                                    sourceVolume.add(CreateLibraryAction.getJarUri(sources, baseFolder, nonDefaultLibBase, ClassifierType.SOURCES));
                                }
                            }
                            catch (Exception ex) {
                                Logger.getLogger(CreateLibraryAction.class.getName()).log(Level.FINE, "Failed to download artifact", ex);
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger(CreateLibraryAction.class.getName()).log(Level.FINE, "Failed to download artifact", ex);
                        }
                    }
                    index += allSourceAndJavadoc ? 3 : 1;
                }
                try {
                    handle.progress("Adding library", index + 4);
                    properties.put("maven-dependencies", mavendeps.toString());
                    base = libraryManager.createURILibrary("j2se", libraryName, libraryName, "Library created from Maven artifacts", volumes, properties);
                    return base;
                }
                catch (IOException ex) {
                    try {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (ThreadDeath online2) {
                        break block37;
                    }
                    catch (IllegalStateException ise) {
                        if (!(ise.getCause() instanceof ThreadDeath)) {
                            throw ise;
                        }
                        break block37;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    handle.finish();
                }
            }
            finally {
                handle.finish();
            }
        }
        return null;
    }

    private static URI appendJarFolder(URI u, String jarFolder) {
        try {
            if (u.isAbsolute()) {
                return new URI("jar:" + u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
            }
            return new URI(u.toString() + "!/" + (jarFolder == null ? "" : jarFolder.replace('\\', '/')));
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static URI getJarUri(Artifact a, File copyTo, File nonDefaultLibBase, ClassifierType type) throws IOException {
        FileObject srcRoot;
        File res = a.getFile();
        URI uri = Utilities.toURI((File)res);
        String jarPath = null;
        if (copyTo != null) {
            String path;
            res = new File(copyTo, a.getFile().getName());
            FileUtils.copyFile((File)a.getFile(), (File)res);
            if (nonDefaultLibBase != null && (path = FileUtilities.getRelativePath(nonDefaultLibBase, res)) != null) {
                uri = LibrariesSupport.convertFilePathToURI((String)path);
            }
        }
        FileUtil.refreshFor((File[])new File[]{res});
        FileObject fo = FileUtil.toFileObject((File)res);
        if (type == ClassifierType.JAVADOC && FileUtil.isArchiveFile((FileObject)fo)) {
            FileObject docRoot = JavadocAndSourceRootDetection.findJavadocRoot((FileObject)(fo = FileUtil.getArchiveRoot((FileObject)fo)));
            if (docRoot != null) {
                jarPath = FileUtil.getRelativePath((FileObject)fo, (FileObject)docRoot);
            }
        } else if (type == ClassifierType.SOURCES && FileUtil.isArchiveFile((FileObject)fo) && (srcRoot = JavadocAndSourceRootDetection.findSourceRoot((FileObject)(fo = FileUtil.getArchiveRoot((FileObject)fo)))) != null) {
            jarPath = FileUtil.getRelativePath((FileObject)fo, (FileObject)srcRoot);
        }
        return CreateLibraryAction.appendJarFolder(uri, jarPath);
    }

    private static enum ClassifierType {
        BINARY,
        JAVADOC,
        SOURCES;

    }
}

