/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.EnumCaseElement;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeMemberElement;
import org.netbeans.modules.php.editor.model.CaseElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassMemberElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.EnumScope;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IncludeElement;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Occurence;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseAliasElement;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.FieldElementImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.IncludeElementImpl;
import org.netbeans.modules.php.editor.model.impl.LazyBuild;
import org.netbeans.modules.php.editor.model.impl.MethodScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VarAssignmentImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfoUtils;
import org.netbeans.modules.php.editor.model.nodes.CaseDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ConstantDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.EnumDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.IncludeInfo;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.PhpDocTypeTagInfo;
import org.netbeans.modules.php.editor.model.nodes.SingleFieldDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.TraitDeclarationInfo;
import org.netbeans.modules.php.editor.options.OptionsUtils;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ClassName;
import org.netbeans.modules.php.editor.parser.astnodes.EnumDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Include;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocMethodTag;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocNode;
import org.netbeans.modules.php.editor.parser.astnodes.PHPDocTypeTag;
import org.netbeans.modules.php.editor.parser.astnodes.Scalar;
import org.netbeans.modules.php.editor.parser.astnodes.SingleFieldDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.openide.util.Union2;

class OccurenceBuilder {
    private static final int INITIAL_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int ACCESSING_THREADS = 2;
    private Map<ASTNodeInfo<Scalar>, ConstantElement> constDeclarations;
    private Map<ConstantDeclarationInfo, ConstantElement> constDeclarations53;
    private Map<ASTNodeInfo<Scalar>, Scope> constInvocations = this.initMap();
    private Map<ASTNodeInfo<Expression>, Scope> nsConstInvocations = this.initMap();
    private Map<ASTNodeInfo<Expression>, Scope> nsFunctionInvocations = this.initMap();
    private Map<ASTNodeInfo<FunctionDeclaration>, FunctionScope> fncDeclarations;
    private Map<ASTNodeInfo<MethodDeclaration>, MethodScope> methodDeclarations;
    private Map<MagicMethodDeclarationInfo, MethodScope> magicMethodDeclarations;
    private Map<ASTNodeInfo<MethodInvocation>, Scope> methodInvocations;
    private Map<ASTNodeInfo<Identifier>, ClassConstantElement> classConstantDeclarations;
    private Map<ASTNodeInfo<Identifier>, CaseElement> caseDeclarations;
    private Map<ASTNodeInfo<FunctionInvocation>, Scope> fncInvocations;
    private Map<ASTNodeInfo<StaticMethodInvocation>, Scope> staticMethodInvocations;
    private Map<ASTNodeInfo<StaticFieldAccess>, Scope> staticFieldInvocations;
    private Map<ASTNodeInfo<StaticConstantAccess>, Scope> staticConstantInvocations;
    private Map<ClassDeclarationInfo, ClassScope> clasDeclarations;
    private Map<InterfaceDeclarationInfo, InterfaceScope> ifaceDeclarations;
    private Map<TraitDeclarationInfo, TraitScope> traitDeclarations;
    private Map<EnumDeclarationInfo, EnumScope> enumDeclarations;
    private Map<PhpDocTypeTagInfo, Scope> docTags;
    private Map<ASTNodeInfo<ClassName>, Scope> clasNames;
    private Map<ASTNodeInfo<ClassInstanceCreation>, Scope> clasInstanceCreations;
    private Map<ASTNodeInfo<Expression>, Scope> clasIDs;
    private Map<ASTNodeInfo<Expression>, Scope> ifaceIDs;
    private Map<ASTNodeInfo<Expression>, Scope> traitIDs;
    private Map<ASTNodeInfo<Expression>, Scope> enumIDs;
    private Map<ASTNodeInfo<Variable>, Scope> variables;
    private Map<IncludeInfo, IncludeElement> includes;
    private Map<SingleFieldDeclarationInfo, FieldElementImpl> fldDeclarations;
    private Map<ASTNodeInfo<FieldAccess>, Scope> fieldInvocations;
    private volatile ElementInfo elementInfo;
    private volatile ElementInfo promotedVariableElementInfo;
    private Map<ASTNodeInfo<GotoLabel>, Scope> gotoLabel;
    private Map<ASTNodeInfo<GotoStatement>, Scope> gotoStatement;
    private Map<ASTNodeInfo<Expression>, Scope> useAliases;
    private final List<Occurence> cachedOccurences;

    OccurenceBuilder() {
        this(-1);
    }

    OccurenceBuilder(int offset) {
        this.constDeclarations = this.initMap();
        this.constDeclarations53 = this.initMap();
        this.includes = this.initMap();
        this.fncInvocations = this.initMap();
        this.fncDeclarations = this.initMap();
        this.staticMethodInvocations = this.initMap();
        this.methodDeclarations = this.initMap();
        this.magicMethodDeclarations = this.initMap();
        this.methodInvocations = this.initMap();
        this.fieldInvocations = this.initMap();
        this.staticFieldInvocations = this.initMap();
        this.staticConstantInvocations = this.initMap();
        this.clasDeclarations = this.initMap();
        this.ifaceDeclarations = this.initMap();
        this.traitDeclarations = this.initMap();
        this.enumDeclarations = this.initMap();
        this.clasNames = this.initMap();
        this.clasInstanceCreations = this.initMap();
        this.clasIDs = this.initMap();
        this.ifaceIDs = this.initMap();
        this.traitIDs = this.initMap();
        this.enumIDs = this.initMap();
        this.classConstantDeclarations = this.initMap();
        this.caseDeclarations = this.initMap();
        this.variables = this.initMap();
        this.fldDeclarations = this.initMap();
        this.docTags = this.initMap();
        this.gotoStatement = this.initMap();
        this.gotoLabel = this.initMap();
        this.useAliases = this.initMap();
        this.cachedOccurences = new ArrayList<Occurence>();
    }

    private <K, V> Map<K, V> initMap() {
        return new ConcurrentHashMap(16, 0.75f, 2);
    }

    void prepare(GotoStatement statement, ScopeImpl scope) {
        if (this.canBePrepared(statement, scope)) {
            ASTNodeInfo<GotoStatement> node = ASTNodeInfo.create(statement);
            this.gotoStatement.put(node, scope);
        }
    }

    void prepare(GotoLabel label, ScopeImpl scope) {
        if (this.canBePrepared(label, scope)) {
            ASTNodeInfo<GotoLabel> node = ASTNodeInfo.create(label);
            this.gotoLabel.put(node, scope);
        }
    }

    void prepare(FieldAccess fieldAccess, Scope scope) {
        if (this.canBePrepared(fieldAccess, scope)) {
            ASTNodeInfo<FieldAccess> node = ASTNodeInfo.create(fieldAccess);
            this.fieldInvocations.put(node, scope);
        }
    }

    void prepare(Include incl, IncludeElementImpl inclImpl) {
        if (this.canBePrepared(incl, inclImpl)) {
            IncludeInfo node = IncludeInfo.create(incl);
            this.includes.put(node, inclImpl);
        }
    }

    void prepare(MethodInvocation methodInvocation, Scope scope) {
        if (this.canBePrepared(methodInvocation, scope)) {
            ASTNodeInfo<MethodInvocation> node = ASTNodeInfo.create(methodInvocation);
            this.methodInvocations.put(node, scope);
        }
    }

    void prepare(SingleFieldDeclarationInfo info, FieldElementImpl fei) {
        SingleFieldDeclaration node = (SingleFieldDeclaration)info.getOriginalNode();
        if (this.canBePrepared(node, fei)) {
            this.fldDeclarations.put(info, fei);
        }
    }

    void prepare(Variable variable, Scope scope) {
        if (this.canBePrepared(variable, scope)) {
            ASTNodeInfo<Variable> node = ASTNodeInfo.create(variable);
            this.variables.put(node, scope);
        }
    }

    void prepare(FunctionInvocation functionInvocation, Scope scope) {
        if (this.canBePrepared(functionInvocation, scope)) {
            ASTNodeInfo<FunctionInvocation> node = ASTNodeInfo.create(functionInvocation);
            this.fncInvocations.put(node, scope);
        }
    }

    void prepare(StaticMethodInvocation staticMethodInvocation, Scope scope) {
        if (this.canBePrepared(staticMethodInvocation, scope)) {
            ASTNodeInfo<StaticMethodInvocation> node = ASTNodeInfo.create(staticMethodInvocation);
            this.staticMethodInvocations.put(node, scope);
        }
    }

    void prepare(StaticFieldAccess staticFieldAccess, Scope scope) {
        if (this.canBePrepared(staticFieldAccess, scope)) {
            ASTNodeInfo<StaticFieldAccess> node = ASTNodeInfo.create(staticFieldAccess);
            this.staticFieldInvocations.put(node, scope);
        }
    }

    void prepare(StaticConstantAccess staticConstantAccess, Scope scope) {
        if (this.canBePrepared(staticConstantAccess, scope)) {
            ASTNodeInfo<StaticConstantAccess> node = ASTNodeInfo.create(staticConstantAccess);
            this.staticConstantInvocations.put(node, scope);
        }
    }

    void prepare(ClassName clsName, Scope scope) {
        if (this.canBePrepared(clsName, scope)) {
            ASTNodeInfo<ClassName> node = ASTNodeInfo.create(clsName);
            this.clasNames.put(node, scope);
        }
    }

    void prepare(NamespaceName namespaceName, Scope scope) {
        ASTNodeInfo.Kind[] kinds = new ASTNodeInfo.Kind[]{ASTNodeInfo.Kind.CLASS, ASTNodeInfo.Kind.IFACE, ASTNodeInfo.Kind.ENUM};
        this.prepare(kinds, namespaceName, scope);
    }

    void prepare(ASTNodeInfo.Kind[] kinds, NamespaceName namespaceName, Scope scope) {
        if (this.canBePrepared(namespaceName, scope)) {
            this.prepareNamespaceName(kinds, namespaceName, scope);
        }
    }

    private void prepareNamespaceName(ASTNodeInfo.Kind[] kinds, NamespaceName namespaceName, Scope scope) {
        QualifiedName qualifiedName = QualifiedName.create(CodeUtils.extractQualifiedName(namespaceName));
        if (!VariousUtils.isSpecialClassName(qualifiedName.toString())) {
            boolean isAliased = VariousUtils.isAliased(qualifiedName, namespaceName.getStartOffset(), scope);
            if (isAliased) {
                this.prepareAliasedNamespaceName(kinds, namespaceName, scope);
            } else {
                this.prepareOccurences(kinds, namespaceName, scope);
            }
        }
    }

    private void prepareAliasedNamespaceName(ASTNodeInfo.Kind[] kinds, NamespaceName namespaceName, Scope scope) {
        List<Identifier> segments = namespaceName.getSegments();
        if (segments.size() > 1) {
            this.prepareOccurences(kinds, namespaceName, scope);
        }
        this.prepare(ASTNodeInfo.Kind.USE_ALIAS, segments.get(0), scope);
    }

    private void prepareOccurences(ASTNodeInfo.Kind[] kinds, Expression expression, Scope scope) {
        for (ASTNodeInfo.Kind kind : kinds) {
            this.prepare(kind, expression, scope);
        }
    }

    void prepare(ASTNodeInfo.Kind kind, Expression node, Scope scope) {
        ASTNodeInfo<Expression> nodeInfo = null;
        if (node instanceof Identifier) {
            nodeInfo = ASTNodeInfo.create(kind, (Identifier)node);
        } else if (node instanceof NamespaceName) {
            nodeInfo = ASTNodeInfo.create(kind, (NamespaceName)node);
        }
        if (nodeInfo != null && this.canBePrepared(node, scope)) {
            switch (nodeInfo.getKind()) {
                case CLASS: {
                    this.clasIDs.put(nodeInfo, scope);
                    break;
                }
                case IFACE: {
                    this.ifaceIDs.put(nodeInfo, scope);
                    break;
                }
                case TRAIT: {
                    this.traitIDs.put(nodeInfo, scope);
                    break;
                }
                case ENUM: {
                    this.enumIDs.put(nodeInfo, scope);
                    break;
                }
                case CONSTANT: {
                    if (!(node instanceof NamespaceName) && !(node instanceof Identifier)) break;
                    this.nsConstInvocations.put(nodeInfo, scope);
                    break;
                }
                case FUNCTION: {
                    if (!(node instanceof NamespaceName)) break;
                    this.nsFunctionInvocations.put(nodeInfo, scope);
                    break;
                }
                case USE_ALIAS: {
                    this.useAliases.put(nodeInfo, scope);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    void prepare(ClassInstanceCreation node, Scope scope) {
        ASTNodeInfo<ClassInstanceCreation> nodeInfo = ASTNodeInfo.create(node);
        if (this.canBePrepared(node, scope) && !node.isAnonymous()) {
            this.clasInstanceCreations.put(nodeInfo, scope);
        }
    }

    void prepare(ASTNodeInfo.Kind kind, Scalar scalar, Scope scope) {
        ASTNodeInfo<Scalar> nodeInfo = ASTNodeInfo.create(kind, scalar);
        if (this.canBePrepared(scalar, scope)) {
            this.constInvocations.put(nodeInfo, scope);
        }
    }

    void prepare(ASTNodeInfo<Scalar> nodeInfo, ConstantElement constantElement) {
        Scalar scalar = nodeInfo.getOriginalNode();
        if (this.canBePrepared(scalar, constantElement)) {
            this.constDeclarations.put(nodeInfo, constantElement);
        }
    }

    void prepare(ConstantDeclarationInfo constantNodeInfo, ConstantElement scope) {
        if (constantNodeInfo != null && this.canBePrepared((ASTNode)constantNodeInfo.getOriginalNode(), scope)) {
            this.constDeclarations53.put(constantNodeInfo, scope);
        }
    }

    void prepare(PHPDocTypeTag pHPDocTag, Scope scope) {
        if (this.canBePrepared(pHPDocTag, scope)) {
            List<? extends PhpDocTypeTagInfo> infos = PhpDocTypeTagInfo.create(pHPDocTag, scope);
            for (PhpDocTypeTagInfo phpDocTypeTagInfo : infos) {
                this.docTags.put(phpDocTypeTagInfo, scope);
            }
        }
    }

    void prepare(ClassDeclaration classDeclaration, ClassScope scope) {
        if (this.canBePrepared(classDeclaration, scope)) {
            ClassDeclarationInfo node = ClassDeclarationInfo.create(classDeclaration);
            this.clasDeclarations.put(node, scope);
            QualifiedName superClassName = QualifiedName.create(classDeclaration.getSuperClass());
            if (superClassName != null) {
                if (VariousUtils.isAlias(superClassName, classDeclaration.getStartOffset(), scope)) {
                    this.prepare(ASTNodeInfo.Kind.USE_ALIAS, classDeclaration.getSuperClass(), (Scope)scope);
                } else {
                    this.prepare(ASTNodeInfo.Kind.CLASS, classDeclaration.getSuperClass(), (Scope)scope);
                }
            }
            List<Expression> interfaes = classDeclaration.getInterfaes();
            for (Expression iface : interfaes) {
                QualifiedName ifaceName = QualifiedName.create(iface);
                if (ifaceName != null && VariousUtils.isAlias(ifaceName, classDeclaration.getStartOffset(), scope)) {
                    this.prepare(ASTNodeInfo.Kind.USE_ALIAS, iface, (Scope)scope);
                    continue;
                }
                this.prepare(ASTNodeInfo.Kind.IFACE, iface, (Scope)scope);
            }
        }
    }

    void prepare(InterfaceDeclaration interfaceDeclaration, InterfaceScope scope) {
        if (this.canBePrepared(interfaceDeclaration, scope)) {
            InterfaceDeclarationInfo node = InterfaceDeclarationInfo.create(interfaceDeclaration);
            this.ifaceDeclarations.put(node, scope);
            List<Expression> interfaes = interfaceDeclaration.getInterfaes();
            for (Expression iface : interfaes) {
                this.prepare(ASTNodeInfo.Kind.IFACE, iface, (Scope)scope);
            }
        }
    }

    void prepare(TraitDeclaration traitDeclaration, TraitScope scope) {
        if (this.canBePrepared(traitDeclaration, scope)) {
            TraitDeclarationInfo nodeInfo = TraitDeclarationInfo.create(traitDeclaration);
            this.traitDeclarations.put(nodeInfo, scope);
        }
    }

    void prepare(EnumDeclaration enumDeclaration, EnumScope scope) {
        if (this.canBePrepared(enumDeclaration, scope)) {
            EnumDeclarationInfo node = EnumDeclarationInfo.create(enumDeclaration);
            this.enumDeclarations.put(node, scope);
            List<Expression> interfaes = enumDeclaration.getInterfaes();
            for (Expression iface : interfaes) {
                QualifiedName ifaceName = QualifiedName.create(iface);
                if (ifaceName != null && VariousUtils.isAlias(ifaceName, enumDeclaration.getStartOffset(), scope)) {
                    this.prepare(ASTNodeInfo.Kind.USE_ALIAS, iface, (Scope)scope);
                    continue;
                }
                this.prepare(ASTNodeInfo.Kind.IFACE, iface, (Scope)scope);
            }
        }
    }

    void prepare(FunctionDeclaration functionDeclaration, FunctionScope scope) {
        if (this.canBePrepared(functionDeclaration, scope)) {
            FunctionDeclarationInfo node = FunctionDeclarationInfo.create(functionDeclaration);
            this.fncDeclarations.put(node, scope);
        }
    }

    void prepare(MethodDeclaration methodDeclaration, MethodScope scope) {
        if (this.canBePrepared(methodDeclaration, scope)) {
            ClassScope classScope;
            String className;
            MethodDeclarationInfo node = MethodDeclarationInfo.create(methodDeclaration, scope.getTypeScope());
            this.methodDeclarations.put(node, scope);
            if (scope.getInScope() instanceof ClassScope && (className = (classScope = (ClassScope)scope.getInScope()).getName()) != null && className.equals(CodeUtils.extractMethodName(methodDeclaration))) {
                this.prepare(ASTNodeInfo.Kind.CLASS, methodDeclaration.getFunction().getFunctionName(), (Scope)scope);
            }
        }
    }

    void prepare(MagicMethodDeclarationInfo node, MethodScope scope) {
        if (this.canBePrepared((ASTNode)node.getOriginalNode(), scope) && ASTNodeInfoUtils.isMethod(node.getKind())) {
            this.magicMethodDeclarations.put(node, scope);
        }
    }

    void prepare(ClassConstantDeclarationInfo constantNodeInfo, ClassConstantElement scope) {
        if (constantNodeInfo != null && this.canBePrepared((ASTNode)constantNodeInfo.getOriginalNode(), scope)) {
            this.classConstantDeclarations.put(constantNodeInfo, scope);
        }
    }

    void prepare(CaseDeclarationInfo caseNodeInfo, CaseElement scope) {
        if (caseNodeInfo != null && this.canBePrepared((ASTNode)caseNodeInfo.getOriginalNode(), scope)) {
            this.caseDeclarations.put(caseNodeInfo, scope);
        }
    }

    private boolean setElementInfo(int offset) {
        this.elementInfo = null;
        ArrayList<LazyBuild> scopesToScan = new ArrayList<LazyBuild>();
        for (Map.Entry<ASTNodeInfo<MethodDeclaration>, MethodScope> entry : this.methodDeclarations.entrySet()) {
            if (entry.getValue() instanceof LazyBuild) {
                LazyBuild scope = (LazyBuild)((Object)entry.getValue());
                scopesToScan.add(scope);
            }
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (LazyBuild lazyBuild : scopesToScan) {
            if (lazyBuild.isScanned()) continue;
            lazyBuild.scan();
        }
        for (Map.Entry<ASTNodeInfo<Statement>, Scope> entry : this.gotoStatement.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<Statement>, Scope> entry : this.gotoLabel.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<Statement>, ModelElement> entry : this.includes.entrySet()) {
            NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(entry.getValue());
            if (namespaceScope == null) continue;
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), namespaceScope), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.fieldInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.methodInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.fldDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.variables.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.fncInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.staticMethodInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.staticFieldInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.staticConstantInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.clasNames.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.clasInstanceCreations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.clasIDs.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.ifaceIDs.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.traitIDs.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.enumIDs.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.constInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.constDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.constDeclarations53.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.docTags.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.clasDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.ifaceDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.traitDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.enumDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.fncDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.magicMethodDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.classConstantDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.caseDeclarations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.nsConstInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.nsFunctionInvocations.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        for (Map.Entry<ASTNodeInfo<ASTNode>, ModelElement> entry : this.useAliases.entrySet()) {
            this.setOffsetElementInfo(new ElementInfo(entry.getKey(), entry.getValue()), offset);
        }
        return this.elementInfo != null;
    }

    private boolean setElementInfo(ModelElement element) {
        this.elementInfo = new ElementInfo(element);
        return true;
    }

    private void build(FileScopeImpl fileScope) {
        ASTNodeInfo.Kind kind;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        ASTNodeInfo.Kind kind2 = kind = this.elementInfo != null ? this.elementInfo.getKind() : null;
        if (this.elementInfo != null && kind != null) {
            IndexScope indexScope = ModelUtils.getIndexScope(fileScope);
            ElementQuery.Index index = indexScope.getIndex();
            this.cachedOccurences.clear();
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.scanMethodBodies();
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            switch (kind) {
                case GOTO: {
                    this.buildGotoLabels(this.elementInfo, fileScope, this.cachedOccurences);
                    this.buildGotoStatements(this.elementInfo, fileScope, this.cachedOccurences);
                    break;
                }
                case FUNCTION: {
                    Set<FunctionElement> functions = index.getFunctions(NameKind.exact(this.elementInfo.getQualifiedName()));
                    this.elementInfo.setDeclarations(functions);
                    this.buildFunctionInvocations(this.elementInfo, fileScope, this.cachedOccurences);
                    this.buildFunctionDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
                    break;
                }
                case VARIABLE: {
                    this.buildVariables(this.elementInfo, fileScope, this.cachedOccurences);
                    this.buildDocTagsForVars(this.elementInfo, fileScope, this.cachedOccurences);
                    break;
                }
                case STATIC_METHOD: {
                    this.buildStaticMethods(index, fileScope, this.cachedOccurences);
                    break;
                }
                case FIELD: {
                    this.buildFields(index, fileScope, this.cachedOccurences);
                    if (this.promotedVariableElementInfo == null) break;
                    this.buildVariables(this.promotedVariableElementInfo, fileScope, this.cachedOccurences);
                    this.buildDocTagsForVars(this.promotedVariableElementInfo, fileScope, this.cachedOccurences);
                    this.promotedVariableElementInfo = null;
                    break;
                }
                case STATIC_FIELD: {
                    this.buildStaticFields(index, fileScope, this.cachedOccurences);
                    break;
                }
                case CONSTANT: {
                    Set<org.netbeans.modules.php.editor.api.elements.ConstantElement> constants = index.getConstants(NameKind.exact(this.elementInfo.getQualifiedName()));
                    this.elementInfo.setDeclarations(constants);
                    this.cachedOccurences.clear();
                    this.buildConstantInvocations(this.elementInfo, fileScope, this.cachedOccurences);
                    this.buildConstantDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
                    break;
                }
                case CLASS_CONSTANT: 
                case STATIC_CLASS_CONSTANT: 
                case ENUM_CASE: {
                    this.buildTypeConstants(index, fileScope, this.cachedOccurences);
                    this.buildEnumCases(index, fileScope, this.cachedOccurences);
                    break;
                }
                case CLASS: 
                case IFACE: 
                case TRAIT: 
                case ENUM: 
                case CLASS_INSTANCE_CREATION: {
                    QualifiedName qualifiedName = this.elementInfo.getNodeInfo() != null ? VariousUtils.getFullyQualifiedName(this.elementInfo.getNodeInfo().getQualifiedName(), ((ASTNode)this.elementInfo.getNodeInfo().getOriginalNode()).getStartOffset(), this.elementInfo.getScope()) : this.elementInfo.getQualifiedName();
                    Set<TypeElement> types = index.getTypes(NameKind.exact(qualifiedName));
                    if (!this.elementInfo.setDeclarations(types)) break;
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    boolean isClass = false;
                    boolean isInterface = false;
                    boolean isTrait = false;
                    boolean isEnum = false;
                    for (TypeElement type : types) {
                        if (type.isClass()) {
                            isClass = true;
                            continue;
                        }
                        if (type.isInterface()) {
                            isInterface = true;
                            continue;
                        }
                        if (type.isTrait()) {
                            isTrait = true;
                            continue;
                        }
                        if (type.isEnum()) {
                            isEnum = true;
                            continue;
                        }
                        assert (false) : "Unknown type: " + type;
                    }
                    if (isClass) {
                        this.buildClassNames(this.elementInfo, fileScope, this.cachedOccurences);
                        this.buildClassIDs(this.elementInfo, fileScope, this.cachedOccurences);
                        this.buildClassDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
                    }
                    if (isInterface) {
                        this.buildInterfaceIDs(this.elementInfo, fileScope, this.cachedOccurences);
                        this.buildInterfaceDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
                    }
                    if (isTrait) {
                        this.buildTraitDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
                        this.buildTraitIDs(this.elementInfo, fileScope, this.cachedOccurences);
                    }
                    if (isEnum) {
                        this.buildEnumDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
                        this.buildEnumIDs(this.elementInfo, fileScope, this.cachedOccurences);
                    }
                    if (!isClass && !isInterface) break;
                    this.buildDocTagsForClasses(this.elementInfo, fileScope, this.cachedOccurences);
                    this.buildClassInstanceCreation(this.elementInfo, fileScope, this.cachedOccurences);
                    break;
                }
                case METHOD: {
                    Scope scope;
                    this.buildMethods(index, fileScope, this.cachedOccurences);
                    if (this.elementInfo.getModelElemnt() == null || !((scope = this.elementInfo.getScope()) instanceof MethodScope) || !"__construct".equalsIgnoreCase(this.elementInfo.getName())) break;
                    this.buildMethods(index, fileScope, this.cachedOccurences);
                    this.setElementInfo((TypeScope)scope.getInScope());
                    if (!this.elementInfo.setDeclarations(index.getTypes(NameKind.exact(this.elementInfo.getQualifiedName())))) break;
                    this.buildClassInstanceCreation(this.elementInfo, fileScope, this.cachedOccurences, true);
                    break;
                }
                case INCLUDE: {
                    this.buildIncludes(this.elementInfo, fileScope, this.cachedOccurences);
                    break;
                }
                case USE_ALIAS: {
                    if (!this.elementInfo.setDeclarations(this.getUseAliasesDeclarations(this.elementInfo))) break;
                    this.buildDocTagsForUseAliases(this.elementInfo, fileScope, this.cachedOccurences);
                    this.buildUseAliases(this.elementInfo, fileScope, this.cachedOccurences);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    private void buildStaticFields(ElementQuery.Index index, FileScopeImpl fileScope, List<Occurence> occurences) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Collection<? extends TypeElement> types = OccurenceBuilder.resolveTypes(index, this.elementInfo);
        if (!types.isEmpty()) {
            NameKind.Exact fieldName = NameKind.exact(this.elementInfo.getName());
            HashSet<FieldElement> fields = new HashSet<FieldElement>();
            for (TypeElement typeElement : types) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                fields.addAll(ElementFilter.forName(fieldName).filter(index.getAlllFields(typeElement)));
            }
            if (this.elementInfo.setDeclarations(fields)) {
                occurences.clear();
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                this.buildStaticFieldInvocations(this.elementInfo, fileScope, occurences);
                this.buildFieldDeclarations(this.elementInfo, fileScope, occurences);
                this.buildDocTagsForFields(this.elementInfo, fileScope, occurences);
            }
        }
    }

    private void buildFields(ElementQuery.Index index, FileScopeImpl fileScope, List<Occurence> occurences) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        NameKind.Exact fieldName = NameKind.exact(this.elementInfo.getName());
        Set<Object> fields = new HashSet();
        Scope scope = this.elementInfo.getScope();
        ASTNodeInfo nodeInfo = this.elementInfo.getNodeInfo();
        if (fields.isEmpty()) {
            String fldName = this.elementInfo.getName();
            fields = index.getFields(NameKind.exact(fldName.startsWith("$") ? fldName.substring(1) : fldName));
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Occurence.Accuracy accuracy = Occurence.Accuracy.NO;
        if (fields.size() == 1) {
            accuracy = this.elementInfo.setDeclarations(fields) ? Occurence.Accuracy.UNIQUE : null;
            this.elementInfo.setDeclarations(fields);
        } else {
            Object originalNode;
            if (nodeInfo != null && scope instanceof VariableScope && (originalNode = nodeInfo.getOriginalNode()) instanceof VariableBase) {
                types.addAll(OccurenceBuilder.getClassName((VariableScope)scope, (VariableBase)originalNode));
            }
            if (scope instanceof FieldElementImpl) {
                Scope inScope = ((FieldElementImpl)scope).getInScope();
                types.add((TypeElement)((Object)inScope));
            }
            if (types.size() > 0) {
                if (!fields.isEmpty()) {
                    fields = new HashSet();
                    for (TypeElement typeElement : types) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        fields.addAll(ElementFilter.forName(fieldName).filter(index.getAlllFields(typeElement)));
                    }
                }
                if (fields.isEmpty() && types.size() == 1) {
                    accuracy = this.elementInfo.setDeclarations(types) ? Occurence.Accuracy.EXACT_TYPE : null;
                    this.elementInfo.setDeclarations(types);
                } else if (fields.isEmpty() && types.size() > 1) {
                    accuracy = Occurence.Accuracy.MORE_TYPES;
                    this.elementInfo.setDeclarations(types);
                } else if (fields.size() == 1) {
                    accuracy = Occurence.Accuracy.EXACT;
                    this.elementInfo.setDeclarations(fields);
                } else if (!fields.isEmpty() && !types.isEmpty()) {
                    accuracy = Occurence.Accuracy.MORE_MEMBERS;
                    this.elementInfo.setDeclarations(fields);
                }
            } else if (!fields.isEmpty()) {
                accuracy = Occurence.Accuracy.MORE;
                this.elementInfo.setDeclarations(fields);
            }
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        if (accuracy != null) {
            occurences.clear();
            if (EnumSet.of(Occurence.Accuracy.EXACT, new Occurence.Accuracy[]{Occurence.Accuracy.EXACT_TYPE, Occurence.Accuracy.UNIQUE, Occurence.Accuracy.EXACT_TYPE, Occurence.Accuracy.MORE_MEMBERS, Occurence.Accuracy.MORE}).contains((Object)accuracy)) {
                this.buildFieldInvocations(this.elementInfo, fileScope, accuracy, occurences);
                this.buildFieldDeclarations(this.elementInfo, fileScope, occurences);
                this.buildDocTagsForFields(this.elementInfo, fileScope, occurences);
            } else if (!accuracy.equals((Object)Occurence.Accuracy.NO)) {
                OccurenceImpl occurence2 = new OccurenceImpl(this.elementInfo.getDeclarations(), nodeInfo.getRange());
                occurence2.setAccuracy(accuracy);
                occurences.add(occurence2);
            }
        }
    }

    private void buildMethods(ElementQuery.Index index, FileScopeImpl fileScope, List<Occurence> occurences) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        NameKind.Exact methodName = NameKind.exact(this.elementInfo.getName());
        Set<Object> methods = new HashSet();
        Scope scope = this.elementInfo.getScope();
        ASTNodeInfo nodeInfo = this.elementInfo.getNodeInfo();
        ModelElement modelElement = this.elementInfo.getModelElemnt();
        if (methods.isEmpty()) {
            methods = index.getMethods(methodName);
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Occurence.Accuracy accuracy = Occurence.Accuracy.NO;
        if (methods.size() == 1) {
            accuracy = this.elementInfo.setDeclarations(methods) ? Occurence.Accuracy.UNIQUE : null;
            this.elementInfo.setDeclarations(methods);
        } else {
            if (nodeInfo != null) {
                Object originalNode = nodeInfo.getOriginalNode();
                if (scope instanceof MethodScopeImpl && originalNode instanceof MethodDeclaration) {
                    types.add((TypeElement)((Object)scope.getInScope()));
                } else if (scope instanceof VariableScope && originalNode instanceof VariableBase) {
                    types.addAll(OccurenceBuilder.getClassName((VariableScope)scope, (VariableBase)originalNode));
                }
            } else if (modelElement instanceof MethodScopeImpl && modelElement.getInScope() instanceof TypeScope) {
                types.add((TypeElement)((Object)scope.getInScope()));
            }
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (types.size() > 0) {
                if (!methods.isEmpty()) {
                    methods = new HashSet();
                    for (TypeElement typeElement : types) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        methods.addAll(ElementFilter.forName(methodName).filter(index.getAllMethods(typeElement)));
                    }
                }
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                if (methods.isEmpty() && types.size() == 1) {
                    accuracy = this.elementInfo.setDeclarations(types) ? Occurence.Accuracy.EXACT_TYPE : null;
                    this.elementInfo.setDeclarations(types);
                } else if (methods.isEmpty() && types.size() > 1) {
                    accuracy = Occurence.Accuracy.MORE_TYPES;
                    this.elementInfo.setDeclarations(types);
                } else if (methods.size() == 1) {
                    accuracy = Occurence.Accuracy.EXACT;
                    this.elementInfo.setDeclarations(methods);
                } else if (!methods.isEmpty() && !types.isEmpty()) {
                    accuracy = Occurence.Accuracy.MORE_MEMBERS;
                    this.elementInfo.setDeclarations(methods);
                }
            }
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        if (accuracy != null) {
            occurences.clear();
            if (EnumSet.of(Occurence.Accuracy.EXACT, new Occurence.Accuracy[]{Occurence.Accuracy.EXACT_TYPE, Occurence.Accuracy.UNIQUE, Occurence.Accuracy.EXACT_TYPE, Occurence.Accuracy.MORE_MEMBERS, Occurence.Accuracy.MORE}).contains((Object)accuracy)) {
                this.buildMethodInvocations(this.elementInfo, fileScope, accuracy, this.cachedOccurences);
                this.buildStaticMethodInvocations(this.elementInfo, fileScope, this.cachedOccurences, false);
                this.buildMethodDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
                this.buildMagicMethodDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
            } else if (!accuracy.equals((Object)Occurence.Accuracy.NO)) {
                OccurenceImpl occurence2 = new OccurenceImpl(this.elementInfo.getDeclarations(), nodeInfo.getRange());
                occurence2.setAccuracy(accuracy);
                occurences.add(occurence2);
            }
        }
    }

    private void buildTypeConstants(ElementQuery.Index index, FileScopeImpl fileScope, List<Occurence> occurences) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Collection<? extends TypeElement> types = OccurenceBuilder.resolveTypes(index, this.elementInfo);
        if (!types.isEmpty()) {
            NameKind.Exact typeConstantName = NameKind.exact(this.elementInfo.getName());
            HashSet<TypeConstantElement> constants = new HashSet<TypeConstantElement>();
            for (TypeElement typeElement : types) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                constants.addAll(ElementFilter.forName(typeConstantName).filter(index.getAllTypeConstants(typeElement)));
            }
            if (this.elementInfo.setDeclarations(constants)) {
                this.buildStaticConstantInvocations(this.elementInfo, fileScope, this.cachedOccurences);
                this.buildStaticConstantDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
            }
        }
    }

    private void buildEnumCases(ElementQuery.Index index, FileScopeImpl fileScope, List<Occurence> occurences) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Collection<? extends TypeElement> types = OccurenceBuilder.resolveTypes(index, this.elementInfo);
        if (!types.isEmpty()) {
            NameKind.Exact enumCaseName = NameKind.exact(this.elementInfo.getName());
            HashSet<EnumCaseElement> enumCases = new HashSet<EnumCaseElement>();
            for (TypeElement typeElement : types) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                enumCases.addAll(ElementFilter.forName(enumCaseName).filter(index.getAllEnumCases(typeElement)));
            }
            if (this.elementInfo.setDeclarations(enumCases)) {
                this.buildEnumCaseDeclarations(this.elementInfo, this.cachedOccurences);
                this.buildEnumCaseInvocations(this.elementInfo, fileScope, this.cachedOccurences);
            }
        }
    }

    private void buildStaticMethods(ElementQuery.Index index, FileScopeImpl fileScope, List<Occurence> occurences) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Collection<? extends TypeElement> types = OccurenceBuilder.resolveTypes(index, this.elementInfo);
        if (!types.isEmpty()) {
            NameKind.Exact methodName = NameKind.exact(this.elementInfo.getName());
            HashSet<MethodElement> methods = new HashSet<MethodElement>();
            for (TypeElement typeElement : types) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                methods.addAll(ElementFilter.forName(methodName).filter(index.getAllMethods(typeElement)));
            }
            if (this.elementInfo.setDeclarations(methods)) {
                occurences.clear();
                this.buildStaticMethodInvocations(this.elementInfo, fileScope, occurences, false);
                if (OptionsUtils.codeCompletionStaticMethods()) {
                    this.buildMethodInvocations(this.elementInfo, fileScope, Occurence.Accuracy.UNIQUE, occurences);
                }
                this.buildMethodDeclarations(this.elementInfo, fileScope, occurences);
                this.buildMagicMethodDeclarations(this.elementInfo, fileScope, this.cachedOccurences);
            }
        }
    }

    private void buildMagicMethodDeclarations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        for (Map.Entry<MagicMethodDeclarationInfo, MethodScope> entry : this.magicMethodDeclarations.entrySet()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            MagicMethodDeclarationInfo nodeInfo = entry.getKey();
            if (!OccurenceBuilder.isNameEquality(nodeCtxInfo, nodeInfo, entry.getValue())) continue;
            occurences.add(new OccurenceImpl(entry.getValue(), nodeInfo.getRange()));
        }
    }

    private void buildMethodInvocations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, Occurence.Accuracy accuracy, List<Occurence> occurences) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Set<? extends PhpElement> declarations = nodeCtxInfo.getDeclarations();
        HashMap<QualifiedName, TypeScope> notMatchingTypeNames = new HashMap<QualifiedName, TypeScope>();
        HashMap<QualifiedName, TypeElement> matchingTypeNames = new HashMap<QualifiedName, TypeElement>();
        for (PhpElement phpElement : declarations) {
            TypeElement type;
            if (phpElement instanceof MethodElement) {
                type = ((MethodElement)phpElement).getType();
                matchingTypeNames.put(type.getFullyQualifiedName(), type);
                continue;
            }
            if (!(phpElement instanceof TypeElement)) continue;
            type = (TypeElement)phpElement;
            matchingTypeNames.put(type.getFullyQualifiedName(), type);
        }
        if (matchingTypeNames.size() > 0) {
            NameKind.Exact name = NameKind.exact(nodeCtxInfo.getQualifiedName());
            ElementFilter elementFilter = ElementFilter.forName(name);
            block1: for (Map.Entry<ASTNodeInfo<MethodInvocation>, Scope> entry : this.methodInvocations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<MethodInvocation> nodeInfo = entry.getKey();
                if (!name.matchesName(PhpElementKind.METHOD, nodeInfo.getQualifiedName())) continue;
                HashSet<? extends TypeScope> types = new HashSet<TypeScope>(OccurenceBuilder.getClassName((VariableScope)entry.getValue(), nodeInfo.getOriginalNode()));
                if (types.isEmpty() || !OccurenceBuilder.createTypeFilter(matchingTypeNames.values(), false).filter(types).isEmpty()) {
                    OccurenceImpl occurence = new OccurenceImpl(declarations, nodeInfo.getRange());
                    occurence.setAccuracy(accuracy);
                    occurences.add(occurence);
                    continue;
                }
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                IndexScope indexScope = ModelUtils.getIndexScope(fileScope);
                ElementQuery.Index index = indexScope.getIndex();
                for (TypeScope typeScope : types) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (!OccurenceBuilder.createTypeFilter(notMatchingTypeNames.values(), false).filter(typeScope).isEmpty()) continue;
                    ElementFilter typeFilter = OccurenceBuilder.createTypeFilter(matchingTypeNames.values(), true);
                    Set<MethodElement> methods = typeFilter.filter(elementFilter.filter(index.getAllMethods(typeScope)));
                    if (!methods.isEmpty()) {
                        matchingTypeNames.put(typeScope.getFullyQualifiedName(), typeScope);
                        OccurenceImpl occurence = new OccurenceImpl(declarations, nodeInfo.getRange());
                        occurence.setAccuracy(accuracy);
                        occurences.add(occurence);
                        continue block1;
                    }
                    notMatchingTypeNames.put(typeScope.getFullyQualifiedName(), typeScope);
                }
            }
        }
    }

    private Set<PhpElement> getUseAliasesDeclarations(ElementInfo nodeCtxInfo) {
        HashSet<PhpElement> aliasDeclarations = new HashSet<PhpElement>();
        Collection<? extends UseScope> declaredUses = nodeCtxInfo.getNamespaceScope().getAllDeclaredSingleUses();
        for (UseScope useScope : declaredUses) {
            UseAliasElement aliasElement = useScope.getAliasElement();
            if (aliasElement == null || !aliasElement.getName().equals(nodeCtxInfo.getName())) continue;
            aliasDeclarations.add(aliasElement);
        }
        return aliasDeclarations;
    }

    private void buildUseAliases(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof UseAliasElement)) continue;
            UseAliasElement useAliasElement = (UseAliasElement)phpElement;
            for (Map.Entry<ASTNodeInfo<Expression>, Scope> entry : this.useAliases.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<Expression> nodeInfo = entry.getKey();
                if (!nodeInfo.getName().equals(useAliasElement.getName())) continue;
                occurences.add(new OccurenceImpl(useAliasElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildIncludes(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        String idName = nodeCtxInfo.getName();
        for (Map.Entry<IncludeInfo, IncludeElement> entry : this.includes.entrySet()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            IncludeInfo nodeInfo = entry.getKey();
            if (!idName.equalsIgnoreCase(nodeInfo.getName())) continue;
            occurences.add(new OccurenceImpl(entry.getValue(), nodeInfo.getRange()));
        }
    }

    private void buildConstantInvocations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            ASTNodeInfo<Expression> nodeInfo;
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            for (Map.Entry<ASTNodeInfo<Scalar>, Scope> entry : this.constInvocations.entrySet()) {
                nodeInfo = entry.getKey();
                if (nodeInfo.getName().length() <= 0 || !NameKind.exact(nodeInfo.getName()).matchesName(phpElement)) continue;
                occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(elements), nodeInfo.getRange()));
            }
            for (Map.Entry<ASTNodeInfo<Expression>, Scope> entry : this.nsConstInvocations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                nodeInfo = entry.getKey();
                Expression originalNode = nodeInfo.getOriginalNode();
                QualifiedName qualifiedName = null;
                if (originalNode instanceof NamespaceName) {
                    NamespaceName namespaceName = (NamespaceName)originalNode;
                    qualifiedName = QualifiedName.create(namespaceName);
                } else if (originalNode instanceof Identifier) {
                    Identifier identifier = (Identifier)originalNode;
                    qualifiedName = QualifiedName.create(identifier);
                }
                if (qualifiedName == null || !NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(elements), nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildConstantDeclarations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        ClassConstantDeclarationInfo nodeInfo;
        String idName = nodeCtxInfo.getName();
        for (Map.Entry<ASTNodeInfo<Scalar>, ConstantElement> entry : this.constDeclarations.entrySet()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            nodeInfo = entry.getKey();
            if (!idName.equalsIgnoreCase(((ASTNodeInfo)nodeInfo).getName())) continue;
            occurences.add(new OccurenceImpl(entry.getValue(), ((ASTNodeInfo)nodeInfo).getRange()));
        }
        for (Map.Entry<ASTNodeInfo<Scalar>, ConstantElement> entry : this.constDeclarations53.entrySet()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            nodeInfo = (ClassConstantDeclarationInfo)entry.getKey();
            if (!idName.equalsIgnoreCase(nodeInfo.getName())) continue;
            occurences.add(new OccurenceImpl(entry.getValue(), nodeInfo.getRange()));
        }
    }

    private void buildStaticConstantDeclarations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof TypeConstantElement)) continue;
            TypeConstantElement constantElement = (TypeConstantElement)phpElement;
            TypeElement typeElement = constantElement.getType();
            NameKind.Exact typeName = NameKind.exact(typeElement.getFullyQualifiedName());
            NameKind.Exact constName = NameKind.exact(constantElement.getName());
            for (Map.Entry<ASTNodeInfo<Identifier>, ClassConstantElement> entry : this.classConstantDeclarations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<Identifier> nodeInfo = entry.getKey();
                TypeScope typeScope = (TypeScope)entry.getValue().getInScope();
                if (!typeName.matchesName(typeScope) || !constName.matchesName(PhpElementKind.TYPE_CONSTANT, nodeInfo.getName())) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildEnumCaseDeclarations(ElementInfo nodeCtxInfo, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof EnumCaseElement)) continue;
            EnumCaseElement enumCaseElement = (EnumCaseElement)phpElement;
            TypeElement typeElement = enumCaseElement.getType();
            NameKind.Exact typeName = NameKind.exact(typeElement.getFullyQualifiedName());
            NameKind.Exact enumCaseName = NameKind.exact(enumCaseElement.getName());
            for (Map.Entry<ASTNodeInfo<Identifier>, CaseElement> entry : this.caseDeclarations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<Identifier> nodeInfo = entry.getKey();
                TypeScope typeScope = (TypeScope)entry.getValue().getInScope();
                if (!typeName.matchesName(typeScope) || !enumCaseName.matchesName(PhpElementKind.ENUM_CASE, nodeInfo.getName())) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildFieldInvocations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, Occurence.Accuracy accuracy, List<Occurence> occurences) {
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Set<? extends PhpElement> declarations = nodeCtxInfo.getDeclarations();
        HashMap<QualifiedName, TypeScope> notMatchingTypeNames = new HashMap<QualifiedName, TypeScope>();
        HashMap<QualifiedName, TypeElement> matchingTypeNames = new HashMap<QualifiedName, TypeElement>();
        for (PhpElement phpElement : declarations) {
            TypeElement type;
            if (phpElement instanceof FieldElement) {
                type = ((FieldElement)phpElement).getType();
                matchingTypeNames.put(type.getFullyQualifiedName(), type);
                continue;
            }
            if (!(phpElement instanceof TypeElement)) continue;
            type = (TypeElement)phpElement;
            matchingTypeNames.put(type.getFullyQualifiedName(), type);
        }
        if (matchingTypeNames.size() > 0) {
            NameKind.Exact name = NameKind.exact(nodeCtxInfo.getQualifiedName());
            ElementFilter elementFilter = ElementFilter.forName(name);
            block1: for (Map.Entry<ASTNodeInfo<FieldAccess>, Scope> entry : this.fieldInvocations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<FieldAccess> nodeInfo = entry.getKey();
                if (!name.matchesName(PhpElementKind.FIELD, nodeInfo.getName())) continue;
                HashSet<? extends TypeScope> types = new HashSet<TypeScope>(OccurenceBuilder.getClassName((VariableScope)entry.getValue(), nodeInfo.getOriginalNode()));
                if (types.isEmpty() || !OccurenceBuilder.createTypeFilter(matchingTypeNames.values(), false).filter(types).isEmpty()) {
                    OccurenceImpl occurence = new OccurenceImpl(declarations, nodeInfo.getRange());
                    occurence.setAccuracy(accuracy);
                    occurences.add(occurence);
                    continue;
                }
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                IndexScope indexScope = ModelUtils.getIndexScope(fileScope);
                ElementQuery.Index index = indexScope.getIndex();
                for (TypeScope typeScope : types) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    if (!OccurenceBuilder.createTypeFilter(notMatchingTypeNames.values(), false).filter(typeScope).isEmpty()) continue;
                    ElementFilter typeFilter = OccurenceBuilder.createTypeFilter(matchingTypeNames.values(), true);
                    Set<FieldElement> fields = typeFilter.filter(elementFilter.filter(index.getAlllFields(typeScope)));
                    if (!fields.isEmpty()) {
                        matchingTypeNames.put(typeScope.getFullyQualifiedName(), typeScope);
                        OccurenceImpl occurence = new OccurenceImpl(declarations, nodeInfo.getRange());
                        occurence.setAccuracy(accuracy);
                        occurences.add(occurence);
                        continue block1;
                    }
                    notMatchingTypeNames.put(typeScope.getFullyQualifiedName(), typeScope);
                }
            }
        }
    }

    private void buildMethodDeclarations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof MethodElement)) continue;
            MethodElement method = (MethodElement)phpElement;
            ElementFilter typeFilter = OccurenceBuilder.createTypeFilter(method.getType(), false);
            NameKind.Exact methodName = NameKind.exact(method.getName());
            for (Map.Entry<ASTNodeInfo<MethodDeclaration>, MethodScope> entry : this.methodDeclarations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<MethodDeclaration> nodeInfo = entry.getKey();
                if (!methodName.matchesName(PhpElementKind.METHOD, nodeInfo.getName()) || !typeFilter.isAccepted((TypeScope)entry.getValue().getInScope())) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private static ElementFilter createTypeFilter(Collection<TypeElement> types, boolean forTypeMembers) {
        ArrayList<ElementFilter> typeFilters = new ArrayList<ElementFilter>();
        for (TypeElement typeElement : types) {
            typeFilters.add(OccurenceBuilder.createTypeFilter(typeElement, forTypeMembers));
        }
        return ElementFilter.anyOf(typeFilters);
    }

    private static ElementFilter createTypeFilter(final TypeElement typeToCompareWith, boolean forTypeMembers) {
        final ElementFilter typeFilter = new ElementFilter(){
            final ElementFilter filterDelegate;
            {
                this.filterDelegate = ElementFilter.anyOf(ElementFilter.forEqualTypes(typeToCompareWith));
            }

            @Override
            public boolean isAccepted(PhpElement element) {
                if (element instanceof TypeElement) {
                    TypeElement typeElement = (TypeElement)element;
                    if (this.filterDelegate.isAccepted(element)) {
                        return true;
                    }
                    ElementQuery elementQuery = typeToCompareWith.getElementQuery();
                    if (elementQuery instanceof ElementQuery.Index) {
                        return !ElementFilter.forEqualTypes(typeElement).filter(((ElementQuery.Index)elementQuery).getInheritedByTypes(typeToCompareWith)).isEmpty();
                    }
                }
                return false;
            }
        };
        return !forTypeMembers ? typeFilter : new ElementFilter(){

            @Override
            public boolean isAccepted(PhpElement element) {
                if (element instanceof TypeMemberElement) {
                    return typeFilter.isAccepted(((TypeMemberElement)element).getType());
                }
                return true;
            }
        };
    }

    private void buildStaticFieldInvocations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        HashSet<QualifiedName> matchingTypeNames = new HashSet<QualifiedName>();
        HashSet<QualifiedName> notMatchingTypeNames = new HashSet<QualifiedName>();
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof FieldElement)) continue;
            FieldElement fieldElement = (FieldElement)phpElement;
            matchingTypeNames.add(fieldElement.getType().getFullyQualifiedName());
            QualifiedName typeQualifiedName = nodeCtxInfo.getTypeQualifiedName();
            if (typeQualifiedName != null) {
                matchingTypeNames.add(typeQualifiedName);
            }
            NameKind.Exact fieldName = NameKind.exact(phpElement.getName());
            for (Map.Entry<ASTNodeInfo<StaticFieldAccess>, Scope> entry : this.staticFieldInvocations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<StaticFieldAccess> nodeInfo = entry.getKey();
                Expression dispatcher = nodeInfo.getOriginalNode().getDispatcher();
                if (!CodeUtils.isUniformVariableSyntax(dispatcher)) {
                    Scope scope;
                    QualifiedName clzName = QualifiedName.create(dispatcher);
                    if (clzName == null || (clzName = OccurenceBuilder.resolveClassName(clzName, scope = entry.getValue().getInScope())) == null || clzName.toString().length() <= 0) continue;
                    clzName = VariousUtils.getFullyQualifiedName(clzName, nodeInfo.getOriginalNode().getStartOffset(), scope);
                    if (!fieldName.matchesName(PhpElementKind.FIELD, nodeInfo.getName())) continue;
                    QualifiedName qualifiedName = VariousUtils.getFullyQualifiedName(clzName, this.elementInfo.getRange().getStart(), scope);
                    NameKind.Exact typeName = NameKind.exact(qualifiedName);
                    boolean isTheSame = false;
                    for (QualifiedName qualifiedName2 : matchingTypeNames) {
                        if (!typeName.matchesName(PhpElementKind.CLASS, qualifiedName2)) continue;
                        isTheSame = true;
                        break;
                    }
                    if (!isTheSame) {
                        boolean skipIt = false;
                        for (QualifiedName notMatchingName : notMatchingTypeNames) {
                            if (!typeName.matchesName(PhpElementKind.CLASS, notMatchingName)) continue;
                            skipIt = true;
                            break;
                        }
                        if (skipIt) continue;
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        IndexScope indexScope = ModelUtils.getIndexScope(fileScope);
                        ElementQuery.Index index = indexScope.getIndex();
                        ElementFilter forTheSameType = ElementFilter.forMembersOfType(fieldElement.getType());
                        Set<FieldElement> expectedFields = forTheSameType.filter(index.getAlllFields(NameKind.exact(clzName), fieldName));
                        boolean bl = isTheSame = !expectedFields.isEmpty();
                    }
                    if (isTheSame) {
                        matchingTypeNames.add(clzName);
                        occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
                        continue;
                    }
                    notMatchingTypeNames.add(clzName);
                    continue;
                }
                if (!fieldName.matchesName(PhpElementKind.FIELD, nodeInfo.getName())) continue;
                Collection<? extends TypeScope> types = OccurenceBuilder.getClassName((VariableScope)entry.getValue(), dispatcher);
                for (TypeScope typeScope : types) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    QualifiedName fqn = typeScope.getFullyQualifiedName();
                    NameKind.Exact typeName = NameKind.exact(fqn);
                    for (QualifiedName qualifiedName : matchingTypeNames) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (typeName.matchesName(PhpElementKind.CLASS, qualifiedName)) {
                            matchingTypeNames.add(fqn);
                            occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
                            continue;
                        }
                        notMatchingTypeNames.add(fqn);
                    }
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void buildStaticMethodInvocations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences, boolean onParentOnly) {
        HashSet<QualifiedName> matchingTypeNames = new HashSet<QualifiedName>();
        HashSet<QualifiedName> notMatchingTypeNames = new HashSet<QualifiedName>();
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof MethodElement)) continue;
            MethodElement methodElement = (MethodElement)phpElement;
            matchingTypeNames.add(methodElement.getType().getFullyQualifiedName());
            QualifiedName typeQualifiedName = nodeCtxInfo.getTypeQualifiedName();
            if (typeQualifiedName != null) {
                matchingTypeNames.add(typeQualifiedName);
            }
            NameKind.Exact methodName = NameKind.exact(phpElement.getName());
            for (Map.Entry<ASTNodeInfo<StaticMethodInvocation>, Scope> entry : this.staticMethodInvocations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<StaticMethodInvocation> nodeInfo = entry.getKey();
                Expression dispatcher = nodeInfo.getOriginalNode().getDispatcher();
                QualifiedName clzName = QualifiedName.create(dispatcher);
                if (clzName != null) {
                    Scope scope = entry.getValue().getInScope();
                    if (onParentOnly && !OccurenceBuilder.isParent(clzName) || (clzName = OccurenceBuilder.resolveClassName(clzName, scope)) == null || clzName.toString().length() <= 0 || !methodName.matchesName(PhpElementKind.METHOD, nodeInfo.getName())) continue;
                    clzName = VariousUtils.getFullyQualifiedName(clzName, nodeInfo.getOriginalNode().getStartOffset(), scope);
                    NameKind.Exact typeName = NameKind.exact(clzName);
                    boolean isTheSame = false;
                    for (Object matchingName : matchingTypeNames) {
                        if (!typeName.matchesName(PhpElementKind.CLASS, (QualifiedName)matchingName)) continue;
                        isTheSame = true;
                        break;
                    }
                    if (!isTheSame) {
                        Object matchingName;
                        boolean skipIt = false;
                        matchingName = notMatchingTypeNames.iterator();
                        while (matchingName.hasNext()) {
                            QualifiedName notMatchingName = (QualifiedName)matchingName.next();
                            if (!typeName.matchesName(PhpElementKind.CLASS, notMatchingName)) continue;
                            skipIt = true;
                            break;
                        }
                        if (skipIt) continue;
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        IndexScope indexScope = ModelUtils.getIndexScope(fileScope);
                        ElementQuery.Index index = indexScope.getIndex();
                        ElementFilter forTheSameType = ElementFilter.forMembersOfType(methodElement.getType());
                        Set<MethodElement> expectedMethods = forTheSameType.filter(index.getAllMethods(NameKind.exact(clzName), methodName));
                        boolean bl = isTheSame = !expectedMethods.isEmpty();
                    }
                    if (isTheSame) {
                        matchingTypeNames.add(clzName);
                        occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
                        continue;
                    }
                    notMatchingTypeNames.add(clzName);
                    continue;
                }
                assert (CodeUtils.isUniformVariableSyntax(dispatcher)) : dispatcher;
                if (!methodName.matchesName(PhpElementKind.METHOD, nodeInfo.getName())) continue;
                Collection<? extends TypeScope> types = OccurenceBuilder.getClassName((VariableScope)entry.getValue(), dispatcher);
                for (TypeScope type : types) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    QualifiedName fqn = type.getFullyQualifiedName();
                    NameKind.Exact typeName = NameKind.exact(fqn);
                    for (QualifiedName matchingName : matchingTypeNames) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (typeName.matchesName(PhpElementKind.CLASS, matchingName)) {
                            matchingTypeNames.add(fqn);
                            occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
                            continue;
                        }
                        notMatchingTypeNames.add(fqn);
                    }
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void buildEnumCaseInvocations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        HashSet<QualifiedName> matchingTypeNames = new HashSet<QualifiedName>();
        HashSet<QualifiedName> notMatchingTypeNames = new HashSet<QualifiedName>();
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof EnumCaseElement)) continue;
            EnumCaseElement enumCaseElement = (EnumCaseElement)phpElement;
            matchingTypeNames.add(enumCaseElement.getType().getFullyQualifiedName());
            QualifiedName typeQualifiedName = nodeCtxInfo.getTypeQualifiedName();
            if (typeQualifiedName != null) {
                matchingTypeNames.add(typeQualifiedName);
            }
            NameKind.Exact enumCaseName = NameKind.exact(phpElement.getName());
            for (Map.Entry<ASTNodeInfo<StaticConstantAccess>, Scope> entry : this.staticConstantInvocations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<StaticConstantAccess> nodeInfo = entry.getKey();
                Expression dispatcher = nodeInfo.getOriginalNode().getDispatcher();
                QualifiedName clzName = QualifiedName.create(dispatcher);
                if (clzName != null) {
                    TypeScope scope = ModelUtils.getTypeScope(entry.getValue());
                    if ((clzName = OccurenceBuilder.resolveClassName(clzName, scope)) == null || clzName.toString().length() <= 0) continue;
                    clzName = VariousUtils.getFullyQualifiedName(clzName, nodeInfo.getOriginalNode().getStartOffset(), scope);
                    if (!enumCaseName.matchesName(PhpElementKind.ENUM_CASE, nodeInfo.getName())) continue;
                    NameKind.Exact typeName = NameKind.exact(clzName);
                    boolean isTheSame = false;
                    for (Object matchingName : matchingTypeNames) {
                        if (!typeName.matchesName(PhpElementKind.ENUM, (QualifiedName)matchingName)) continue;
                        isTheSame = true;
                        break;
                    }
                    if (!isTheSame) {
                        Object matchingName;
                        boolean skipIt = false;
                        matchingName = notMatchingTypeNames.iterator();
                        while (matchingName.hasNext()) {
                            QualifiedName notMatchingName = (QualifiedName)matchingName.next();
                            if (!typeName.matchesName(PhpElementKind.ENUM, notMatchingName)) continue;
                            skipIt = true;
                            break;
                        }
                        if (skipIt) continue;
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        IndexScope indexScope = ModelUtils.getIndexScope(fileScope);
                        ElementQuery.Index index = indexScope.getIndex();
                        ElementFilter forTheSameType = ElementFilter.forMembersOfType(enumCaseElement.getType());
                        Set<EnumCaseElement> expectedConstants = forTheSameType.filter(index.getAllEnumCases(NameKind.exact(clzName), enumCaseName));
                        boolean bl = isTheSame = !expectedConstants.isEmpty();
                    }
                    if (isTheSame) {
                        matchingTypeNames.add(clzName);
                        occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
                        continue;
                    }
                    notMatchingTypeNames.add(clzName);
                    continue;
                }
                assert (CodeUtils.isUniformVariableSyntax(dispatcher)) : dispatcher;
                if (!enumCaseName.matchesName(PhpElementKind.ENUM_CASE, nodeInfo.getName())) continue;
                Collection<? extends TypeScope> types = OccurenceBuilder.getClassName((VariableScope)entry.getValue(), dispatcher);
                for (TypeScope type : types) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    QualifiedName fqn = type.getFullyQualifiedName();
                    NameKind.Exact typeName = NameKind.exact(fqn);
                    for (QualifiedName matchingName : matchingTypeNames) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (typeName.matchesName(PhpElementKind.ENUM, matchingName)) {
                            matchingTypeNames.add(fqn);
                            occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
                            continue;
                        }
                        notMatchingTypeNames.add(fqn);
                    }
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void buildStaticConstantInvocations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        HashSet<QualifiedName> matchingTypeNames = new HashSet<QualifiedName>();
        HashSet<QualifiedName> notMatchingTypeNames = new HashSet<QualifiedName>();
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof TypeConstantElement)) continue;
            TypeConstantElement constantElement = (TypeConstantElement)phpElement;
            matchingTypeNames.add(constantElement.getType().getFullyQualifiedName());
            QualifiedName typeQualifiedName = nodeCtxInfo.getTypeQualifiedName();
            if (typeQualifiedName != null) {
                TypeScope scope;
                if (OccurenceBuilder.isParent(typeQualifiedName) && (scope = ModelUtils.getTypeScope(nodeCtxInfo.getModelElemnt())) != null) {
                    typeQualifiedName = OccurenceBuilder.resolveClassName(typeQualifiedName, scope);
                }
                matchingTypeNames.add(typeQualifiedName);
            }
            NameKind.Exact constantName = NameKind.exact(phpElement.getName());
            for (Map.Entry<ASTNodeInfo<StaticConstantAccess>, Scope> entry : this.staticConstantInvocations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<StaticConstantAccess> nodeInfo = entry.getKey();
                Expression dispatcher = nodeInfo.getOriginalNode().getDispatcher();
                QualifiedName clzName = QualifiedName.create(dispatcher);
                if (dispatcher instanceof Variable && "this".equalsIgnoreCase(CodeUtils.extractQualifiedName(((Variable)dispatcher).getName()))) {
                    clzName = QualifiedName.create("self");
                }
                if (clzName != null) {
                    TypeScope scope = ModelUtils.getTypeScope(entry.getValue());
                    if ((clzName = OccurenceBuilder.resolveClassName(clzName, scope)) == null || clzName.toString().length() <= 0) continue;
                    clzName = VariousUtils.getFullyQualifiedName(clzName, nodeInfo.getOriginalNode().getStartOffset(), scope);
                    if (!constantName.matchesName(PhpElementKind.TYPE_CONSTANT, nodeInfo.getName())) continue;
                    NameKind.Exact typeName = NameKind.exact(clzName);
                    boolean isTheSame = false;
                    for (Object matchingName : matchingTypeNames) {
                        if (!typeName.matchesName(PhpElementKind.CLASS, (QualifiedName)matchingName)) continue;
                        isTheSame = true;
                        break;
                    }
                    if (!isTheSame) {
                        Object matchingName;
                        boolean skipIt = false;
                        matchingName = notMatchingTypeNames.iterator();
                        while (matchingName.hasNext()) {
                            QualifiedName notMatchingName = (QualifiedName)matchingName.next();
                            if (!typeName.matchesName(PhpElementKind.CLASS, notMatchingName)) continue;
                            skipIt = true;
                            break;
                        }
                        if (skipIt) continue;
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        IndexScope indexScope = ModelUtils.getIndexScope(fileScope);
                        ElementQuery.Index index = indexScope.getIndex();
                        ElementFilter forTheSameType = ElementFilter.forMembersOfType(constantElement.getType());
                        Set<TypeConstantElement> expectedConstants = forTheSameType.filter(index.getAllTypeConstants(NameKind.exact(clzName), constantName));
                        boolean bl = isTheSame = !expectedConstants.isEmpty();
                    }
                    if (isTheSame) {
                        matchingTypeNames.add(clzName);
                        occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
                        continue;
                    }
                    notMatchingTypeNames.add(clzName);
                    continue;
                }
                assert (CodeUtils.isUniformVariableSyntax(dispatcher)) : dispatcher;
                if (!constantName.matchesName(PhpElementKind.TYPE_CONSTANT, nodeInfo.getName())) continue;
                Collection<? extends TypeScope> types = OccurenceBuilder.getClassName((VariableScope)entry.getValue(), dispatcher);
                for (TypeScope type : types) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    QualifiedName fqn = type.getFullyQualifiedName();
                    NameKind.Exact typeName = NameKind.exact(fqn);
                    for (QualifiedName matchingName : matchingTypeNames) {
                        if (CancelSupport.getDefault().isCancelled()) {
                            return;
                        }
                        if (typeName.matchesName(PhpElementKind.CLASS, matchingName)) {
                            matchingTypeNames.add(fqn);
                            occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
                            continue;
                        }
                        notMatchingTypeNames.add(fqn);
                    }
                }
            }
        }
    }

    private void buildDocTagsForUseAliases(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<PhpDocTypeTagInfo, Scope> entry : this.docTags.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                PhpDocTypeTagInfo nodeInfo = entry.getKey();
                if (!phpElement.getName().equals(nodeInfo.getName())) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildDocTagsForClasses(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<PhpDocTypeTagInfo, Scope> entry : this.docTags.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                PhpDocTypeTagInfo nodeInfo = entry.getKey();
                QualifiedName qualifiedName = VariousUtils.getFullyQualifiedName(nodeInfo.getQualifiedName(), ((PHPDocNode)nodeInfo.getOriginalNode()).getStartOffset(), entry.getValue());
                String name = CodeUtils.removeNullableTypePrefix(nodeInfo.getName());
                if (!StringUtils.hasText((String)name) || !NameKind.exact(name).matchesName(PhpElementKind.CLASS, phpElement.getName()) || !NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(elements), nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildClassInstanceCreation(ElementInfo query, FileScopeImpl fileScope, List<Occurence> occurences) {
        this.buildClassInstanceCreation(query, fileScope, occurences, false);
    }

    private void buildClassInstanceCreation(ElementInfo query, FileScopeImpl fileScope, List<Occurence> occurences, boolean forConstructMethod) {
        Set<? extends PhpElement> elements = query.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<ASTNodeInfo<ClassInstanceCreation>, Scope> entry : this.clasInstanceCreations.entrySet()) {
                NamespaceScope namespaceScope;
                AliasedName aliasedName;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<ClassInstanceCreation> nodeInfo = entry.getKey();
                boolean isAliased = VariousUtils.isAliased(nodeInfo.getQualifiedName(), nodeInfo.getOriginalNode().getStartOffset(), entry.getValue());
                boolean isConstructorAlias = false;
                if (forConstructMethod && (aliasedName = VariousUtils.getAliasedName(nodeInfo.getQualifiedName(), nodeInfo.getOriginalNode().getStartOffset(), query.getScope())) != null) {
                    QualifiedName realName = aliasedName.getRealName();
                    isConstructorAlias = phpElement.getName().equals(realName.getName());
                }
                if (isAliased && nodeInfo.getQualifiedName().getSegments().size() <= 1 && !isConstructorAlias) continue;
                QualifiedName qualifiedName = VariousUtils.getFullyQualifiedName(nodeInfo.getQualifiedName(), nodeInfo.getOriginalNode().getStartOffset(), entry.getValue());
                Set<? extends PhpElement> contextTypes = elements;
                if (!NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified() && (namespaceScope = ModelUtils.getNamespaceScope(fileScope, nodeInfo.getRange().getStart())) != null) {
                    HashSet<QualifiedName> allNames = new HashSet<QualifiedName>();
                    for (QualifiedName qn : VariousUtils.getComposedNames(qualifiedName, namespaceScope)) {
                        if (qn.getKind().isUnqualified() || qn.isDefaultNamespace()) continue;
                        allNames.add(qn.toNamespaceName());
                    }
                    ElementFilter forTypesFromNamespace = ElementFilter.forTypesFromNamespaces(allNames);
                    contextTypes = forTypesFromNamespace.filter(elements);
                    if (contextTypes.isEmpty()) {
                        contextTypes = elements;
                    } else if (!contextTypes.contains(phpElement)) continue;
                }
                if (!qualifiedName.getKind().isUnqualified()) {
                    contextTypes = Collections.singleton(phpElement);
                }
                OccurenceImpl occurenceImpl = new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(contextTypes), nodeInfo.getRange()){

                    @Override
                    public Collection<? extends PhpElement> gotoDeclarations() {
                        ArrayList<MethodElement> result = new ArrayList<MethodElement>(this.getAllDeclarations().size());
                        for (PhpElement phpElement : this.getAllDeclarations()) {
                            if (CancelSupport.getDefault().isCancelled()) {
                                return Collections.emptyList();
                            }
                            ElementQuery elementQuery = phpElement.getElementQuery();
                            if (!(phpElement instanceof TypeElement) || elementQuery == null || !elementQuery.getQueryScope().isIndexScope()) continue;
                            ElementQuery.Index index = (ElementQuery.Index)elementQuery;
                            Set<MethodElement> declaredMethods = ElementFilter.forName(NameKind.exact("__construct")).filter(index.getDeclaredMethods((TypeElement)phpElement));
                            if (declaredMethods.isEmpty()) continue;
                            result.addAll(declaredMethods);
                        }
                        if (result.size() > 0) {
                            return result;
                        }
                        return super.gotoDeclarations();
                    }
                };
                occurences.add(occurenceImpl);
            }
        }
    }

    private void buildClassNames(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<ASTNodeInfo<ClassName>, Scope> entry : this.clasNames.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<ClassName> nodeInfo = entry.getKey();
                QualifiedName qualifiedName = nodeInfo.getQualifiedName();
                if (!NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(elements, nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildInterfaceIDs(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<ASTNodeInfo<Expression>, Scope> entry : this.ifaceIDs.entrySet()) {
                NamespaceScope namespaceScope;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<Expression> nodeInfo = entry.getKey();
                Set<? extends PhpElement> contextTypes = elements;
                QualifiedName qualifiedName = nodeInfo.getQualifiedName();
                if (!NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified() && (namespaceScope = ModelUtils.getNamespaceScope(fileScope, nodeInfo.getRange().getStart())) != null) {
                    HashSet<QualifiedName> allNames = new HashSet<QualifiedName>();
                    for (QualifiedName qn : VariousUtils.getComposedNames(qualifiedName, namespaceScope)) {
                        if (qn.getKind().isUnqualified() || qn.isDefaultNamespace()) continue;
                        allNames.add(qn.toNamespaceName());
                    }
                    ElementFilter forTypesFromNamespace = ElementFilter.forTypesFromNamespaces(allNames);
                    contextTypes = forTypesFromNamespace.filter(elements);
                    if (contextTypes.isEmpty()) {
                        contextTypes = elements;
                    } else if (!contextTypes.contains(phpElement)) continue;
                }
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(contextTypes), nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildTraitIDs(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<ASTNodeInfo<Expression>, Scope> entry : this.traitIDs.entrySet()) {
                NamespaceScope namespaceScope;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<Expression> nodeInfo = entry.getKey();
                Set<? extends PhpElement> contextTypes = elements;
                QualifiedName qualifiedName = nodeInfo.getQualifiedName();
                if (!NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified() && (namespaceScope = ModelUtils.getNamespaceScope(fileScope, nodeInfo.getRange().getStart())) != null) {
                    HashSet<QualifiedName> allNames = new HashSet<QualifiedName>();
                    for (QualifiedName qn : VariousUtils.getComposedNames(qualifiedName, namespaceScope)) {
                        if (qn.getKind().isUnqualified() || qn.isDefaultNamespace()) continue;
                        allNames.add(qn.toNamespaceName());
                    }
                    ElementFilter forTypesFromNamespace = ElementFilter.forTypesFromNamespaces(allNames);
                    contextTypes = forTypesFromNamespace.filter(elements);
                    if (contextTypes.isEmpty()) {
                        contextTypes = elements;
                    } else if (!contextTypes.contains(phpElement)) continue;
                }
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(contextTypes), nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildClassIDs(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<ASTNodeInfo<Expression>, Scope> entry : this.clasIDs.entrySet()) {
                NamespaceScope namespaceScope;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<Expression> nodeInfo = entry.getKey();
                QualifiedName qualifiedName = VariousUtils.getFullyQualifiedName(nodeInfo.getQualifiedName(), nodeInfo.getOriginalNode().getStartOffset(), entry.getValue());
                Set<? extends PhpElement> contextTypes = elements;
                if (!NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified() && (namespaceScope = ModelUtils.getNamespaceScope(fileScope, nodeInfo.getRange().getStart())) != null) {
                    HashSet<QualifiedName> allNames = new HashSet<QualifiedName>();
                    for (QualifiedName qn : VariousUtils.getComposedNames(qualifiedName, namespaceScope)) {
                        if (qn.getKind().isUnqualified() || qn.isDefaultNamespace()) continue;
                        allNames.add(qn.toNamespaceName());
                    }
                    ElementFilter forTypesFromNamespace = ElementFilter.forTypesFromNamespaces(allNames);
                    contextTypes = forTypesFromNamespace.filter(elements);
                    if (contextTypes.isEmpty()) {
                        contextTypes = elements;
                    } else if (!contextTypes.contains(phpElement)) continue;
                }
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(contextTypes), nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildEnumIDs(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<ASTNodeInfo<Expression>, Scope> entry : this.enumIDs.entrySet()) {
                NamespaceScope namespaceScope;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<Expression> nodeInfo = entry.getKey();
                QualifiedName qualifiedName = VariousUtils.getFullyQualifiedName(nodeInfo.getQualifiedName(), nodeInfo.getOriginalNode().getStartOffset(), entry.getValue());
                Set<? extends PhpElement> contextTypes = elements;
                if (!NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified() && (namespaceScope = ModelUtils.getNamespaceScope(fileScope, nodeInfo.getRange().getStart())) != null) {
                    HashSet<QualifiedName> allNames = new HashSet<QualifiedName>();
                    for (QualifiedName qn : VariousUtils.getComposedNames(qualifiedName, namespaceScope)) {
                        if (qn.getKind().isUnqualified() || qn.isDefaultNamespace()) continue;
                        allNames.add(qn.toNamespaceName());
                    }
                    ElementFilter forTypesFromNamespace = ElementFilter.forTypesFromNamespaces(allNames);
                    contextTypes = forTypesFromNamespace.filter(elements);
                    if (contextTypes.isEmpty()) {
                        contextTypes = elements;
                    } else if (!contextTypes.contains(phpElement)) continue;
                }
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(contextTypes), nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildInterfaceDeclarations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<InterfaceDeclarationInfo, InterfaceScope> entry : this.ifaceDeclarations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                InterfaceDeclarationInfo nodeInfo = entry.getKey();
                if (!NameKind.exact(nodeInfo.getQualifiedName()).matchesName(phpElement) || !nodeInfo.getRange().containsInclusive(phpElement.getOffset()) || fileScope.getFileObject() != phpElement.getFileObject()) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildClassDeclarations(ElementInfo query, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = query.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<ClassDeclarationInfo, ClassScope> entry : this.clasDeclarations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ClassDeclarationInfo nodeInfo = entry.getKey();
                if (!NameKind.exact(nodeInfo.getQualifiedName()).matchesName(phpElement) || !nodeInfo.getRange().containsInclusive(phpElement.getOffset()) || fileScope.getFileObject() != phpElement.getFileObject()) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildTraitDeclarations(ElementInfo query, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = query.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<TraitDeclarationInfo, TraitScope> entry : this.traitDeclarations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                TraitDeclarationInfo nodeInfo = entry.getKey();
                if (!NameKind.exact(nodeInfo.getQualifiedName()).matchesName(phpElement) || !nodeInfo.getRange().containsInclusive(phpElement.getOffset()) || fileScope.getFileObject() != phpElement.getFileObject()) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildEnumDeclarations(ElementInfo query, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = query.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<EnumDeclarationInfo, EnumScope> entry : this.enumDeclarations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                EnumDeclarationInfo nodeInfo = entry.getKey();
                if (!NameKind.exact(nodeInfo.getQualifiedName()).matchesName(phpElement) || !nodeInfo.getRange().containsInclusive(phpElement.getOffset()) || fileScope.getFileObject() != phpElement.getFileObject()) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildFunctionDeclarations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            for (Map.Entry<ASTNodeInfo<FunctionDeclaration>, FunctionScope> entry : this.fncDeclarations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                ASTNodeInfo<FunctionDeclaration> nodeInfo = entry.getKey();
                if (!NameKind.exact(nodeInfo.getQualifiedName()).matchesName(phpElement)) continue;
                occurences.add(new OccurenceImpl(entry.getValue(), nodeInfo.getRange()));
            }
        }
    }

    private void buildFunctionInvocations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            ASTNodeInfo<Expression> nodeInfo;
            for (Map.Entry<ASTNodeInfo<FunctionInvocation>, Scope> entry : this.fncInvocations.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                nodeInfo = entry.getKey();
                QualifiedName qualifiedName = nodeInfo.getQualifiedName();
                if (!NameKind.exact(qualifiedName).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(elements), nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
            for (Map.Entry<ASTNodeInfo<Expression>, Scope> entry : this.nsFunctionInvocations.entrySet()) {
                NamespaceName namespaceName;
                QualifiedName qualifiedName;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                nodeInfo = entry.getKey();
                Expression originalNode = nodeInfo.getOriginalNode();
                if (!(originalNode instanceof NamespaceName) || !NameKind.exact(qualifiedName = QualifiedName.create(namespaceName = (NamespaceName)originalNode)).matchesName(phpElement)) continue;
                if (qualifiedName.getKind().isUnqualified()) {
                    occurences.add(new OccurenceImpl(ElementFilter.forFiles(fileScope.getFileObject()).prefer(elements), nodeInfo.getRange()));
                    continue;
                }
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildFieldDeclarations(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof FieldElement)) continue;
            FieldElement field = (FieldElement)phpElement;
            TypeElement typeElement = field.getType();
            NameKind.Exact typeName = NameKind.exact(typeElement.getFullyQualifiedName());
            NameKind.Exact fieldName = NameKind.exact(field.getName());
            for (Map.Entry<SingleFieldDeclarationInfo, FieldElementImpl> entry : this.fldDeclarations.entrySet()) {
                TypeScope typeScope;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                SingleFieldDeclarationInfo nodeInfo = entry.getKey();
                Scope inScope = entry.getValue().getInScope();
                if (!(inScope instanceof TypeScope) || !typeName.matchesName(typeScope = (TypeScope)inScope) || !fieldName.matchesName(PhpElementKind.FIELD, nodeInfo.getName())) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildDocTagsForFields(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Set<? extends PhpElement> elements = nodeCtxInfo.getDeclarations();
        for (PhpElement phpElement : elements) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (!(phpElement instanceof FieldElement)) continue;
            FieldElement fieldElement = (FieldElement)phpElement;
            TypeElement typeElement = fieldElement.getType();
            NameKind.Exact typeName = NameKind.exact(typeElement.getFullyQualifiedName());
            NameKind.Exact fieldName = NameKind.exact(phpElement.getName());
            for (Map.Entry<PhpDocTypeTagInfo, Scope> entry : this.docTags.entrySet()) {
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                PhpDocTypeTagInfo nodeInfo = entry.getKey();
                Scope scope = entry.getValue();
                if (!ASTNodeInfo.Kind.FIELD.equals((Object)nodeInfo.getKind()) || !(scope instanceof ClassScope) || !typeName.matchesName((ClassScope)scope) || !fieldName.matchesName(PhpElementKind.FIELD, nodeInfo.getName())) continue;
                occurences.add(new OccurenceImpl(phpElement, nodeInfo.getRange()));
            }
        }
    }

    private void buildGotoStatements(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        this.buildGoto(nodeCtxInfo, this.gotoStatement, fileScope, occurences);
    }

    private void buildGotoLabels(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        this.buildGoto(nodeCtxInfo, this.gotoLabel, fileScope, occurences);
    }

    private <T extends ASTNode> void buildGoto(ElementInfo nodeCtxInfo, Map<ASTNodeInfo<T>, Scope> entries, FileScopeImpl fileScope, List<Occurence> occurences) {
        String currentName = nodeCtxInfo.getName();
        Scope currentScope = nodeCtxInfo.getScope();
        for (Map.Entry<ASTNodeInfo<T>, Scope> entry : entries.entrySet()) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            ASTNodeInfo<T> nodeInfo = entry.getKey();
            String name = nodeInfo.getName();
            Scope scope = entry.getValue();
            if (!currentName.equalsIgnoreCase(name) || currentScope != scope) continue;
            occurences.add(new OccurenceImpl(entry.getValue(), nodeInfo.getRange()){

                @Override
                public Collection<? extends PhpElement> gotoDeclarations() {
                    return Collections.emptyList();
                }
            });
        }
    }

    private void buildDocTagsForVars(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        VariableName var;
        Scope ctxScope;
        Scope scope = ctxScope = nodeCtxInfo.getScope() instanceof VariableName || nodeCtxInfo.getScope() instanceof VarAssignmentImpl ? nodeCtxInfo.getScope().getInScope() : nodeCtxInfo.getScope();
        if (!(ctxScope instanceof VariableScope)) {
            return;
        }
        VariableScope ctxVarScope = (VariableScope)ctxScope;
        ElementFilter nameFilter = ElementFilter.forName(NameKind.exact(nodeCtxInfo.getName()));
        Set<? extends VariableName> vars = nameFilter.filter(new HashSet<VariableName>(ctxVarScope.getDeclaredVariables()));
        VariableName variableName = var = vars.size() == 1 ? vars.iterator().next() : null;
        if (var != null) {
            for (Map.Entry<PhpDocTypeTagInfo, Scope> entry : this.docTags.entrySet()) {
                Set<? extends VariableName> nextVars;
                VariableName nextVar;
                Scope nextScope;
                if (CancelSupport.getDefault().isCancelled()) {
                    return;
                }
                PhpDocTypeTagInfo nodeInfo = entry.getKey();
                Scope scope2 = entry.getValue();
                if (!ASTNodeInfo.Kind.VARIABLE.equals((Object)nodeInfo.getKind()) || !(scope2 instanceof VariableScope) || nodeInfo.getName().trim().isEmpty() || !NameKind.exact(nodeInfo.getName()).matchesName(PhpElementKind.VARIABLE, nodeCtxInfo.getName())) continue;
                if (!var.isGloballyVisible()) {
                    nextScope = entry.getValue();
                    if (!ctxVarScope.equals(nextScope)) continue;
                    occurences.add(new OccurenceImpl(var, nodeInfo.getRange()));
                    continue;
                }
                nextScope = entry.getValue();
                if (!(nextScope instanceof VariableScope) || (nextVar = (nextVars = nameFilter.filter(new HashSet<VariableName>(((VariableScope)nextScope).getDeclaredVariables()))).size() == 1 ? nextVars.iterator().next() : null) == null || !nextVar.isGloballyVisible()) continue;
                occurences.add(new OccurenceImpl(var, nodeInfo.getRange()));
            }
        }
    }

    private void buildVariables(ElementInfo nodeCtxInfo, FileScopeImpl fileScope, List<Occurence> occurences) {
        Scope ctxScope;
        if (CancelSupport.getDefault().isCancelled()) {
            return;
        }
        Scope scope = ctxScope = nodeCtxInfo.getScope() instanceof VariableName ? nodeCtxInfo.getScope().getInScope() : nodeCtxInfo.getScope();
        if (ctxScope instanceof VarAssignmentImpl) {
            ctxScope = ctxScope.getInScope();
        }
        if (!(ctxScope instanceof VariableScope)) {
            return;
        }
        VariableScope ctxVarScope = (VariableScope)ctxScope;
        String nodeName = nodeCtxInfo.getName();
        if (StringUtils.hasText((String)nodeName)) {
            VariableName var;
            ElementFilter nameFilter = ElementFilter.forName(NameKind.exact(nodeName));
            Set<? extends VariableName> vars = nameFilter.filter(new HashSet<VariableName>(ctxVarScope.getDeclaredVariables()));
            VariableName variableName = var = vars.size() == 1 ? vars.iterator().next() : null;
            if (var != null) {
                for (Map.Entry<ASTNodeInfo<Variable>, Scope> entry : this.variables.entrySet()) {
                    if (CancelSupport.getDefault().isCancelled()) {
                        return;
                    }
                    ASTNodeInfo<Variable> nodeInfo = entry.getKey();
                    boolean addOccurence = false;
                    if (NameKind.exact(nodeInfo.getName()).matchesName(PhpElementKind.VARIABLE, nodeName)) {
                        Scope nextScope;
                        if (!var.isGloballyVisible()) {
                            nextScope = entry.getValue();
                            if (var.representsThis() && nextScope.getInScope() instanceof TypeScope) {
                                Scope inScope;
                                Scope scope2 = inScope = ctxVarScope instanceof MethodScope ? ctxVarScope.getInScope() : ctxVarScope;
                                if (nextScope.getInScope().equals(inScope)) {
                                    addOccurence = true;
                                }
                            } else if (ctxVarScope.equals(nextScope)) {
                                addOccurence = true;
                            }
                        } else {
                            nextScope = entry.getValue();
                            if (nextScope instanceof VariableScope) {
                                VariableName nextVar;
                                Set<? extends VariableName> nextVars = nameFilter.filter(new HashSet<VariableName>(((VariableScope)nextScope).getDeclaredVariables()));
                                VariableName variableName2 = nextVar = nextVars.size() == 1 ? nextVars.iterator().next() : null;
                                if (nextVar != null && nextVar.isGloballyVisible()) {
                                    addOccurence = true;
                                }
                            }
                        }
                    }
                    if (!addOccurence) continue;
                    if (var instanceof VariableNameImpl && ((VariableNameImpl)var).indexedElement instanceof PhpElement) {
                        final VariableNameImpl nameImpl = (VariableNameImpl)var;
                        occurences.add(new OccurenceImpl(var, nodeInfo.getRange()){

                            @Override
                            public Collection<? extends PhpElement> gotoDeclarations() {
                                return Collections.singleton((PhpElement)nameImpl.indexedElement);
                            }
                        });
                        continue;
                    }
                    occurences.add(new OccurenceImpl(var, nodeInfo.getRange()));
                }
            }
        }
    }

    Occurence build(FileScopeImpl fileScope, int offset) {
        Occurence retval = this.findOccurenceByOffset(offset);
        if (retval == null && this.setElementInfo(offset)) {
            this.build(fileScope);
            retval = this.findOccurenceByOffset(offset);
        }
        return retval;
    }

    List<Occurence> build(FileScopeImpl fileScope, ModelElement element) {
        if (this.setElementInfo(element)) {
            this.build(fileScope);
        }
        return new ArrayList<Occurence>(this.cachedOccurences);
    }

    private void scanMethodBodies() {
        for (Map.Entry<ASTNodeInfo<MethodDeclaration>, MethodScope> entry : this.methodDeclarations.entrySet()) {
            LazyBuild scope;
            if (!(entry.getValue() instanceof LazyBuild) || (scope = (LazyBuild)((Object)entry.getValue())).isScanned()) continue;
            scope.scan();
        }
    }

    private Occurence findOccurenceByOffset(int offset) {
        Occurence retval = null;
        for (Occurence occ : this.cachedOccurences) {
            assert (occ != null);
            if (!occ.getOccurenceRange().containsInclusive(offset)) continue;
            retval = occ;
        }
        return retval;
    }

    private boolean canBePrepared(ASTNode node, ModelElement scope) {
        return scope != null && node != null;
    }

    private void setOffsetElementInfo(ElementInfo nextElementInfo, int offset) {
        OffsetRange range;
        if (nextElementInfo != null && offset >= 0 && nextElementInfo.getName() != null && nextElementInfo.getName().trim().length() > 0 && (range = nextElementInfo.getRange()) != null && range.containsInclusive(offset)) {
            if (this.elementInfo != null && this.elementInfo.getKind() == ASTNodeInfo.Kind.FIELD && nextElementInfo.getKind() == ASTNodeInfo.Kind.VARIABLE) {
                this.promotedVariableElementInfo = nextElementInfo;
            } else {
                this.elementInfo = nextElementInfo;
            }
        }
    }

    private static Collection<? extends TypeScope> getClassName(VariableScope scp, VariableBase varBase) {
        String vartype = VariousUtils.extractTypeFroVariableBase(varBase, Collections.emptyMap());
        return VariousUtils.getType(scp, vartype, varBase.getStartOffset(), true);
    }

    private static Collection<? extends TypeScope> getClassName(VariableScope scp, Expression expression) {
        String vartype = VariousUtils.extractVariableTypeFromExpression(expression, Collections.emptyMap());
        return VariousUtils.getType(scp, vartype, expression.getStartOffset(), false);
    }

    private static Collection<? extends TypeElement> resolveTypes(ElementQuery.Index index, ElementInfo elementInfo) {
        Expression dispatcher;
        Object originalNode;
        ASTNodeInfo nodeInfo = elementInfo.getNodeInfo();
        if (nodeInfo != null && (originalNode = nodeInfo.getOriginalNode()) instanceof StaticDispatch && CodeUtils.isUniformVariableSyntax(dispatcher = ((StaticDispatch)originalNode).getDispatcher())) {
            return OccurenceBuilder.getClassName((VariableScope)elementInfo.getScope(), dispatcher);
        }
        QualifiedName clzName = elementInfo.getTypeQualifiedName();
        assert (clzName != null) : elementInfo.getQualifiedName();
        TypeScope scope = ModelUtils.getTypeScope(elementInfo.getScope());
        if ((clzName = OccurenceBuilder.resolveClassName(clzName, scope)) != null && clzName.toString().length() > 0 && !clzName.getKind().isFullyQualified()) {
            clzName = VariousUtils.getFullyQualifiedName(clzName.toName(), elementInfo.getRange().getStart(), scope);
        }
        if (CancelSupport.getDefault().isCancelled()) {
            return Collections.emptyList();
        }
        if (clzName != null) {
            return index.getTypes(NameKind.exact(clzName));
        }
        return Collections.emptyList();
    }

    private static boolean isNameEquality(ElementInfo query, ASTNodeInfo node, ModelElement nodeScope) {
        String idName = query.getName();
        if (idName.equalsIgnoreCase(node.getName())) {
            QualifiedName nodeQN;
            QualifiedName queryQN = query.getQualifiedName();
            if (queryQN.equals(nodeQN = node.getQualifiedName())) {
                return true;
            }
            Collection<QualifiedName> queryComposedNames = VariousUtils.getComposedNames(queryQN, query.getNamespaceScope());
            NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(nodeScope);
            assert (namespaceScope != null);
            Collection<QualifiedName> nodeQomposedNames = VariousUtils.getComposedNames(nodeQN, namespaceScope);
            queryComposedNames.retainAll(nodeQomposedNames);
            return !queryComposedNames.isEmpty();
        }
        return false;
    }

    private static QualifiedName resolveClassName(QualifiedName clzName, Scope scope) {
        ClassScope classScope;
        if (!clzName.getKind().isUnqualified()) {
            return clzName;
        }
        String name = clzName.getName();
        if (name.equalsIgnoreCase("self") || name.equals("static")) {
            TypeScope typeScope = ModelUtils.getTypeScope(scope);
            if (typeScope != null) {
                clzName = typeScope.getFullyQualifiedName();
            }
        } else if (OccurenceBuilder.isParent(clzName) && (classScope = ModelUtils.getClassScope(scope)) != null) {
            clzName = classScope.getSuperClassName();
        }
        return clzName;
    }

    private static boolean isParent(QualifiedName clzName) {
        if (!clzName.getKind().isUnqualified()) {
            return false;
        }
        return clzName.getName().equalsIgnoreCase("parent");
    }

    private static class ElementInfo {
        private final Scope scope;
        private final Union2<ASTNodeInfo, ModelElement> element;
        public Set<? extends PhpElement> declarations = Collections.emptySet();

        public ElementInfo(ModelElement element) {
            this.element = Union2.createSecond((Object)element);
            this.scope = element instanceof Scope ? (Scope)element : element.getInScope();
        }

        public ElementInfo(ASTNodeInfo nodeInfo, ModelElement element) {
            this.element = Union2.createFirst((Object)nodeInfo);
            this.scope = element instanceof Scope ? (Scope)element : element.getInScope();
        }

        public Scope getScope() {
            return this.scope;
        }

        public FileScope getFileScope() {
            return ModelUtils.getFileScope(this.scope);
        }

        public NamespaceScope getNamespaceScope() {
            return ModelUtils.getNamespaceScope(this.scope);
        }

        @CheckForNull
        public QualifiedName getTypeQualifiedName() {
            QualifiedName qualifiedName;
            ASTNodeInfo nodeInfo = this.getNodeInfo();
            if (nodeInfo != null) {
                Object originalNode = nodeInfo.getOriginalNode();
                if ((nodeInfo instanceof ClassConstantDeclarationInfo || nodeInfo instanceof CaseDeclarationInfo) && originalNode instanceof Identifier && this.getScope() instanceof TypeScope) {
                    return ((TypeScope)this.getScope()).getFullyQualifiedName();
                }
                if (originalNode instanceof StaticDispatch) {
                    if (CodeUtils.isUniformVariableSyntax((StaticDispatch)originalNode)) {
                        return null;
                    }
                    QualifiedName pureQualifiedName = ASTNodeInfo.toQualifiedName(originalNode, true);
                    qualifiedName = VariousUtils.getFullyQualifiedName(pureQualifiedName, ((ASTNode)originalNode).getStartOffset(), this.getScope());
                } else {
                    if (this.getScope().getInScope() instanceof TypeScope && (originalNode instanceof MethodDeclaration || originalNode instanceof SingleFieldDeclaration || originalNode instanceof PHPDocMethodTag)) {
                        return ((TypeScope)this.getScope().getInScope()).getFullyQualifiedName();
                    }
                    qualifiedName = nodeInfo.getQualifiedName();
                }
            } else {
                ModelElement modelElemnt = this.getModelElemnt();
                QualifiedName namespaceName = modelElemnt.getNamespaceName();
                Scope inScope = modelElemnt.getInScope();
                qualifiedName = inScope instanceof TypeScope ? namespaceName.append(inScope.getName()) : namespaceName.append(modelElemnt.getName());
            }
            return qualifiedName;
        }

        public QualifiedName getQualifiedName() {
            QualifiedName qualifiedName;
            ASTNodeInfo nodeInfo = this.getNodeInfo();
            if (nodeInfo != null) {
                qualifiedName = nodeInfo.getQualifiedName();
            } else {
                ModelElement modelElemnt = this.getModelElemnt();
                if (modelElemnt instanceof ClassMemberElement) {
                    qualifiedName = QualifiedName.createUnqualifiedName(modelElemnt.getName());
                } else {
                    QualifiedName namespaceName = modelElemnt.getNamespaceName();
                    qualifiedName = namespaceName.append(modelElemnt.getName());
                }
            }
            return qualifiedName;
        }

        public Collection<QualifiedName> getComposedNames() {
            return VariousUtils.getComposedNames(this.getQualifiedName(), this.getNamespaceScope());
        }

        public String getName() {
            ASTNodeInfo nodeInfo = this.getNodeInfo();
            if (nodeInfo != null) {
                return nodeInfo.getName();
            }
            return this.getModelElemnt().getName();
        }

        public ASTNodeInfo.Kind getKind() {
            ASTNodeInfo nodeInfo = this.getNodeInfo();
            if (nodeInfo != null) {
                return nodeInfo.getKind();
            }
            ASTNodeInfo.Kind kind = null;
            ModelElement modelElemnt = this.getModelElemnt();
            PhpElementKind phpElementKind = modelElemnt.getPhpElementKind();
            switch (phpElementKind) {
                case CLASS: {
                    kind = ASTNodeInfo.Kind.CLASS;
                    break;
                }
                case TYPE_CONSTANT: {
                    kind = ASTNodeInfo.Kind.CLASS_CONSTANT;
                    break;
                }
                case CONSTANT: {
                    kind = ASTNodeInfo.Kind.CONSTANT;
                    break;
                }
                case FIELD: {
                    kind = modelElemnt.getPhpModifiers().isStatic() ? ASTNodeInfo.Kind.STATIC_FIELD : ASTNodeInfo.Kind.FIELD;
                    break;
                }
                case FUNCTION: {
                    kind = ASTNodeInfo.Kind.FUNCTION;
                    break;
                }
                case IFACE: {
                    kind = ASTNodeInfo.Kind.IFACE;
                    break;
                }
                case INCLUDE: {
                    kind = ASTNodeInfo.Kind.INCLUDE;
                    break;
                }
                case METHOD: {
                    boolean isStatic = modelElemnt.getPhpModifiers().isStatic();
                    kind = isStatic ? ASTNodeInfo.Kind.STATIC_METHOD : ASTNodeInfo.Kind.METHOD;
                    break;
                }
                case VARIABLE: {
                    kind = ASTNodeInfo.Kind.VARIABLE;
                    break;
                }
                case USE_ALIAS: {
                    kind = ASTNodeInfo.Kind.USE_ALIAS;
                    break;
                }
                case TRAIT: {
                    kind = ASTNodeInfo.Kind.TRAIT;
                    break;
                }
                case ENUM: {
                    kind = ASTNodeInfo.Kind.ENUM;
                    break;
                }
                case ENUM_CASE: {
                    kind = ASTNodeInfo.Kind.ENUM_CASE;
                    break;
                }
                default: {
                    assert (false) : phpElementKind;
                    break;
                }
            }
            assert (kind != null) : phpElementKind;
            return kind;
        }

        public OffsetRange getRange() {
            ASTNodeInfo nodeInfo = this.getNodeInfo();
            if (nodeInfo != null) {
                return nodeInfo.getRange();
            }
            return this.getModelElemnt().getNameRange();
        }

        public Union2<ASTNodeInfo, ModelElement> getRawElement() {
            return this.element;
        }

        public ASTNodeInfo getNodeInfo() {
            return this.element.hasFirst() ? (ASTNodeInfo)this.element.first() : null;
        }

        private ModelElement getModelElemnt() {
            return this.element.hasSecond() ? (ModelElement)this.element.second() : null;
        }

        public Set<? extends PhpElement> getDeclarations() {
            return new HashSet<PhpElement>(this.declarations);
        }

        public boolean setDeclarations(Set<? extends PhpElement> declarations) {
            this.declarations = new HashSet<PhpElement>(declarations);
            return this.declarations != null && !this.declarations.isEmpty();
        }
    }

    private class OccurenceImpl
    implements Occurence {
        private final OffsetRange occurenceRange;
        private final PhpElement declaration;
        private Collection<? extends PhpElement> allDeclarations;
        private Occurence.Accuracy accuracy = Occurence.Accuracy.EXACT;

        public OccurenceImpl(Collection<? extends PhpElement> allDeclarations, OffsetRange occurenceRange) {
            this(allDeclarations, ModelUtils.getFirst(allDeclarations), occurenceRange);
        }

        public OccurenceImpl(PhpElement declaration, OffsetRange occurenceRange) {
            this(Collections.singleton(declaration), occurenceRange);
        }

        private OccurenceImpl(Collection<? extends PhpElement> allDeclarations, PhpElement declaration, OffsetRange occurenceRange) {
            if (declaration instanceof MethodScope && ((MethodScope)declaration).isConstructor()) {
                ModelElement modelElement = (ModelElement)declaration;
                this.declaration = modelElement.getInScope();
            } else {
                this.allDeclarations = allDeclarations;
                this.declaration = declaration;
            }
            assert (declaration != null);
            this.occurenceRange = occurenceRange;
        }

        @Override
        public PhpElementKind getKind() {
            return this.declaration.getPhpElementKind();
        }

        @Override
        public OffsetRange getOccurenceRange() {
            return this.occurenceRange;
        }

        @Override
        public Occurence.Accuracy degreeOfAccuracy() {
            return this.accuracy;
        }

        @Override
        public Collection<? extends PhpElement> gotoDeclarations() {
            return new HashSet<PhpElement>(this.allDeclarations);
        }

        public void setAccuracy(Occurence.Accuracy accuracy) {
            this.accuracy = accuracy;
        }

        @Override
        public Collection<? extends PhpElement> getAllDeclarations() {
            return new HashSet<PhpElement>(this.allDeclarations);
        }

        @Override
        public Collection<Occurence> getAllOccurences() {
            return OccurenceBuilder.this.cachedOccurences;
        }
    }
}

