/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSWriteCurrentFrameSlotNode;
import com.oracle.truffle.js.runtime.SafeInteger;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSWriteCurrentFrameSlotNode.class)
final class JSWriteCurrentFrameSlotNodeGen
extends JSWriteCurrentFrameSlotNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private int state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;

    private JSWriteCurrentFrameSlotNodeGen(FrameSlot frameSlot, JavaScriptNode rhsNode, FrameDescriptor frameDescriptor) {
        super(frameSlot, rhsNode, frameDescriptor);
    }

    @Override
    Object executeEvaluated(VirtualFrame frameValue, Object rhsNodeValue) {
        int rhsNodeValue_;
        int state = this.state_;
        if ((state & 1) != 0 && rhsNodeValue instanceof Boolean) {
            rhsNodeValue_ = ((Boolean)rhsNodeValue).booleanValue();
            if (this.isBooleanKind((Frame)frameValue)) {
                return this.doBoolean(frameValue, rhsNodeValue_ != 0);
            }
        }
        if ((state & 2) != 0 && rhsNodeValue instanceof Integer) {
            rhsNodeValue_ = (Integer)rhsNodeValue;
            if (this.isIntegerKind((Frame)frameValue) || this.isLongKind((Frame)frameValue) || this.isDoubleKind((Frame)frameValue)) {
                return this.doInteger(frameValue, rhsNodeValue_);
            }
        }
        if ((state & 4) != 0 && rhsNodeValue instanceof SafeInteger) {
            SafeInteger rhsNodeValue_2 = (SafeInteger)rhsNodeValue;
            if (this.isLongKind((Frame)frameValue)) {
                return this.doSafeInteger(frameValue, rhsNodeValue_2);
            }
        }
        if ((state & 8) != 0 && rhsNodeValue instanceof Long) {
            long rhsNodeValue_3 = (Long)rhsNodeValue;
            return this.doLong(frameValue, rhsNodeValue_3);
        }
        if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue)) {
            double rhsNodeValue_4 = JSTypesGen.asImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue);
            if (this.isDoubleKind((Frame)frameValue)) {
                return this.doDouble(frameValue, rhsNodeValue_4);
            }
        }
        if ((state & 0x20) != 0) {
            return this.doObject(frameValue, rhsNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, rhsNodeValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        int state = this.state_;
        if ((state & 0x3E) == 0 && (state & 0x3F) != 0) {
            return this.execute_boolean0(frameValue, state);
        }
        if ((state & 0x3D) == 0 && (state & 0x3F) != 0) {
            return this.execute_int1(frameValue, state);
        }
        if ((state & 0x37) == 0 && (state & 0x3F) != 0) {
            return this.execute_long2(frameValue, state);
        }
        if ((state & 0x2F) == 0 && (state & 0x3F) != 0) {
            return this.execute_double3(frameValue, state);
        }
        return this.execute_generic4(frameValue, state);
    }

    private Object execute_boolean0(VirtualFrame frameValue, int state) {
        boolean rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state & 1) != 0);
        if (this.isBooleanKind((Frame)frameValue)) {
            return this.doBoolean(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    private Object execute_int1(VirtualFrame frameValue, int state) {
        int rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state & 2) != 0);
        if (this.isIntegerKind((Frame)frameValue) || this.isLongKind((Frame)frameValue) || this.isDoubleKind((Frame)frameValue)) {
            return this.doInteger(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    private Object execute_long2(VirtualFrame frameValue, int state) {
        long rhsNodeValue_;
        try {
            rhsNodeValue_ = this.rhsNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state & 8) != 0);
        return this.doLong(frameValue, rhsNodeValue_);
    }

    private Object execute_double3(VirtualFrame frameValue, int state) {
        double rhsNodeValue_;
        int rhsNodeValue_int = 0;
        long rhsNodeValue_long = 0L;
        try {
            if ((state & 0x380) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_long = this.rhsNode.executeLong(frameValue);
                rhsNodeValue_ = JSTypes.longToDouble(rhsNodeValue_long);
            } else if ((state & 0x340) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_int = this.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else if ((state & 0x2C0) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_ = this.rhsNode.executeDouble(frameValue);
            } else {
                Object rhsNodeValue__ = this.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(frameValue, ex.getResult());
        }
        assert ((state & 0x10) != 0);
        if (this.isDoubleKind((Frame)frameValue)) {
            return this.doDouble(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, (state & 0x380) == 0 && (state & 0x3F) != 0 ? (Number)rhsNodeValue_long : (Number)((state & 0x340) == 0 && (state & 0x3F) != 0 ? (Number)rhsNodeValue_int : (Number)rhsNodeValue_));
    }

    private Object execute_generic4(VirtualFrame frameValue, int state) {
        int rhsNodeValue__;
        Object rhsNodeValue_ = this.rhsNode.execute(frameValue);
        if ((state & 1) != 0 && rhsNodeValue_ instanceof Boolean) {
            rhsNodeValue__ = ((Boolean)rhsNodeValue_).booleanValue();
            if (this.isBooleanKind((Frame)frameValue)) {
                return this.doBoolean(frameValue, rhsNodeValue__ != 0);
            }
        }
        if ((state & 2) != 0 && rhsNodeValue_ instanceof Integer) {
            rhsNodeValue__ = (Integer)rhsNodeValue_;
            if (this.isIntegerKind((Frame)frameValue) || this.isLongKind((Frame)frameValue) || this.isDoubleKind((Frame)frameValue)) {
                return this.doInteger(frameValue, rhsNodeValue__);
            }
        }
        if ((state & 4) != 0 && rhsNodeValue_ instanceof SafeInteger) {
            SafeInteger rhsNodeValue__2 = (SafeInteger)rhsNodeValue_;
            if (this.isLongKind((Frame)frameValue)) {
                return this.doSafeInteger(frameValue, rhsNodeValue__2);
            }
        }
        if ((state & 8) != 0 && rhsNodeValue_ instanceof Long) {
            long rhsNodeValue__3 = (Long)rhsNodeValue_;
            return this.doLong(frameValue, rhsNodeValue__3);
        }
        if ((state & 0x10) != 0 && JSTypesGen.isImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue_)) {
            double rhsNodeValue__4 = JSTypesGen.asImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue_);
            if (this.isDoubleKind((Frame)frameValue)) {
                return this.doDouble(frameValue, rhsNodeValue__4);
            }
        }
        if ((state & 0x20) != 0) {
            return this.doObject(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, rhsNodeValue_);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
        boolean rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectBoolean(this.execute(frameValue));
        }
        try {
            rhsNodeValue_ = this.rhsNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectBoolean(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state & 1) != 0 && this.isBooleanKind((Frame)frameValue)) {
            return this.doBoolean(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectBoolean(this.executeAndSpecialize(frameValue, rhsNodeValue_));
    }

    @Override
    public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
        double rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectDouble(this.execute(frameValue));
        }
        int rhsNodeValue_int = 0;
        long rhsNodeValue_long = 0L;
        try {
            if ((state & 0x380) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_long = this.rhsNode.executeLong(frameValue);
                rhsNodeValue_ = JSTypes.longToDouble(rhsNodeValue_long);
            } else if ((state & 0x340) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_int = this.rhsNode.executeInt(frameValue);
                rhsNodeValue_ = JSTypes.intToDouble(rhsNodeValue_int);
            } else if ((state & 0x2C0) == 0 && (state & 0x3F) != 0) {
                rhsNodeValue_ = this.rhsNode.executeDouble(frameValue);
            } else {
                Object rhsNodeValue__ = this.rhsNode.execute(frameValue);
                rhsNodeValue_ = JSTypesGen.expectImplicitDouble((state & 0x3C0) >>> 6, rhsNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectDouble(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state & 0x10) != 0 && this.isDoubleKind((Frame)frameValue)) {
            return this.doDouble(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectDouble(this.executeAndSpecialize(frameValue, (state & 0x380) == 0 && (state & 0x3F) != 0 ? (Number)rhsNodeValue_long : (Number)((state & 0x340) == 0 && (state & 0x3F) != 0 ? (Number)rhsNodeValue_int : (Number)rhsNodeValue_)));
    }

    @Override
    public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
        int rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectInteger(this.execute(frameValue));
        }
        try {
            rhsNodeValue_ = this.rhsNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectInteger(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state & 2) != 0 && (this.isIntegerKind((Frame)frameValue) || this.isLongKind((Frame)frameValue) || this.isDoubleKind((Frame)frameValue))) {
            return this.doInteger(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectInteger(this.executeAndSpecialize(frameValue, rhsNodeValue_));
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        long rhsNodeValue_;
        int state = this.state_;
        if ((state & 0x20) != 0) {
            return JSTypesGen.expectLong(this.execute(frameValue));
        }
        try {
            rhsNodeValue_ = this.rhsNode.executeLong(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return JSTypesGen.expectLong(this.executeAndSpecialize(frameValue, ex.getResult()));
        }
        if ((state & 8) != 0) {
            return this.doLong(frameValue, rhsNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return JSTypesGen.expectLong(this.executeAndSpecialize(frameValue, rhsNodeValue_));
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        int state = this.state_;
        try {
            if ((state & 0x37) == 0 && (state & 0x3F) != 0) {
                this.executeLong(frameValue);
                return;
            }
            if ((state & 0x3D) == 0 && (state & 0x3F) != 0) {
                this.executeInt(frameValue);
                return;
            }
            if ((state & 0x2F) == 0 && (state & 0x3F) != 0) {
                this.executeDouble(frameValue);
                return;
            }
            if ((state & 0x3E) == 0 && (state & 0x3F) != 0) {
                this.executeBoolean(frameValue);
                return;
            }
            this.execute(frameValue);
            return;
        }
        catch (UnexpectedResultException ex) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object executeAndSpecialize(VirtualFrame frameValue, Object rhsNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        int state = this.state_;
        int exclude = this.exclude_;
        try {
            int doubleCast0;
            int rhsNodeValue_;
            if ((exclude & 1) == 0 && rhsNodeValue instanceof Boolean) {
                rhsNodeValue_ = ((Boolean)rhsNodeValue).booleanValue();
                if (this.isBooleanKind((Frame)frameValue)) {
                    this.state_ = state |= 1;
                    lock.unlock();
                    hasLock = false;
                    Boolean bl = this.doBoolean(frameValue, rhsNodeValue_ != 0);
                    return bl;
                }
            }
            if ((exclude & 2) == 0 && rhsNodeValue instanceof Integer) {
                rhsNodeValue_ = (Integer)rhsNodeValue;
                if (this.isIntegerKind((Frame)frameValue) || this.isLongKind((Frame)frameValue) || this.isDoubleKind((Frame)frameValue)) {
                    this.state_ = state |= 2;
                    lock.unlock();
                    hasLock = false;
                    Integer n = this.doInteger(frameValue, rhsNodeValue_);
                    return n;
                }
            }
            if ((exclude & 4) == 0 && rhsNodeValue instanceof SafeInteger) {
                SafeInteger rhsNodeValue_2 = (SafeInteger)rhsNodeValue;
                if (this.isLongKind((Frame)frameValue)) {
                    this.state_ = state |= 4;
                    lock.unlock();
                    hasLock = false;
                    SafeInteger safeInteger = this.doSafeInteger(frameValue, rhsNodeValue_2);
                    return safeInteger;
                }
            }
            if ((exclude & 8) == 0 && rhsNodeValue instanceof Long) {
                long rhsNodeValue_3 = (Long)rhsNodeValue;
                this.state_ = state |= 8;
                lock.unlock();
                hasLock = false;
                Long l = this.doLong(frameValue, rhsNodeValue_3);
                return l;
            }
            if ((exclude & 0x10) == 0 && (doubleCast0 = JSTypesGen.specializeImplicitDouble(rhsNodeValue)) != 0) {
                double rhsNodeValue_4 = JSTypesGen.asImplicitDouble(doubleCast0, rhsNodeValue);
                if (this.isDoubleKind((Frame)frameValue)) {
                    this.exclude_ = exclude |= 6;
                    state &= 0xFFFFFFF9;
                    state |= doubleCast0 << 6;
                    this.state_ = state |= 0x10;
                    lock.unlock();
                    hasLock = false;
                    Double d = this.doDouble(frameValue, rhsNodeValue_4);
                    return d;
                }
            }
            this.exclude_ = exclude |= 0x1F;
            state &= 0xFFFFFFE0;
            this.state_ = state |= 0x20;
            lock.unlock();
            hasLock = false;
            Object object = this.doObject(frameValue, rhsNodeValue);
            return object;
        }
        finally {
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    public NodeCost getCost() {
        int state = this.state_;
        if ((state & 0x3F) == 0) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x3F & (state & 0x3F) - 1) == 0) {
            return NodeCost.MONOMORPHIC;
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        Object[] data = new Object[7];
        data[0] = 0;
        int state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 1) != 0 ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[1] = s;
        s = new Object[3];
        s[0] = "doInteger";
        s[1] = (state & 2) != 0 ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[2] = s;
        s = new Object[3];
        s[0] = "doSafeInteger";
        s[1] = (state & 4) != 0 ? Byte.valueOf((byte)1) : ((exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[3] = s;
        s = new Object[3];
        s[0] = "doLong";
        s[1] = (state & 8) != 0 ? Byte.valueOf((byte)1) : ((exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[4] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 0x10) != 0 ? Byte.valueOf((byte)1) : ((exclude & 0x10) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[5] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 0x20) != 0 ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        return Introspection.Provider.create((Object[])data);
    }

    public static JSWriteCurrentFrameSlotNode create(FrameSlot frameSlot, JavaScriptNode rhsNode, FrameDescriptor frameDescriptor) {
        return new JSWriteCurrentFrameSlotNodeGen(frameSlot, rhsNode, frameDescriptor);
    }
}

