/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.commit.ConflictResolvedAction;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.spi.diff.MergeVisualizer;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public class ResolveConflictsExecutor
extends SvnProgressSupport {
    private static final String TMP_PREFIX = "merge";
    static final String CHANGE_LEFT = "<<<<<<< ";
    static final String CHANGE_RIGHT = ">>>>>>> ";
    static final String CHANGE_DELIMETER = "=======";
    static final String CHANGE_BASE_DELIMETER = "|||||||";
    static final String LOCAL_FILE_SUFFIX = ".mine";
    static final String WORKING_FILE_SUFFIX = ".working";
    private String leftFileRevision = null;
    private String rightFileRevision = null;
    private final File file;
    private static final String NESTED_CONFLICT = "NESTED_CONFLICT";
    private String newLineString;
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");

    public ResolveConflictsExecutor(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec() {
        assert (SwingUtilities.isEventDispatchThread());
        MergeVisualizer merge = (MergeVisualizer)Lookup.getDefault().lookup(MergeVisualizer.class);
        if (merge == null) {
            throw new IllegalStateException("No Merge engine found.");
        }
        try {
            FileObject fo = FileUtil.toFileObject((File)this.file);
            if (fo == null) {
                Subversion.LOG.log(Level.WARNING, "can''t resolve conflicts for null fileobject : {0}, exists: {1}", new Object[]{this.file, this.file.exists()});
                return;
            }
            FileLock lock = fo.lock();
            boolean mergeWriterCreated = false;
            try {
                mergeWriterCreated = this.handleMergeFor(this.file, fo, lock, merge);
            }
            finally {
                if (!mergeWriterCreated && lock != null) {
                    lock.releaseLock();
                }
            }
        }
        catch (FileAlreadyLockedException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Set components = TopComponent.getRegistry().getOpened();
                    for (TopComponent tc : components) {
                        if (tc.getClientProperty((Object)ResolveConflictsExecutor.class.getName()) == null) continue;
                        tc.requestActive();
                    }
                }
            });
        }
        catch (IOException ioex) {
            if (NESTED_CONFLICT.equals(ioex.getMessage())) {
                JOptionPane.showMessageDialog(Utilities.findDialogParent(), NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"MSG_NestedConflicts"), NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"MSG_NestedConflicts_Title"), 2);
                Utils.openFile((File)this.file);
            }
            Subversion.LOG.log(Level.SEVERE, null, ioex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMergeFor(File file, FileObject fo, FileLock lock, MergeVisualizer merge) throws IOException {
        String mimeType = fo == null ? "text/plain" : fo.getMIMEType();
        String ext = "." + fo.getExt();
        File f1 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, ext));
        File f2 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, ext));
        File f3 = FileUtil.normalizeFile((File)File.createTempFile(TMP_PREFIX, ext));
        f1.deleteOnExit();
        f2.deleteOnExit();
        f3.deleteOnExit();
        this.newLineString = Utils.getLineEnding((FileObject)fo, (FileLock)lock);
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)fo);
        Difference[] diffs = this.copyParts(true, file, f1, true, encoding);
        if (diffs.length == 0) {
            try {
                ConflictResolvedAction.perform(file);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            return false;
        }
        this.copyParts(false, file, f2, false, encoding);
        String originalLeftFileRevision = this.leftFileRevision;
        String originalRightFileRevision = this.rightFileRevision;
        if (this.leftFileRevision != null) {
            this.leftFileRevision.trim();
        }
        if (this.rightFileRevision != null) {
            this.rightFileRevision.trim();
        }
        this.leftFileRevision = this.leftFileRevision == null || this.leftFileRevision.equals(LOCAL_FILE_SUFFIX) || this.leftFileRevision.equals(WORKING_FILE_SUFFIX) ? NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleRevision", (Object)this.leftFileRevision);
        this.rightFileRevision = this.rightFileRevision == null || this.rightFileRevision.equals(LOCAL_FILE_SUFFIX) || this.rightFileRevision.equals(WORKING_FILE_SUFFIX) ? NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleRevision", (Object)this.rightFileRevision);
        Utils.associateEncoding((File)file, (File)f1);
        Utils.associateEncoding((File)file, (File)f2);
        StreamSource s1 = StreamSource.createSource((String)file.getName(), (String)this.leftFileRevision, (String)mimeType, (File)f1);
        StreamSource s2 = StreamSource.createSource((String)file.getName(), (String)this.rightFileRevision, (String)mimeType, (File)f2);
        MergeResultWriterInfo result = new MergeResultWriterInfo(f1, f2, f3, file, mimeType, originalLeftFileRevision, originalRightFileRevision, fo, lock, encoding, this.newLineString);
        try {
            Component c = merge.createView(diffs, s1, s2, (StreamSource)result);
            if (c instanceof TopComponent) {
                ((TopComponent)c).putClientProperty((Object)ResolveConflictsExecutor.class.getName(), (Object)Boolean.TRUE);
            }
        }
        catch (IOException ioex) {
            Subversion.LOG.log(Level.SEVERE, null, ioex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Difference[] copyParts(boolean generateDiffs, File source, File dest, boolean leftPart, Charset charset) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(source), charset));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), charset));
        ArrayList<Difference> diffList = null;
        if (generateDiffs) {
            diffList = new ArrayList<Difference>();
        }
        try {
            String line;
            boolean isChangeLeft = false;
            boolean isChangeRight = false;
            boolean isChangeBase = false;
            int f1l1 = 0;
            int f1l2 = 0;
            int f2l1 = 0;
            int f2l2 = 0;
            StringBuilder text1 = new StringBuilder();
            StringBuilder text2 = new StringBuilder();
            int i = 1;
            int j = 1;
            while ((line = r.readLine()) != null) {
                String lineText;
                if (line.startsWith(CHANGE_BASE_DELIMETER)) {
                    isChangeBase = true;
                    continue;
                }
                if (isChangeBase && line.startsWith(CHANGE_DELIMETER)) {
                    isChangeBase = false;
                } else if (isChangeBase) continue;
                if (line.startsWith(CHANGE_LEFT)) {
                    if (isChangeLeft || isChangeRight) {
                        throw new IOException(NESTED_CONFLICT);
                    }
                    if (generateDiffs) {
                        if (this.leftFileRevision == null) {
                            this.leftFileRevision = line.substring(CHANGE_LEFT.length());
                        }
                        if (isChangeLeft) {
                            f1l2 = i - 1;
                            diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                            f2l2 = 0;
                            f2l1 = 0;
                            f1l2 = 0;
                            f1l1 = 0;
                            text1.delete(0, text1.length());
                            text2.delete(0, text2.length());
                        } else {
                            f1l1 = i;
                        }
                    }
                    isChangeLeft = !isChangeLeft;
                    continue;
                }
                if (line.startsWith(CHANGE_RIGHT)) {
                    if (generateDiffs) {
                        if (this.rightFileRevision == null) {
                            this.rightFileRevision = line.substring(CHANGE_RIGHT.length());
                        }
                        if (isChangeRight) {
                            f2l2 = j - 1;
                            diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                            f2l2 = 0;
                            f2l1 = 0;
                            f1l2 = 0;
                            f1l1 = 0;
                            text1.delete(0, text1.length());
                            text2.delete(0, text2.length());
                        } else {
                            f2l1 = j;
                        }
                    }
                    isChangeRight = !isChangeRight;
                    continue;
                }
                if (isChangeRight && line.indexOf(CHANGE_RIGHT) != -1) {
                    lineText = line.substring(0, line.lastIndexOf(CHANGE_RIGHT));
                    if (generateDiffs) {
                        if (this.rightFileRevision == null) {
                            this.rightFileRevision = line.substring(line.lastIndexOf(CHANGE_RIGHT) + CHANGE_RIGHT.length());
                        }
                        text2.append(lineText);
                        f2l2 = j;
                        diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                        f2l2 = 0;
                        f2l1 = 0;
                        f1l2 = 0;
                        f1l1 = 0;
                        text1.delete(0, text1.length());
                        text2.delete(0, text2.length());
                    }
                    if (!leftPart) {
                        w.write(lineText);
                        w.newLine();
                    }
                    isChangeRight = !isChangeRight;
                    continue;
                }
                if (line.equals(CHANGE_DELIMETER)) {
                    if (isChangeLeft) {
                        isChangeLeft = false;
                        isChangeRight = true;
                        f1l2 = i - 1;
                        f2l1 = j;
                        continue;
                    }
                    if (isChangeRight) {
                        isChangeRight = false;
                        isChangeLeft = true;
                        f2l2 = j - 1;
                        f1l1 = i;
                        continue;
                    }
                } else if (line.endsWith(CHANGE_DELIMETER) && !line.endsWith(CHANGE_DELIMETER + CHANGE_DELIMETER.charAt(0))) {
                    lineText = line.substring(0, line.length() - CHANGE_DELIMETER.length()) + this.newLineString;
                    if (isChangeLeft) {
                        text1.append(lineText);
                        if (leftPart) {
                            w.write(lineText);
                            w.write(this.newLineString);
                        }
                        isChangeLeft = false;
                        isChangeRight = true;
                        f1l2 = i;
                        f2l1 = j;
                        continue;
                    }
                    if (!isChangeRight) continue;
                    text2.append(lineText);
                    if (!leftPart) {
                        w.write(lineText);
                        w.write(this.newLineString);
                    }
                    isChangeRight = false;
                    isChangeLeft = true;
                    f2l2 = j;
                    f1l1 = i;
                    continue;
                }
                if (!isChangeLeft && !isChangeRight || leftPart == isChangeLeft) {
                    w.write(line);
                    w.write(this.newLineString);
                }
                if (isChangeLeft) {
                    text1.append(line).append(this.newLineString);
                }
                if (isChangeRight) {
                    text2.append(line).append(this.newLineString);
                }
                if (!generateDiffs) continue;
                if (isChangeLeft) {
                    ++i;
                    continue;
                }
                if (isChangeRight) {
                    ++j;
                    continue;
                }
                ++i;
                ++j;
            }
        }
        finally {
            try {
                r.close();
            }
            finally {
                w.close();
            }
        }
        if (generateDiffs) {
            return diffList.toArray(new Difference[diffList.size()]);
        }
        return null;
    }

    @Override
    public void perform() {
        this.exec();
    }

    @Override
    public void run() {
        throw new RuntimeException("Not implemented");
    }

    private static class LineEndingFilterWriter
    extends FilterWriter {
        private final String lineEnding;

        public LineEndingFilterWriter(OutputStreamWriter outputStreamWriter, String lineEnding) {
            super(outputStreamWriter);
            this.lineEnding = lineEnding;
        }

        @Override
        public void write(String str) throws IOException {
            if (!SYSTEM_LINE_SEPARATOR.equals(this.lineEnding)) {
                str = str.replaceAll(SYSTEM_LINE_SEPARATOR, this.lineEnding);
            }
            super.write(str);
        }
    }

    private static class MergeConflictFileWriter
    extends FilterWriter {
        private Difference[] conflicts;
        private int lineNumber;
        private int currentConflict;
        private String leftName;
        private String rightName;
        private FileObject fo;
        private final String newLineString;

        public MergeConflictFileWriter(Writer delegate, FileObject fo, Difference[] conflicts, String leftName, String rightName, String newLineString) throws IOException {
            super(delegate);
            this.conflicts = conflicts;
            this.leftName = leftName;
            this.rightName = rightName;
            this.newLineString = newLineString;
            this.lineNumber = 1;
            this.currentConflict = 0;
            if (this.lineNumber == conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
            this.fo = fo;
        }

        @Override
        public void write(String str) throws IOException {
            if (!SYSTEM_LINE_SEPARATOR.equals(this.newLineString)) {
                str = str.replaceAll(SYSTEM_LINE_SEPARATOR, this.newLineString);
            }
            super.write(str);
            this.lineNumber += MergeConflictFileWriter.numChars(this.newLineString, str);
            if (this.currentConflict < this.conflicts.length && this.lineNumber >= this.conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(this.conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
        }

        private void writeConflict(Difference conflict) throws IOException {
            super.write(ResolveConflictsExecutor.CHANGE_LEFT + this.leftName + this.newLineString);
            super.write(conflict.getFirstText());
            super.write(ResolveConflictsExecutor.CHANGE_DELIMETER + this.newLineString);
            super.write(conflict.getSecondText());
            super.write(ResolveConflictsExecutor.CHANGE_RIGHT + this.rightName + this.newLineString);
        }

        private static int numChars(String s, String str) {
            int n = 0;
            int pos = str.indexOf(s);
            while (pos >= 0 && pos < str.length()) {
                ++n;
                pos = str.indexOf(s, pos + 1);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.fo != null) {
                this.fo.refresh(true);
            }
        }
    }

    private static class MergeResultWriterInfo
    extends StreamSource {
        private File tempf1;
        private File tempf2;
        private File tempf3;
        private File outputFile;
        private File fileToRepairEntriesOf;
        private String mimeType;
        private String leftFileRevision;
        private String rightFileRevision;
        private FileObject fo;
        private FileLock lock;
        private Charset encoding;
        private final String newLineString;

        public MergeResultWriterInfo(File tempf1, File tempf2, File tempf3, File outputFile, String mimeType, String leftFileRevision, String rightFileRevision, FileObject fo, FileLock lock, Charset encoding, String newLineString) {
            this.tempf1 = tempf1;
            this.tempf2 = tempf2;
            this.tempf3 = tempf3;
            this.outputFile = outputFile;
            this.mimeType = mimeType;
            this.leftFileRevision = leftFileRevision;
            this.rightFileRevision = rightFileRevision;
            this.fo = fo;
            this.lock = lock;
            this.newLineString = newLineString;
            if (encoding == null) {
                encoding = FileEncodingQuery.getEncoding((FileObject)FileUtil.toFileObject((File)tempf1));
            }
            this.encoding = encoding;
        }

        public String getName() {
            return this.outputFile.getName();
        }

        public String getTitle() {
            return NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Merge.titleResult");
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            throw new IOException("No reader of merge result");
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            LineEndingFilterWriter w = this.fo != null ? new LineEndingFilterWriter(new OutputStreamWriter(this.fo.getOutputStream(this.lock), this.encoding), this.newLineString) : new LineEndingFilterWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.outputFile), this.encoding), this.newLineString);
            if (conflicts == null || conflicts.length == 0) {
                this.fileToRepairEntriesOf = this.outputFile;
                return w;
            }
            return new MergeConflictFileWriter(w, this.fo, conflicts, this.leftFileRevision, this.rightFileRevision, this.newLineString);
        }

        public void close() {
            this.tempf1.delete();
            this.tempf2.delete();
            this.tempf3.delete();
            if (this.lock != null) {
                this.lock.releaseLock();
                this.lock = null;
            }
            this.fo = null;
            if (this.fileToRepairEntriesOf != null) {
                this.repairEntries(this.fileToRepairEntriesOf);
                this.fileToRepairEntriesOf = null;
            }
        }

        private void repairEntries(File file) {
            try {
                ConflictResolvedAction.perform(file);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
            }
        }
    }
}

