/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.versioning.util.VCSNotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public abstract class VCSKenaiAccessor {
    public static final String PROP_KENAI_VCS_NOTIFICATION = "kenai.vcs.notification";
    protected static final Logger LOG = Logger.getLogger("org.netbeans.modules.versioning.util.VCSKenaiSupport");

    public abstract PasswordAuthentication getPasswordAuthentication(String var1);

    public abstract PasswordAuthentication getPasswordAuthentication(String var1, boolean var2);

    public abstract boolean isKenai(String var1);

    public abstract boolean showLogin();

    public abstract boolean isLogged(String var1);

    public abstract KenaiUser forName(String var1);

    public abstract KenaiUser forName(String var1, String var2);

    public abstract boolean isUserOnline(String var1);

    public abstract void addVCSNoficationListener(PropertyChangeListener var1);

    public abstract void removeVCSNoficationListener(PropertyChangeListener var1);

    public abstract String getRevisionUrl(String var1, String var2);

    public abstract void logVcsUsage(String var1, String var2);

    public abstract boolean isAuthorized(String var1, RepositoryActivity var2);

    public static abstract class KenaiNotificationListener
    extends VCSNotificationDisplayer
    implements PropertyChangeListener {
        protected static Logger LOG = LOG;
        private final RequestProcessor rp = new RequestProcessor("Kenai VCS notifications");

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(VCSKenaiAccessor.PROP_KENAI_VCS_NOTIFICATION)) {
                final VCSKenaiNotification notification = (VCSKenaiNotification)evt.getNewValue();
                this.rp.post(new Runnable(){

                    @Override
                    public void run() {
                        this.handleVCSNotification(notification);
                    }
                });
            }
        }

        protected abstract void handleVCSNotification(VCSKenaiNotification var1);
    }

    public static abstract class VCSKenaiModification {
        public abstract Type getType();

        public abstract String getResource();

        public abstract String getId();

        public static enum Type {
            NEW,
            CHANGE,
            DELETE;

        }
    }

    public static abstract class VCSKenaiNotification {
        public abstract URI getUri();

        public abstract Date getStamp();

        public abstract Service getService();

        public abstract List<VCSKenaiModification> getModifications();

        public abstract String getAuthor();

        public abstract File getProjectDirectory();
    }

    public static abstract class KenaiUser {
        public abstract boolean isOnline();

        public abstract void addPropertyChangeListener(PropertyChangeListener var1);

        public abstract void removePropertyChangeListener(PropertyChangeListener var1);

        public abstract Icon getIcon();

        public abstract JLabel createUserWidget();

        public abstract String getUser();

        public abstract void startChat();

        public abstract void startChat(String var1);

        public static String getChatLink(FileObject fo, int line) {
            Project p;
            ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
            String ret = "";
            ret = cp != null ? cp.getResourceName(fo) : ((p = FileOwnerQuery.getOwner((FileObject)fo)) != null ? "{$" + ProjectUtils.getInformation((Project)p).getName() + "}/" + FileUtil.getRelativePath((FileObject)p.getProjectDirectory(), (FileObject)fo) : fo.getPath());
            ret = ret + ":" + line;
            ret = "FILE:" + ret;
            return ret;
        }
    }

    public static enum RepositoryActivity {
        READ,
        WRITE;

    }

    public static enum Service {
        VCS_SVN,
        VCS_HG,
        UNKNOWN;

    }
}

