/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.team.spi;

import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import org.netbeans.modules.team.spi.Bundle;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.netbeans.modules.team.spi.RepositoryUser;
import org.netbeans.modules.team.spi.TeamAccessor;
import org.netbeans.modules.team.spi.TeamProject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class TeamAccessorUtils {
    public static final String ALL_ISSUES_QUERY_DISPLAY_NAME = Bundle.LBL_All();
    public static final String MY_ISSUES_QUERY_DISPLAY_NAME = Bundle.LBL_My();
    public static final String RELATED_ISSUES_QUERY_DISPLAY_NAME = Bundle.LBL_Related();
    public static final String RECENT_ISSUES_QUERY_DISPLAY_NAME = Bundle.LBL_Recent();
    public static final String MINE_ISSUES_QUERY_DISPLAY_NAME = Bundle.LBL_Mine();
    public static final String OPEN_ISSUES_QUERY_DISPLAY_NAME = Bundle.LBL_Open();
    private static TeamAccessor[] teamAccessors;

    public static TeamAccessor[] getTeamAccessors() {
        if (teamAccessors == null) {
            Collection coll = Lookup.getDefault().lookupAll(TeamAccessor.class);
            teamAccessors = coll.toArray(new TeamAccessor[coll.size()]);
        }
        return teamAccessors;
    }

    public static TeamAccessor getTeamAccessor(String url) {
        TeamAccessor accessor = null;
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            if (!ka.isOwner(url)) continue;
            accessor = ka;
            break;
        }
        return accessor;
    }

    public static boolean isLoggedIn(URL url) {
        return TeamAccessorUtils.isLoggedIn(url.toString());
    }

    public static boolean isLoggedIn(String url) {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            if (!ka.isLoggedIn(url)) continue;
            return true;
        }
        return false;
    }

    public static boolean showLogin(String url) {
        TeamAccessor ka = TeamAccessorUtils.getTeamAccessor(url);
        return ka != null ? ka.showLogin() : false;
    }

    public static PasswordAuthentication getPasswordAuthentication(String url, boolean forceLogin) {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            PasswordAuthentication pa = ka.getPasswordAuthentication(url, forceLogin);
            if (pa == null) continue;
            return pa;
        }
        return null;
    }

    public static Collection<RepositoryUser> getProjectMembers(TeamProject kp) {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            try {
                Collection<RepositoryUser> projectMembers = ka.getProjectMembers(kp);
                if (projectMembers == null) continue;
                return projectMembers;
            }
            catch (IOException ex) {
                Logger.getLogger(TeamAccessorUtils.class.getName()).log(Level.WARNING, null, ex);
            }
        }
        return Collections.emptyList();
    }

    public static JLabel createUserWidget(String url, String userName, String host, String chatMessage) {
        TeamAccessor ka = TeamAccessorUtils.getTeamAccessor(url);
        assert (ka != null);
        return ka.createUserWidget(userName, host, chatMessage);
    }

    public static OwnerInfo getOwnerInfo(Node node) {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            OwnerInfo ownerInfo = ka.getOwnerInfo(node);
            if (ownerInfo == null) continue;
            return ownerInfo;
        }
        return null;
    }

    public static OwnerInfo getOwnerInfo(File file) {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            OwnerInfo ownerInfo = ka.getOwnerInfo(file);
            if (ownerInfo == null) continue;
            return ownerInfo;
        }
        return null;
    }

    public static void logTeamUsage(String url, Object ... parameters) {
        TeamAccessor ka = TeamAccessorUtils.getTeamAccessor(url);
        if (ka != null) {
            ka.logTeamUsage(parameters);
        }
    }

    public static TeamProject getTeamProjectForRepository(String repositoryUrl) throws IOException {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            TeamProject kp = ka.getTeamProjectForRepository(repositoryUrl);
            if (kp == null) continue;
            return kp;
        }
        return null;
    }

    public static TeamProject getTeamProjectForRepository(String repositoryUrl, boolean forceLogin) throws IOException {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            TeamProject kp;
            if (ka.isOwner(repositoryUrl) && forceLogin && !ka.isLoggedIn(repositoryUrl)) {
                ka.showLogin();
            }
            if ((kp = ka.getTeamProjectForRepository(repositoryUrl)) == null) continue;
            return kp;
        }
        return null;
    }

    public static TeamProject getTeamProject(String url, String projectName) {
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            try {
                TeamProject kp = ka.getTeamProject(url, projectName);
                if (kp == null) continue;
                return kp;
            }
            catch (IOException ex) {
                Logger.getLogger(TeamAccessorUtils.class.getName()).log(Level.WARNING, url, ex);
            }
        }
        return null;
    }

    public static TeamProject[] getDashboardProjects(boolean onlyOpened) {
        LinkedList<TeamProject> projs = new LinkedList<TeamProject>();
        for (TeamAccessor ka : TeamAccessorUtils.getTeamAccessors()) {
            projs.addAll(Arrays.asList(ka.getDashboardProjects(onlyOpened)));
        }
        return projs.toArray(new TeamProject[projs.size()]);
    }

    public static String getChatLink(String id) {
        return "ISSUE:" + id;
    }
}

