/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.css.lib.api.properties.GrammarElementVisitor;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;

public abstract class GrammarElement {
    public static final char INVISIBLE_PROPERTY_PREFIX = '@';
    private GroupGrammarElement parent;
    private String path;
    private String name;
    private int minimum_occurances = 1;
    private int maximum_occurances = 1;

    public static boolean isArtificialElementName(CharSequence name) {
        if (name.length() == 0) {
            return false;
        }
        return name.charAt(0) == '@';
    }

    public GrammarElement(GroupGrammarElement parent, String elementName) {
        this.parent = parent;
        this.name = elementName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract void accept(GrammarElementVisitor var1);

    public void setMinimumOccurances(int i) {
        this.minimum_occurances = i;
    }

    public void setMaximumOccurances(int i) {
        this.maximum_occurances = i;
    }

    public int getMaximumOccurances() {
        return this.maximum_occurances;
    }

    public int getMinimumOccurances() {
        return this.minimum_occurances;
    }

    public boolean isOptional() {
        return this.getMinimumOccurances() == 0;
    }

    public GroupGrammarElement parent() {
        return this.parent;
    }

    public boolean equals(Object o) {
        if (!(o instanceof GrammarElement)) {
            return false;
        }
        GrammarElement e = (GrammarElement)o;
        return this.path().equalsIgnoreCase(e.path());
    }

    public int hashCode() {
        return this.path().hashCode();
    }

    public String origin() {
        return this.origin(true);
    }

    public String getVisibleOrigin() {
        return this.origin(false);
    }

    private String origin(boolean allowNonVisibleElements) {
        for (GroupGrammarElement p = this.parent; p != null; p = p.parent()) {
            boolean visible;
            if (p.getName() == null) continue;
            boolean bl = visible = !GrammarElement.isArtificialElementName(p.getName());
            if (!visible && !allowNonVisibleElements) continue;
            return p.getName();
        }
        return null;
    }

    public String path() {
        if (this.path == null) {
            StringBuilder sb = new StringBuilder();
            if (this.parent() != null) {
                sb.append(this.parent().path());
                sb.append('/');
            }
            sb.append(this.toString());
            this.path = sb.toString();
        }
        return this.path;
    }

    public List<GrammarElement> elementsPath() {
        LinkedList<GrammarElement> elementsPath = new LinkedList<GrammarElement>();
        GrammarElement element = this;
        do {
            elementsPath.add(0, element);
        } while ((element = element.parent()) != null);
        return elementsPath;
    }

    public String toString() {
        if (this.getMinimumOccurances() != 1 || this.getMaximumOccurances() != 1) {
            return "{" + this.getMinimumOccurances() + "," + (this.getMaximumOccurances() == Integer.MAX_VALUE ? "inf" : Integer.valueOf(this.getMaximumOccurances())) + "}";
        }
        return "";
    }
}

