/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class GradleFileLocator
implements LineConvertors.FileLocator {
    private ClassPath classpath;
    private final Project project;
    private static final Object LOCK = new Object();
    private static final Logger LOG = Logger.getLogger(GradleFileLocator.class.getName());

    public GradleFileLocator(Project project) {
        this.project = project;
        NbGradleProject.addPropertyChangeListener((Project)project, (PropertyChangeListener)new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("resources".equals(evt.getPropertyName()) || "ProjectInfo".equals(evt.getPropertyName())) {
                    Object object = LOCK;
                    synchronized (object) {
                        GradleFileLocator.this.classpath = null;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject find(String filename) {
        ClassPath cp;
        if (filename == null) {
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.classpath == null) {
                this.classpath = this.getProjectClasspath(this.project);
            }
            cp = this.classpath;
        }
        FileObject toRet = cp.findResource(filename);
        if (toRet == null) {
            LOG.log(Level.FINE, "#221053: Cannot find FileObject for {0}", filename);
        }
        return toRet;
    }

    private ClassPath getProjectClasspath(Project p) {
        ClassPathProvider cpp = (ClassPathProvider)p.getLookup().lookup(ClassPathProvider.class);
        HashSet<FileObject> roots = new HashSet<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)p);
        if (sources != null) {
            SourceGroup[] groups = sources.getSourceGroups("java");
            for (SourceGroup group : groups) {
                roots.add(group.getRootFolder());
            }
        }
        HashSet<ClassPath> setCP = new HashSet<ClassPath>();
        if (cpp != null) {
            for (FileObject file : roots) {
                ClassPath path = cpp.findClassPath(file, "classpath/compile");
                setCP.add(path);
            }
        }
        for (ClassPath cp : setCP) {
            FileObject[] rootsCP;
            for (FileObject fo : rootsCP = cp.getRoots()) {
                FileObject[] aaa = SourceForBinaryQuery.findSourceRoots((URL)fo.toURL()).getRoots();
                roots.addAll(Arrays.asList(aaa));
            }
        }
        JavaPlatform platform = JavaPlatform.getDefault();
        if (platform != null) {
            roots.addAll(Arrays.asList(platform.getSourceFolders().getRoots()));
        }
        ClassPath result = ClassPathSupport.createClassPath((FileObject[])roots.toArray(new FileObject[roots.size()]));
        return result;
    }
}

