/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.CRTable;
import com.sun.tools.javac.jvm.ClassWriter;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.jvm.PoolWriter;
import com.sun.tools.javac.jvm.UninitializedType;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Position;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.ToIntBiFunction;

public class Code {
    public final boolean debugCode;
    public final boolean needStackMap;
    final Types types;
    final Symtab syms;
    final PoolWriter poolWriter;
    public int max_stack = 0;
    public int max_locals = 0;
    public byte[] code = new byte[64];
    public int cp = 0;
    ListBuffer<char[]> catchInfo = new ListBuffer();
    List<char[]> lineInfo = List.nil();
    public CRTable crt;
    public boolean fatcode;
    private boolean alive = true;
    State state;
    private boolean fixedPc = false;
    public int nextreg = 0;
    Chain pendingJumps = null;
    int pendingStatPos = -1;
    boolean pendingStackMap = false;
    StackMapFormat stackMap;
    boolean varDebugInfo;
    boolean lineDebugInfo;
    Position.LineMap lineMap;
    final Symbol.MethodSymbol meth;
    private int letExprStackPos = 0;
    StackMapFrame[] stackMapBuffer = null;
    ClassWriter.StackMapTableFrame[] stackMapTableBuffer = null;
    int stackMapBufferSize = 0;
    int lastStackMapPC = -1;
    StackMapFrame lastFrame = null;
    StackMapFrame frameBeforeLast = null;
    static final Type jsrReturnValue = new Type.JCPrimitiveType(TypeTag.INT, null);
    LocalVar[] lvar;
    LocalVar[] varBuffer;
    int varBufferSize;

    public boolean checkLimits(JCDiagnostic.DiagnosticPosition pos, Log log) {
        if (this.cp > 65535) {
            log.error(pos, CompilerProperties.Errors.LimitCode);
            return true;
        }
        if (this.max_locals > 65535) {
            log.error(pos, CompilerProperties.Errors.LimitLocals);
            return true;
        }
        if (this.max_stack > 65535) {
            log.error(pos, CompilerProperties.Errors.LimitStack);
            return true;
        }
        return false;
    }

    public Code(Symbol.MethodSymbol meth, boolean fatcode, Position.LineMap lineMap, boolean varDebugInfo, StackMapFormat stackMap, boolean debugCode, CRTable crt, Symtab syms, Types types, PoolWriter poolWriter) {
        this.meth = meth;
        this.fatcode = fatcode;
        this.lineMap = lineMap;
        this.lineDebugInfo = lineMap != null;
        this.varDebugInfo = varDebugInfo;
        this.crt = crt;
        this.syms = syms;
        this.types = types;
        this.poolWriter = poolWriter;
        this.debugCode = debugCode;
        this.stackMap = stackMap;
        switch (stackMap) {
            case CLDC: 
            case JSR202: {
                this.needStackMap = true;
                break;
            }
            default: {
                this.needStackMap = false;
            }
        }
        this.state = new State();
        this.lvar = new LocalVar[20];
    }

    public static int typecode(Type type) {
        switch (type.getTag()) {
            case BYTE: {
                return 5;
            }
            case SHORT: {
                return 7;
            }
            case CHAR: {
                return 6;
            }
            case INT: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case FLOAT: {
                return 2;
            }
            case DOUBLE: {
                return 3;
            }
            case BOOLEAN: {
                return 5;
            }
            case VOID: {
                return 8;
            }
            case CLASS: 
            case ARRAY: 
            case METHOD: 
            case BOT: 
            case TYPEVAR: 
            case UNINITIALIZED_THIS: 
            case UNINITIALIZED_OBJECT: {
                return 4;
            }
        }
        throw new AssertionError((Object)("typecode " + (Object)((Object)type.getTag())));
    }

    public static int truncate(int tc) {
        switch (tc) {
            case 5: 
            case 6: 
            case 7: {
                return 0;
            }
        }
        return tc;
    }

    public static int width(int typecode) {
        switch (typecode) {
            case 1: 
            case 3: {
                return 2;
            }
            case 8: {
                return 0;
            }
        }
        return 1;
    }

    public static int width(Type type) {
        return type == null ? 1 : Code.width(Code.typecode(type));
    }

    public static int width(List<Type> types) {
        int w = 0;
        List<Type> l = types;
        while (l.nonEmpty()) {
            w += Code.width((Type)l.head);
            l = l.tail;
        }
        return w;
    }

    public static int arraycode(Type type) {
        switch (type.getTag()) {
            case BYTE: {
                return 8;
            }
            case BOOLEAN: {
                return 4;
            }
            case SHORT: {
                return 9;
            }
            case CHAR: {
                return 5;
            }
            case INT: {
                return 10;
            }
            case LONG: {
                return 11;
            }
            case FLOAT: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case CLASS: {
                return 0;
            }
            case ARRAY: {
                return 1;
            }
        }
        throw new AssertionError((Object)("arraycode " + type));
    }

    public int curCP() {
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        if (this.pendingStatPos != -1) {
            this.markStatBegin();
        }
        this.fixedPc = true;
        return this.cp;
    }

    private void emit1(int od) {
        if (!this.alive) {
            return;
        }
        this.code = ArrayUtils.ensureCapacity(this.code, this.cp);
        this.code[this.cp++] = (byte)od;
    }

    private void emit2(int od) {
        if (!this.alive) {
            return;
        }
        if (this.cp + 2 > this.code.length) {
            this.emit1(od >> 8);
            this.emit1(od);
        } else {
            this.code[this.cp++] = (byte)(od >> 8);
            this.code[this.cp++] = (byte)od;
        }
    }

    public void emit4(int od) {
        if (!this.alive) {
            return;
        }
        if (this.cp + 4 > this.code.length) {
            this.emit1(od >> 24);
            this.emit1(od >> 16);
            this.emit1(od >> 8);
            this.emit1(od);
        } else {
            this.code[this.cp++] = (byte)(od >> 24);
            this.code[this.cp++] = (byte)(od >> 16);
            this.code[this.cp++] = (byte)(od >> 8);
            this.code[this.cp++] = (byte)od;
        }
    }

    private void emitop(int op) {
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        if (this.alive) {
            if (this.pendingStatPos != -1) {
                this.markStatBegin();
            }
            if (this.pendingStackMap) {
                this.pendingStackMap = false;
                this.emitStackMap();
            }
            if (this.debugCode) {
                System.err.println("emit@" + this.cp + " stack=" + this.state.stacksize + ": " + Code.mnem(op));
            }
            this.emit1(op);
        }
    }

    void postop() {
        Assert.check(this.alive || this.isStatementStart());
    }

    public void emitLdc(PoolConstant.LoadableConstant constant) {
        int od = this.poolWriter.putConstant(constant);
        if (od <= 255) {
            this.emitop1(18, od, constant);
        } else {
            this.emitop2(19, od, constant);
        }
    }

    public void emitMultianewarray(int ndims, int type, Type arrayType) {
        this.emitop(197);
        if (!this.alive) {
            return;
        }
        this.emit2(type);
        this.emit1(ndims);
        this.state.pop(ndims);
        this.state.push(arrayType);
    }

    public void emitNewarray(int elemcode, Type arrayType) {
        this.emitop(188);
        if (!this.alive) {
            return;
        }
        this.emit1(elemcode);
        this.state.pop(1);
        this.state.push(arrayType);
    }

    public void emitAnewarray(int od, Type arrayType) {
        this.emitop(189);
        if (!this.alive) {
            return;
        }
        this.emit2(od);
        this.state.pop(1);
        this.state.push(arrayType);
    }

    public void emitInvokeinterface(Symbol member, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(185);
        if (!this.alive) {
            return;
        }
        this.emit2(this.poolWriter.putMember(member));
        this.emit1(argsize + 1);
        this.emit1(0);
        this.state.pop(argsize + 1);
        this.state.push(mtype.getReturnType());
    }

    public void emitInvokespecial(Symbol member, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(183);
        if (!this.alive) {
            return;
        }
        this.emit2(this.poolWriter.putMember(member));
        this.state.pop(argsize);
        if (member.isConstructor()) {
            this.state.markInitialized((UninitializedType)this.state.peek());
        }
        this.state.pop(1);
        this.state.push(mtype.getReturnType());
    }

    public void emitInvokestatic(Symbol member, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(184);
        if (!this.alive) {
            return;
        }
        this.emit2(this.poolWriter.putMember(member));
        this.state.pop(argsize);
        this.state.push(mtype.getReturnType());
    }

    public void emitInvokevirtual(Symbol member, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(182);
        if (!this.alive) {
            return;
        }
        this.emit2(this.poolWriter.putMember(member));
        this.state.pop(argsize + 1);
        this.state.push(mtype.getReturnType());
    }

    public void emitInvokedynamic(Symbol.DynamicMethodSymbol dynMember, Type mtype) {
        int argsize = Code.width(mtype.getParameterTypes());
        this.emitop(186);
        if (!this.alive) {
            return;
        }
        this.emit2(this.poolWriter.putDynamic(dynMember));
        this.emit2(0);
        this.state.pop(argsize);
        this.state.push(mtype.getReturnType());
    }

    public void emitop0(int op) {
        this.emitop(op);
        if (!this.alive) {
            return;
        }
        switch (op) {
            case 50: {
                this.state.pop(1);
                Type a = this.state.stack[this.state.stacksize - 1];
                Assert.check(!a.hasTag(TypeTag.BOT));
                this.state.pop(1);
                this.state.push(this.types.erasure(this.types.elemtype(a)));
                break;
            }
            case 167: {
                this.markDead();
                break;
            }
            case 0: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                break;
            }
            case 1: {
                this.state.push(this.syms.botType);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.state.push(this.syms.intType);
                break;
            }
            case 9: 
            case 10: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.state.push(this.syms.longType);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.state.push(this.syms.floatType);
                break;
            }
            case 14: 
            case 15: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.state.push(this.syms.doubleType);
                break;
            }
            case 42: {
                this.state.push(this.lvar[0].sym.type);
                break;
            }
            case 43: {
                this.state.push(this.lvar[1].sym.type);
                break;
            }
            case 44: {
                this.state.push(this.lvar[2].sym.type);
                break;
            }
            case 45: {
                this.state.push(this.lvar[3].sym.type);
                break;
            }
            case 46: 
            case 51: 
            case 52: 
            case 53: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 47: {
                this.state.pop(2);
                this.state.push(this.syms.longType);
                break;
            }
            case 48: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 49: {
                this.state.pop(2);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 87: 
            case 121: 
            case 123: 
            case 125: {
                this.state.pop(1);
                break;
            }
            case 172: 
            case 174: 
            case 176: {
                Assert.check(this.state.nlocks == 0);
                this.state.pop(1);
                this.markDead();
                break;
            }
            case 191: {
                this.state.pop(this.state.stacksize);
                this.markDead();
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 88: {
                this.state.pop(2);
                break;
            }
            case 173: 
            case 175: {
                Assert.check(this.state.nlocks == 0);
                this.state.pop(2);
                this.markDead();
                break;
            }
            case 89: {
                this.state.push(this.state.stack[this.state.stacksize - 1]);
                break;
            }
            case 177: {
                Assert.check(this.state.nlocks == 0);
                this.markDead();
                break;
            }
            case 190: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                this.state.pop(1);
                break;
            }
            case 83: {
                this.state.pop(3);
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: {
                this.state.pop(2);
                break;
            }
            case 148: {
                this.state.pop(4);
                this.state.push(this.syms.intType);
                break;
            }
            case 136: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 133: {
                this.state.pop(1);
                this.state.push(this.syms.longType);
                break;
            }
            case 134: {
                this.state.pop(1);
                this.state.push(this.syms.floatType);
                break;
            }
            case 135: {
                this.state.pop(1);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 137: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 138: {
                this.state.pop(2);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 139: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 140: {
                this.state.pop(1);
                this.state.push(this.syms.longType);
                break;
            }
            case 141: {
                this.state.pop(1);
                this.state.push(this.syms.doubleType);
                break;
            }
            case 142: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 143: {
                this.state.pop(2);
                this.state.push(this.syms.longType);
                break;
            }
            case 144: {
                this.state.pop(2);
                this.state.push(this.syms.floatType);
                break;
            }
            case 170: 
            case 171: {
                this.state.pop(1);
                break;
            }
            case 90: {
                Type val1 = this.state.pop1();
                Type val2 = this.state.pop1();
                this.state.push(val1);
                this.state.push(val2);
                this.state.push(val1);
                break;
            }
            case 84: {
                this.state.pop(3);
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                this.state.pop(1);
                break;
            }
            case 79: 
            case 81: 
            case 85: 
            case 86: {
                this.state.pop(3);
                break;
            }
            case 80: 
            case 82: {
                this.state.pop(4);
                break;
            }
            case 92: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value1 = this.state.pop1();
                    Type value2 = this.state.pop1();
                    this.state.push(value2);
                    this.state.push(value1);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value = this.state.pop2();
                this.state.push(value);
                this.state.push(value);
                break;
            }
            case 93: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value1 = this.state.pop1();
                    Type value2 = this.state.pop1();
                    Type value3 = this.state.pop1();
                    this.state.push(value2);
                    this.state.push(value1);
                    this.state.push(value3);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value1 = this.state.pop2();
                Type value2 = this.state.pop1();
                this.state.push(value1);
                this.state.push(value2);
                this.state.push(value1);
                break;
            }
            case 94: {
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value1 = this.state.pop1();
                    Type value2 = this.state.pop1();
                    if (this.state.stack[this.state.stacksize - 1] != null) {
                        Type value3 = this.state.pop1();
                        Type value4 = this.state.pop1();
                        this.state.push(value2);
                        this.state.push(value1);
                        this.state.push(value4);
                        this.state.push(value3);
                        this.state.push(value2);
                        this.state.push(value1);
                        break;
                    }
                    Type value3 = this.state.pop2();
                    this.state.push(value2);
                    this.state.push(value1);
                    this.state.push(value3);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value1 = this.state.pop2();
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value2 = this.state.pop1();
                    Type value3 = this.state.pop1();
                    this.state.push(value1);
                    this.state.push(value3);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value2 = this.state.pop2();
                this.state.push(value1);
                this.state.push(value2);
                this.state.push(value1);
                break;
            }
            case 91: {
                Type value1 = this.state.pop1();
                if (this.state.stack[this.state.stacksize - 1] != null) {
                    Type value2 = this.state.pop1();
                    Type value3 = this.state.pop1();
                    this.state.push(value1);
                    this.state.push(value3);
                    this.state.push(value2);
                    this.state.push(value1);
                    break;
                }
                Type value2 = this.state.pop2();
                this.state.push(value1);
                this.state.push(value2);
                this.state.push(value1);
                break;
            }
            case 149: 
            case 150: {
                this.state.pop(2);
                this.state.push(this.syms.intType);
                break;
            }
            case 151: 
            case 152: {
                this.state.pop(4);
                this.state.push(this.syms.intType);
                break;
            }
            case 95: {
                Type value1 = this.state.pop1();
                Type value2 = this.state.pop1();
                this.state.push(value1);
                this.state.push(value2);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.state.pop(2);
                break;
            }
            case 169: {
                this.markDead();
                break;
            }
            case 196: {
                return;
            }
            case 194: 
            case 195: {
                this.state.pop(1);
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
        this.postop();
    }

    public void emitop1(int op, int od) {
        this.emitop1(op, od, null);
    }

    public void emitop1(int op, int od, PoolConstant data) {
        this.emitop(op);
        if (!this.alive) {
            return;
        }
        this.emit1(od);
        switch (op) {
            case 16: {
                this.state.push(this.syms.intType);
                break;
            }
            case 18: {
                this.state.push(this.types.constantType((PoolConstant.LoadableConstant)data));
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
        this.postop();
    }

    public void emitop1w(int op, int od) {
        if (od > 255) {
            this.emitop(196);
            this.emitop(op);
            this.emit2(od);
        } else {
            this.emitop(op);
            this.emit1(od);
        }
        if (!this.alive) {
            return;
        }
        switch (op) {
            case 21: {
                this.state.push(this.syms.intType);
                break;
            }
            case 22: {
                this.state.push(this.syms.longType);
                break;
            }
            case 23: {
                this.state.push(this.syms.floatType);
                break;
            }
            case 24: {
                this.state.push(this.syms.doubleType);
                break;
            }
            case 25: {
                this.state.push(this.lvar[od].sym.type);
                break;
            }
            case 55: 
            case 57: {
                this.state.pop(2);
                break;
            }
            case 54: 
            case 56: 
            case 58: {
                this.state.pop(1);
                break;
            }
            case 169: {
                this.markDead();
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
        this.postop();
    }

    public void emitop1w(int op, int od1, int od2) {
        if (od1 > 255 || od2 < -128 || od2 > 127) {
            this.emitop(196);
            this.emitop(op);
            this.emit2(od1);
            this.emit2(od2);
        } else {
            this.emitop(op);
            this.emit1(od1);
            this.emit1(od2);
        }
        if (!this.alive) {
            return;
        }
        switch (op) {
            case 132: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
    }

    public <P extends PoolConstant> void emitop2(int op, P constant, ToIntBiFunction<PoolWriter, P> poolFunc) {
        int od = poolFunc.applyAsInt(this.poolWriter, constant);
        this.emitop2(op, od, constant);
    }

    public void emitop2(int op, int od) {
        this.emitop2(op, od, null);
    }

    public void emitop2(int op, int od, PoolConstant data) {
        this.emitop(op);
        if (!this.alive) {
            return;
        }
        this.emit2(od);
        switch (op) {
            case 178: {
                this.state.push(((Symbol)data).erasure(this.types));
                break;
            }
            case 179: {
                this.state.pop(((Symbol)data).erasure(this.types));
                break;
            }
            case 187: {
                Type t = (Type)data;
                this.state.push(UninitializedType.uninitializedObject(t.tsym.erasure(this.types), this.cp - 3));
                break;
            }
            case 17: {
                this.state.push(this.syms.intType);
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 198: 
            case 199: {
                this.state.pop(1);
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.state.pop(2);
                break;
            }
            case 167: {
                this.markDead();
                break;
            }
            case 181: {
                this.state.pop(((Symbol)data).erasure(this.types));
                this.state.pop(1);
                break;
            }
            case 180: {
                this.state.pop(1);
                this.state.push(((Symbol)data).erasure(this.types));
                break;
            }
            case 192: {
                this.state.pop(1);
                Type t = this.types.erasure((Type)data);
                this.state.push(t);
                break;
            }
            case 20: {
                this.state.push(this.types.constantType((PoolConstant.LoadableConstant)data));
                break;
            }
            case 193: {
                this.state.pop(1);
                this.state.push(this.syms.intType);
                break;
            }
            case 19: {
                this.state.push(this.types.constantType((PoolConstant.LoadableConstant)data));
                break;
            }
            case 168: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
    }

    public void emitop4(int op, int od) {
        this.emitop(op);
        if (!this.alive) {
            return;
        }
        this.emit4(od);
        switch (op) {
            case 200: {
                this.markDead();
                break;
            }
            case 201: {
                break;
            }
            default: {
                throw new AssertionError((Object)Code.mnem(op));
            }
        }
    }

    public void align(int incr) {
        if (this.alive) {
            while (this.cp % incr != 0) {
                this.emitop0(0);
            }
        }
    }

    private void put1(int pc, int op) {
        this.code[pc] = (byte)op;
    }

    private void put2(int pc, int od) {
        this.put1(pc, od >> 8);
        this.put1(pc + 1, od);
    }

    public void put4(int pc, int od) {
        this.put1(pc, od >> 24);
        this.put1(pc + 1, od >> 16);
        this.put1(pc + 2, od >> 8);
        this.put1(pc + 3, od);
    }

    private int get1(int pc) {
        return this.code[pc] & 0xFF;
    }

    private int get2(int pc) {
        return this.get1(pc) << 8 | this.get1(pc + 1);
    }

    public int get4(int pc) {
        return this.get1(pc) << 24 | this.get1(pc + 1) << 16 | this.get1(pc + 2) << 8 | this.get1(pc + 3);
    }

    public boolean isAlive() {
        return this.alive || this.pendingJumps != null;
    }

    public void markDead() {
        this.alive = false;
    }

    public int entryPoint() {
        int pc = this.curCP();
        this.alive = true;
        this.pendingStackMap = this.needStackMap;
        return pc;
    }

    public int entryPoint(State state) {
        int pc = this.curCP();
        this.alive = true;
        State newState = state.dup();
        this.setDefined(newState.defined);
        this.state = newState;
        Assert.check(state.stacksize <= this.max_stack);
        if (this.debugCode) {
            System.err.println("entry point " + state);
        }
        this.pendingStackMap = this.needStackMap;
        return pc;
    }

    public int entryPoint(State state, Type pushed) {
        int pc = this.curCP();
        this.alive = true;
        State newState = state.dup();
        this.setDefined(newState.defined);
        this.state = newState;
        Assert.check(state.stacksize <= this.max_stack);
        this.state.push(pushed);
        if (this.debugCode) {
            System.err.println("entry point " + state);
        }
        this.pendingStackMap = this.needStackMap;
        return pc;
    }

    public int setLetExprStackPos(int pos) {
        int res = this.letExprStackPos;
        this.letExprStackPos = pos;
        return res;
    }

    public boolean isStatementStart() {
        return !this.alive || this.state.stacksize == this.letExprStackPos;
    }

    public void emitStackMap() {
        int pc = this.curCP();
        if (!this.needStackMap) {
            return;
        }
        switch (this.stackMap) {
            case CLDC: {
                this.emitCLDCStackMap(pc, this.getLocalsSize());
                break;
            }
            case JSR202: {
                this.emitStackMapFrame(pc, this.getLocalsSize());
                break;
            }
            default: {
                throw new AssertionError((Object)"Should have chosen a stackmap format");
            }
        }
        if (this.debugCode) {
            this.state.dump(pc);
        }
    }

    private int getLocalsSize() {
        int nextLocal = 0;
        for (int i = this.max_locals - 1; i >= 0; --i) {
            if (!this.state.defined.isMember(i) || this.lvar[i] == null) continue;
            nextLocal = i + Code.width(this.lvar[i].sym.erasure(this.types));
            break;
        }
        return nextLocal;
    }

    void emitCLDCStackMap(int pc, int localsSize) {
        int i;
        if (this.lastStackMapPC == pc) {
            this.stackMapBuffer[--this.stackMapBufferSize] = null;
        }
        this.lastStackMapPC = pc;
        this.stackMapBuffer = this.stackMapBuffer == null ? new StackMapFrame[20] : ArrayUtils.ensureCapacity(this.stackMapBuffer, this.stackMapBufferSize);
        StackMapFrame stackMapFrame = new StackMapFrame();
        this.stackMapBuffer[this.stackMapBufferSize++] = stackMapFrame;
        StackMapFrame frame = stackMapFrame;
        frame.pc = pc;
        frame.locals = new Type[localsSize];
        for (i = 0; i < localsSize; ++i) {
            if (!this.state.defined.isMember(i) || this.lvar[i] == null) continue;
            Type vtype = this.lvar[i].sym.type;
            if (!(vtype instanceof UninitializedType)) {
                vtype = this.types.erasure(vtype);
            }
            frame.locals[i] = vtype;
        }
        frame.stack = new Type[this.state.stacksize];
        for (i = 0; i < this.state.stacksize; ++i) {
            frame.stack[i] = this.state.stack[i];
        }
    }

    void emitStackMapFrame(int pc, int localsSize) {
        int i;
        if (this.lastFrame == null) {
            this.lastFrame = this.getInitialFrame();
        } else if (this.lastFrame.pc == pc) {
            this.stackMapTableBuffer[--this.stackMapBufferSize] = null;
            this.lastFrame = this.frameBeforeLast;
            this.frameBeforeLast = null;
        }
        StackMapFrame frame = new StackMapFrame();
        frame.pc = pc;
        int localCount = 0;
        Type[] locals = new Type[localsSize];
        int i2 = 0;
        while (i2 < localsSize) {
            if (this.state.defined.isMember(i2) && this.lvar[i2] != null) {
                Type vtype = this.lvar[i2].sym.type;
                if (!(vtype instanceof UninitializedType)) {
                    vtype = this.types.erasure(vtype);
                }
                locals[i2] = vtype;
                if (Code.width(vtype) > 1) {
                    ++i2;
                }
            }
            ++i2;
            ++localCount;
        }
        frame.locals = new Type[localCount];
        i2 = 0;
        int j = 0;
        while (i2 < localsSize) {
            Assert.check(j < localCount);
            frame.locals[j] = locals[i2];
            if (Code.width(locals[i2]) > 1) {
                ++i2;
            }
            ++i2;
            ++j;
        }
        int stackCount = 0;
        for (i = 0; i < this.state.stacksize; ++i) {
            if (this.state.stack[i] == null) continue;
            ++stackCount;
        }
        frame.stack = new Type[stackCount];
        stackCount = 0;
        for (i = 0; i < this.state.stacksize; ++i) {
            if (this.state.stack[i] == null) continue;
            frame.stack[stackCount++] = this.types.erasure(this.state.stack[i]);
        }
        this.stackMapTableBuffer = this.stackMapTableBuffer == null ? new ClassWriter.StackMapTableFrame[20] : ArrayUtils.ensureCapacity(this.stackMapTableBuffer, this.stackMapBufferSize);
        this.stackMapTableBuffer[this.stackMapBufferSize++] = ClassWriter.StackMapTableFrame.getInstance(frame, this.lastFrame.pc, this.lastFrame.locals, this.types);
        this.frameBeforeLast = this.lastFrame;
        this.lastFrame = frame;
    }

    StackMapFrame getInitialFrame() {
        StackMapFrame frame = new StackMapFrame();
        List<Type> arg_types = ((Type.MethodType)this.meth.externalType((Types)this.types)).argtypes;
        int len = arg_types.length();
        int count = 0;
        if (!this.meth.isStatic()) {
            Type thisType = this.meth.owner.type;
            frame.locals = new Type[len + 1];
            frame.locals[count++] = this.meth.isConstructor() && thisType != this.syms.objectType ? UninitializedType.uninitializedThis(thisType) : this.types.erasure(thisType);
        } else {
            frame.locals = new Type[len];
        }
        for (Type arg_type : arg_types) {
            frame.locals[count++] = this.types.erasure(arg_type);
        }
        frame.pc = -1;
        frame.stack = null;
        return frame;
    }

    public static int negate(int opcode) {
        if (opcode == 198) {
            return 199;
        }
        if (opcode == 199) {
            return 198;
        }
        return (opcode + 1 ^ 1) - 1;
    }

    public int emitJump(int opcode) {
        if (this.fatcode) {
            if (opcode == 167 || opcode == 168) {
                this.emitop4(opcode + 200 - 167, 0);
            } else {
                this.emitop2(Code.negate(opcode), 8);
                this.emitop4(200, 0);
                this.alive = true;
                this.pendingStackMap = this.needStackMap;
            }
            return this.cp - 5;
        }
        this.emitop2(opcode, 0);
        return this.cp - 3;
    }

    public Chain branch(int opcode) {
        Chain result = null;
        if (opcode == 167) {
            result = this.pendingJumps;
            this.pendingJumps = null;
        }
        if (opcode != 168 && this.isAlive()) {
            result = new Chain(this.emitJump(opcode), result, this.state.dup());
            this.fixedPc = this.fatcode;
            if (opcode == 167) {
                this.alive = false;
            }
        }
        return result;
    }

    public void resolve(Chain chain, int target) {
        boolean changed = false;
        State newState = this.state;
        while (chain != null) {
            Assert.check(this.state != chain.state && (target > chain.pc || this.isStatementStart()));
            if (target >= this.cp) {
                target = this.cp;
            } else if (this.get1(target) == 167) {
                target = this.fatcode ? (target += this.get4(target + 1)) : (target += this.get2(target + 1));
            }
            if (this.get1(chain.pc) == 167 && chain.pc + 3 == target && target == this.cp && !this.fixedPc) {
                if (this.varDebugInfo) {
                    this.adjustAliveRanges(this.cp, -3);
                }
                this.cp -= 3;
                target -= 3;
                if (chain.next == null) {
                    this.alive = true;
                    break;
                }
            } else {
                if (this.fatcode) {
                    this.put4(chain.pc + 1, target - chain.pc);
                } else if (target - chain.pc < Short.MIN_VALUE || target - chain.pc > Short.MAX_VALUE) {
                    this.fatcode = true;
                } else {
                    this.put2(chain.pc + 1, target - chain.pc);
                }
                Assert.check(!this.alive || chain.state.stacksize == newState.stacksize && chain.state.nlocks == newState.nlocks);
            }
            this.fixedPc = true;
            if (this.cp == target) {
                changed = true;
                if (this.debugCode) {
                    System.err.println("resolving chain state=" + chain.state);
                }
                if (this.alive) {
                    newState = chain.state.join(newState);
                } else {
                    newState = chain.state;
                    this.alive = true;
                }
            }
            chain = chain.next;
        }
        Assert.check(!changed || this.state != newState);
        if (this.state != newState) {
            this.setDefined(newState.defined);
            this.state = newState;
            this.pendingStackMap = this.needStackMap;
        }
    }

    public void resolve(Chain chain) {
        Assert.check(!this.alive || chain == null || this.state.stacksize == chain.state.stacksize && this.state.nlocks == chain.state.nlocks);
        this.pendingJumps = Code.mergeChains(chain, this.pendingJumps);
    }

    public void resolvePending() {
        Chain x = this.pendingJumps;
        this.pendingJumps = null;
        this.resolve(x, this.cp);
    }

    public static Chain mergeChains(Chain chain1, Chain chain2) {
        if (chain2 == null) {
            return chain1;
        }
        if (chain1 == null) {
            return chain2;
        }
        Assert.check(chain1.state.stacksize == chain2.state.stacksize && chain1.state.nlocks == chain2.state.nlocks);
        if (chain1.pc < chain2.pc) {
            return new Chain(chain2.pc, Code.mergeChains(chain1, chain2.next), chain2.state);
        }
        return new Chain(chain1.pc, Code.mergeChains(chain1.next, chain2), chain1.state);
    }

    public void addCatch(char startPc, char endPc, char handlerPc, char catchType) {
        this.catchInfo.append(new char[]{startPc, endPc, handlerPc, catchType});
    }

    public void compressCatchTable() {
        ListBuffer<char[]> compressedCatchInfo = new ListBuffer<char[]>();
        List<Object> handlerPcs = List.nil();
        for (char[] catchEntry : this.catchInfo) {
            handlerPcs = handlerPcs.prepend(Integer.valueOf(catchEntry[2]));
        }
        for (char[] catchEntry : this.catchInfo) {
            char endpc;
            char startpc = catchEntry[0];
            if (startpc == (endpc = catchEntry[1]) || startpc == endpc - '\u0001' && handlerPcs.contains(startpc)) continue;
            compressedCatchInfo.append(catchEntry);
        }
        this.catchInfo = compressedCatchInfo;
    }

    public void addLineNumber(char startPc, char lineNumber) {
        if (this.lineDebugInfo) {
            if (this.lineInfo.nonEmpty() && ((char[])this.lineInfo.head)[0] == startPc) {
                this.lineInfo = this.lineInfo.tail;
            }
            if (this.lineInfo.isEmpty() || ((char[])this.lineInfo.head)[1] != lineNumber) {
                this.lineInfo = this.lineInfo.prepend(new char[]{startPc, lineNumber});
            }
        }
    }

    public void statBegin(int pos) {
        if (pos != -1) {
            this.pendingStatPos = pos;
        }
    }

    public void markStatBegin() {
        if (this.alive && this.lineDebugInfo) {
            int line = this.lineMap.getLineNumber(this.pendingStatPos);
            char cp1 = (char)this.cp;
            char line1 = (char)line;
            if (cp1 == this.cp && line1 == line) {
                this.addLineNumber(cp1, line1);
            }
        }
        this.pendingStatPos = -1;
    }

    private void addLocalVar(Symbol.VarSymbol v) {
        int adr = v.adr;
        this.lvar = ArrayUtils.ensureCapacity(this.lvar, adr + 1);
        Assert.checkNull(this.lvar[adr]);
        if (this.pendingJumps != null) {
            this.resolvePending();
        }
        this.lvar[adr] = new LocalVar(v);
        this.state.defined.excl(adr);
    }

    void adjustAliveRanges(int oldCP, int delta) {
        for (LocalVar localVar : this.lvar) {
            if (localVar == null) continue;
            for (LocalVar.Range range : localVar.aliveRanges) {
                if (!range.closed() || range.start_pc + range.length < oldCP) continue;
                range.length = (char)(range.length + (char)delta);
            }
        }
    }

    public int getLVTSize() {
        int result = this.varBufferSize;
        for (int i = 0; i < this.varBufferSize; ++i) {
            LocalVar var = this.varBuffer[i];
            result += var.aliveRanges.size() - 1;
        }
        return result;
    }

    public void setDefined(Bits newDefined) {
        if (this.alive && newDefined != this.state.defined) {
            Bits diff = new Bits(this.state.defined).xorSet(newDefined);
            int adr = diff.nextBit(0);
            while (adr >= 0) {
                if (adr >= this.nextreg) {
                    this.state.defined.excl(adr);
                } else if (this.state.defined.isMember(adr)) {
                    this.setUndefined(adr);
                } else {
                    this.setDefined(adr);
                }
                adr = diff.nextBit(adr + 1);
            }
        }
    }

    public void setDefined(int adr) {
        LocalVar v = this.lvar[adr];
        if (v == null) {
            this.state.defined.excl(adr);
        } else {
            this.state.defined.incl(adr);
            if (this.cp < 65535) {
                v.openRange((char)this.cp);
            }
        }
    }

    public void setUndefined(int adr) {
        this.state.defined.excl(adr);
        if (adr < this.lvar.length && this.lvar[adr] != null && this.lvar[adr].isLastRangeInitialized()) {
            LocalVar v = this.lvar[adr];
            char length = (char)(this.curCP() - v.lastRange().start_pc);
            if (length < '\uffff') {
                this.lvar[adr] = v.dup();
                v.closeRange(length);
                this.putVar(v);
                this.fillLocalVarPosition(v);
            } else {
                v.removeLastRange();
            }
        }
    }

    private void endScope(int adr) {
        LocalVar v = this.lvar[adr];
        if (v != null) {
            char length;
            if (v.isLastRangeInitialized() && (length = (char)(this.curCP() - v.lastRange().start_pc)) < '\uffff') {
                v.closeRange(length);
                this.putVar(v);
                this.fillLocalVarPosition(v);
            }
            this.lvar[adr] = null;
        }
        this.state.defined.excl(adr);
    }

    private void fillLocalVarPosition(LocalVar lv) {
        if (lv == null || lv.sym == null || lv.sym.isExceptionParameter() || !lv.sym.hasTypeAnnotations()) {
            return;
        }
        LocalVar.Range[] validRanges = (LocalVar.Range[])lv.aliveRanges.stream().filter(r -> r.closed() && r.length > '\u0000').toArray(LocalVar.Range[]::new);
        if (validRanges.length == 0) {
            return;
        }
        int[] lvarOffset = Arrays.stream(validRanges).mapToInt(r -> r.start_pc).toArray();
        int[] lvarLength = Arrays.stream(validRanges).mapToInt(r -> r.length).toArray();
        int[] lvarIndex = Arrays.stream(validRanges).mapToInt(r -> lv.reg).toArray();
        for (Attribute.TypeCompound ta : lv.sym.getRawTypeAttributes()) {
            TypeAnnotationPosition p = ta.position;
            p.lvarOffset = this.appendArray(p.lvarOffset, lvarOffset);
            p.lvarLength = this.appendArray(p.lvarLength, lvarLength);
            p.lvarIndex = this.appendArray(p.lvarIndex, lvarIndex);
            p.isValidOffset = true;
        }
    }

    private int[] appendArray(int[] source, int[] append) {
        if (source == null || source.length == 0) {
            return append;
        }
        int[] result = new int[source.length + append.length];
        System.arraycopy(source, 0, result, 0, source.length);
        System.arraycopy(append, 0, result, source.length, append.length);
        return result;
    }

    public void fillExceptionParameterPositions() {
        for (int i = 0; i < this.varBufferSize; ++i) {
            LocalVar lv = this.varBuffer[i];
            if (lv == null || lv.sym == null || !lv.sym.hasTypeAnnotations() || !lv.sym.isExceptionParameter()) continue;
            for (Attribute.TypeCompound ta : lv.sym.getRawTypeAttributes()) {
                TypeAnnotationPosition p = ta.position;
                if (!p.hasCatchType()) continue;
                int idx = this.findExceptionIndex(p);
                if (idx == -1) {
                    Assert.error("Could not find exception index for type annotation " + ta + " on exception parameter");
                }
                p.setExceptionIndex(idx);
            }
        }
    }

    private int findExceptionIndex(TypeAnnotationPosition p) {
        int catchType = p.getCatchType();
        int startPos = p.getStartPos();
        int len = this.catchInfo.length();
        List<Object> iter = this.catchInfo.toList();
        for (int i = 0; i < len; ++i) {
            char[] catchEntry = (char[])iter.head;
            iter = iter.tail;
            char ct = catchEntry[3];
            char sp = catchEntry[0];
            if (catchType != ct || sp != startPos) continue;
            return i;
        }
        return -1;
    }

    void putVar(LocalVar var) {
        boolean ignoredSyntheticVar;
        boolean keepLocalVariables;
        boolean bl = keepLocalVariables = this.varDebugInfo || var.sym.isExceptionParameter() && var.sym.hasTypeAnnotations();
        if (!keepLocalVariables) {
            return;
        }
        boolean bl2 = ignoredSyntheticVar = (var.sym.flags() & 0x1000L) != 0L && ((var.sym.owner.flags() & 0x2000000000000L) == 0L || (var.sym.flags() & 0x200000000L) == 0L);
        if (ignoredSyntheticVar) {
            return;
        }
        this.varBuffer = this.varBuffer == null ? new LocalVar[20] : ArrayUtils.ensureCapacity(this.varBuffer, this.varBufferSize);
        this.varBuffer[this.varBufferSize++] = var;
    }

    private int newLocal(int typecode) {
        int reg = this.nextreg;
        int w = Code.width(typecode);
        this.nextreg = reg + w;
        if (this.nextreg > this.max_locals) {
            this.max_locals = this.nextreg;
        }
        return reg;
    }

    private int newLocal(Type type) {
        return this.newLocal(Code.typecode(type));
    }

    public int newLocal(Symbol.VarSymbol v) {
        int reg = v.adr = this.newLocal(v.erasure(this.types));
        this.addLocalVar(v);
        return reg;
    }

    public void newRegSegment() {
        this.nextreg = this.max_locals;
    }

    public void endScopes(int first) {
        int prevNextReg = this.nextreg;
        for (int i = this.nextreg = first; i < prevNextReg; ++i) {
            this.endScope(i);
        }
    }

    public static String mnem(int opcode) {
        return Mneumonics.mnem[opcode];
    }

    public static class Chain {
        public final int pc;
        State state;
        public final Chain next;

        public Chain(int pc, Chain next, State state) {
            this.pc = pc;
            this.next = next;
            this.state = state;
        }
    }

    static class StackMapFrame {
        int pc;
        Type[] locals;
        Type[] stack;

        StackMapFrame() {
        }
    }

    public static enum StackMapFormat {
        NONE,
        CLDC{

            @Override
            Name getAttributeName(Names names) {
                return names.StackMap;
            }
        }
        ,
        JSR202{

            @Override
            Name getAttributeName(Names names) {
                return names.StackMapTable;
            }
        };


        Name getAttributeName(Names names) {
            return names.empty;
        }
    }

    class State
    implements Cloneable {
        Bits defined = new Bits();
        Type[] stack = new Type[16];
        int stacksize;
        int[] locks;
        int nlocks;

        State() {
        }

        State dup() {
            try {
                State state = (State)super.clone();
                state.defined = new Bits(this.defined);
                state.stack = (Type[])this.stack.clone();
                if (this.locks != null) {
                    state.locks = (int[])this.locks.clone();
                }
                if (Code.this.debugCode) {
                    System.err.println("duping state " + this);
                    this.dump();
                }
                return state;
            }
            catch (CloneNotSupportedException ex) {
                throw new AssertionError((Object)ex);
            }
        }

        void lock(int register) {
            this.locks = this.locks == null ? new int[20] : ArrayUtils.ensureCapacity(this.locks, this.nlocks);
            this.locks[this.nlocks] = register;
            ++this.nlocks;
        }

        void unlock(int register) {
            --this.nlocks;
            Assert.check(this.locks[this.nlocks] == register);
            this.locks[this.nlocks] = -1;
        }

        void push(Type t) {
            if (Code.this.debugCode) {
                System.err.println("   pushing " + t);
            }
            switch (t.getTag()) {
                case VOID: {
                    return;
                }
                case BYTE: 
                case SHORT: 
                case CHAR: 
                case BOOLEAN: {
                    t = Code.this.syms.intType;
                    break;
                }
            }
            this.stack = ArrayUtils.ensureCapacity(this.stack, this.stacksize + 2);
            this.stack[this.stacksize++] = t;
            switch (Code.width(t)) {
                case 1: {
                    break;
                }
                case 2: {
                    this.stack[this.stacksize++] = null;
                    break;
                }
                default: {
                    throw new AssertionError(t);
                }
            }
            if (this.stacksize > Code.this.max_stack) {
                Code.this.max_stack = this.stacksize;
            }
        }

        Type pop1() {
            if (Code.this.debugCode) {
                System.err.println("   popping 1");
            }
            --this.stacksize;
            Type result = this.stack[this.stacksize];
            this.stack[this.stacksize] = null;
            Assert.check(result != null && Code.width(result) == 1);
            return result;
        }

        Type peek() {
            return this.stack[this.stacksize - 1];
        }

        Type pop2() {
            if (Code.this.debugCode) {
                System.err.println("   popping 2");
            }
            this.stacksize -= 2;
            Type result = this.stack[this.stacksize];
            this.stack[this.stacksize] = null;
            Assert.check(this.stack[this.stacksize + 1] == null && result != null && Code.width(result) == 2);
            return result;
        }

        void pop(int n) {
            if (Code.this.debugCode) {
                System.err.println("   popping " + n);
            }
            while (n > 0) {
                this.stack[--this.stacksize] = null;
                --n;
            }
        }

        void pop(Type t) {
            this.pop(Code.width(t));
        }

        void forceStackTop(Type t) {
            if (!Code.this.alive) {
                return;
            }
            switch (t.getTag()) {
                case CLASS: 
                case ARRAY: {
                    int width = Code.width(t);
                    Type old = this.stack[this.stacksize - width];
                    Assert.check(Code.this.types.isSubtype(Code.this.types.erasure(old), Code.this.types.erasure(t)));
                    this.stack[this.stacksize - width] = t;
                    break;
                }
            }
        }

        void markInitialized(UninitializedType old) {
            int i;
            Type newtype = old.initializedType();
            for (i = 0; i < this.stacksize; ++i) {
                if (this.stack[i] != old) continue;
                this.stack[i] = newtype;
            }
            for (i = 0; i < Code.this.lvar.length; ++i) {
                LocalVar lv = Code.this.lvar[i];
                if (lv == null || lv.sym.type != old) continue;
                Symbol.VarSymbol sym = lv.sym;
                sym = sym.clone(sym.owner);
                sym.type = newtype;
                LocalVar newlv = Code.this.lvar[i] = new LocalVar(sym);
                newlv.aliveRanges = lv.aliveRanges;
            }
        }

        State join(State other) {
            int w;
            this.defined.andSet(other.defined);
            Assert.check(this.stacksize == other.stacksize && this.nlocks == other.nlocks);
            for (int i = 0; i < this.stacksize; i += w) {
                Type t = this.stack[i];
                Type tother = other.stack[i];
                Type result = t == tother ? t : (Code.this.types.isSubtype(t, tother) ? tother : (Code.this.types.isSubtype(tother, t) ? t : this.error()));
                w = Code.width(result);
                this.stack[i] = result;
                if (w != 2) continue;
                Assert.checkNull(this.stack[i + 1]);
            }
            return this;
        }

        Type error() {
            throw new AssertionError((Object)"inconsistent stack types at join point");
        }

        void dump() {
            this.dump(-1);
        }

        void dump(int pc) {
            int i;
            System.err.print("stackMap for " + Code.this.meth.owner + "." + Code.this.meth);
            if (pc == -1) {
                System.out.println();
            } else {
                System.out.println(" at " + pc);
            }
            System.err.println(" stack (from bottom):");
            for (int i2 = 0; i2 < this.stacksize; ++i2) {
                System.err.println("  " + i2 + ": " + this.stack[i2]);
            }
            int lastLocal = 0;
            for (i = Code.this.max_locals - 1; i >= 0; --i) {
                if (!this.defined.isMember(i)) continue;
                lastLocal = i;
                break;
            }
            if (lastLocal >= 0) {
                System.err.println(" locals:");
            }
            for (i = 0; i <= lastLocal; ++i) {
                System.err.print("  " + i + ": ");
                if (this.defined.isMember(i)) {
                    LocalVar var = Code.this.lvar[i];
                    if (var == null) {
                        System.err.println("(none)");
                        continue;
                    }
                    if (var.sym == null) {
                        System.err.println("UNKNOWN!");
                        continue;
                    }
                    System.err.println("" + var.sym + " of type " + var.sym.erasure(Code.this.types));
                    continue;
                }
                System.err.println("undefined");
            }
            if (this.nlocks != 0) {
                System.err.print(" locks:");
                for (i = 0; i < this.nlocks; ++i) {
                    System.err.print(" " + this.locks[i]);
                }
                System.err.println();
            }
        }
    }

    static class LocalVar {
        final Symbol.VarSymbol sym;
        final char reg;
        java.util.List<Range> aliveRanges = new ArrayList<Range>();

        LocalVar(Symbol.VarSymbol v) {
            this.sym = v;
            this.reg = (char)v.adr;
        }

        public LocalVar dup() {
            return new LocalVar(this.sym);
        }

        Range firstRange() {
            return this.aliveRanges.isEmpty() ? null : this.aliveRanges.get(0);
        }

        Range lastRange() {
            return this.aliveRanges.isEmpty() ? null : this.aliveRanges.get(this.aliveRanges.size() - 1);
        }

        void removeLastRange() {
            Range lastRange = this.lastRange();
            if (lastRange != null) {
                this.aliveRanges.remove(lastRange);
            }
        }

        public String toString() {
            if (this.aliveRanges == null) {
                return "empty local var";
            }
            StringBuilder sb = new StringBuilder().append(this.sym).append(" in register ").append((int)this.reg).append(" \n");
            for (Range r : this.aliveRanges) {
                sb.append(" starts at pc=").append(Integer.toString(r.start_pc)).append(" length=").append(Integer.toString(r.length)).append("\n");
            }
            return sb.toString();
        }

        public void openRange(char start) {
            if (!this.hasOpenRange()) {
                this.aliveRanges.add(new Range(start));
            }
        }

        public void closeRange(char length) {
            if (this.isLastRangeInitialized() && length > '\u0000') {
                Range range = this.lastRange();
                if (range != null && range.length == '\uffff') {
                    range.length = length;
                }
            } else {
                this.removeLastRange();
            }
        }

        public boolean hasOpenRange() {
            if (this.aliveRanges.isEmpty()) {
                return false;
            }
            return this.lastRange().length == '\uffff';
        }

        public boolean isLastRangeInitialized() {
            if (this.aliveRanges.isEmpty()) {
                return false;
            }
            return this.lastRange().start_pc != '\uffff';
        }

        public Range getWidestRange() {
            if (this.aliveRanges.isEmpty()) {
                return new Range();
            }
            Range firstRange = this.firstRange();
            Range lastRange = this.lastRange();
            char length = (char)(lastRange.length + (lastRange.start_pc - firstRange.start_pc));
            return new Range(firstRange.start_pc, length);
        }

        class Range {
            char start_pc = (char)65535;
            char length = (char)65535;

            Range() {
            }

            Range(char start) {
                this.start_pc = start;
            }

            Range(char start, char length) {
                this.start_pc = start;
                this.length = length;
            }

            boolean closed() {
                return this.start_pc != '\uffff' && this.length != '\uffff';
            }

            public String toString() {
                char currentStartPC = this.start_pc;
                char currentLength = this.length;
                return "startpc = " + currentStartPC + " length " + currentLength;
            }
        }
    }

    private static class Mneumonics {
        private static final String[] mnem = new String[203];

        private Mneumonics() {
        }

        static {
            Mneumonics.mnem[0] = "nop";
            Mneumonics.mnem[1] = "aconst_null";
            Mneumonics.mnem[2] = "iconst_m1";
            Mneumonics.mnem[3] = "iconst_0";
            Mneumonics.mnem[4] = "iconst_1";
            Mneumonics.mnem[5] = "iconst_2";
            Mneumonics.mnem[6] = "iconst_3";
            Mneumonics.mnem[7] = "iconst_4";
            Mneumonics.mnem[8] = "iconst_5";
            Mneumonics.mnem[9] = "lconst_0";
            Mneumonics.mnem[10] = "lconst_1";
            Mneumonics.mnem[11] = "fconst_0";
            Mneumonics.mnem[12] = "fconst_1";
            Mneumonics.mnem[13] = "fconst_2";
            Mneumonics.mnem[14] = "dconst_0";
            Mneumonics.mnem[15] = "dconst_1";
            Mneumonics.mnem[16] = "bipush";
            Mneumonics.mnem[17] = "sipush";
            Mneumonics.mnem[18] = "ldc1";
            Mneumonics.mnem[19] = "ldc2";
            Mneumonics.mnem[20] = "ldc2w";
            Mneumonics.mnem[21] = "iload";
            Mneumonics.mnem[22] = "lload";
            Mneumonics.mnem[23] = "fload";
            Mneumonics.mnem[24] = "dload";
            Mneumonics.mnem[25] = "aload";
            Mneumonics.mnem[26] = "iload_0";
            Mneumonics.mnem[30] = "lload_0";
            Mneumonics.mnem[34] = "fload_0";
            Mneumonics.mnem[38] = "dload_0";
            Mneumonics.mnem[42] = "aload_0";
            Mneumonics.mnem[27] = "iload_1";
            Mneumonics.mnem[31] = "lload_1";
            Mneumonics.mnem[35] = "fload_1";
            Mneumonics.mnem[39] = "dload_1";
            Mneumonics.mnem[43] = "aload_1";
            Mneumonics.mnem[28] = "iload_2";
            Mneumonics.mnem[32] = "lload_2";
            Mneumonics.mnem[36] = "fload_2";
            Mneumonics.mnem[40] = "dload_2";
            Mneumonics.mnem[44] = "aload_2";
            Mneumonics.mnem[29] = "iload_3";
            Mneumonics.mnem[33] = "lload_3";
            Mneumonics.mnem[37] = "fload_3";
            Mneumonics.mnem[41] = "dload_3";
            Mneumonics.mnem[45] = "aload_3";
            Mneumonics.mnem[46] = "iaload";
            Mneumonics.mnem[47] = "laload";
            Mneumonics.mnem[48] = "faload";
            Mneumonics.mnem[49] = "daload";
            Mneumonics.mnem[50] = "aaload";
            Mneumonics.mnem[51] = "baload";
            Mneumonics.mnem[52] = "caload";
            Mneumonics.mnem[53] = "saload";
            Mneumonics.mnem[54] = "istore";
            Mneumonics.mnem[55] = "lstore";
            Mneumonics.mnem[56] = "fstore";
            Mneumonics.mnem[57] = "dstore";
            Mneumonics.mnem[58] = "astore";
            Mneumonics.mnem[59] = "istore_0";
            Mneumonics.mnem[63] = "lstore_0";
            Mneumonics.mnem[67] = "fstore_0";
            Mneumonics.mnem[71] = "dstore_0";
            Mneumonics.mnem[75] = "astore_0";
            Mneumonics.mnem[60] = "istore_1";
            Mneumonics.mnem[64] = "lstore_1";
            Mneumonics.mnem[68] = "fstore_1";
            Mneumonics.mnem[72] = "dstore_1";
            Mneumonics.mnem[76] = "astore_1";
            Mneumonics.mnem[61] = "istore_2";
            Mneumonics.mnem[65] = "lstore_2";
            Mneumonics.mnem[69] = "fstore_2";
            Mneumonics.mnem[73] = "dstore_2";
            Mneumonics.mnem[77] = "astore_2";
            Mneumonics.mnem[62] = "istore_3";
            Mneumonics.mnem[66] = "lstore_3";
            Mneumonics.mnem[70] = "fstore_3";
            Mneumonics.mnem[74] = "dstore_3";
            Mneumonics.mnem[78] = "astore_3";
            Mneumonics.mnem[79] = "iastore";
            Mneumonics.mnem[80] = "lastore";
            Mneumonics.mnem[81] = "fastore";
            Mneumonics.mnem[82] = "dastore";
            Mneumonics.mnem[83] = "aastore";
            Mneumonics.mnem[84] = "bastore";
            Mneumonics.mnem[85] = "castore";
            Mneumonics.mnem[86] = "sastore";
            Mneumonics.mnem[87] = "pop";
            Mneumonics.mnem[88] = "pop2";
            Mneumonics.mnem[89] = "dup";
            Mneumonics.mnem[90] = "dup_x1";
            Mneumonics.mnem[91] = "dup_x2";
            Mneumonics.mnem[92] = "dup2";
            Mneumonics.mnem[93] = "dup2_x1";
            Mneumonics.mnem[94] = "dup2_x2";
            Mneumonics.mnem[95] = "swap";
            Mneumonics.mnem[96] = "iadd";
            Mneumonics.mnem[97] = "ladd";
            Mneumonics.mnem[98] = "fadd";
            Mneumonics.mnem[99] = "dadd";
            Mneumonics.mnem[100] = "isub";
            Mneumonics.mnem[101] = "lsub";
            Mneumonics.mnem[102] = "fsub";
            Mneumonics.mnem[103] = "dsub";
            Mneumonics.mnem[104] = "imul";
            Mneumonics.mnem[105] = "lmul";
            Mneumonics.mnem[106] = "fmul";
            Mneumonics.mnem[107] = "dmul";
            Mneumonics.mnem[108] = "idiv";
            Mneumonics.mnem[109] = "ldiv";
            Mneumonics.mnem[110] = "fdiv";
            Mneumonics.mnem[111] = "ddiv";
            Mneumonics.mnem[112] = "imod";
            Mneumonics.mnem[113] = "lmod";
            Mneumonics.mnem[114] = "fmod";
            Mneumonics.mnem[115] = "dmod";
            Mneumonics.mnem[116] = "ineg";
            Mneumonics.mnem[117] = "lneg";
            Mneumonics.mnem[118] = "fneg";
            Mneumonics.mnem[119] = "dneg";
            Mneumonics.mnem[120] = "ishl";
            Mneumonics.mnem[121] = "lshl";
            Mneumonics.mnem[122] = "ishr";
            Mneumonics.mnem[123] = "lshr";
            Mneumonics.mnem[124] = "iushr";
            Mneumonics.mnem[125] = "lushr";
            Mneumonics.mnem[126] = "iand";
            Mneumonics.mnem[127] = "land";
            Mneumonics.mnem[128] = "ior";
            Mneumonics.mnem[129] = "lor";
            Mneumonics.mnem[130] = "ixor";
            Mneumonics.mnem[131] = "lxor";
            Mneumonics.mnem[132] = "iinc";
            Mneumonics.mnem[133] = "i2l";
            Mneumonics.mnem[134] = "i2f";
            Mneumonics.mnem[135] = "i2d";
            Mneumonics.mnem[136] = "l2i";
            Mneumonics.mnem[137] = "l2f";
            Mneumonics.mnem[138] = "l2d";
            Mneumonics.mnem[139] = "f2i";
            Mneumonics.mnem[140] = "f2l";
            Mneumonics.mnem[141] = "f2d";
            Mneumonics.mnem[142] = "d2i";
            Mneumonics.mnem[143] = "d2l";
            Mneumonics.mnem[144] = "d2f";
            Mneumonics.mnem[145] = "int2byte";
            Mneumonics.mnem[146] = "int2char";
            Mneumonics.mnem[147] = "int2short";
            Mneumonics.mnem[148] = "lcmp";
            Mneumonics.mnem[149] = "fcmpl";
            Mneumonics.mnem[150] = "fcmpg";
            Mneumonics.mnem[151] = "dcmpl";
            Mneumonics.mnem[152] = "dcmpg";
            Mneumonics.mnem[153] = "ifeq";
            Mneumonics.mnem[154] = "ifne";
            Mneumonics.mnem[155] = "iflt";
            Mneumonics.mnem[156] = "ifge";
            Mneumonics.mnem[157] = "ifgt";
            Mneumonics.mnem[158] = "ifle";
            Mneumonics.mnem[159] = "if_icmpeq";
            Mneumonics.mnem[160] = "if_icmpne";
            Mneumonics.mnem[161] = "if_icmplt";
            Mneumonics.mnem[162] = "if_icmpge";
            Mneumonics.mnem[163] = "if_icmpgt";
            Mneumonics.mnem[164] = "if_icmple";
            Mneumonics.mnem[165] = "if_acmpeq";
            Mneumonics.mnem[166] = "if_acmpne";
            Mneumonics.mnem[167] = "goto_";
            Mneumonics.mnem[168] = "jsr";
            Mneumonics.mnem[169] = "ret";
            Mneumonics.mnem[170] = "tableswitch";
            Mneumonics.mnem[171] = "lookupswitch";
            Mneumonics.mnem[172] = "ireturn";
            Mneumonics.mnem[173] = "lreturn";
            Mneumonics.mnem[174] = "freturn";
            Mneumonics.mnem[175] = "dreturn";
            Mneumonics.mnem[176] = "areturn";
            Mneumonics.mnem[177] = "return_";
            Mneumonics.mnem[178] = "getstatic";
            Mneumonics.mnem[179] = "putstatic";
            Mneumonics.mnem[180] = "getfield";
            Mneumonics.mnem[181] = "putfield";
            Mneumonics.mnem[182] = "invokevirtual";
            Mneumonics.mnem[183] = "invokespecial";
            Mneumonics.mnem[184] = "invokestatic";
            Mneumonics.mnem[185] = "invokeinterface";
            Mneumonics.mnem[186] = "invokedynamic";
            Mneumonics.mnem[187] = "new_";
            Mneumonics.mnem[188] = "newarray";
            Mneumonics.mnem[189] = "anewarray";
            Mneumonics.mnem[190] = "arraylength";
            Mneumonics.mnem[191] = "athrow";
            Mneumonics.mnem[192] = "checkcast";
            Mneumonics.mnem[193] = "instanceof_";
            Mneumonics.mnem[194] = "monitorenter";
            Mneumonics.mnem[195] = "monitorexit";
            Mneumonics.mnem[196] = "wide";
            Mneumonics.mnem[197] = "multianewarray";
            Mneumonics.mnem[198] = "if_acmp_null";
            Mneumonics.mnem[199] = "if_acmp_nonnull";
            Mneumonics.mnem[200] = "goto_w";
            Mneumonics.mnem[201] = "jsr_w";
            Mneumonics.mnem[202] = "breakpoint";
        }
    }
}

