/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ClassSource {
    private final String className;
    private final String typeParameters;
    private final Collection<? extends Entry> entries;

    public ClassSource(String className, Entry ... entries) {
        this(className, Arrays.asList(entries));
    }

    public ClassSource(String className, Collection<? extends Entry> entries) {
        this(className, entries, null);
    }

    public ClassSource(String className, Collection<? extends Entry> entries, String typeParameters) {
        if (entries.contains(null)) {
            throw new IllegalArgumentException("entries contains null entry: " + entries);
        }
        this.className = className;
        this.entries = entries;
        this.typeParameters = typeParameters;
    }

    public String getClassName() {
        return this.className;
    }

    public String getTypeParameters() {
        return this.typeParameters;
    }

    public Collection<? extends Entry> getEntries() {
        return this.entries;
    }

    public boolean hasEntries() {
        return !this.entries.isEmpty();
    }

    public List<URL> getClasspath() {
        ArrayList<URL> cp = new ArrayList<URL>();
        for (Entry entry : this.entries) {
            cp.addAll(entry.getClasspath());
        }
        for (URL uRL : cp) {
            assert (uRL.toExternalForm().endsWith("/")) : uRL;
        }
        return cp;
    }

    public boolean addToProjectClassPath(FileObject projectArtifact, String classPathType) throws IOException, UnsupportedOperationException {
        for (Entry entry : this.entries) {
            if (entry.addToProjectClassPath(projectArtifact, classPathType).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static Entry unpickle(String type, String name) {
        Resolver resolver = (Resolver)Lookup.getDefault().lookup(Resolver.class);
        return resolver != null ? resolver.resolve(type, name) : null;
    }

    public static interface Resolver {
        public Entry resolve(String var1, String var2);
    }

    public static abstract class Entry {
        public abstract List<URL> getClasspath();

        public abstract Boolean addToProjectClassPath(FileObject var1, String var2) throws IOException, UnsupportedOperationException;

        public abstract String getDisplayName();

        public abstract String getPicklingType();

        public abstract String getPicklingName();

        public final int hashCode() {
            return this.getClasspath().hashCode();
        }

        public final boolean equals(Object obj) {
            return obj instanceof Entry && this.getClasspath().equals(((Entry)obj).getClasspath());
        }

        public final String toString() {
            return super.toString() + this.getClasspath();
        }
    }
}

