/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetStandardTagTemplateRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String standardTagNamespaceName;

    @ConstructorProperties(value={"compartmentId", "standardTagNamespaceName"})
    GetStandardTagTemplateRequest(String compartmentId, String standardTagNamespaceName) {
        this.compartmentId = compartmentId;
        this.standardTagNamespaceName = standardTagNamespaceName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).standardTagNamespaceName(this.standardTagNamespaceName);
    }

    public String toString() {
        return "GetStandardTagTemplateRequest(super=" + super.toString() + ", compartmentId=" + this.getCompartmentId() + ", standardTagNamespaceName=" + this.getStandardTagNamespaceName() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetStandardTagTemplateRequest)) {
            return false;
        }
        GetStandardTagTemplateRequest other = (GetStandardTagTemplateRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        String this$standardTagNamespaceName = this.getStandardTagNamespaceName();
        String other$standardTagNamespaceName = other.getStandardTagNamespaceName();
        return !(this$standardTagNamespaceName == null ? other$standardTagNamespaceName != null : !this$standardTagNamespaceName.equals(other$standardTagNamespaceName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetStandardTagTemplateRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        String $standardTagNamespaceName = this.getStandardTagNamespaceName();
        result = result * 59 + ($standardTagNamespaceName == null ? 43 : $standardTagNamespaceName.hashCode());
        return result;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getStandardTagNamespaceName() {
        return this.standardTagNamespaceName;
    }

    public static class Builder
    implements BmcRequest.Builder<GetStandardTagTemplateRequest, Void> {
        private String compartmentId;
        private String standardTagNamespaceName;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetStandardTagTemplateRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.standardTagNamespaceName(o.getStandardTagNamespaceName());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetStandardTagTemplateRequest build() {
            GetStandardTagTemplateRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder standardTagNamespaceName(String standardTagNamespaceName) {
            this.standardTagNamespaceName = standardTagNamespaceName;
            return this;
        }

        public GetStandardTagTemplateRequest buildWithoutInvocationCallback() {
            return new GetStandardTagTemplateRequest(this.compartmentId, this.standardTagNamespaceName);
        }

        public String toString() {
            return "GetStandardTagTemplateRequest.Builder(compartmentId=" + this.compartmentId + ", standardTagNamespaceName=" + this.standardTagNamespaceName + ")";
        }
    }
}

