/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.j2ee.clientproject.AppClientProject;
import org.netbeans.modules.j2ee.clientproject.ui.customizer.AppClientProjectProperties;
import org.netbeans.modules.j2ee.dd.api.client.AppClientMetadata;
import org.netbeans.modules.j2ee.dd.api.webservices.WebservicesMetadata;
import org.netbeans.modules.j2ee.dd.spi.MetadataUnit;
import org.netbeans.modules.j2ee.dd.spi.client.AppClientMetadataModelFactory;
import org.netbeans.modules.j2ee.dd.spi.webservices.WebservicesMetadataModelFactory;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ResourceChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation2;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.ResourceChangeReporterImplementation;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.java.api.common.classpath.ClassPathProviderImpl;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class AppClientProvider
extends J2eeModuleProvider
implements J2eeModuleImplementation2,
ModuleChangeReporter,
EjbChangeDescriptor,
PropertyChangeListener {
    public static final String FILE_DD = "application-client.xml";
    static boolean showMetaInfDialog = true;
    private final ResourceChangeReporter rcr = ResourceChangeReporterFactory.createResourceChangeReporter((ResourceChangeReporterImplementation)new AppClientResourceChangeReporter());
    private final AppClientProject project;
    private final AntProjectHelper helper;
    private final ClassPathProviderImpl cpProvider;
    private MetadataModel<AppClientMetadata> appClientMetadataModel;
    private MetadataModel<WebservicesMetadata> webservicesMetadataModel;
    private PropertyChangeSupport propertyChangeSupport;
    private J2eeModule j2eeModule;
    private long notificationTimeout = 0L;

    AppClientProvider(AppClientProject project, AntProjectHelper helper, ClassPathProviderImpl cpProvider) {
        this.project = project;
        this.helper = helper;
        this.cpProvider = cpProvider;
    }

    public FileObject getDeploymentDescriptor() {
        FileObject metaInfFo = this.getMetaInf();
        if (metaInfFo == null) {
            return null;
        }
        return metaInfFo.getFileObject(FILE_DD);
    }

    public FileObject[] getJavaSources() {
        return this.project.getSourceRoots().getRoots();
    }

    public FileObject getMetaInf() {
        FileObject metaInf = this.getFileObject("meta.inf");
        if (metaInf == null) {
            Profile version = this.project.getAPICar().getJ2eeProfile();
            if (showMetaInfDialog && AppClientProvider.needConfigurationFolder(version)) {
                String relativePath = this.helper.getStandardPropertyEvaluator().getProperty("meta.inf");
                String path = relativePath != null ? this.helper.resolvePath(relativePath) : "";
                this.showErrorMessage(NbBundle.getMessage(AppClientProvider.class, (String)"MSG_MetaInfCorrupted", (Object)this.project.getName(), (Object)path));
            }
        }
        return metaInf;
    }

    static boolean needConfigurationFolder(Profile version) {
        return Profile.J2EE_13.equals(version) || Profile.J2EE_14.equals(version);
    }

    public File getMetaInfAsFile() {
        return this.getFile("meta.inf");
    }

    public File getResourceDirectory() {
        return this.getFile("resource.dir");
    }

    public File getDeploymentConfigurationFile(String name) {
        String path = this.getConfigSupport().getContentRelativePath(name);
        if (path == null) {
            path = name;
        }
        if (path.startsWith("META-INF/")) {
            path = path.substring(8);
        }
        return new File(this.getMetaInfAsFile(), path);
    }

    public ClassPathProvider getClassPathProvider() {
        return this.project.getClassPathProvider();
    }

    public File[] getRequiredLibraries() {
        ClassPath cp = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.project.getProjectDirectory()), (PropertyEvaluator)this.project.evaluator(), (String[])new String[]{"javac.classpath"}));
        ArrayList<File> files = new ArrayList<File>();
        for (FileObject fo : cp.getRoots()) {
            if (FileUtil.getArchiveFile((FileObject)fo) == null) continue;
            files.add(FileUtil.toFile((FileObject)FileUtil.getArchiveFile((FileObject)fo)));
        }
        return files.toArray(new File[files.size()]);
    }

    public FileObject getArchive() {
        return this.getFileObject("dist.jar");
    }

    private FileObject getFileObject(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFileObject(prop);
        }
        return null;
    }

    private File getFile(String propname) {
        String prop = this.helper.getStandardPropertyEvaluator().getProperty(propname);
        if (prop != null) {
            return this.helper.resolveFile(prop);
        }
        return null;
    }

    public synchronized J2eeModule getJ2eeModule() {
        if (this.j2eeModule == null) {
            this.j2eeModule = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation2)this);
        }
        return this.j2eeModule;
    }

    public ModuleChangeReporter getModuleChangeReporter() {
        return this;
    }

    public ResourceChangeReporter getResourceChangeReporter() {
        return this.rcr;
    }

    public String getServerID() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.type");
    }

    public String getServerInstanceID() {
        return this.helper.getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
    }

    public void setServerInstanceID(String serverInstanceID) {
        assert (serverInstanceID != null) : "passed serverInstanceID cannot be null";
        AppClientProjectProperties.setServerInstance(this.project, this.helper, serverInstanceID);
    }

    public Iterator<J2eeModule.RootedEntry> getArchiveContents() throws IOException {
        return new IT(this.getContentDirectory());
    }

    public FileObject getContentDirectory() {
        return this.getFileObject("build.classes.dir");
    }

    public FileObject getBuildDirectory() {
        return this.getFileObject("build.dir");
    }

    public File getContentDirectoryAsFile() {
        return this.getFile("build.classes.dir");
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> type) {
        if (type == AppClientMetadata.class) {
            MetadataModel<AppClientMetadata> model = this.getMetadataModel();
            return model;
        }
        if (type == WebservicesMetadata.class) {
            MetadataModel<WebservicesMetadata> model = this.getWebservicesMetadataModel();
            return model;
        }
        return null;
    }

    private synchronized MetadataModel<AppClientMetadata> getMetadataModel() {
        if (this.appClientMetadataModel == null) {
            FileObject ddFO = this.getDeploymentDescriptor();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.appClientMetadataModel = AppClientMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.appClientMetadataModel;
    }

    private synchronized MetadataModel<WebservicesMetadata> getWebservicesMetadataModel() {
        if (this.webservicesMetadataModel == null) {
            FileObject ddFO = this.getDD();
            File ddFile = ddFO != null ? FileUtil.toFile((FileObject)ddFO) : null;
            MetadataUnit metadataUnit = MetadataUnit.create((ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/boot"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/compile"), (ClassPath)this.cpProvider.getProjectSourcesClassPath("classpath/source"), (File)ddFile);
            this.webservicesMetadataModel = WebservicesMetadataModelFactory.createMetadataModel((MetadataUnit)metadataUnit);
        }
        return this.webservicesMetadataModel;
    }

    public FileObject getDD() {
        FileObject metaInfFo = this.getMetaInf();
        if (metaInfFo == null) {
            return null;
        }
        return metaInfFo.getFileObject("webservices", "xml");
    }

    public EjbChangeDescriptor getEjbChanges(long timestamp) {
        return this;
    }

    public J2eeModule.Type getModuleType() {
        return J2eeModule.Type.CAR;
    }

    public String getModuleVersion() {
        Profile p = Profile.fromPropertiesString((String)this.project.evaluator().getProperty("j2ee.platform"));
        if (p == null) {
            return "6";
        }
        if (Profile.JAKARTA_EE_10_FULL.equals(p) || Profile.JAKARTA_EE_10_WEB.equals(p)) {
            return "10";
        }
        if (Profile.JAKARTA_EE_9_1_FULL.equals(p) || Profile.JAKARTA_EE_9_1_WEB.equals(p)) {
            return "9";
        }
        if (Profile.JAKARTA_EE_9_FULL.equals(p) || Profile.JAKARTA_EE_9_WEB.equals(p)) {
            return "9";
        }
        if (Profile.JAKARTA_EE_8_FULL.equals(p) || Profile.JAKARTA_EE_8_FULL.equals(p)) {
            return "8";
        }
        if (Profile.JAVA_EE_8_FULL.equals(p) || Profile.JAVA_EE_8_WEB.equals(p)) {
            return "8";
        }
        if (Profile.JAVA_EE_7_FULL.equals(p) || Profile.JAVA_EE_7_WEB.equals(p)) {
            return "7";
        }
        if (Profile.JAVA_EE_5.equals(p)) {
            return "5";
        }
        if (Profile.J2EE_14.equals(p)) {
            return "1.4";
        }
        return "6";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dd_version")) {
            String oldVersion = (String)evt.getOldValue();
            String newVersion = (String)evt.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("moduleVersion", oldVersion, newVersion);
        } else if (evt.getPropertyName().equals("j2ee.server.instance")) {
            try {
                Deployment d = Deployment.getDefault();
                String oldServerID = evt.getOldValue() == null ? null : d.getServerInstance((String)evt.getOldValue()).getServerID();
                String newServerID = evt.getNewValue() == null ? null : d.getServerInstance((String)evt.getNewValue()).getServerID();
                this.fireServerChange(oldServerID, newServerID);
            }
            catch (InstanceRemovedException ie) {
                Logger.getLogger(AppClientProvider.class.getName()).log(Level.FINE, null, ie);
            }
        } else if ("resource.dir".equals(evt.getPropertyName())) {
            String oldValue = (String)evt.getOldValue();
            String newValue = (String)evt.getNewValue();
            this.getPropertyChangeSupport().firePropertyChange("resourceDir", oldValue == null ? null : new File(oldValue), newValue == null ? null : new File(newValue));
        }
    }

    public String getUrl() {
        EditableProperties ep = this.helper.getProperties("nbproject/project.properties");
        String name = ep.getProperty("jar.name");
        return name == null ? "" : '/' + name;
    }

    public boolean isManifestChanged(long timestamp) {
        return false;
    }

    public void setUrl(String url) {
        throw new UnsupportedOperationException("Cannot customize URL of Application Client module");
    }

    public boolean ejbsChanged() {
        return false;
    }

    public String[] getChangedEjbs() {
        return new String[0];
    }

    public Profile getJ2eeProfile() {
        return Profile.fromPropertiesString((String)this.helper.getStandardPropertyEvaluator().getProperty("j2ee.platform"));
    }

    public FileObject[] getSourceRoots() {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        LinkedList<FileObject> roots = new LinkedList<FileObject>();
        FileObject metaInf = this.getMetaInf();
        if (metaInf != null) {
            roots.add(metaInf);
        }
        for (int i = 0; i < groups.length; ++i) {
            roots.add(groups[i].getRootFolder());
        }
        FileObject[] rootArray = new FileObject[roots.size()];
        return roots.toArray(rootArray);
    }

    private void showErrorMessage(final String message) {
        if (new Date().getTime() > this.notificationTimeout && this.isProjectOpen()) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        SwingUtilities.invokeLater(this);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                    }
                }
            };
            r.run();
            this.notificationTimeout = new Date().getTime() + 20000L;
        }
    }

    private boolean isProjectOpen() {
        if (OpenProjects.getDefault() != null) {
            Project[] projects = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projects.length; ++i) {
                if (!projects[i].equals(this.project)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            return;
        }
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        FileObject f;
        FileObject root;

        FSRootRE(FileObject root, FileObject f) {
            this.f = f;
            this.root = root;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static class IT
    implements Iterator<J2eeModule.RootedEntry> {
        Enumeration<? extends FileObject> ch;
        FileObject root;

        private IT(FileObject f) {
            this.ch = f.getChildren(true);
            this.root = f;
        }

        @Override
        public boolean hasNext() {
            return this.ch.hasMoreElements();
        }

        @Override
        public J2eeModule.RootedEntry next() {
            FileObject f = this.ch.nextElement();
            return new FSRootRE(this.root, f);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class AppClientResourceChangeReporter
    implements ResourceChangeReporterImplementation {
        private AppClientResourceChangeReporter() {
        }

        public boolean isServerResourceChanged(long lastDeploy) {
            File[] children;
            File resDir = AppClientProvider.this.getResourceDirectory();
            if (resDir != null && resDir.exists() && resDir.isDirectory() && (children = resDir.listFiles()) != null) {
                for (File file : children) {
                    if (file.lastModified() <= lastDeploy) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

