/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.PathFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitStatus;
import org.netbeans.libs.git.jgit.DelegatingGitProgressMonitor;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.Utils;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.jgit.commands.StatusCommand;
import org.netbeans.libs.git.progress.FileListener;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.libs.git.progress.StatusListener;

abstract class MoveTreeCommand
extends GitCommand {
    private final File source;
    private final File target;
    private final boolean after;
    private final ProgressMonitor monitor;
    private final boolean keepSourceTree;
    private final FileListener listener;

    protected MoveTreeCommand(Repository repository, GitClassFactory gitFactory, File source, File target, boolean after, boolean keepSourceTree, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.source = source;
        this.target = target;
        this.monitor = monitor;
        this.listener = listener;
        this.after = after;
        this.keepSourceTree = keepSourceTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws GitException {
        File sourceFile = this.tryNormalizeSymlink(this.source);
        File targetFile = this.tryNormalizeSymlink(this.target);
        if (!this.keepSourceTree && !this.after) {
            this.rename();
        }
        sourceFile = this.tryNormalizeSymlink(sourceFile);
        targetFile = this.tryNormalizeSymlink(targetFile);
        Repository repository = this.getRepository();
        try {
            DirCache cache = repository.lockDirCache();
            try {
                List<String> ignoredTargets = this.getIgnores(targetFile);
                boolean retried = false;
                DirCacheBuilder builder = cache.builder();
                TreeWalk treeWalk = new TreeWalk(repository);
                PathFilter sourceFilter = PathFilter.create((String)Utils.getRelativePath(repository.getWorkTree(), sourceFile));
                PathFilter targetFilter = PathFilter.create((String)Utils.getRelativePath(repository.getWorkTree(), targetFile));
                treeWalk.setFilter(PathFilterGroup.create(Arrays.asList(sourceFilter, targetFilter)));
                treeWalk.setRecursive(true);
                treeWalk.reset();
                treeWalk.addTree((AbstractTreeIterator)new DirCacheBuildIterator(builder));
                while (treeWalk.next() && !this.monitor.isCanceled()) {
                    String path = treeWalk.getPathString();
                    File file = new File(repository.getWorkTree().getAbsolutePath() + File.separator + path);
                    DirCacheEntry e = ((DirCacheBuildIterator)treeWalk.getTree(0, DirCacheBuildIterator.class)).getDirCacheEntry();
                    if (e == null) continue;
                    if (targetFilter.include(treeWalk)) {
                        if (Utils.isUnderOrEqual(treeWalk, Collections.singletonList(targetFilter))) {
                            this.monitor.notifyWarning(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Warning_IndexEntryExists"), path));
                            continue;
                        }
                        builder.add(e);
                        continue;
                    }
                    boolean symlink = (e.getFileMode().getBits() & 0xA000) == 40960;
                    String newPath = null;
                    try {
                        newPath = this.getRelativePath(file, sourceFile, targetFile);
                    }
                    catch (IllegalArgumentException ex) {
                        if (symlink && !retried) {
                            this.monitor.notifyWarning(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Warning_FileMayBeSymlink"), sourceFile));
                            this.monitor.notifyWarning(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Warning_FileMayBeSymlink"), targetFile));
                            sourceFile = sourceFile.getCanonicalFile();
                            targetFile = targetFile.getCanonicalFile();
                            sourceFilter = PathFilter.create((String)Utils.getRelativePath(repository.getWorkTree(), sourceFile));
                            targetFilter = PathFilter.create((String)Utils.getRelativePath(repository.getWorkTree(), targetFile));
                            treeWalk.setFilter(PathFilterGroup.create(Arrays.asList(sourceFilter, targetFilter)));
                            treeWalk.reset();
                            builder = cache.builder();
                            treeWalk.addTree((AbstractTreeIterator)new DirCacheBuildIterator(builder));
                            retried = true;
                            continue;
                        }
                        throw ex;
                    }
                    if (!this.isIgnored(ignoredTargets, newPath)) {
                        DirCacheEntry copied = new DirCacheEntry(newPath);
                        copied.copyMetaData(e);
                        File newFile = new File(repository.getWorkTree().getAbsolutePath() + File.separator + newPath);
                        this.listener.notifyFile(newFile, treeWalk.getPathString());
                        builder.add(copied);
                    }
                    if (!this.keepSourceTree) continue;
                    builder.add(e);
                }
                if (!this.monitor.isCanceled()) {
                    builder.commit();
                }
            }
            finally {
                cache.unlock();
            }
        }
        catch (CorruptObjectException ex) {
            throw new GitException(ex);
        }
        catch (IOException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected boolean prepareCommand() throws GitException {
        boolean retval = super.prepareCommand();
        if (retval) {
            String relPathToTarget;
            File workTree = this.getRepository().getWorkTree();
            String relPathToSource = Utils.getRelativePath(workTree, this.source);
            if (relPathToSource.startsWith((relPathToTarget = Utils.getRelativePath(workTree, this.target)) + "/")) {
                this.monitor.preparationsFailed(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Error_SourceFolderUnderTarget"), relPathToSource, relPathToTarget));
                throw new GitException(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Error_SourceFolderUnderTarget"), relPathToSource, relPathToTarget));
            }
            if (relPathToTarget.startsWith(relPathToSource + "/")) {
                this.monitor.preparationsFailed(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Error_TargetFolderUnderSource"), relPathToTarget, relPathToSource));
                throw new GitException(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Error_TargetFolderUnderSource"), relPathToTarget, relPathToSource));
            }
        }
        return retval;
    }

    private void rename() throws GitException {
        File parentFile = this.target.getParentFile();
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new GitException(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Exception_CannotCreateFolder"), parentFile.getAbsolutePath()));
        }
        if (!this.source.renameTo(this.target)) {
            throw new GitException(MessageFormat.format(Utils.getBundle(MoveTreeCommand.class).getString("MSG_Exception_CannotRenameTo"), this.source.getAbsolutePath(), this.target.getAbsolutePath()));
        }
    }

    private String getRelativePath(File file, File ancestor, File target) {
        String relativePathToAncestor = Utils.getRelativePath(ancestor, file);
        StringBuilder relativePathToSource = new StringBuilder(Utils.getRelativePath(this.getRepository().getWorkTree(), target));
        if (!relativePathToAncestor.isEmpty()) {
            if (relativePathToSource.length() > 0) {
                relativePathToSource.append("/");
            }
            relativePathToSource.append(relativePathToAncestor);
        }
        return relativePathToSource.toString();
    }

    private List<String> getIgnores(File targetFile) throws GitException {
        StatusCommand cmd = new StatusCommand(this.getRepository(), "HEAD", new File[]{targetFile}, this.getClassFactory(), new DelegatingGitProgressMonitor(this.monitor), new StatusListener(){

            @Override
            public void notifyStatus(GitStatus status) {
            }
        });
        cmd.run();
        ArrayList<String> ignores = new ArrayList<String>();
        Map<File, GitStatus> statuses = cmd.getStatuses();
        for (Map.Entry<File, GitStatus> e : statuses.entrySet()) {
            GitStatus status = e.getValue();
            if (status.getStatusIndexWC() != GitStatus.Status.STATUS_IGNORED) continue;
            ignores.add(status.getRelativePath());
        }
        return ignores;
    }

    private boolean isIgnored(List<String> ignores, String path) {
        boolean ignored = false;
        for (String ignore : ignores) {
            if (!path.equals(ignore) && !path.startsWith(ignore + '/')) continue;
            ignored = true;
        }
        return ignored;
    }

    private File tryNormalizeSymlink(File input) {
        if (input == null) {
            return input;
        }
        if (input.exists()) {
            try {
                return input.toPath().toRealPath(new LinkOption[0]).toFile();
            }
            catch (IOException ex) {
                return input;
            }
        }
        return input;
    }
}

