/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.processtreekiller;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.processtreekiller.DarwinCLibrary;
import org.netbeans.processtreekiller.DarwinProcess;
import org.netbeans.processtreekiller.UnixSystem;

class DarwinSystem
extends UnixSystem<DarwinProcess> {
    private static final Logger LOGGER = Logger.getLogger(DarwinSystem.class.getName());
    private static final int[] MIB_PROC_ALL = new int[]{1, 14, 0};

    DarwinSystem() {
        try {
            Memory m;
            DarwinCLibrary.SizeTByReference size;
            block5: {
                DarwinCLibrary.SizeT newLen = new DarwinCLibrary.SizeT();
                size = new DarwinCLibrary.SizeTByReference();
                int nRetry = 0;
                do {
                    if (DarwinCLibrary.LIBC.sysctl(MIB_PROC_ALL, 3, null, size, null, newLen) != 0) {
                        throw new IOException("Failed to obtain memory requirement: " + DarwinCLibrary.LIBC.strerror(Native.getLastError()));
                    }
                    m = new Memory(size.getValue());
                    if (DarwinCLibrary.LIBC.sysctl(MIB_PROC_ALL, 3, (Pointer)m, size, null, newLen) == 0) break block5;
                } while (Native.getLastError() == 12 && nRetry++ < 16);
                throw new IOException("Failed to call kern.proc.all: " + DarwinCLibrary.LIBC.strerror(Native.getLastError()));
            }
            int count = (int)(size.getValue() / 648L);
            LOGGER.log(Level.FINE, "Found {0} processes", count);
            int base = 0;
            while ((long)base < size.getValue()) {
                int pid = m.getInt((long)(base + 40));
                int ppid = m.getInt((long)(base + 560));
                this.processes.put(pid, new DarwinProcess(this, pid, ppid));
                base += 648;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to obtain process list", e);
        }
    }
}

