/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2.ui.codegen;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.table.DefaultTableModel;
import org.netbeans.modules.php.nette2.codegen.ActionRenderMethodChecker;
import org.netbeans.modules.php.nette2.ui.codegen.Bundle;
import org.netbeans.modules.php.nette2.utils.EditorUtils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class ActionRenderVisualPanel
extends JPanel {
    private DefaultTableModel tableModel;
    private ActionRenderMethodChecker methodChecker;
    private JTextField actionNameText;
    private JTable actionTable;
    private JButton addButton;
    private JButton deleteButton;
    private JFileChooser directoryChooser;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane1;
    private JLabel warningLabel;

    public ActionRenderVisualPanel(DefaultTableModel tableModel) {
        this.tableModel = tableModel;
        this.initComponents();
        this.warningLabel.setText("");
    }

    @Override
    public String getName() {
        return Bundle.TXT_ActionRenderVisualPanelName();
    }

    public Set<Action> getActions() {
        HashSet<Action> actions = new HashSet<Action>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            actions.add(new Action((String)this.tableModel.getValueAt(i, 0), (Boolean)this.tableModel.getValueAt(i, 1), (Boolean)this.tableModel.getValueAt(i, 2)));
        }
        return actions;
    }

    public void setMethodChecker(ActionRenderMethodChecker methodChecker) {
        this.methodChecker = methodChecker;
    }

    private void initComponents() {
        this.directoryChooser = new JFileChooser();
        this.jLabel2 = new JLabel();
        this.actionNameText = new JTextField();
        this.addButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.actionTable = new JTable();
        this.deleteButton = new JButton();
        this.warningLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.directoryChooser.setFileSelectionMode(1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ActionRenderVisualPanel.class, (String)"ActionRenderVisualPanel.jLabel2.text"));
        this.actionNameText.setText(NbBundle.getMessage(ActionRenderVisualPanel.class, (String)"ActionRenderVisualPanel.actionNameText.text"));
        this.actionNameText.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent evt) {
                ActionRenderVisualPanel.this.actionNameTextCaretUpdate(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ActionRenderVisualPanel.class, (String)"ActionRenderVisualPanel.addButton.text"));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionRenderVisualPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.actionTable.setModel(this.tableModel);
        this.actionTable.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.actionTable);
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage(ActionRenderVisualPanel.class, (String)"ActionRenderVisualPanel.deleteButton.text"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ActionRenderVisualPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(ActionRenderVisualPanel.class, (String)"ActionRenderVisualPanel.warningLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ActionRenderVisualPanel.class, (String)"ActionRenderVisualPanel.jLabel3.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.actionNameText, -1, 508, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton, -2, 65, -2)).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.deleteButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.warningLabel)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.actionNameText, -2, -1, -2).addComponent(this.addButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 143, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE).addComponent(this.warningLabel)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addAction();
    }

    private void actionNameTextCaretUpdate(CaretEvent evt) {
        if (this.isValidAction(this.actionNameText.getText())) {
            this.addButton.setEnabled(true);
        } else {
            if (this.actionNameText.getText().trim().isEmpty()) {
                this.hideWarning();
            }
            this.addButton.setEnabled(false);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        int row = this.actionTable.getSelectedRow();
        if (row != -1) {
            int result = JOptionPane.showConfirmDialog(this, Bundle.TXT_DeleteRowConfirmText(), Bundle.TXT_DeleteRowConfirmTitle(), 0, 2);
            if (result == 0) {
                this.tableModel.removeRow(row);
            }
        } else {
            JOptionPane.showMessageDialog(this, Bundle.TXT_NoActionSelectedText(), Bundle.TXT_NoActionSelectedTitle(), 1);
        }
    }

    private void addAction() {
        if (this.isValidAction(this.actionNameText.getText())) {
            this.tableModel.addRow(new Object[]{this.actionNameText.getText(), false, false});
            this.actionNameText.setText("");
            this.addButton.setEnabled(false);
            this.hideWarning();
            this.actionNameText.requestFocus();
        }
    }

    private boolean isValidAction(String action) {
        boolean result = false;
        if (this.isValidActionFormat(action) && !this.actionExists(action)) {
            this.hideWarning();
            result = true;
        }
        return result;
    }

    private boolean isValidActionFormat(String action) {
        boolean result = false;
        if (action.trim().matches("^[a-zA-Z0-9][a-zA-Z0-9_]*$")) {
            result = true;
        } else {
            this.showWarning(Bundle.WRN_InvalidActionFormat());
        }
        return result;
    }

    private boolean actionExists(String newAction) {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            String oldAction = (String)this.tableModel.getValueAt(i, 0);
            if (!oldAction.equals(newAction)) continue;
            this.showWarning(Bundle.WRN_ActionExists());
            return true;
        }
        if (this.methodChecker != null && this.methodChecker.existsActionMethod(newAction) && this.methodChecker.existsRenderMethod(newAction)) {
            this.showWarning(Bundle.WRN_ActionRenderMethodExists());
            return true;
        }
        return false;
    }

    private void showWarning(String warning) {
        this.warningLabel.setText(" ");
        this.warningLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.warningLabel.setText(warning);
    }

    private void hideWarning() {
        this.warningLabel.setText(" ");
    }

    public static final class Action {
        private final String name;
        private final boolean generateAction;
        private final boolean generateRender;

        public Action(String name, boolean generateAction, boolean generateRender) {
            assert (name != null);
            this.name = name;
            this.generateAction = generateAction;
            this.generateRender = generateRender;
        }

        public String getName() {
            return this.name;
        }

        public boolean isGenerateAction() {
            return this.generateAction;
        }

        public String generateAction() {
            return this.getMethod("action");
        }

        public boolean isGenerateRender() {
            return this.generateRender;
        }

        public String generateRender() {
            return this.getMethod("render");
        }

        private String getMethod(String type) {
            return "public function " + type + EditorUtils.firstLetterCapital(this.name) + "() {\n \n}";
        }
    }
}

