/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetCommitRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String commitId;
    private String opcRequestId;

    @ConstructorProperties(value={"repositoryId", "commitId", "opcRequestId"})
    GetCommitRequest(String repositoryId, String commitId, String opcRequestId) {
        this.repositoryId = repositoryId;
        this.commitId = commitId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).commitId(this.commitId).opcRequestId(this.opcRequestId);
    }

    public String toString() {
        return "GetCommitRequest(super=" + super.toString() + ", repositoryId=" + this.getRepositoryId() + ", commitId=" + this.getCommitId() + ", opcRequestId=" + this.getOpcRequestId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GetCommitRequest)) {
            return false;
        }
        GetCommitRequest other = (GetCommitRequest)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$repositoryId = this.getRepositoryId();
        String other$repositoryId = other.getRepositoryId();
        if (this$repositoryId == null ? other$repositoryId != null : !this$repositoryId.equals(other$repositoryId)) {
            return false;
        }
        String this$commitId = this.getCommitId();
        String other$commitId = other.getCommitId();
        if (this$commitId == null ? other$commitId != null : !this$commitId.equals(other$commitId)) {
            return false;
        }
        String this$opcRequestId = this.getOpcRequestId();
        String other$opcRequestId = other.getOpcRequestId();
        return !(this$opcRequestId == null ? other$opcRequestId != null : !this$opcRequestId.equals(other$opcRequestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GetCommitRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $repositoryId = this.getRepositoryId();
        result = result * 59 + ($repositoryId == null ? 43 : $repositoryId.hashCode());
        String $commitId = this.getCommitId();
        result = result * 59 + ($commitId == null ? 43 : $commitId.hashCode());
        String $opcRequestId = this.getOpcRequestId();
        result = result * 59 + ($opcRequestId == null ? 43 : $opcRequestId.hashCode());
        return result;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCommitRequest, Void> {
        private String repositoryId;
        private String commitId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCommitRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.commitId(o.getCommitId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCommitRequest build() {
            GetCommitRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetCommitRequest buildWithoutInvocationCallback() {
            return new GetCommitRequest(this.repositoryId, this.commitId, this.opcRequestId);
        }

        public String toString() {
            return "GetCommitRequest.Builder(repositoryId=" + this.repositoryId + ", commitId=" + this.commitId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

