/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.cdnjs.Library;
import org.netbeans.modules.javascript.cdnjs.LibraryProvider;
import org.netbeans.modules.javascript.cdnjs.LibraryUtils;
import org.netbeans.modules.javascript.cdnjs.ui.Bundle;
import org.netbeans.modules.javascript.cdnjs.ui.EditPanel;
import org.netbeans.modules.javascript.cdnjs.ui.SearchPanel;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SelectionPanel
extends JPanel
implements HelpCtx.Provider {
    private SearchPanel searchPanel;
    private final List<Library.Version> libraries;
    private final LibraryTableModel tableModel;
    private final File webRoot;
    private final Map<String, Library> libraryInfo = new HashMap<String, Library>();
    private static final RequestProcessor RP = new RequestProcessor(SearchPanel.class.getName(), 3);
    private JButton addButton;
    private JButton browseButton;
    private JButton editButton;
    private JTextField folderField;
    private JLabel folderInfoLabel;
    private JLabel folderLabel;
    private JScrollPane librariesScrollPane;
    private JTable librariesTable;
    private JButton removeButton;
    private JButton updateButton;

    public SelectionPanel(Project project, Library.Version[] existingLibraries, File webRoot, String libraryFolder) {
        assert (project != null);
        this.libraries = new ArrayList<Library.Version>(Arrays.asList(existingLibraries));
        Collections.sort(this.libraries, new LibraryVersionComparator());
        this.webRoot = webRoot;
        this.tableModel = new LibraryTableModel();
        this.initComponents();
        this.folderField.setText(libraryFolder);
        this.librariesTable.getSelectionModel().addListSelectionListener(new Listener());
        VersionColumnRenderer versionColumnRenderer = new VersionColumnRenderer();
        TableColumnModel tableColumnModel = this.librariesTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(new LibraryNameColumnRenderer(project));
        tableColumnModel.getColumn(1).setCellRenderer(versionColumnRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(versionColumnRenderer);
        this.loadLibraryInfo(existingLibraries);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.cdnjs.ui.SelectionPanel");
    }

    public Library.Version[] getSelectedLibraries() {
        return this.libraries.toArray(new Library.Version[this.libraries.size()]);
    }

    public String getLibraryFolder() {
        return this.folderField.getText();
    }

    private void showSearchPanel() {
        Library.Version selectedVersion;
        SearchPanel panel = this.getSearchPanel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)panel, Bundle.SelectionPanel_searchDialog_title(), true, new Object[]{panel.getAddButton(), panel.getCancelButton()}, (Object)panel.getAddButton(), 0, HelpCtx.DEFAULT_HELP, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        if (descriptor.getValue() == panel.getAddButton() && (selectedVersion = panel.getSelectedVersion()) != null) {
            this.addLibrary(selectedVersion);
        }
    }

    @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Comparing instances is OK here")
    private void showEditPanel() {
        int selectedRow = this.librariesTable.getSelectedRow();
        Library.Version selectedVersion = this.libraries.get(selectedRow);
        Library library = this.libraryInfo.get(selectedVersion.getLibrary().getName());
        EditPanel editPanel = new EditPanel(library, selectedVersion);
        String update = Bundle.SelectionPanel_editDialog_update();
        String cancel = Bundle.SelectionPanel_editDialog_cancel();
        DialogDescriptor descriptor = new DialogDescriptor((Object)editPanel, Bundle.SelectionPanel_editDialog_title(), true, new Object[]{update, cancel}, (Object)update, 0, HelpCtx.DEFAULT_HELP, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.setVisible(true);
        if (descriptor.getValue() == update) {
            Library.Version version = editPanel.getSelection();
            if (version == null) {
                this.removeSelectedLibraries();
            } else {
                this.addLibrary(version);
            }
        }
    }

    private SearchPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new SearchPanel();
        }
        return this.searchPanel;
    }

    private void addLibrary(Library.Version libraryVersion) {
        String newLibraryName = libraryVersion.getLibrary().getName();
        Library.Version versionToReplace = this.findLibrary(newLibraryName);
        if (versionToReplace != null) {
            this.libraries.remove(versionToReplace);
        }
        this.libraries.add(libraryVersion);
        Collections.sort(this.libraries, new LibraryVersionComparator());
        this.libraryInfo.put(newLibraryName, libraryVersion.getLibrary());
        this.tableModel.fireTableDataChanged();
    }

    private Library.Version findLibrary(String libraryName) {
        for (Library.Version existingVersion : this.libraries) {
            String existingLibraryName = existingVersion.getLibrary().getName();
            if (!libraryName.equals(existingLibraryName)) continue;
            return existingVersion;
        }
        return null;
    }

    private void removeSelectedLibraries() {
        int[] selectedRows = this.librariesTable.getSelectedRows();
        int length = selectedRows.length;
        for (int i = 1; i <= length; ++i) {
            this.libraries.remove(selectedRows[length - i]);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void showBrowseDialog() {
        File libraryFolder = PropertyUtils.resolveFile((File)this.webRoot, (String)this.getLibraryFolder());
        File selectedDir = new FileChooserBuilder(SelectionPanel.class).setDirectoriesOnly(true).setTitle(Bundle.SelectionPanel_browseDialog_title()).setDefaultWorkingDirectory(libraryFolder).forceUseOfDefaultWorkingDirectory(true).showOpenDialog();
        if (selectedDir != null) {
            String relativePath = PropertyUtils.relativizeFile((File)this.webRoot, (File)selectedDir);
            String path = relativePath == null ? selectedDir.getAbsolutePath() : relativePath;
            this.folderField.setText(path);
        }
    }

    private void loadLibraryInfo(Library.Version[] existingLibraries) {
        RP.execute(() -> {
            LibraryProvider provider = LibraryProvider.getInstance();
            for (Library.Version libraryVersion : existingLibraries) {
                String libraryName = libraryVersion.getLibrary().getName();
                Library library = provider.loadLibrary(libraryName);
                if (library == null) continue;
                SwingUtilities.invokeLater(() -> this.updateLibraryInfo(library));
            }
        });
    }

    void updateLibraryInfo(Library foundLibrary) {
        this.libraryInfo.put(foundLibrary.getName(), foundLibrary);
        this.tableModel.fireTableDataChanged();
    }

    void updateUpdateButton() {
        boolean updatePossible = false;
        for (int row : this.librariesTable.getSelectedRows()) {
            Object value = this.tableModel.getValueAt(row, 2);
            if (value == VersionColumnRenderer.CHECKING || value == VersionColumnRenderer.UNKNOWN || value == VersionColumnRenderer.UP_TO_DATE) continue;
            updatePossible = true;
            break;
        }
        this.updateButton.setEnabled(updatePossible);
    }

    void updateSelectedLibraries() {
        for (int row : this.librariesTable.getSelectedRows()) {
            Library.Version currentVersion = this.libraries.get(row);
            String libraryName = currentVersion.getLibrary().getName();
            Library library = this.libraryInfo.get(libraryName);
            Library.Version latestVersion = library.getVersions()[0];
            if (currentVersion.getName().equals(latestVersion.getName())) continue;
            this.addLibrary(latestVersion);
        }
    }

    private void initComponents() {
        this.librariesScrollPane = new JScrollPane();
        this.librariesTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.folderLabel = new JLabel();
        this.folderField = new JTextField();
        this.folderInfoLabel = new JLabel();
        this.browseButton = new JButton();
        this.editButton = new JButton();
        this.updateButton = new JButton();
        FormListener formListener = new FormListener();
        this.librariesTable.setModel(this.tableModel);
        this.librariesScrollPane.setViewportView(this.librariesTable);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"SelectionPanel.addButton.text"));
        this.addButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"SelectionPanel.removeButton.text"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(SelectionPanel.class, (String)"SelectionPanel.folderLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.folderInfoLabel, (String)NbBundle.getMessage(SelectionPanel.class, (String)"SelectionPanel.folderInfoLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"SelectionPanel.browseButton.text"));
        this.browseButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.editButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"SelectionPanel.editButton.text"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(formListener);
        Mnemonics.setLocalizedText((AbstractButton)this.updateButton, (String)NbBundle.getMessage(SelectionPanel.class, (String)"SelectionPanel.updateButton.text"));
        this.updateButton.setEnabled(false);
        this.updateButton.addActionListener(formListener);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.librariesScrollPane).addGroup(layout.createSequentialGroup().addComponent(this.folderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.folderInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.folderField)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton).addComponent(this.removeButton, GroupLayout.Alignment.TRAILING)).addComponent(this.browseButton).addComponent(this.editButton).addComponent(this.updateButton, GroupLayout.Alignment.TRAILING)).addGap(0, 0, 0)));
        layout.linkSize(0, this.addButton, this.browseButton, this.editButton, this.removeButton, this.updateButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.updateButton).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.librariesScrollPane, -1, 277, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.folderLabel).addComponent(this.folderField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.folderInfoLabel)));
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.showSearchPanel();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        this.removeSelectedLibraries();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        this.showBrowseDialog();
    }

    private void editButtonActionPerformed(ActionEvent evt) {
        this.showEditPanel();
    }

    private void updateButtonActionPerformed(ActionEvent evt) {
        this.updateSelectedLibraries();
    }

    class LibraryTableModel
    extends AbstractTableModel {
        LibraryTableModel() {
        }

        @Override
        public int getRowCount() {
            return SelectionPanel.this.libraries.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            String columnName;
            switch (column) {
                case 0: {
                    columnName = Bundle.SelectionPanel_table_libraryColumn();
                    break;
                }
                case 1: {
                    columnName = Bundle.SelectionPanel_table_versionColumn();
                    break;
                }
                case 2: {
                    columnName = Bundle.SelectionPanel_table_latestVersionColumn();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return columnName;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value;
            Library.Version libraryVersion = (Library.Version)SelectionPanel.this.libraries.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    value = libraryVersion;
                    break;
                }
                case 1: {
                    value = libraryVersion.getName();
                    break;
                }
                case 2: {
                    String libraryName = libraryVersion.getLibrary().getName();
                    Library library = (Library)SelectionPanel.this.libraryInfo.get(libraryName);
                    if (library == null || library.getVersions() == null || library.getVersions().length == 0) {
                        value = SelectionPanel.this.libraryInfo.containsKey(libraryName) ? VersionColumnRenderer.UNKNOWN : VersionColumnRenderer.CHECKING;
                        break;
                    }
                    String latestVersion = library.getVersions()[0].getName();
                    String currentVersion = libraryVersion.getName();
                    value = currentVersion.equals(latestVersion) ? VersionColumnRenderer.UP_TO_DATE : latestVersion;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            return value;
        }
    }

    static class VersionColumnRenderer
    extends DefaultTableCellRenderer {
        static final Object UP_TO_DATE = new Object();
        static final Object CHECKING = new Object();
        static final Object UNKNOWN = new Object();
        private static final String UP_TO_DATE_ICON = "org/netbeans/modules/javascript/cdnjs/ui/resources/uptodate.gif";
        private static final String CHECKING_ICON = "org/netbeans/modules/javascript/cdnjs/ui/resources/checking.png";
        private static final String UNKNOWN_ICON = "org/netbeans/modules/javascript/cdnjs/ui/resources/unknown.png";

        VersionColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String icon = null;
            String toolTip = null;
            if (value == UNKNOWN) {
                icon = UNKNOWN_ICON;
                toolTip = Bundle.SelectionPanel_version_unknown();
            } else if (value == CHECKING) {
                icon = CHECKING_ICON;
                toolTip = Bundle.SelectionPanel_version_checking();
            } else if (value == UP_TO_DATE) {
                icon = UP_TO_DATE_ICON;
                toolTip = Bundle.SelectionPanel_version_uptodate();
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setHorizontalAlignment(0);
            this.setToolTipText(toolTip);
            if (icon == null) {
                this.setIcon(null);
            } else {
                this.setText(null);
                this.setIcon(ImageUtilities.loadImageIcon((String)icon, (boolean)false));
            }
            return this;
        }
    }

    static class LibraryNameColumnRenderer
    extends DefaultTableCellRenderer {
        private static final String BROKEN_ICON = "org/netbeans/modules/javascript/cdnjs/ui/resources/broken.png";
        private final Project project;

        LibraryNameColumnRenderer(Project project) {
            assert (project != null);
            this.project = project;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String icon = null;
            String toolTip = null;
            if (value instanceof Library.Version) {
                Library.Version libraryVersion = (Library.Version)value;
                value = libraryVersion.getLibrary().getName();
                if (LibraryUtils.isBroken(this.project, libraryVersion)) {
                    icon = BROKEN_ICON;
                    toolTip = Bundle.SelectionPanel_version_broken();
                }
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setToolTipText(toolTip);
            if (icon == null) {
                this.setIcon(null);
            } else {
                this.setIcon(ImageUtilities.loadImageIcon((String)icon, (boolean)false));
            }
            return this;
        }
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"}, justification="No need to be serializable")
    static class LibraryVersionComparator
    implements Comparator<Library.Version> {
        LibraryVersionComparator() {
        }

        @Override
        public int compare(Library.Version o1, Library.Version o2) {
            String name1 = o1.getLibrary().getName();
            String name2 = o2.getLibrary().getName();
            return name1.compareTo(name2);
        }
    }

    class Listener
    implements ListSelectionListener {
        Listener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRows = SelectionPanel.this.librariesTable.getSelectedRowCount();
            SelectionPanel.this.editButton.setEnabled(selectedRows == 1);
            SelectionPanel.this.removeButton.setEnabled(selectedRows != 0);
            SelectionPanel.this.updateUpdateButton();
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == SelectionPanel.this.addButton) {
                SelectionPanel.this.addButtonActionPerformed(evt);
            } else if (evt.getSource() == SelectionPanel.this.removeButton) {
                SelectionPanel.this.removeButtonActionPerformed(evt);
            } else if (evt.getSource() == SelectionPanel.this.browseButton) {
                SelectionPanel.this.browseButtonActionPerformed(evt);
            } else if (evt.getSource() == SelectionPanel.this.editButton) {
                SelectionPanel.this.editButtonActionPerformed(evt);
            } else if (evt.getSource() == SelectionPanel.this.updateButton) {
                SelectionPanel.this.updateButtonActionPerformed(evt);
            }
        }
    }
}

