/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.tld.LibraryDescriptor;
import org.netbeans.modules.web.core.syntax.tld.LibraryDescriptorException;
import org.netbeans.modules.web.core.syntax.tld.TldLibrary;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.Function;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class JSPELPlugin
extends ELPlugin {
    private static final Logger LOGGER = Logger.getLogger(JSPELPlugin.class.getName());
    private static final String PLUGIN_NAME = "JSP EL Plugin";
    private Collection<String> MIMETYPES = Arrays.asList("text/x-jsp", "text/x-tag");
    private Collection<ImplicitObject> implicitObjects;

    public String getName() {
        return PLUGIN_NAME;
    }

    public Collection<String> getMimeTypes() {
        return this.MIMETYPES;
    }

    public Collection<ImplicitObject> getImplicitObjects(FileObject file) {
        if (file != null && JspUtils.isJSPOrTagFile(file)) {
            return this.getImplicitObjects();
        }
        return Collections.emptyList();
    }

    public List<ResourceBundle> getResourceBundles(FileObject file, ResolverContext context) {
        return Collections.emptyList();
    }

    private synchronized Collection<ImplicitObject> getImplicitObjects() {
        if (this.implicitObjects == null) {
            this.initImplicitObjects();
        }
        return this.implicitObjects;
    }

    private synchronized void initImplicitObjects() {
        this.implicitObjects = new ArrayList<ImplicitObject>(11);
        this.implicitObjects.addAll(JSPELPlugin.getScopeObjects());
        this.implicitObjects.add(new PageContextObject("pageContext"));
        this.implicitObjects.add(new ELImplicitObject("param"));
        this.implicitObjects.add(new ELImplicitObject("paramValues"));
        this.implicitObjects.add(new ELImplicitObject("header"));
        this.implicitObjects.add(new ELImplicitObject("headerValues"));
        this.implicitObjects.add(new ELImplicitObject("initParam"));
        this.implicitObjects.add(new ELImplicitObject("cookie"));
    }

    private static Collection<ELImplicitObject> getScopeObjects() {
        ArrayList<ELImplicitObject> result = new ArrayList<ELImplicitObject>(4);
        result.add(new ELImplicitObject("pageScope"));
        result.add(new ELImplicitObject("sessionScope"));
        result.add(new ELImplicitObject("applicationScope"));
        result.add(new ELImplicitObject("requestScope"));
        for (ELImplicitObject each : result) {
            each.setType(ImplicitObjectType.SCOPE_TYPE);
        }
        return result;
    }

    public List<Function> getFunctions(FileObject file) {
        ArrayList<Function> functions = new ArrayList<Function>();
        Document document = JSPELPlugin.getDocumentForFile(file);
        if (!(document instanceof BaseDocument)) {
            return functions;
        }
        JspSyntaxSupport ss = JspSyntaxSupport.get(document);
        Map prefixMapper = ss.getPrefixMapper();
        if (prefixMapper == null || prefixMapper.isEmpty()) {
            return functions;
        }
        Map<String, String> urlToPrefixMapper = JSPELPlugin.transposeMap(prefixMapper);
        Map tagLibMappings = JspUtils.getTaglibMap(file);
        for (Map.Entry entry : tagLibMappings.entrySet()) {
            String url = (String)entry.getKey();
            if (!urlToPrefixMapper.containsKey(url)) continue;
            functions.addAll(JSPELPlugin.getFunctionsForUrl(((String[])entry.getValue())[0], ((String[])entry.getValue())[1], urlToPrefixMapper.get(url)));
        }
        return functions;
    }

    private static Map<String, String> transposeMap(Map<String, String> original) {
        HashMap<String, String> newMap = new HashMap<String, String>(original.size());
        for (Map.Entry<String, String> entry : original.entrySet()) {
            newMap.put(entry.getValue(), entry.getKey());
        }
        return newMap;
    }

    private static Document getDocumentForFile(FileObject fo) {
        try {
            EditorCookie ec = (EditorCookie)DataObject.find((FileObject)fo).getLookup().lookup(EditorCookie.class);
            return ec == null ? null : ec.getDocument();
        }
        catch (DataObjectNotFoundException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return null;
        }
    }

    private static List<Function> getFunctionsForUrl(String jarPath, String tldPath, String prefix) {
        File f;
        ArrayList<Function> functions = new ArrayList<Function>();
        String FILE_PREFIX = "file:/";
        if (jarPath.startsWith(FILE_PREFIX)) {
            URI u = URI.create(jarPath);
            f = new File(u);
        } else {
            f = new File(jarPath);
        }
        try {
            FileObject tldFile = null;
            if (tldPath != null && tldPath.endsWith(jarPath)) {
                tldFile = FileUtil.toFileObject((File)new File(tldPath));
            } else {
                JarFileSystem jfs = new JarFileSystem(FileUtil.normalizeFile((File)f));
                tldFile = jfs.getRoot().getFileObject(tldPath);
            }
            if (tldFile != null) {
                TldLibrary tldLib = TldLibrary.create(tldFile);
                for (Map.Entry<String, LibraryDescriptor.Function> entry : tldLib.getFunctions().entrySet()) {
                    functions.add(new Function(prefix + ":" + entry.getKey(), JSPELPlugin.getReturnTypeForSignature(entry.getValue().getSignature()), JSPELPlugin.getParametersForSignature(entry.getValue().getSignature()), JSPELPlugin.getDescription(entry.getValue().getDescription(), entry.getValue().getExample())));
                }
            } else {
                LOGGER.log(Level.FINE, "No FileObject for {0}:{1}", new Object[]{jarPath, tldPath});
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, null, ioe);
        }
        catch (LibraryDescriptorException lde) {
            LOGGER.log(Level.INFO, null, lde);
        }
        return functions;
    }

    private static String getReturnTypeForSignature(String signature) {
        String returnType = signature.substring(0, signature.indexOf(" "));
        return JSPELPlugin.getSimpleNameForType(returnType.trim());
    }

    private static List<String> getParametersForSignature(String signature) {
        ArrayList<String> params = new ArrayList<String>();
        String paramString = signature.substring(signature.indexOf("(") + 1, signature.indexOf(")"));
        for (String param : paramString.split(",")) {
            params.add(JSPELPlugin.getSimpleNameForType(param.trim()));
        }
        return params;
    }

    private static String getSimpleNameForType(String fqn) {
        return fqn.substring(fqn.lastIndexOf(".") + 1);
    }

    private static String getDescription(String description, String example) {
        return description;
    }

    private static class ELImplicitObject
    implements ImplicitObject {
        private String myName;
        private ImplicitObjectType myType;
        private String myClazz;

        public ELImplicitObject(String name) {
            this.myName = name;
            this.myType = ImplicitObjectType.MAP_TYPE;
        }

        public String getName() {
            return this.myName;
        }

        public ImplicitObjectType getType() {
            return this.myType;
        }

        public void setType(ImplicitObjectType type) {
            this.myType = type;
        }

        public String getClazz() {
            return this.myClazz;
        }

        public void setClazz(String clazz) {
            this.myClazz = clazz;
        }
    }

    static class PageContextObject
    extends ELImplicitObject {
        public PageContextObject(String name) {
            super(name);
            this.setType(ImplicitObjectType.OBJECT_TYPE);
            this.setClazz("javax.servlet.jsp.PageContext");
        }
    }
}

