/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.explorer;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.explorer.NodeLookupContextValues;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataListener;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeDataProvider;
import org.netbeans.modules.java.lsp.server.explorer.api.TreeItemData;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class DefaultDecorationsImpl
implements TreeDataProvider.Factory {
    public static final String EXPLORER_ROOT = "Explorers";
    public static final String COOKIES_EXT = "contextValues";
    public static final String CTXVALUE_FILE = "is:file";
    public static final String CTXVALUE_FOLDER = "is:folder";
    public static final String CTXVALUE_PROJECT = "is:project";
    public static final String CTXVALUE_PROJECT_ROOT = "is:projectRoot";
    public static final String CTXVALUE_PROJECT_SUBPROJECT = "is:subproject";
    public static final String CTXVALUE_CAP_RENAME = "cap:rename";
    public static final String CTXVALUE_CAP_DELETE = "cap:delete";
    private static final Logger LOG = Logger.getLogger(DefaultDecorationsImpl.class.getName());
    private static final Node DUMMY_NODE = new AbstractNode(Children.LEAF);
    private static final Image DEFAULT_IMAGE = DUMMY_NODE.getIcon(1);

    void readFiles(FileObject parent, List<String> lines) {
        if (parent == null) {
            return;
        }
        for (FileObject f : parent.getChildren()) {
            if (!f.isData() || !COOKIES_EXT.equals(f.getExt())) continue;
            try {
                f.asLines().stream().filter(s -> !s.trim().isEmpty() && !s.startsWith("#")).forEach(lines::add);
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Unable to read lookup items from {0}", f);
            }
        }
    }

    @Override
    public synchronized TreeDataProvider createProvider(String treeId) {
        LOG.log(Level.FINE, "Creating default DecorationImpl for {0}", treeId);
        ArrayList<String> lines = new ArrayList<String>();
        FileObject explorerRoot = FileUtil.getConfigFile((String)EXPLORER_ROOT);
        this.readFiles(explorerRoot, lines);
        this.readFiles(explorerRoot.getFileObject(treeId), lines);
        this.readFiles(explorerRoot.getFileObject("_all"), lines);
        NodeLookupContextValues p = NodeLookupContextValues.nodeLookup(lines.toArray(new String[lines.size()]));
        return new ProviderImpl(p);
    }

    static class ProviderImpl
    implements TreeDataProvider {
        private final NodeLookupContextValues lookupValues;

        public ProviderImpl(NodeLookupContextValues lookupValues) {
            this.lookupValues = lookupValues;
        }

        @Override
        public TreeItemData createDecorations(Node n, boolean expanded) {
            Image i;
            String[] vals;
            TreeItemData d = new TreeItemData();
            boolean set = false;
            NodeLookupContextValues v = this.lookupValues;
            if (v != null && (vals = v.findContextValues(n)) != null && vals.length > 0) {
                set = true;
                d.setContextValues(vals);
            }
            if (!(i = n.getIcon(1)).equals(DEFAULT_IMAGE)) {
                d.setIconImage(i);
                set = true;
            }
            FileObject f = (FileObject)n.getLookup().lookup(FileObject.class);
            boolean nodeChecked = false;
            if (f == null) {
                DataFolder df = (DataFolder)n.getLookup().lookup(DataFolder.class);
                if (df != null) {
                    f = df.getPrimaryFile();
                    nodeChecked = true;
                }
            } else if (f.isFolder()) {
                nodeChecked = true;
            }
            boolean folder = false;
            File physFile = null;
            Project p = (Project)n.getLookup().lookup(Project.class);
            if (f != null) {
                Node fn = (Node)f.getLookup().lookup(Node.class);
                if (fn == null && !f.isFolder()) {
                    try {
                        DataObject obj = DataObject.find((FileObject)f);
                        fn = obj.getNodeDelegate();
                    }
                    catch (DataObjectNotFoundException obj) {
                        // empty catch block
                    }
                }
                if ((nodeChecked || fn != null) && (nodeChecked || n.getLookup().lookup(fn.getClass()) == fn)) {
                    try {
                        physFile = FileUtil.toFile((FileObject)f);
                        if (f.isFolder() && physFile != null) {
                            Project parentP;
                            Node parent;
                            Project owner = FileOwnerQuery.getOwner((FileObject)f);
                            if (owner == null || !owner.getProjectDirectory().equals(f) || (parent = n.getParentNode()) == null || (parentP = (Project)parent.getLookup().lookup(Project.class)) != owner) {
                                folder = true;
                                d.addContextValues(DefaultDecorationsImpl.CTXVALUE_FOLDER);
                            }
                        } else if ((f.isData() || f.isValid()) && !f.isVirtual()) {
                            d.addContextValues(DefaultDecorationsImpl.CTXVALUE_FILE);
                            d.setCommand("vscode.open");
                        }
                        d.setResourceURI(new URI(Utils.toUri(f)));
                        set = true;
                    }
                    catch (URISyntaxException ex) {
                        LOG.log(Level.WARNING, "Could not convert file to URI: {0}", f);
                    }
                }
            }
            if (p != null & folder && p.getProjectDirectory().equals(f)) {
                d.addContextValues(DefaultDecorationsImpl.CTXVALUE_PROJECT);
                Project root = ProjectUtils.rootOf((Project)p);
                if (root == p) {
                    Set contained = ProjectUtils.getContainedProjects((Project)root, (boolean)false);
                    if (contained != null && !contained.isEmpty()) {
                        d.addContextValues(DefaultDecorationsImpl.CTXVALUE_PROJECT_ROOT);
                    }
                } else {
                    d.addContextValues(DefaultDecorationsImpl.CTXVALUE_PROJECT_SUBPROJECT);
                }
            } else if (n.canDestroy()) {
                d.addContextValues(DefaultDecorationsImpl.CTXVALUE_CAP_DELETE);
                set = true;
            }
            if (n.canRename()) {
                d.addContextValues(DefaultDecorationsImpl.CTXVALUE_CAP_RENAME);
                set = true;
            }
            return set ? d : null;
        }

        @Override
        public void addTreeItemDataListener(TreeDataListener l) {
            this.lookupValues.addTreeItemDataListener(l);
        }

        @Override
        public void removeTreeItemDataListener(TreeDataListener l) {
            this.lookupValues.removeTreeItemDataListener(l);
        }

        @Override
        public void nodeReleased(Node n) {
            this.lookupValues.nodeReleased(n);
        }
    }
}

