/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.JspLoader;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.UserCancelException;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.CloneableOpenSupport;

class BaseJspEditorSupport
extends DataEditorSupport
implements EditCookie,
EditorCookie.Observable,
OpenCookie,
LineCookie,
CloseCookie,
PrintCookie {
    private static final Logger LOGGER = Logger.getLogger(BaseJspEditorSupport.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(BaseJspEditorSupport.class.getSimpleName(), 4);
    private static final int AUTO_PARSING_DELAY = 2000;
    private static final String DOCUMENT_SAVE_ENCODING = "Document_Save_Encoding";
    private RequestProcessor.Task PARSER_RESTART_TASK;
    private static String defaulEncoding = "UTF-8";
    private final DocumentListener DOCUMENT_LISTENER;
    private final AtomicBoolean encodingVerified = new AtomicBoolean();
    private static final Set<String> UTF_16_CHARSETS = new HashSet<String>();
    private static final Set<String> UTF_32_CHARSETS = new HashSet<String>();

    public BaseJspEditorSupport(JspDataObject obj) {
        super((DataObject)obj, null, (CloneableEditorSupport.Env)new BaseJspEnv(obj));
        DataObject data = this.getDataObject();
        if (data instanceof JspDataObject) {
            this.setMIMEType(JspLoader.getMimeType((JspDataObject)data));
        }
        this.DOCUMENT_LISTENER = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.change(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.change(e);
            }

            private void change(DocumentEvent e) {
                BaseJspEditorSupport.this.restartParserTask();
                TagLibParseSupport sup = (TagLibParseSupport)BaseJspEditorSupport.this.getDataObject().getCookie(TagLibParseSupport.class);
                if (sup != null) {
                    sup.setDocumentDirty(true);
                }
            }
        };
        this.PARSER_RESTART_TASK = RP.create(new Runnable(){

            @Override
            public void run() {
                TagLibParseSupport sup = (TagLibParseSupport)BaseJspEditorSupport.this.getDataObject().getCookie(TagLibParseSupport.class);
                if (sup != null && WebModule.getWebModule((FileObject)BaseJspEditorSupport.this.getDataObject().getPrimaryFile()) != null) {
                    sup.autoParse();
                }
            }
        });
        RP.post(new Runnable(){

            @Override
            public void run() {
                FileObject wmRoot;
                ClassPath cp;
                WebModule webModule = BaseJspEditorSupport.this.getWebModule(BaseJspEditorSupport.this.getDataObject().getPrimaryFile());
                if (webModule != null && (cp = ClassPath.getClassPath((FileObject)(wmRoot = webModule.getDocumentBase()), (String)"classpath/execute")) != null) {
                    cp.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            BaseJspEditorSupport.this.restartParserTask();
                        }
                    }, (Object)cp));
                }
            }
        });
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("document")) {
                    if (evt.getNewValue() != null) {
                        BaseJspEditorSupport.this.restartParserTask();
                        ((Document)evt.getNewValue()).addDocumentListener(BaseJspEditorSupport.this.DOCUMENT_LISTENER);
                    } else {
                        Object oldDoc = evt.getOldValue();
                        if (oldDoc == null) {
                            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "property change fired with both new and old value null!", new IllegalStateException());
                            return;
                        }
                        ((Document)oldDoc).removeDocumentListener(BaseJspEditorSupport.this.DOCUMENT_LISTENER);
                        TagLibParseSupport sup = (TagLibParseSupport)BaseJspEditorSupport.this.getDataObject().getCookie(TagLibParseSupport.class);
                        if (sup != null) {
                            sup.cancelParsingTask();
                        }
                    }
                }
            }
        });
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)this.getDataObject().getPrimaryFile().getMIMEType(), (Serializable)this.getDataObject());
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument doc = super.createStyledDocument(kit);
        Runnable postInitRunnable = (Runnable)doc.getProperty("postInitRunnable");
        if (postInitRunnable != null) {
            postInitRunnable.run();
        }
        return doc;
    }

    private WebModule getWebModule(FileObject fo) {
        FileObject wmRoot;
        WebModule wm = WebModule.getWebModule((FileObject)fo);
        if (wm != null && (wmRoot = wm.getDocumentBase()) != null && (fo == wmRoot || FileUtil.isParentOf((FileObject)wmRoot, (FileObject)fo))) {
            return wm;
        }
        return null;
    }

    void restartParserTask() {
        this.PARSER_RESTART_TASK.schedule(2000);
    }

    private boolean isSupportedEncoding(String encoding) {
        boolean supported;
        try {
            supported = Charset.isSupported(encoding);
        }
        catch (IllegalCharsetNameException e) {
            supported = false;
        }
        return supported;
    }

    protected boolean asynchronousOpen() {
        return true;
    }

    private JspDataObject getJspDataObject() {
        return (JspDataObject)this.getDataObject();
    }

    public void open() {
        super.open();
        if (this.encodingVerified.compareAndSet(false, true)) {
            this.verifyEncoding();
        }
    }

    protected void notifyClosed() {
        this.encodingVerified.set(false);
        super.notifyClosed();
    }

    private void verifyEncoding() {
        String encoding = this.getJspDataObject().getFileEncoding();
        if (!this.isSupportedEncoding(encoding)) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadEncodingDuringLoad", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding, defaulEncoding}), 2);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
        }
    }

    protected boolean notifyModified() {
        boolean notify = super.notifyModified();
        if (!notify) {
            return false;
        }
        JspDataObject obj = (JspDataObject)this.getDataObject();
        if (obj.getCookie(SaveCookie.class) == null) {
            obj.addSaveCookie(new SaveCookie(){

                public void save() throws IOException {
                    try {
                        BaseJspEditorSupport.this.saveDocument();
                    }
                    catch (UserCancelException userCancelException) {
                        // empty catch block
                    }
                }
            });
        }
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JspDataObject obj = (JspDataObject)this.getDataObject();
        obj.removeSaveCookie();
    }

    public void saveAs(FileObject folder, String fileName) throws IOException {
        this.checkFileEncoding();
        super.saveAs(folder, fileName);
    }

    public void saveDocument() throws IOException {
        this.saveDocument(true, true);
    }

    private void saveDocument(boolean parse, boolean forceSave) throws IOException {
        if (forceSave || this.isModified()) {
            TagLibParseSupport sup;
            this.checkFileEncoding();
            super.saveDocument();
            if (parse && (sup = (TagLibParseSupport)this.getDataObject().getCookie(TagLibParseSupport.class)) != null) {
                sup.prepare();
            }
        }
    }

    private void checkFileEncoding() throws UserCancelException {
        ((JspDataObject)this.getDataObject()).updateFileEncoding(true);
        String encoding = ((JspDataObject)this.getDataObject()).getFileEncoding();
        if (!this.isSupportedEncoding(encoding)) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding, defaulEncoding}), 0, 2);
            nd.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                throw new UserCancelException();
            }
        } else {
            try {
                CharsetEncoder coder = Charset.forName(encoding).newEncoder();
                if (!coder.canEncode(this.getDocument().getText(0, this.getDocument().getLength()))) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(BaseJspEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), encoding}), 0, 2);
                    nd.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                    if (nd.getValue() != NotifyDescriptor.YES_OPTION) {
                        throw new UserCancelException();
                    }
                }
            }
            catch (BadLocationException e) {
                Logger.getLogger("global").log(Level.INFO, null, e);
            }
        }
        StyledDocument doc = this.getDocument();
        if (doc != null) {
            doc.putProperty(DOCUMENT_SAVE_ENCODING, encoding);
        }
    }

    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        Parameters.notNull((CharSequence)"doc", (Object)doc);
        Parameters.notNull((CharSequence)"kit", (Object)kit);
        String foundEncoding = (String)doc.getProperty(DOCUMENT_SAVE_ENCODING);
        String encoding = foundEncoding != null ? foundEncoding : defaulEncoding;
        Charset charset = StandardCharsets.UTF_8;
        try {
            charset = Charset.forName(encoding);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
            LOGGER.log(Level.INFO, "Illegal charset found: {0}, defaulted to UTF-8 as warned by dialog", encoding);
        }
        this.writeByteOrderMark(charset, stream);
        super.saveFromKitToStream(doc, kit, stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeByteOrderMark(Charset charset, OutputStream os) throws IOException {
        if (!UTF_16_CHARSETS.contains(charset.name()) && !UTF_32_CHARSETS.contains(charset.name())) {
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, charset);){
            ((Writer)writer).write(65533);
        }
        byte[] buffer = out.toByteArray();
        if (UTF_16_CHARSETS.contains(charset.name()) && buffer.length > 2 || UTF_32_CHARSETS.contains(charset.name()) && buffer.length > 4) {
            return;
        }
        if (UTF_16_CHARSETS.contains(charset.name())) {
            if (buffer.length < 2) {
                return;
            }
            if (buffer[0] == -1 && buffer[1] == -3) {
                os.write(254);
                os.write(255);
            } else if (buffer[0] == -3 && buffer[1] == -1) {
                os.write(255);
                os.write(254);
            }
        } else if (UTF_32_CHARSETS.contains(charset.name())) {
            if (buffer.length < 4) {
                return;
            }
            if (buffer[0] == -1 && buffer[1] == -3 && buffer[2] == 0 && buffer[3] == 0) {
                os.write(0);
                os.write(0);
                os.write(254);
                os.write(255);
            } else if (buffer[0] == 0 && buffer[1] == 0 && buffer[2] == -3 && buffer[3] == -1) {
                os.write(255);
                os.write(254);
                os.write(0);
                os.write(0);
            }
        }
    }

    static {
        Collections.addAll(UTF_16_CHARSETS, "UTF-16", "UTF-16LE", "UTF-16BE");
        Collections.addAll(UTF_32_CHARSETS, "UTF-32", "UTF-32LE", "UTF-32BE");
    }

    public static class BaseJspEditor
    extends CloneableEditor {
        public static final String JSP_MIME_TYPE = "text/x-jsp";
        public static final String TAG_MIME_TYPE = "text/x-tag";
        private TagLibParseSupport taglibParseSupport;
        private InstanceContent instanceContent;

        public boolean isXmlSyntax(DataObject dataObject) {
            FileObject fileObject;
            FileObject fileObject2 = fileObject = dataObject != null ? dataObject.getPrimaryFile() : null;
            if (fileObject == null) {
                return false;
            }
            return this.taglibParseSupport.getCachedOpenInfo(false, false).isXmlSyntax();
        }
    }

    public static class BaseJspEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public BaseJspEnv(JspDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (BaseJspEditorSupport)this.getDataObject().getCookie(BaseJspEditorSupport.class);
        }
    }
}

