/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.javaee.SunMessageDestination;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.payara.common.parser.TreeParser;
import org.netbeans.modules.payara.jakartaee.Hk2DeploymentManager;
import org.netbeans.modules.payara.jakartaee.ResourceModifier;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Hk2MessageDestinationManager
implements MessageDestinationDeployment {
    private Hk2DeploymentManager dm;
    private static final String DOMAIN_XML_PATH = "config/domain.xml";
    public static final String JMS_PREFIX = "jms/";
    public static final String QUEUE = "javax.jms.Queue";
    public static final String TOPIC = "javax.jms.Topic";
    public static final String QUEUE_PROP = "PhysicalQueue";
    public static final String TOPIC_PROP = "PhysicalTopic";
    public static final String QUEUE_CNTN_FACTORY = "javax.jms.QueueConnectionFactory";
    public static final String TOPIC_CNTN_FACTORY = "javax.jms.TopicConnectionFactory";
    private static final Logger LOG = Logger.getLogger("payara-jakartaee");
    private static final String ATTR_JNDINAME = "jndi-name";
    private static final String ATTR_POOLNAME = "pool-name";
    private static final String ATTR_POOL_NAME = "name";
    private static final String AO_TAG_1 = "    <admin-object-resource enabled=\"true\" ";
    private static final String ATTR_RESTYPE = " res-type";
    private static final String AO_TAG_2 = " res-adapter=\"jmsra\">\n";
    private static final String PROP_NAME = "Name";
    private static final String AO_TAG_3 = "    </admin-object-resource>\n";
    private static final String CONNECTOR_POOL_TAG_1 = "    <connector-connection-pool ";
    private static final String ATTR_CONN_DEFINITION = " connection-definition-name";
    private static final String CONNECTOR_POOL_TAG_2 = " resource-adapter-name=\"jmsra\"/>\n";
    private static final String CONNECTOR_TAG_1 = "    <connector-resource enabled=\"true\" ";
    private static final String CONNECTOR_TAG_2 = " />\n";

    public Hk2MessageDestinationManager(Hk2DeploymentManager dm) {
        this.dm = dm;
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        PayaraModule commonSupport = this.dm.getCommonServerSupport();
        String domainsDir = (String)commonSupport.getInstanceProperties().get("domainsfolder");
        String domainName = (String)commonSupport.getInstanceProperties().get("domainname");
        if (null != domainsDir) {
            File domainXml = new File(domainsDir, domainName + File.separatorChar + DOMAIN_XML_PATH);
            return Hk2MessageDestinationManager.readMessageDestinations(domainXml, "/domain/", null);
        }
        return Collections.emptySet();
    }

    public void deployMessageDestinations(Set<MessageDestination> destinations) throws ConfigurationException {
    }

    public static Set<MessageDestination> getMessageDestinations(File resourceDir, String baseName) {
        File resourcesXml = new File(resourceDir, baseName + ".xml");
        return Hk2MessageDestinationManager.readMessageDestinations(resourcesXml, "/", resourceDir);
    }

    private static Set<MessageDestination> readMessageDestinations(File xmlFile, String xPathPrefix, File resourcesDir) {
        HashSet<MessageDestination> msgDestinations = new HashSet<MessageDestination>();
        if (xmlFile.exists()) {
            HashMap<String, AdminObjectResource> aoResourceMap = new HashMap<String, AdminObjectResource>();
            ArrayList<TreeParser.Path> pathList = new ArrayList<TreeParser.Path>();
            pathList.add(new TreeParser.Path(xPathPrefix + "resources/admin-object-resource", (TreeParser.NodeReader)new AdminObjectReader(aoResourceMap)));
            try {
                TreeParser.readXml((File)xmlFile, pathList);
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            for (AdminObjectResource adminObj : aoResourceMap.values()) {
                String type = adminObj.getResType();
                if (type.equals(QUEUE)) {
                    msgDestinations.add((MessageDestination)new SunMessageDestination(adminObj.getJndiName(), MessageDestination.Type.QUEUE, resourcesDir));
                    continue;
                }
                msgDestinations.add((MessageDestination)new SunMessageDestination(adminObj.getJndiName(), MessageDestination.Type.TOPIC, resourcesDir));
            }
        }
        return msgDestinations;
    }

    public static MessageDestination createMessageDestination(String name, MessageDestination.Type type, File resourceDir, String baseName) throws ConfigurationException {
        if (!name.startsWith(JMS_PREFIX)) {
            name = JMS_PREFIX + name;
        }
        DuplicateAOFinder aoFinder = new DuplicateAOFinder(name);
        DuplicateConnectorFinder connFinder = new DuplicateConnectorFinder(name);
        ConnectorPoolFinder cpFinder = new ConnectorPoolFinder();
        File xmlFile = new File(resourceDir, baseName + ".xml");
        if (xmlFile.exists()) {
            ArrayList<TreeParser.Path> pathList = new ArrayList<TreeParser.Path>();
            pathList.add(new TreeParser.Path("/resources/admin-object-resource", (TreeParser.NodeReader)aoFinder));
            pathList.add(new TreeParser.Path("/resources/connector-resource", (TreeParser.NodeReader)connFinder));
            pathList.add(new TreeParser.Path("/resources/connector-connection-pool", (TreeParser.NodeReader)cpFinder));
            TreeParser.readXml((File)xmlFile, pathList);
            if (connFinder.isDuplicate()) {
                throw new ConfigurationException("Resource already exists");
            }
        }
        String connectionFactoryJndiName = name + "Factory";
        String connectionFactoryPoolName = name + "FactoryPool";
        try {
            Hk2MessageDestinationManager.createAdminObject(xmlFile, name, type);
            Hk2MessageDestinationManager.createConnectorConnectionPool(xmlFile, connectionFactoryPoolName, type);
            Hk2MessageDestinationManager.createConnector(xmlFile, connectionFactoryJndiName, connectionFactoryPoolName);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, ex.getLocalizedMessage(), ex);
            throw new ConfigurationException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        SunMessageDestination msgDest = new SunMessageDestination(name, type, resourceDir);
        return msgDest;
    }

    public static void createAdminObject(File sunResourcesXml, String jndiName, MessageDestination.Type type) throws IOException {
        StringBuilder xmlBuilder = new StringBuilder(500);
        xmlBuilder.append(AO_TAG_1);
        ResourceModifier.appendAttr(xmlBuilder, ATTR_JNDINAME, jndiName, false);
        if (MessageDestination.Type.QUEUE.equals((Object)type)) {
            ResourceModifier.appendAttr(xmlBuilder, ATTR_RESTYPE, QUEUE, true);
            xmlBuilder.append(AO_TAG_2);
            ResourceModifier.appendProperty(xmlBuilder, PROP_NAME, QUEUE_PROP, true);
        } else if (MessageDestination.Type.TOPIC.equals((Object)type)) {
            ResourceModifier.appendAttr(xmlBuilder, ATTR_RESTYPE, TOPIC, true);
            xmlBuilder.append(AO_TAG_2);
            ResourceModifier.appendProperty(xmlBuilder, PROP_NAME, TOPIC_PROP, true);
        }
        xmlBuilder.append(AO_TAG_3);
        String xmlFragment = xmlBuilder.toString();
        LOG.log(Level.FINER, "New Connector resource:\n" + xmlFragment);
        ResourceModifier.appendResource(sunResourcesXml, xmlFragment);
    }

    public static void createConnectorConnectionPool(File sunResourcesXml, String poolName, MessageDestination.Type type) throws IOException {
        StringBuilder xmlBuilder = new StringBuilder(500);
        xmlBuilder.append(CONNECTOR_POOL_TAG_1);
        ResourceModifier.appendAttr(xmlBuilder, ATTR_POOL_NAME, poolName, true);
        if (type.equals((Object)MessageDestination.Type.QUEUE)) {
            ResourceModifier.appendAttr(xmlBuilder, ATTR_CONN_DEFINITION, QUEUE_CNTN_FACTORY, true);
        } else if (type.equals((Object)MessageDestination.Type.TOPIC)) {
            ResourceModifier.appendAttr(xmlBuilder, ATTR_CONN_DEFINITION, TOPIC_CNTN_FACTORY, true);
        }
        xmlBuilder.append(CONNECTOR_POOL_TAG_2);
        String xmlFragment = xmlBuilder.toString();
        LOG.log(Level.FINER, "New Connector Connection Pool resource:\n" + xmlFragment);
        ResourceModifier.appendResource(sunResourcesXml, xmlFragment);
    }

    public static void createConnector(File sunResourcesXml, String jndiName, String poolName) throws IOException {
        StringBuilder xmlBuilder = new StringBuilder(500);
        xmlBuilder.append(CONNECTOR_TAG_1);
        ResourceModifier.appendAttr(xmlBuilder, ATTR_JNDINAME, jndiName, true);
        ResourceModifier.appendAttr(xmlBuilder, ATTR_POOLNAME, poolName, true);
        xmlBuilder.append(CONNECTOR_TAG_2);
        String xmlFragment = xmlBuilder.toString();
        LOG.log(Level.FINER, "New Connector resource:\n" + xmlFragment);
        ResourceModifier.appendResource(sunResourcesXml, xmlFragment);
    }

    private static class ConnectorPool {
        private final String poolName;
        private final String raName;
        private final String conndefName;

        public ConnectorPool(String poolName, String raname, String conndefname) {
            this.poolName = poolName;
            this.raName = raname;
            this.conndefName = conndefname;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public String getRaName() {
            return this.raName;
        }

        public String getConndefName() {
            return this.conndefName;
        }
    }

    private static class ConnectorPoolFinder
    extends TreeParser.NodeReader {
        private Map<String, String> properties = null;
        private Map<String, ConnectorPool> pools = new HashMap<String, ConnectorPool>();

        private ConnectorPoolFinder() {
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            this.properties = new HashMap<String, String>();
            String poolName = attributes.getValue(Hk2MessageDestinationManager.ATTR_POOL_NAME);
            if (poolName != null && poolName.length() > 0) {
                if (!this.pools.containsKey(poolName)) {
                    this.properties.put(Hk2MessageDestinationManager.ATTR_POOL_NAME, poolName);
                    this.properties.put("raname", attributes.getValue("resource-adapter-name"));
                    this.properties.put("conndefname", attributes.getValue("connection-definition-name"));
                } else {
                    LOG.log(Level.WARNING, "Duplicate pool-names defined for Resource Adapter Pools: " + poolName);
                }
            }
        }

        public void readChildren(String qname, Attributes attributes) throws SAXException {
            String key;
            if (null != attributes && null != this.properties && (key = attributes.getValue(Hk2MessageDestinationManager.ATTR_POOL_NAME)) != null && key.length() > 0) {
                this.properties.put(key.toLowerCase(Locale.ENGLISH), attributes.getValue("value"));
            }
        }

        public void endNode(String qname) throws SAXException {
            String poolName = this.properties.get(Hk2MessageDestinationManager.ATTR_POOL_NAME);
            ConnectorPool pool = new ConnectorPool(poolName, this.properties.get("raname"), this.properties.get("conndefname"));
            this.pools.put(poolName, pool);
        }

        public List<String> getPoolNames() {
            return new ArrayList<String>(this.pools.keySet());
        }

        public Map<String, ConnectorPool> getPoolData() {
            return Collections.unmodifiableMap(this.pools);
        }
    }

    private static class DuplicateConnectorFinder
    extends TreeParser.NodeReader {
        private final String targetJndiName;
        private boolean duplicate;
        private String poolName;

        public DuplicateConnectorFinder(String jndiName) {
            this.targetJndiName = jndiName;
            this.duplicate = false;
            this.poolName = null;
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String jndiName = attributes.getValue(Hk2MessageDestinationManager.ATTR_JNDINAME);
            if (this.targetJndiName.equals(jndiName)) {
                if (this.duplicate) {
                    LOG.log(Level.WARNING, "Duplicate jndi-names defined for Connector resources.");
                }
                this.duplicate = true;
                this.poolName = attributes.getValue(Hk2MessageDestinationManager.ATTR_POOLNAME);
            }
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public String getPoolName() {
            return this.poolName;
        }
    }

    private static class DuplicateAOFinder
    extends TreeParser.NodeReader {
        private final String targetJndiName;
        private boolean duplicate;
        private String resType;

        public DuplicateAOFinder(String jndiName) {
            this.targetJndiName = jndiName;
            this.duplicate = false;
            this.resType = null;
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String jndiName = attributes.getValue(Hk2MessageDestinationManager.ATTR_JNDINAME);
            if (this.targetJndiName.equals(jndiName)) {
                if (this.duplicate) {
                    LOG.log(Level.WARNING, "Duplicate jndi-names defined for Admin Object resources.");
                }
                this.duplicate = true;
                this.resType = attributes.getValue("res-type");
            }
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public String getResType() {
            return this.resType;
        }
    }

    private static class AdminObjectResource {
        private final String jndiName;
        private final String resType;
        private final String resAdapter;

        public AdminObjectResource(String jndiName, String resType, String resAdapter) {
            this.jndiName = jndiName;
            this.resType = resType;
            this.resAdapter = resAdapter;
        }

        public String getJndiName() {
            return this.jndiName;
        }

        public String getResType() {
            return this.resType;
        }

        public String getResAdapter() {
            return this.resAdapter;
        }
    }

    private static class AdminObjectReader
    extends TreeParser.NodeReader {
        private final Map<String, AdminObjectResource> resourceMap;

        public AdminObjectReader(Map<String, AdminObjectResource> resourceMap) {
            this.resourceMap = resourceMap;
        }

        public void readAttributes(String qname, Attributes attributes) throws SAXException {
            String type = attributes.getValue("object-type");
            if (type != null && type.startsWith("system-")) {
                return;
            }
            String jndiName = attributes.getValue(Hk2MessageDestinationManager.ATTR_JNDINAME);
            String resType = attributes.getValue("res-type");
            String resadapter = attributes.getValue("res-adapter");
            if (jndiName != null && jndiName.length() > 0 && resType != null && resType.length() > 0) {
                this.resourceMap.put(jndiName, new AdminObjectResource(jndiName, resType, resadapter));
            }
        }
    }
}

