/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import com.oracle.bmc.identity.model.Tenancy;
import com.oracle.bmc.model.BmcException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.OCIProfile;
import org.netbeans.modules.cloud.oracle.actions.AbstractPasswordPanel;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletAction;
import org.netbeans.modules.cloud.oracle.actions.DownloadWalletDialog;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentNode;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseNode;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.items.TenancyItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public class AddADBAction
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(AddADBAction.class.getName());
    private static final String DB = "db";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    @Override
    public void actionPerformed(ActionEvent e) {
        final HashMap result = new HashMap();
        NotifyDescriptor.ComposedInput ci = new NotifyDescriptor.ComposedInput(Bundle.AddADB(), 3, new NotifyDescriptor.ComposedInput.Callback(){
            Map<Integer, Map> values = new HashMap<Integer, Map>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public NotifyDescriptor createInput(NotifyDescriptor.ComposedInput input, int number) {
                if (number == 1) {
                    String title;
                    ProgressHandle h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingProfiles());
                    h.start();
                    h.progress(Bundle.MSG_CollectingProfiles_Text());
                    LinkedHashMap<OCIProfile, Tenancy> profiles = new LinkedHashMap<OCIProfile, Tenancy>();
                    LinkedHashMap<String, TenancyItem> tenancyItems = new LinkedHashMap<String, TenancyItem>();
                    try {
                        for (OCIProfile p : OCIManager.getDefault().getConnectedProfiles()) {
                            TenancyItem t = p.getTenancy().orElse(null);
                            if (t == null) continue;
                            Tenancy data = p.getTenancyData();
                            profiles.put(p, data);
                            tenancyItems.put(p.getId(), t);
                        }
                    }
                    finally {
                        h.finish();
                    }
                    if (profiles.size() == 1) {
                        this.values.put(1, AddADBAction.this.getCompartmentsAndDbs(((OCIProfile)profiles.keySet().iterator().next()).getTenancy().get()));
                        title = Bundle.SelectCompartment();
                        return AddADBAction.this.createQuickPick(this.values.get(1), title);
                    }
                    title = Bundle.SelectProfile();
                    ArrayList<NotifyDescriptor.QuickPick.Item> items = new ArrayList<NotifyDescriptor.QuickPick.Item>(profiles.size());
                    for (OCIProfile p : profiles.keySet()) {
                        Tenancy t = (Tenancy)profiles.get(p);
                        items.add(new NotifyDescriptor.QuickPick.Item(p.getId(), Bundle.SelectProfile_Description(t.getName(), t.getHomeRegionKey())));
                    }
                    this.values.put(1, tenancyItems);
                    return new NotifyDescriptor.QuickPick(title, title, items, false);
                }
                NotifyDescriptor prev = input.getInputs()[number - 2];
                OCIItem prevItem = null;
                if (prev instanceof NotifyDescriptor.QuickPick) {
                    for (NotifyDescriptor.QuickPick.Item item : ((NotifyDescriptor.QuickPick)prev).getItems()) {
                        if (!item.isSelected()) continue;
                        prevItem = (OCIItem)this.values.get(number - 1).get(item.getLabel());
                        break;
                    }
                    if (prevItem == null) {
                        return null;
                    }
                    if (prevItem instanceof DatabaseItem) {
                        result.put(AddADBAction.DB, prevItem);
                        return new NotifyDescriptor.InputLine(Bundle.EnterUsername(), Bundle.EnterUsername());
                    }
                    ProgressHandle h = ProgressHandle.createHandle((String)Bundle.MSG_CollectingItems());
                    h.start();
                    h.progress(Bundle.MSG_CollectingItems_Text());
                    try {
                        this.values.put(number, AddADBAction.this.getCompartmentsAndDbs(prevItem));
                        input.setEstimatedNumberOfInputs(input.getEstimatedNumberOfInputs() + 1);
                        NotifyDescriptor.QuickPick quickPick = AddADBAction.this.createQuickPick(this.values.get(number), Bundle.SelectDatabase());
                        return quickPick;
                    }
                    finally {
                        h.finish();
                    }
                }
                if (prev instanceof NotifyDescriptor.PasswordLine) {
                    result.put(AddADBAction.PASSWORD, ((NotifyDescriptor.PasswordLine)prev).getInputText());
                    return null;
                }
                if (prev instanceof NotifyDescriptor.InputLine) {
                    String username = ((NotifyDescriptor.InputLine)prev).getInputText();
                    if (username == null || username.trim().isEmpty()) {
                        return prev;
                    }
                    result.put(AddADBAction.USERNAME, username);
                    return new NotifyDescriptor.PasswordLine(Bundle.EnterPassword(), Bundle.EnterPassword());
                }
                return null;
            }
        });
        if (DialogDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)ci)) {
            try {
                DatabaseItem selectedDatabase = (DatabaseItem)result.get(DB);
                DownloadWalletAction action = new DownloadWalletAction(selectedDatabase);
                DownloadWalletDialog.WalletInfo info = new DownloadWalletDialog.WalletInfo(DownloadWalletDialog.getWalletsDir().getAbsolutePath(), AbstractPasswordPanel.generatePassword(), (String)result.get(USERNAME), ((String)result.get(PASSWORD)).toCharArray());
                action.addConnection(info);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private <T extends OCIItem> NotifyDescriptor.QuickPick createQuickPick(Map<String, T> ociItems, String title) {
        List items = ociItems.values().stream().map(tenancy -> new NotifyDescriptor.QuickPick.Item(tenancy.getName(), tenancy.getDescription())).collect(Collectors.toList());
        return new NotifyDescriptor.QuickPick(title, title, items, false);
    }

    private Map<String, OCIItem> getCompartmentsAndDbs(OCIItem parent) {
        HashMap<String, OCIItem> items = new HashMap<String, OCIItem>();
        try {
            if (parent instanceof CompartmentItem) {
                DatabaseNode.getDatabases().apply((CompartmentItem)parent).forEach(db -> items.put(db.getName(), (OCIItem)db));
            }
        }
        catch (BmcException e) {
            LOGGER.log(Level.SEVERE, "Unable to load compartment list", e);
        }
        CompartmentNode.getCompartments().apply(parent).forEach(c -> items.put(c.getName(), (OCIItem)c));
        return items;
    }
}

