/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.pkcs1;

import de.rub.nds.tlsattacker.attacks.padding.VectorResponse;
import de.rub.nds.tlsattacker.attacks.util.response.EqualityError;
import de.rub.nds.tlsattacker.attacks.util.response.FingerPrintChecker;
import java.util.List;

public class BleichenbacherVulnerabilityMap {
    private final List<VectorResponse> bleichenbacherVectorMap;
    private final EqualityError error;

    public BleichenbacherVulnerabilityMap(List<VectorResponse> bleichenbacherVectorMap, EqualityError error) {
        this.bleichenbacherVectorMap = bleichenbacherVectorMap;
        this.error = error;
    }

    public boolean looksIdentical(BleichenbacherVulnerabilityMap otherMap) {
        if (otherMap.error != this.error) {
            return false;
        }
        block0: for (VectorResponse otherPair : otherMap.bleichenbacherVectorMap) {
            for (VectorResponse ourPair : this.bleichenbacherVectorMap) {
                if (!otherPair.getVector().getName().equals(this)) continue;
                if (FingerPrintChecker.checkEquality(ourPair.getFingerprint(), otherPair.getFingerprint()) == EqualityError.NONE) continue block0;
                return false;
            }
        }
        return true;
    }

    public List<VectorResponse> getBleichenbacherVectorMap() {
        return this.bleichenbacherVectorMap;
    }

    public EqualityError getError() {
        return this.error;
    }
}

