/*
 * Decompiled with CFR 0.152.
 */
package jadx.core;

import jadx.api.ICodeInfo;
import jadx.core.codegen.CodeGen;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.ProcessState;
import jadx.core.dex.visitors.DepthTraversal;
import jadx.core.dex.visitors.IDexTreeVisitor;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.exceptions.JadxRuntimeException;
import org.jetbrains.annotations.NotNull;

public final class ProcessClass {
    private ProcessClass() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void process(ClassNode cls) {
        ClassNode topParentClass = cls.getTopParentClass();
        if (topParentClass != cls) {
            ProcessClass.process(topParentClass);
            return;
        }
        if (cls.getState().isProcessed()) {
            return;
        }
        ClassInfo classInfo = cls.getClassInfo();
        synchronized (classInfo) {
            try {
                if (cls.getState() == ProcessState.NOT_LOADED) {
                    cls.load();
                }
                if (cls.getState() == ProcessState.LOADED) {
                    cls.setState(ProcessState.PROCESS_STARTED);
                    for (IDexTreeVisitor visitor : cls.root().getPasses()) {
                        DepthTraversal.visit(visitor, cls);
                    }
                    cls.setState(ProcessState.PROCESS_COMPLETE);
                }
            }
            catch (Throwable e) {
                ErrorsCounter.classError(cls, e.getClass().getSimpleName(), e);
            }
        }
    }

    @NotNull
    public static ICodeInfo generateCode(ClassNode cls) {
        ClassNode topParentClass = cls.getTopParentClass();
        if (topParentClass != cls) {
            return ProcessClass.generateCode(topParentClass);
        }
        try {
            ProcessClass.process(cls);
            cls.getDependencies().forEach(ProcessClass::process);
            ICodeInfo code = CodeGen.generate(cls);
            cls.unload();
            return code;
        }
        catch (Throwable e) {
            throw new JadxRuntimeException("Failed to generate code for class: " + cls.getFullName(), e);
        }
    }
}

