/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ElementTreePanel
extends JPanel
implements CaretListener,
DocumentListener,
PropertyChangeListener,
TreeSelectionListener {
    protected JTree tree;
    protected JTextComponent editor;
    protected ElementTreeModel treeModel;
    protected boolean updatingSelection;

    public ElementTreePanel(JTextComponent editor) {
        this.editor = editor;
        Document document = editor.getDocument();
        this.treeModel = new ElementTreeModel(document);
        this.tree = new JTree(this.treeModel){

            @Override
            public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                String asString;
                if (!(value instanceof Element)) {
                    return value.toString();
                }
                Element e = (Element)value;
                AttributeSet as = e.getAttributes().copyAttributes();
                if (as != null) {
                    StringBuilder retBuffer = new StringBuilder("[");
                    Enumeration<?> names = as.getAttributeNames();
                    while (names.hasMoreElements()) {
                        Object nextName = names.nextElement();
                        if (nextName == StyleConstants.ResolveAttribute) continue;
                        retBuffer.append(" ");
                        retBuffer.append(nextName);
                        retBuffer.append("=");
                        retBuffer.append(as.getAttribute(nextName));
                    }
                    retBuffer.append(" ]");
                    asString = retBuffer.toString();
                } else {
                    asString = "[ ]";
                }
                if (e.isLeaf()) {
                    return e.getName() + " [" + e.getStartOffset() + ", " + e.getEndOffset() + "] Attributes: " + asString;
                }
                return e.getName() + " [" + e.getStartOffset() + ", " + e.getEndOffset() + "] Attributes: " + asString;
            }
        };
        this.tree.addTreeSelectionListener(this);
        this.tree.setDragEnabled(true);
        this.tree.setRootVisible(false);
        this.tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Dimension getPreferredSize() {
                Dimension retValue = super.getPreferredSize();
                if (retValue != null) {
                    retValue.width += 15;
                }
                return retValue;
            }
        });
        document.addDocumentListener(this);
        editor.addPropertyChangeListener(this);
        editor.addCaretListener(this);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.tree), "Center");
        JLabel label = new JLabel("Elements that make up the current document", 0);
        label.setFont(new Font("Dialog", 1, 14));
        this.add((Component)label, "North");
        this.setPreferredSize(new Dimension(400, 400));
    }

    public void setEditor(JTextComponent editor) {
        if (this.editor == editor) {
            return;
        }
        if (this.editor != null) {
            Document oldDoc = this.editor.getDocument();
            oldDoc.removeDocumentListener(this);
            this.editor.removePropertyChangeListener(this);
            this.editor.removeCaretListener(this);
        }
        this.editor = editor;
        if (editor == null) {
            this.treeModel = null;
            this.tree.setModel(null);
        } else {
            Document newDoc = editor.getDocument();
            newDoc.addDocumentListener(this);
            editor.addPropertyChangeListener(this);
            editor.addCaretListener(this);
            this.treeModel = new ElementTreeModel(newDoc);
            this.tree.setModel(this.treeModel);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource() == this.getEditor() && e.getPropertyName().equals("document")) {
            Document oldDoc = (Document)e.getOldValue();
            Document newDoc = (Document)e.getNewValue();
            oldDoc.removeDocumentListener(this);
            newDoc.addDocumentListener(this);
            this.treeModel = new ElementTreeModel(newDoc);
            this.tree.setModel(this.treeModel);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateTree(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateTree(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateTree(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretUpdate(CaretEvent e) {
        if (!this.updatingSelection) {
            int selBegin = Math.min(e.getDot(), e.getMark());
            int end = Math.max(e.getDot(), e.getMark());
            ArrayList<TreePath> paths = new ArrayList<TreePath>();
            DefaultTreeModel model = this.getTreeModel();
            Object root = model.getRoot();
            int rootCount = model.getChildCount(root);
            for (int counter = 0; counter < rootCount; ++counter) {
                int start = selBegin;
                while (start <= end) {
                    TreePath path = this.getPathForIndex(start, root, (Element)model.getChild(root, counter));
                    Element charElement = (Element)path.getLastPathComponent();
                    paths.add(path);
                    if (start >= charElement.getEndOffset()) {
                        ++start;
                        continue;
                    }
                    start = charElement.getEndOffset();
                }
            }
            int numPaths = paths.size();
            if (numPaths > 0) {
                TreePath[] pathArray = new TreePath[numPaths];
                paths.toArray(pathArray);
                this.updatingSelection = true;
                try {
                    this.getTree().setSelectionPaths(pathArray);
                    this.getTree().scrollPathToVisible(pathArray[0]);
                }
                finally {
                    this.updatingSelection = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selPath;
        Object lastPathComponent;
        if (!this.updatingSelection && this.tree.getSelectionCount() == 1 && !((lastPathComponent = (selPath = this.tree.getSelectionPath()).getLastPathComponent()) instanceof DefaultMutableTreeNode)) {
            Element selElement = (Element)lastPathComponent;
            this.updatingSelection = true;
            try {
                this.getEditor().select(selElement.getStartOffset(), selElement.getEndOffset());
            }
            finally {
                this.updatingSelection = false;
            }
        }
    }

    protected JTree getTree() {
        return this.tree;
    }

    protected JTextComponent getEditor() {
        return this.editor;
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateTree(DocumentEvent event) {
        this.updatingSelection = true;
        try {
            DefaultTreeModel model = this.getTreeModel();
            Object root = model.getRoot();
            for (int counter = model.getChildCount(root) - 1; counter >= 0; --counter) {
                this.updateTree(event, (Element)model.getChild(root, counter));
            }
        }
        finally {
            this.updatingSelection = false;
        }
    }

    protected void updateTree(DocumentEvent event, Element element) {
        DocumentEvent.ElementChange ec = event.getChange(element);
        if (ec != null) {
            int counter;
            int[] indices;
            Object[] removed = ec.getChildrenRemoved();
            Element[] added = ec.getChildrenAdded();
            int startIndex = ec.getIndex();
            if (removed != null && removed.length > 0) {
                indices = new int[removed.length];
                for (counter = 0; counter < removed.length; ++counter) {
                    indices[counter] = startIndex + counter;
                }
                this.getTreeModel().nodesWereRemoved((TreeNode)((Object)element), indices, removed);
            }
            if (added != null && added.length > 0) {
                indices = new int[added.length];
                for (counter = 0; counter < added.length; ++counter) {
                    indices[counter] = startIndex + counter;
                }
                this.getTreeModel().nodesWereInserted((TreeNode)((Object)element), indices);
            }
        }
        if (!element.isLeaf()) {
            int startIndex = element.getElementIndex(event.getOffset());
            int elementCount = element.getElementCount();
            int endIndex = Math.min(elementCount - 1, element.getElementIndex(event.getOffset() + event.getLength()));
            if (startIndex > 0 && startIndex < elementCount && element.getElement(startIndex).getStartOffset() == event.getOffset()) {
                --startIndex;
            }
            if (startIndex != -1 && endIndex != -1) {
                for (int counter = startIndex; counter <= endIndex; ++counter) {
                    this.updateTree(event, element.getElement(counter));
                }
            }
        } else {
            this.getTreeModel().nodeChanged((TreeNode)((Object)element));
        }
    }

    protected TreePath getPathForIndex(int position, Object root, Element rootElement) {
        TreePath path = new TreePath(root);
        Element child = rootElement.getElement(rootElement.getElementIndex(position));
        path = path.pathByAddingChild(rootElement);
        path = path.pathByAddingChild(child);
        while (!child.isLeaf()) {
            child = child.getElement(child.getElementIndex(position));
            path = path.pathByAddingChild(child);
        }
        return path;
    }

    public static class ElementTreeModel
    extends DefaultTreeModel {
        protected Element[] rootElements;

        public ElementTreeModel(Document document) {
            super(new DefaultMutableTreeNode("root"), false);
            this.rootElements = document.getRootElements();
        }

        @Override
        public Object getChild(Object parent, int index) {
            if (parent == this.root) {
                return this.rootElements[index];
            }
            return super.getChild(parent, index);
        }

        @Override
        public int getChildCount(Object parent) {
            if (parent == this.root) {
                return this.rootElements.length;
            }
            return super.getChildCount(parent);
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node == this.root) {
                return false;
            }
            return super.isLeaf(node);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            if (parent == this.root) {
                for (int counter = this.rootElements.length - 1; counter >= 0; --counter) {
                    if (this.rootElements[counter] != child) continue;
                    return counter;
                }
                return -1;
            }
            return super.getIndexOfChild(parent, child);
        }

        @Override
        public void nodeChanged(TreeNode node) {
            if (this.listenerList != null && node != null) {
                int anIndex;
                TreeNode parent = node.getParent();
                if (parent == null && node != this.root) {
                    parent = this.root;
                }
                if (parent != null && (anIndex = this.getIndexOfChild(parent, node)) != -1) {
                    int[] cIndexs = new int[]{anIndex};
                    this.nodesChanged(parent, cIndexs);
                }
            }
        }

        @Override
        protected TreeNode[] getPathToRoot(TreeNode aNode, int depth) {
            TreeNode[] retNodes;
            if (aNode == null) {
                if (depth == 0) {
                    return null;
                }
                retNodes = new TreeNode[depth];
            } else {
                ++depth;
                if (aNode == this.root) {
                    retNodes = new TreeNode[depth];
                } else {
                    TreeNode parent = aNode.getParent();
                    if (parent == null) {
                        parent = this.root;
                    }
                    retNodes = this.getPathToRoot(parent, depth);
                }
                retNodes[retNodes.length - depth] = aNode;
            }
            return retNodes;
        }
    }
}

