/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.template_engine;

import org.openstreetmap.josm.data.osm.search.SearchParseError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.template_engine.Tokenizer;

public class ParseError
extends Exception {
    private final transient Tokenizer.Token unexpectedToken;

    public ParseError(Tokenizer.Token unexpectedToken) {
        super(I18n.tr("Unexpected token ({0}) on position {1}", new Object[]{unexpectedToken.getType(), unexpectedToken.getPosition()}));
        this.unexpectedToken = unexpectedToken;
    }

    public ParseError(Tokenizer.Token unexpectedToken, Tokenizer.TokenType expected) {
        super(I18n.tr("Unexpected token on position {0}. Expected {1}, found {2}", new Object[]{unexpectedToken.getPosition(), expected, unexpectedToken.getType()}));
        this.unexpectedToken = unexpectedToken;
    }

    public ParseError(int position, SearchParseError e) {
        super(I18n.tr("Error while parsing search expression on position {0}", position), e);
        this.unexpectedToken = null;
    }

    public ParseError(String message) {
        super(message);
        this.unexpectedToken = null;
    }

    public Tokenizer.Token getUnexpectedToken() {
        return this.unexpectedToken;
    }

    public static ParseError unexpectedChar(char expected, char found, int position) {
        return new ParseError(I18n.tr("Unexpected char on {0}. Expected {1} found {2}", position, Character.valueOf(expected), Character.valueOf(found)));
    }
}

