/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.clientScope.entity;

import jakarta.persistence.Basic;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import jakarta.persistence.UniqueConstraint;
import jakarta.persistence.Version;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hibernate.annotations.Type;
import org.hibernate.bytecode.enhance.spi.EnhancementInfo;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ManagedEntity;
import org.hibernate.engine.spi.PersistentAttributeInterceptable;
import org.hibernate.engine.spi.PersistentAttributeInterceptor;
import org.keycloak.models.map.client.MapProtocolMapperEntity;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.UuidValidator;
import org.keycloak.models.map.storage.jpa.Constants;
import org.keycloak.models.map.storage.jpa.JpaAttributeEntity;
import org.keycloak.models.map.storage.jpa.JpaRootVersionedEntity;
import org.keycloak.models.map.storage.jpa.clientScope.entity.JpaClientScopeAttributeEntity;
import org.keycloak.models.map.storage.jpa.clientScope.entity.JpaClientScopeMetadata;
import org.keycloak.models.map.storage.jpa.hibernate.jsonb.JsonbType;

@Entity
@Table(name="kc_client_scope", uniqueConstraints={@UniqueConstraint(columnNames={"realmId", "name"})})
@EnhancementInfo(version="6.2.7.Final")
public class JpaClientScopeEntity
extends MapClientScopeEntity.AbstractClientScopeEntity
implements JpaRootVersionedEntity,
ManagedEntity,
PersistentAttributeInterceptable {
    @Id
    @Column
    UUID id;
    @Version
    @Column
    int version;
    @Type(value=JsonbType.class)
    @Column(columnDefinition="jsonb")
    JpaClientScopeMetadata metadata;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    Integer entityVersion;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String realmId;
    @Column(insertable=false, updatable=false)
    @Basic(fetch=FetchType.LAZY)
    String name;
    @OneToMany(mappedBy="root", cascade={CascadeType.PERSIST}, orphanRemoval=true)
    Set<JpaClientScopeAttributeEntity> attributes = new HashSet<JpaClientScopeAttributeEntity>();
    @Transient
    private transient EntityEntry $$_hibernate_entityEntryHolder;
    @Transient
    private transient ManagedEntity $$_hibernate_previousManagedEntity;
    @Transient
    private transient ManagedEntity $$_hibernate_nextManagedEntity;
    @Transient
    private transient PersistentAttributeInterceptor $$_hibernate_attributeInterceptor;

    public JpaClientScopeEntity() {
        this.metadata = new JpaClientScopeMetadata();
    }

    public JpaClientScopeEntity(DeepCloner cloner) {
        this.metadata = new JpaClientScopeMetadata(cloner);
    }

    public JpaClientScopeEntity(UUID id, int version, Integer entityVersion, String realmId, String name) {
        this.$$_hibernate_write_id(id);
        this.$$_hibernate_write_version(version);
        this.$$_hibernate_write_entityVersion(entityVersion);
        this.$$_hibernate_write_realmId(realmId);
        this.$$_hibernate_write_name(name);
        this.metadata = null;
    }

    public boolean isMetadataInitialized() {
        return this.$$_hibernate_read_metadata() != null;
    }

    @Override
    public Integer getEntityVersion() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getEntityVersion();
        }
        return this.$$_hibernate_read_entityVersion();
    }

    @Override
    public void setEntityVersion(Integer entityVersion) {
        this.$$_hibernate_read_metadata().setEntityVersion(entityVersion);
    }

    @Override
    public Integer getCurrentSchemaVersion() {
        return Constants.CURRENT_SCHEMA_VERSION_CLIENT_SCOPE;
    }

    @Override
    public int getVersion() {
        return this.$$_hibernate_read_version();
    }

    public String getId() {
        return this.$$_hibernate_read_id() == null ? null : this.$$_hibernate_read_id().toString();
    }

    public void setId(String id) {
        String validatedId = UuidValidator.validateAndConvert((String)id);
        this.$$_hibernate_write_id(UUID.fromString(validatedId));
    }

    public String getRealmId() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getRealmId();
        }
        return this.$$_hibernate_read_realmId();
    }

    public void setRealmId(String realmId) {
        this.$$_hibernate_read_metadata().setRealmId(realmId);
    }

    public Set<MapProtocolMapperEntity> getProtocolMappers() {
        return this.$$_hibernate_read_metadata().getProtocolMappers();
    }

    public Optional<MapProtocolMapperEntity> getProtocolMapper(String id) {
        return this.$$_hibernate_read_metadata().getProtocolMapper(id);
    }

    public void addProtocolMapper(MapProtocolMapperEntity mapping) {
        this.$$_hibernate_read_metadata().addProtocolMapper(mapping);
    }

    public void removeProtocolMapper(String id) {
        this.$$_hibernate_read_metadata().removeProtocolMapper(id);
    }

    public void addScopeMapping(String id) {
        this.$$_hibernate_read_metadata().addScopeMapping(id);
    }

    public void removeScopeMapping(String id) {
        this.$$_hibernate_read_metadata().removeScopeMapping(id);
    }

    public Collection<String> getScopeMappings() {
        return this.$$_hibernate_read_metadata().getScopeMappings();
    }

    public String getDescription() {
        return this.$$_hibernate_read_metadata().getDescription();
    }

    public void setDescription(String description) {
        this.$$_hibernate_read_metadata().setDescription(description);
    }

    public String getName() {
        if (this.isMetadataInitialized()) {
            return this.$$_hibernate_read_metadata().getName();
        }
        return this.$$_hibernate_read_name();
    }

    public void setName(String name) {
        this.$$_hibernate_read_metadata().setName(name);
    }

    public String getProtocol() {
        return this.$$_hibernate_read_metadata().getProtocol();
    }

    public void setProtocol(String protocol) {
        this.$$_hibernate_read_metadata().setProtocol(protocol);
    }

    public void removeAttribute(String name) {
        this.$$_hibernate_read_attributes().removeIf(attr -> Objects.equals(attr.getName(), name));
    }

    public void setAttribute(String name, List<String> values) {
        this.removeAttribute(name);
        for (String value : values) {
            JpaClientScopeAttributeEntity attribute = new JpaClientScopeAttributeEntity(this, name, value);
            this.$$_hibernate_read_attributes().add(attribute);
        }
    }

    public List<String> getAttribute(String name) {
        return this.$$_hibernate_read_attributes().stream().filter(a -> Objects.equals(a.getName(), name)).map(JpaAttributeEntity::getValue).collect(Collectors.toList());
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (JpaClientScopeAttributeEntity attribute : this.$$_hibernate_read_attributes()) {
            List values = result.getOrDefault(attribute.getName(), new LinkedList());
            values.add(attribute.getValue());
            result.put(attribute.getName(), values);
        }
        return result;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.$$_hibernate_read_attributes().clear();
        if (attributes != null) {
            for (Map.Entry<String, List<String>> attrEntry : attributes.entrySet()) {
                this.setAttribute(attrEntry.getKey(), attrEntry.getValue());
            }
        }
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JpaClientScopeEntity)) {
            return false;
        }
        return Objects.equals(this.getId(), ((JpaClientScopeEntity)obj).getId());
    }

    public Object $$_hibernate_getEntityInstance() {
        return this;
    }

    public EntityEntry $$_hibernate_getEntityEntry() {
        return this.$$_hibernate_entityEntryHolder;
    }

    public void $$_hibernate_setEntityEntry(EntityEntry entityEntry) {
        this.$$_hibernate_entityEntryHolder = entityEntry;
    }

    public ManagedEntity $$_hibernate_getPreviousManagedEntity() {
        return this.$$_hibernate_previousManagedEntity;
    }

    public void $$_hibernate_setPreviousManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_previousManagedEntity = managedEntity;
    }

    public ManagedEntity $$_hibernate_getNextManagedEntity() {
        return this.$$_hibernate_nextManagedEntity;
    }

    public void $$_hibernate_setNextManagedEntity(ManagedEntity managedEntity) {
        this.$$_hibernate_nextManagedEntity = managedEntity;
    }

    public PersistentAttributeInterceptor $$_hibernate_getInterceptor() {
        return this.$$_hibernate_attributeInterceptor;
    }

    public void $$_hibernate_setInterceptor(PersistentAttributeInterceptor persistentAttributeInterceptor) {
        this.$$_hibernate_attributeInterceptor = persistentAttributeInterceptor;
    }

    public UUID $$_hibernate_read_id() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().readObject((Object)this, "id", (Object)this.id);
        }
        return this.id;
    }

    public void $$_hibernate_write_id(UUID uUID) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.id = (UUID)this.$$_hibernate_getInterceptor().writeObject((Object)this, "id", (Object)this.id, (Object)uUID);
            return;
        }
        this.id = uUID;
    }

    public int $$_hibernate_read_version() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().readInt((Object)this, "version", this.version);
        }
        return this.version;
    }

    public void $$_hibernate_write_version(int n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.version = this.$$_hibernate_getInterceptor().writeInt((Object)this, "version", this.version, n);
            return;
        }
        this.version = n;
    }

    public JpaClientScopeMetadata $$_hibernate_read_metadata() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.metadata = (JpaClientScopeMetadata)this.$$_hibernate_getInterceptor().readObject((Object)this, "metadata", (Object)this.metadata);
        }
        return this.metadata;
    }

    public Integer $$_hibernate_read_entityVersion() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().readObject((Object)this, "entityVersion", (Object)this.entityVersion);
        }
        return this.entityVersion;
    }

    public void $$_hibernate_write_entityVersion(Integer n) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.entityVersion = (Integer)this.$$_hibernate_getInterceptor().writeObject((Object)this, "entityVersion", (Object)this.entityVersion, (Object)n);
            return;
        }
        this.entityVersion = n;
    }

    public String $$_hibernate_read_realmId() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "realmId", (Object)this.realmId);
        }
        return this.realmId;
    }

    public void $$_hibernate_write_realmId(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.realmId = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "realmId", (Object)this.realmId, (Object)string);
            return;
        }
        this.realmId = string;
    }

    public String $$_hibernate_read_name() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().readObject((Object)this, "name", (Object)this.name);
        }
        return this.name;
    }

    public void $$_hibernate_write_name(String string) {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.name = (String)this.$$_hibernate_getInterceptor().writeObject((Object)this, "name", (Object)this.name, (Object)string);
            return;
        }
        this.name = string;
    }

    public Set $$_hibernate_read_attributes() {
        if (this.$$_hibernate_getInterceptor() != null) {
            this.attributes = (Set)this.$$_hibernate_getInterceptor().readObject((Object)this, "attributes", this.attributes);
        }
        return this.attributes;
    }
}

