/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization.adapter;

import java.util.Objects;
import org.keycloak.authorization.UserManagedPermissionUtil;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.authorization.adapter.AbstractPermissionTicketModel;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;

public class MapPermissionTicketAdapter
extends AbstractPermissionTicketModel<MapPermissionTicketEntity> {
    private final RealmModel realm;
    private ResourceServer resourceServer;

    public MapPermissionTicketAdapter(RealmModel realm, ResourceServer resourceServer, MapPermissionTicketEntity entity, StoreFactory storeFactory) {
        super(entity, storeFactory);
        Objects.requireNonNull(realm, "realm");
        this.realm = realm;
        this.resourceServer = resourceServer;
    }

    public String getId() {
        return ((MapPermissionTicketEntity)this.entity).getId();
    }

    public String getOwner() {
        return ((MapPermissionTicketEntity)this.entity).getOwner();
    }

    public String getRequester() {
        return ((MapPermissionTicketEntity)this.entity).getRequester();
    }

    public Resource getResource() {
        return this.storeFactory.getResourceStore().findById(this.realm, this.getResourceServer(), ((MapPermissionTicketEntity)this.entity).getResourceId());
    }

    public Scope getScope() {
        if (((MapPermissionTicketEntity)this.entity).getScopeId() == null) {
            return null;
        }
        return this.storeFactory.getScopeStore().findById(this.realm, this.getResourceServer(), ((MapPermissionTicketEntity)this.entity).getScopeId());
    }

    public boolean isGranted() {
        return ((MapPermissionTicketEntity)this.entity).getGrantedTimestamp() != null;
    }

    public Long getCreatedTimestamp() {
        return ((MapPermissionTicketEntity)this.entity).getCreatedTimestamp();
    }

    public Long getGrantedTimestamp() {
        return ((MapPermissionTicketEntity)this.entity).getGrantedTimestamp();
    }

    public void setGrantedTimestamp(Long millis) {
        ((MapPermissionTicketEntity)this.entity).setGrantedTimestamp(millis);
        UserManagedPermissionUtil.updatePolicy((PermissionTicket)this, (StoreFactory)this.storeFactory);
    }

    public ResourceServer getResourceServer() {
        if (this.resourceServer == null) {
            this.resourceServer = this.storeFactory.getResourceServerStore().findById(this.realm, ((MapPermissionTicketEntity)this.entity).getResourceServerId());
        }
        return this.resourceServer;
    }

    public Policy getPolicy() {
        if (((MapPermissionTicketEntity)this.entity).getPolicyId() == null) {
            return null;
        }
        return this.storeFactory.getPolicyStore().findById(this.realm, this.getResourceServer(), ((MapPermissionTicketEntity)this.entity).getPolicyId());
    }

    public void setPolicy(Policy policy) {
        if (policy != null) {
            ((MapPermissionTicketEntity)this.entity).setPolicyId(policy.getId());
        }
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }
}

