/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Content;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.keycloak.admin.ui.rest.RoleMappingResource;
import org.keycloak.admin.ui.rest.model.ClientRole;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.services.resources.admin.permissions.RolePermissionEvaluator;

public class AvailableRoleMappingResource
extends RoleMappingResource {
    private final KeycloakSession session;
    private final RealmModel realm;
    private final AdminPermissionEvaluator auth;

    public AvailableRoleMappingResource(KeycloakSession session, RealmModel realm, AdminPermissionEvaluator auth) {
        super(realm, auth);
        this.realm = realm;
        this.auth = auth;
        this.session = session;
    }

    @GET
    @Path(value="/clientScopes/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all composite client roles for this client scope", description="This endpoint returns all the client role mapping for a specific client scope")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listCompositeClientScopeRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") long first, @QueryParam(value="max") @DefaultValue(value="10") long max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        ClientScopeModel scopeModel = this.realm.getClientScopeById(id);
        if (scopeModel == null) {
            throw new NotFoundException("Could not find client scope");
        }
        this.auth.clients().requireView(scopeModel);
        return this.mapping(((Predicate<RoleModel>)arg_0 -> ((ClientScopeModel)scopeModel).hasDirectScope(arg_0)).negate(), arg_0 -> ((RolePermissionEvaluator)this.auth.roles()).canMapClientScope(arg_0), first, max, search);
    }

    @GET
    @Path(value="/clients/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all composite client roles for this client", description="This endpoint returns all the client role mapping for a specific client")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listCompositeClientRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") long first, @QueryParam(value="max") @DefaultValue(value="10") long max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        ClientModel client = this.realm.getClientById(id);
        if (client == null) {
            throw new NotFoundException("Could not find client");
        }
        this.auth.clients().requireView(client);
        return this.mapping(((Predicate<RoleModel>)arg_0 -> ((ClientModel)client).hasDirectScope(arg_0)).negate(), first, max, search);
    }

    @GET
    @Path(value="/groups/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all composite client roles for this group", description="This endpoint returns all the client role mapping for a specific group")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listCompositeGroupRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") long first, @QueryParam(value="max") @DefaultValue(value="10") long max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        GroupModel group = this.realm.getGroupById(id);
        if (group == null) {
            throw new NotFoundException("Could not find group");
        }
        this.auth.groups().requireView(group);
        return this.mapping(((Predicate<RoleModel>)arg_0 -> ((GroupModel)group).hasDirectRole(arg_0)).negate(), first, max, search);
    }

    @GET
    @Path(value="/users/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all composite client roles for this user", description="This endpoint returns all the client role mapping for a specific user")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listCompositeUserRoleMappings(@PathParam(value="id") String id, @QueryParam(value="first") @DefaultValue(value="0") long first, @QueryParam(value="max") @DefaultValue(value="10") long max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        UserProvider users = Objects.requireNonNull(this.session).users();
        UserModel userModel = users.getUserById(this.realm, id);
        if (userModel == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("User not found");
            }
            throw new ForbiddenException();
        }
        this.auth.users().requireView(userModel);
        return this.mapping(((Predicate<RoleModel>)arg_0 -> ((UserModel)userModel).hasDirectRole(arg_0)).negate(), first, max, search);
    }

    @GET
    @Path(value="/roles/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List all composite client roles", description="This endpoint returns all the client role")
    @APIResponse(responseCode="200", description="", content={@Content(schema=@Schema(implementation=ClientRole.class, type=SchemaType.ARRAY))})
    public final List<ClientRole> listCompositeRoleMappings(@QueryParam(value="first") @DefaultValue(value="0") long first, @QueryParam(value="max") @DefaultValue(value="10") long max, @QueryParam(value="search") @DefaultValue(value="") String search) {
        return this.mapping(o -> true, first, max, search);
    }
}

