/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.provider.Provider;

public interface UserSessionProvider
extends Provider {
    public KeycloakSession getKeycloakSession();

    public AuthenticatedClientSessionModel createClientSession(RealmModel var1, ClientModel var2, UserSessionModel var3);

    default public AuthenticatedClientSessionModel getClientSession(UserSessionModel userSession, ClientModel client, UUID clientSessionId, boolean offline) {
        return this.getClientSession(userSession, client, clientSessionId == null ? null : clientSessionId.toString(), offline);
    }

    public AuthenticatedClientSessionModel getClientSession(UserSessionModel var1, ClientModel var2, String var3, boolean var4);

    default public UserSessionModel createUserSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        return this.createUserSession(null, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId, UserSessionModel.SessionPersistenceState.PERSISTENT);
    }

    public UserSessionModel createUserSession(String var1, RealmModel var2, UserModel var3, String var4, String var5, String var6, boolean var7, String var8, String var9, UserSessionModel.SessionPersistenceState var10);

    public UserSessionModel getUserSession(RealmModel var1, String var2);

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel var1, UserModel var2);

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel var1, ClientModel var2);

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel var1, ClientModel var2, Integer var3, Integer var4);

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel var1, String var2);

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel var1, String var2);

    public UserSessionModel getUserSessionWithPredicate(RealmModel var1, String var2, boolean var3, Predicate<UserSessionModel> var4);

    public long getActiveUserSessions(RealmModel var1, ClientModel var2);

    public Map<String, Long> getActiveClientSessionStats(RealmModel var1, boolean var2);

    public void removeUserSession(RealmModel var1, UserSessionModel var2);

    public void removeUserSessions(RealmModel var1, UserModel var2);

    public void removeAllExpired();

    public void removeExpired(RealmModel var1);

    public void removeUserSessions(RealmModel var1);

    public void onRealmRemoved(RealmModel var1);

    public void onClientRemoved(RealmModel var1, ClientModel var2);

    public UserSessionModel createOfflineUserSession(UserSessionModel var1);

    public UserSessionModel getOfflineUserSession(RealmModel var1, String var2);

    public void removeOfflineUserSession(RealmModel var1, UserSessionModel var2);

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel var1, UserSessionModel var2);

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel var1, UserModel var2);

    public UserSessionModel getOfflineUserSessionByBrokerSessionId(RealmModel var1, String var2);

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel var1, String var2);

    public long getOfflineSessionsCount(RealmModel var1, ClientModel var2);

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel var1, ClientModel var2, Integer var3, Integer var4);

    public void importUserSessions(Collection<UserSessionModel> var1, boolean var2);

    @Override
    public void close();

    public int getStartupTime(RealmModel var1);
}

