/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.ValidSingleResponseCollector;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.irac.IracManager;

public class IracTombstoneRemoteSiteCheckCommand
extends XSiteReplicateCommand<IntSet> {
    public static final byte COMMAND_ID = 38;
    private List<Object> keys;

    public IracTombstoneRemoteSiteCheckCommand() {
        super((byte)38, null);
    }

    public IracTombstoneRemoteSiteCheckCommand(ByteString cacheName) {
        super((byte)38, cacheName);
    }

    public IracTombstoneRemoteSiteCheckCommand(ByteString cacheName, List<Object> keys) {
        super((byte)38, cacheName);
        this.keys = keys;
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    public CompletionStage<IntSet> invokeAsync(ComponentRegistry registry) {
        int numberOfKeys = this.keys.size();
        IntSet toKeepIndexes = IntSets.mutableEmptySet((int)numberOfKeys);
        LocalizedCacheTopology topology = registry.getDistributionManager().getCacheTopology();
        IracManager iracManager = registry.getIracManager().running();
        for (int index = 0; index < numberOfKeys; ++index) {
            Object key = this.keys.get(index);
            if (topology.getDistribution(key).isPrimary() && !iracManager.containsKey(key)) continue;
            toKeepIndexes.set(index);
        }
        return CompletableFuture.completedFuture(toKeepIndexes);
    }

    @Override
    public byte getCommandId() {
        return 38;
    }

    @Override
    public CompletionStage<IntSet> performInLocalSite(ComponentRegistry registry, boolean preserveOrder) {
        LocalizedCacheTopology topology = registry.getDistributionManager().getCacheTopology();
        IracManager iracManager = registry.getIracManager().running();
        RpcManager rpcManager = registry.getRpcManager().running();
        RpcOptions rpcOptions = rpcManager.getSyncRpcOptions();
        int numberOfKeys = this.keys.size();
        HashMap<Address, IntSetResponseCollector> primaryOwnerKeys = new HashMap<Address, IntSetResponseCollector>(rpcManager.getMembers().size());
        IntSet toKeepIndexes = IntSets.concurrentSet((int)numberOfKeys);
        for (int index = 0; index < numberOfKeys; ++index) {
            Object key = this.keys.get(index);
            DistributionInfo dInfo = topology.getDistribution(key);
            if (dInfo.isPrimary()) {
                if (!iracManager.containsKey(key)) continue;
                toKeepIndexes.set(index);
                continue;
            }
            IntSetResponseCollector collector = primaryOwnerKeys.computeIfAbsent(dInfo.primary(), a -> new IntSetResponseCollector(numberOfKeys, toKeepIndexes));
            collector.add(index, key);
        }
        if (primaryOwnerKeys.isEmpty()) {
            return CompletableFuture.completedFuture(toKeepIndexes);
        }
        AggregateCompletionStage<IntSet> stage = CompletionStages.aggregateCompletionStage(toKeepIndexes);
        for (Map.Entry entry : primaryOwnerKeys.entrySet()) {
            IracTombstoneRemoteSiteCheckCommand cmd = new IracTombstoneRemoteSiteCheckCommand(this.cacheName, ((IntSetResponseCollector)entry.getValue()).getKeys());
            stage.dependsOn(rpcManager.invokeCommand((Address)entry.getKey(), (ReplicableCommand)cmd, (ResponseCollector)entry.getValue(), rpcOptions));
        }
        return stage.freeze();
    }

    @Override
    public CompletionStage<IntSet> performInLocalSite(BackupReceiver receiver, boolean preserveOrder) {
        throw new IllegalStateException("Should never be invoked!");
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.keys, (ObjectOutput)output);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.keys = (List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    @Override
    public String toString() {
        return "IracSiteTombstoneCheckCommand{cacheName=" + this.cacheName + ", keys=" + this.keys.stream().map(Util::toStr).collect(Collectors.joining(",")) + "}";
    }

    private static class IntSetResponseCollector
    extends ValidSingleResponseCollector<Void> {
        private final List<Object> keys;
        private final int[] keyIndexes;
        private final IntSet globalToKeepIndexes;
        private int nextInsertPosition;

        private IntSetResponseCollector(int maxCapacity, IntSet globalToKeepIndexes) {
            this.keys = new ArrayList<Object>(maxCapacity);
            this.keyIndexes = new int[maxCapacity];
            this.globalToKeepIndexes = globalToKeepIndexes;
        }

        void add(int index, Object key) {
            assert (this.nextInsertPosition < this.keyIndexes.length);
            this.keys.add(key);
            this.keyIndexes[this.nextInsertPosition++] = index;
        }

        List<Object> getKeys() {
            return this.keys;
        }

        @Override
        protected Void withValidResponse(Address sender, ValidResponse response) {
            Object rsp = response.getResponseValue();
            assert (rsp instanceof IntSet);
            IntSet toKeep = (IntSet)rsp;
            PrimitiveIterator.OfInt it = toKeep.iterator();
            while (it.hasNext()) {
                int localPosition = it.nextInt();
                assert (localPosition < this.keyIndexes.length);
                this.globalToKeepIndexes.set(this.keyIndexes[localPosition]);
            }
            return null;
        }

        @Override
        protected Void withException(Address sender, Exception exception) {
            this.markAllToKeep();
            return null;
        }

        @Override
        protected Void targetNotFound(Address sender) {
            this.markAllToKeep();
            return null;
        }

        private void markAllToKeep() {
            for (int index : this.keyIndexes) {
                this.globalToKeepIndexes.set(index);
            }
        }
    }
}

