/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.Incubating;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.FunctionContributor;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.query.hql.HqlTranslator;
import org.hibernate.query.hql.internal.StandardHqlTranslator;
import org.hibernate.query.hql.spi.SqmCreationOptions;
import org.hibernate.query.internal.QueryInterpretationCacheDisabledImpl;
import org.hibernate.query.internal.QueryInterpretationCacheStandardImpl;
import org.hibernate.query.named.NamedObjectRepository;
import org.hibernate.query.spi.QueryEngineOptions;
import org.hibernate.query.spi.QueryInterpretationCache;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.query.sqm.internal.SqmCreationOptionsStandard;
import org.hibernate.query.sqm.internal.SqmCriteriaNodeBuilder;
import org.hibernate.query.sqm.spi.SqmCreationContext;
import org.hibernate.query.sqm.sql.SqmTranslatorFactory;
import org.hibernate.query.sqm.sql.StandardSqmTranslatorFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

@Incubating
public class QueryEngine {
    public static final int DEFAULT_QUERY_PLAN_MAX_COUNT = 2048;
    private static final Logger LOG_HQL_FUNCTIONS = CoreLogging.logger("org.hibernate.HQL_FUNCTIONS");
    private final NamedObjectRepository namedObjectRepository;
    private final NativeQueryInterpreter nativeQueryInterpreter;
    private final QueryInterpretationCache interpretationCache;
    private final SqmCriteriaNodeBuilder criteriaBuilder;
    private final HqlTranslator hqlTranslator;
    private final SqmTranslatorFactory sqmTranslatorFactory;
    private final SqmFunctionRegistry sqmFunctionRegistry;
    private final TypeConfiguration typeConfiguration;

    public static QueryEngine from(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata) {
        SessionFactoryOptions options = sessionFactory.getSessionFactoryOptions();
        Dialect dialect = sessionFactory.getJdbcServices().getDialect();
        return new QueryEngine(sessionFactory, metadata.getTypeConfiguration(), QueryEngine.resolveHqlTranslator(options, dialect, sessionFactory, new SqmCreationOptionsStandard(options)), QueryEngine.resolveSqmTranslatorFactory(options, dialect), QueryEngine.createFunctionRegistry(sessionFactory, metadata, options, dialect), metadata.buildNamedQueryRepository(sessionFactory), QueryEngine.buildInterpretationCache(sessionFactory::getStatistics, sessionFactory.getProperties()));
    }

    private static SqmFunctionRegistry createFunctionRegistry(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata, QueryEngineOptions queryEngineOptions, Dialect dialect) {
        SqmFunctionRegistry sqmFunctionRegistry = metadata.getFunctionRegistry();
        queryEngineOptions.getCustomSqlFunctionMap().forEach(sqmFunctionRegistry::register);
        SqmFunctionRegistry customSqmFunctionRegistry = queryEngineOptions.getCustomSqmFunctionRegistry();
        if (customSqmFunctionRegistry != null) {
            customSqmFunctionRegistry.overlay(sqmFunctionRegistry);
        }
        FunctionContributionsImpl functionContributions = new FunctionContributionsImpl(sessionFactory.getServiceRegistry(), metadata.getTypeConfiguration(), sqmFunctionRegistry);
        for (FunctionContributor contributor : QueryEngine.sortedFunctionContributors(sessionFactory.getServiceRegistry())) {
            contributor.contributeFunctions(functionContributions);
        }
        dialect.initializeFunctionRegistry(functionContributions);
        if (LOG_HQL_FUNCTIONS.isDebugEnabled()) {
            sqmFunctionRegistry.getFunctionsByName().forEach(entry -> LOG_HQL_FUNCTIONS.debug((Object)((SqmFunctionDescriptor)entry.getValue()).getSignature((String)entry.getKey())));
        }
        return sqmFunctionRegistry;
    }

    private QueryEngine(SessionFactoryImplementor sessionFactory, TypeConfiguration typeConfiguration, HqlTranslator hqlTranslator, SqmTranslatorFactory sqmTranslatorFactory, SqmFunctionRegistry functionRegistry, NamedObjectRepository namedObjectRepository, QueryInterpretationCache interpretationCache) {
        this.typeConfiguration = typeConfiguration;
        this.sqmFunctionRegistry = functionRegistry;
        this.sqmTranslatorFactory = sqmTranslatorFactory;
        this.hqlTranslator = hqlTranslator;
        this.namedObjectRepository = namedObjectRepository;
        this.interpretationCache = interpretationCache;
        this.nativeQueryInterpreter = sessionFactory.getServiceRegistry().getService(NativeQueryInterpreter.class);
        SessionFactoryOptions sessionFactoryOptions = sessionFactory.getSessionFactoryOptions();
        this.criteriaBuilder = new SqmCriteriaNodeBuilder(sessionFactory.getUuid(), sessionFactory.getName(), this, sessionFactoryOptions.getJpaCompliance().isJpaQueryComplianceEnabled(), sessionFactoryOptions.getCriteriaValueHandlingMode(), sessionFactory.getServiceRegistry(), () -> sessionFactory);
    }

    private static HqlTranslator resolveHqlTranslator(QueryEngineOptions runtimeOptions, Dialect dialect, SqmCreationContext sqmCreationContext, SqmCreationOptions sqmCreationOptions) {
        if (runtimeOptions.getCustomHqlTranslator() != null) {
            return runtimeOptions.getCustomHqlTranslator();
        }
        if (dialect.getHqlTranslator() != null) {
            return dialect.getHqlTranslator();
        }
        return new StandardHqlTranslator(sqmCreationContext, sqmCreationOptions);
    }

    private static SqmTranslatorFactory resolveSqmTranslatorFactory(QueryEngineOptions runtimeOptions, Dialect dialect) {
        if (runtimeOptions.getCustomSqmTranslatorFactory() != null) {
            return runtimeOptions.getCustomSqmTranslatorFactory();
        }
        if (dialect.getSqmTranslatorFactory() != null) {
            return dialect.getSqmTranslatorFactory();
        }
        return new StandardSqmTranslatorFactory();
    }

    private static List<FunctionContributor> sortedFunctionContributors(ServiceRegistry serviceRegistry) {
        ArrayList<FunctionContributor> contributors = new ArrayList<FunctionContributor>(serviceRegistry.getService(ClassLoaderService.class).loadJavaServices(FunctionContributor.class));
        contributors.sort(Comparator.comparingInt(FunctionContributor::ordinal).thenComparing(a -> a.getClass().getCanonicalName()));
        return contributors;
    }

    private static QueryInterpretationCache buildInterpretationCache(Supplier<StatisticsImplementor> statisticsSupplier, Map<String, Object> properties) {
        boolean explicitUseCache = ConfigurationHelper.getBoolean("hibernate.query.plan_cache_enabled", properties, true);
        Integer explicitMaxPlanSize = ConfigurationHelper.getInteger("hibernate.query.plan_cache_max_size", properties);
        if (explicitUseCache || explicitMaxPlanSize != null && explicitMaxPlanSize > 0) {
            int size = explicitMaxPlanSize != null ? explicitMaxPlanSize : 2048;
            return new QueryInterpretationCacheStandardImpl(size, statisticsSupplier);
        }
        return new QueryInterpretationCacheDisabledImpl(statisticsSupplier);
    }

    public void prepare(SessionFactoryImplementor sessionFactory, Metadata bootMetamodel) {
        this.namedObjectRepository.prepare(sessionFactory, bootMetamodel);
    }

    public void validateNamedQueries() {
        this.namedObjectRepository.validateNamedQueries(this);
    }

    public NamedObjectRepository getNamedObjectRepository() {
        return this.namedObjectRepository;
    }

    public SqmCriteriaNodeBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public HqlTranslator getHqlTranslator() {
        return this.hqlTranslator;
    }

    public SqmTranslatorFactory getSqmTranslatorFactory() {
        return this.sqmTranslatorFactory;
    }

    public NativeQueryInterpreter getNativeQueryInterpreter() {
        return this.nativeQueryInterpreter;
    }

    public QueryInterpretationCache getInterpretationCache() {
        return this.interpretationCache;
    }

    public SqmFunctionRegistry getSqmFunctionRegistry() {
        return this.sqmFunctionRegistry;
    }

    public TypeConfiguration getTypeConfiguration() {
        return this.typeConfiguration;
    }

    public void close() {
        if (this.namedObjectRepository != null) {
            this.namedObjectRepository.close();
        }
        if (this.criteriaBuilder != null) {
            this.criteriaBuilder.close();
        }
        if (this.hqlTranslator != null) {
            this.hqlTranslator.close();
        }
        if (this.interpretationCache != null) {
            this.interpretationCache.close();
        }
        if (this.sqmFunctionRegistry != null) {
            this.sqmFunctionRegistry.close();
        }
    }

    private static class FunctionContributionsImpl
    implements FunctionContributions {
        private final ServiceRegistry serviceRegistry;
        private final TypeConfiguration typeConfiguration;
        private final SqmFunctionRegistry functionRegistry;

        public FunctionContributionsImpl(ServiceRegistry serviceRegistry, TypeConfiguration typeConfiguration, SqmFunctionRegistry functionRegistry) {
            this.serviceRegistry = serviceRegistry;
            this.typeConfiguration = typeConfiguration;
            this.functionRegistry = functionRegistry;
        }

        @Override
        public TypeConfiguration getTypeConfiguration() {
            return this.typeConfiguration;
        }

        @Override
        public SqmFunctionRegistry getFunctionRegistry() {
            return this.functionRegistry;
        }

        @Override
        public ServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }
    }
}

