/*
 * Decompiled with CFR 0.152.
 */
package liquibase.logging.core;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.logging.LogLevel;
import liquibase.logging.core.AbstractLogger;
import liquibase.logging.core.DefaultLoggerConfiguration;
import liquibase.util.StringUtils;

public class DefaultLogger
extends AbstractLogger {
    private String name = "liquibase";
    private PrintStream err = System.err;

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public LogLevel getLogLevel() {
        LogLevel logLevel = super.getLogLevel();
        if (logLevel == null) {
            return this.toLogLevel(LiquibaseConfiguration.getInstance().getConfiguration(DefaultLoggerConfiguration.class).getLogLevel());
        }
        return logLevel;
    }

    @Override
    public void setLogLevel(String logLevel, String logFile) {
        this.setLogLevel(logLevel);
        if (logFile != null) {
            File log = new File(logFile);
            try {
                if (!log.exists() && !log.createNewFile()) {
                    throw new RuntimeException("Could not create logFile " + log.getAbsolutePath());
                }
                this.err = new PrintStream(log);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void severe(String message) {
        if (this.getLogLevel().compareTo(LogLevel.SEVERE) <= 0) {
            this.print(LogLevel.SEVERE, message);
        }
    }

    protected void print(LogLevel logLevel, String message) {
        if (StringUtils.trimToNull(message) == null) {
            return;
        }
        this.err.println((Object)((Object)logLevel) + " " + DateFormat.getDateTimeInstance(3, 3).format(new Date()) + ": " + this.name + ": " + this.buildMessage(message));
    }

    @Override
    public void severe(String message, Throwable e) {
        if (this.getLogLevel().compareTo(LogLevel.SEVERE) <= 0) {
            this.print(LogLevel.SEVERE, message);
            e.printStackTrace(this.err);
        }
    }

    @Override
    public void warning(String message) {
        if (this.getLogLevel().compareTo(LogLevel.WARNING) <= 0) {
            this.print(LogLevel.WARNING, message);
        }
    }

    @Override
    public void warning(String message, Throwable e) {
        if (this.getLogLevel().compareTo(LogLevel.WARNING) <= 0) {
            this.print(LogLevel.WARNING, message);
            e.printStackTrace(this.err);
        }
    }

    @Override
    public void info(String message) {
        if (this.getLogLevel().compareTo(LogLevel.INFO) <= 0) {
            this.print(LogLevel.INFO, message);
        }
    }

    @Override
    public void info(String message, Throwable e) {
        if (this.getLogLevel().compareTo(LogLevel.INFO) <= 0) {
            this.print(LogLevel.INFO, message);
            e.printStackTrace(this.err);
        }
    }

    @Override
    public void debug(String message) {
        if (this.getLogLevel().compareTo(LogLevel.DEBUG) <= 0) {
            this.print(LogLevel.DEBUG, message);
        }
    }

    @Override
    public void debug(String message, Throwable e) {
        if (this.getLogLevel().compareTo(LogLevel.DEBUG) <= 0) {
            this.print(LogLevel.DEBUG, message);
            e.printStackTrace(this.err);
        }
    }
}

