/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.MatchError;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005mb\u0001\u0002\r\u001a\u0001yA\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\to\u0001\u0011\t\u0011)A\u0005c!A\u0001\b\u0001BC\u0002\u0013\u0005\u0011\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003;\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005=\"A!\r\u0001B\u0001B\u0003%1\rC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0004z\u0001\t\u0007I\u0011\u0002>\t\r}\u0004\u0001\u0015!\u0003|\u0011%\t\t\u0001\u0001b\u0001\n\u0013\t\u0019\u0001\u0003\u0005\u0002\f\u0001\u0001\u000b\u0011BA\u0003\u0011%\ti\u0001\u0001a\u0001\n\u0013\ty\u0001C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003\u0002\u001a!A\u0011Q\u0005\u0001!B\u0013\t\t\u0002C\u0004\u00020\u0001!\t!!\r\t\u000f\u0005M\u0002\u0001\"\u0003\u00022!9\u0011Q\u0007\u0001\u0005\u0002\u0005E\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\u0007\u0005\b\u0003s\u0001A\u0011AA\u0019\u0005MY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0015\tQ2$\u0001\u0004tKJ4XM\u001d\u0006\u00029\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001 O)\u0002\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\t1\fgn\u001a\u0006\u0002I\u0005!!.\u0019<b\u0013\t1\u0013E\u0001\u0004PE*,7\r\u001e\t\u0003A!J!!K\u0011\u0003\u0011I+hN\\1cY\u0016\u0004\"a\u000b\u0018\u000e\u00031R!!L\u000e\u0002\u000bU$\u0018\u000e\\:\n\u0005=b#a\u0002'pO\u001eLgnZ\u0001\u0003S\u0012\u0004\"AM\u001b\u000e\u0003MR\u0011\u0001N\u0001\u0006g\u000e\fG.Y\u0005\u0003mM\u00121!\u00138u\u0003!\u0011'o\\6fe&#\u0017AE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ,\u0012A\u000f\t\u0003w\u0011k\u0011\u0001\u0010\u0006\u0003{y\nAaY8sK*\u0011q\bQ\u0001\b[\u0016$(/[2t\u0015\t\t%)\u0001\u0004zC6lWM\u001d\u0006\u0002\u0007\u0006\u00191m\\7\n\u0005\u0015c$!B'fi\u0016\u0014\u0018aE1hOJ,w-\u0019;f\u0013\u0012dW-T3uKJ\u0004\u0013a\u0005;pi\u0006d\u0007*\u00198eY\u0016\u0014H\u000b\u001b:fC\u0012\u001cX#A%\u0011\u0005)\u000bV\"A&\u000b\u00051k\u0015AB1u_6L7M\u0003\u0002O\u001f\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005A\u001b\u0013\u0001B;uS2L!AU&\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003Q!x\u000e^1m\u0011\u0006tG\r\\3s)\"\u0014X-\u00193tA\u0005q!/Z9vKN$8\t[1o]\u0016dW#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e[\u0012a\u00028fi^|'o[\u0005\u00037b\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.A\bsKF,Xm\u001d;DQ\u0006tg.\u001a7!\u0003\u0011\t\u0007/[:\u0011\u0005}\u0003W\"A\r\n\u0005\u0005L\"!E!qSJ+\u0017/^3ti\"\u000bg\u000e\u001a7fe\u0006!A/[7f!\t!W.D\u0001f\u0015\ticM\u0003\u0002hQ\u000611m\\7n_:T!\u0001H5\u000b\u0005)\\\u0017AB1qC\u000eDWMC\u0001m\u0003\ry'oZ\u0005\u0003]\u0016\u0014A\u0001V5nK\u00061A(\u001b8jiz\"\u0002\"\u001d:tiV4x\u000f\u001f\t\u0003?\u0002AQ\u0001M\u0006A\u0002EBQaN\u0006A\u0002EBQ\u0001O\u0006A\u0002iBQaR\u0006A\u0002%CQ\u0001V\u0006A\u0002YCQ!X\u0006A\u0002yCQAY\u0006A\u0002\r\f\u0001c\u001d5vi\u0012|wO\\\"p[BdW\r^3\u0016\u0003m\u0004\"\u0001`?\u000e\u00035K!A`'\u0003\u001d\r{WO\u001c;E_^tG*\u0019;dQ\u0006\t2\u000f[;uI><hnQ8na2,G/\u001a\u0011\u0002\u0019I,\u0017/^3ti2{7-\u00197\u0016\u0005\u0005\u0015\u0001cA0\u0002\b%\u0019\u0011\u0011B\r\u0003\u0019I+\u0017/^3ti2{7-\u00197\u0002\u001bI,\u0017/^3ti2{7-\u00197!\u0003\u001d\u0019Ho\u001c9qK\u0012,\"!!\u0005\u0011\u0007I\n\u0019\"C\u0002\u0002\u0016M\u0012qAQ8pY\u0016\fg.A\u0006ti>\u0004\b/\u001a3`I\u0015\fH\u0003BA\u000e\u0003C\u00012AMA\u000f\u0013\r\tyb\r\u0002\u0005+:LG\u000fC\u0005\u0002$E\t\t\u00111\u0001\u0002\u0012\u0005\u0019\u0001\u0010J\u0019\u0002\u0011M$x\u000e\u001d9fI\u0002B3AEA\u0015!\r\u0011\u00141F\u0005\u0004\u0003[\u0019$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0007I,h\u000e\u0006\u0002\u0002\u001c\u0005\u00012m\\7qY\u0016$Xm\u00155vi\u0012|wO\\\u0001\u0005gR|\u0007/\u0001\tj]&$\u0018.\u0019;f'\",H\u000fZ8x]\u0006i\u0011m^1jiNCW\u000f\u001e3po:\u0004")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        while (!this.stopped()) {
            long startSelectTime = this.time.nanoseconds();
            RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(300L);
            long endTime = this.time.nanoseconds();
            long idleTime = endTime - startSelectTime;
            this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
            if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
                this.completeShutdown();
                return;
            }
            if (req instanceof RequestChannel.Request) {
                RequestChannel.Request request = (RequestChannel.Request)req;
                try {
                    try {
                        request.requestDequeueTimeNanos_$eq(endTime);
                        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                        this.apis.handle(request, this.requestLocal());
                        continue;
                    }
                    catch (FatalExitError e) {
                        this.completeShutdown();
                        throw Exit$.MODULE$.exit(e.statusCode(), Exit$.MODULE$.exit$default$2());
                    }
                    catch (Throwable e) {
                        this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                        continue;
                    }
                }
                finally {
                    request.releaseBuffer();
                    continue;
                }
            }
            if (req == null) continue;
            throw new MatchError((Object)req);
        }
        this.completeShutdown();
    }

    private void completeShutdown() {
        this.requestLocal().close();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public KafkaRequestHandler(int id, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(new StringBuilder(37).append("[Kafka Request Handler ").append(id).append(" on Broker ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.stopped = false;
    }
}

