/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.BlockingSend;
import kafka.server.KafkaConfig;
import kafka.server.LeaderEndPoint;
import kafka.server.PartitionFetchState;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaQuota;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.FetchSessionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\u0010 \u0001\u0011B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"IQ\t\u0001BC\u0002\u0013\u0005qD\u0012\u0005\t%\u0002\u0011\t\u0011)A\u0005\u000f\"A1\u000b\u0001B\u0001B\u0003%A\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011!Y\u0006A!A!\u0002\u0013a\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u00021\t\u000b)\u0004A\u0011A6\t\u000fQ\u0004!\u0019!C\u0005k\"1a\u0010\u0001Q\u0001\nYDqa \u0001C\u0002\u0013%Q\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002<\t\u0011\u0005\r\u0001A1A\u0005\nUDq!!\u0002\u0001A\u0003%a\u000f\u0003\u0005\u0002\b\u0001\u0011\r\u0011\"\u0003v\u0011\u001d\tI\u0001\u0001Q\u0001\nYDq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002\u0016\u0001!\t%a\u0006\t\u000f\u0005}\u0001\u0001\"\u0011\u0002\u0018!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0002bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003W\u0002A\u0011IA7\u0011\u001d\t\u0019\t\u0001C!\u0003\u000bCq!a#\u0001\t\u0013\ti\tC\u0004\u0002\u0018\u0002!\t%!'\t\u000f\u0005=\u0007\u0001\"\u0011\u0002R\"9\u0011q \u0001\u0005\n\t\u0005\u0001b\u0002B\u0006\u0001\u0011\u0005#Q\u0002\u0002\u0015%\u0016lw\u000e^3MK\u0006$WM]#oIB{\u0017N\u001c;\u000b\u0005\u0001\n\u0013AB:feZ,'OC\u0001#\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A\u0013,_A\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\u0004\"\u0001L\u0017\u000e\u0003}I!AL\u0010\u0003\u001d1+\u0017\rZ3s\u000b:$\u0007k\\5oiB\u0011\u0001gM\u0007\u0002c)\u0011!'I\u0001\u0006kRLGn]\u0005\u0003iE\u0012q\u0001T8hO&tw-A\u0005m_\u001e\u0004&/\u001a4jqB\u0011qG\u0010\b\u0003qq\u0002\"!O\u0014\u000e\u0003iR!aO\u0012\u0002\rq\u0012xn\u001c;?\u0013\tit%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u007f\u0001\u0013aa\u0015;sS:<'BA\u001f(\u00039\u0011Gn\\2lS:<7+\u001a8eKJ\u0004\"\u0001L\"\n\u0005\u0011{\"\u0001\u0004\"m_\u000e\\\u0017N\\4TK:$\u0017a\u00054fi\u000eD7+Z:tS>t\u0007*\u00198eY\u0016\u0014X#A$\u0011\u0005!\u0003V\"A%\u000b\u0005)[\u0015aB2mS\u0016tGo\u001d\u0006\u0003E1S!!\u0014(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0015aA8sO&\u0011\u0011+\u0013\u0002\u0014\r\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM]\u0001\u0015M\u0016$8\r[*fgNLwN\u001c%b]\u0012dWM\u001d\u0011\u0002\u0019\t\u0014xn[3s\u0007>tg-[4\u0011\u00051*\u0016B\u0001, \u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB\u0011A&W\u0005\u00035~\u0011aBU3qY&\u001c\u0017-T1oC\u001e,'/A\u0003rk>$\u0018\r\u0005\u0002-;&\u0011al\b\u0002\r%\u0016\u0004H.[2b#V|G/Y\u0001\u0018[\u0016$\u0018\rZ1uCZ+'o]5p]N+\b\u000f\u001d7jKJ\u00042AJ1d\u0013\t\u0011wEA\u0005Gk:\u001cG/[8oaA\u0011A\r[\u0007\u0002K*\u0011amZ\u0001\u0007G>lWn\u001c8\u000b\u0005\u0001Z\u0015BA5f\u0005=iU\r^1eCR\fg+\u001a:tS>t\u0017A\u0002\u001fj]&$h\b\u0006\u0005m[:|\u0007/\u001d:t!\ta\u0003\u0001C\u00036\u0013\u0001\u0007a\u0007C\u0003B\u0013\u0001\u0007!\tC\u0003F\u0013\u0001\u0007q\tC\u0003T\u0013\u0001\u0007A\u000bC\u0003X\u0013\u0001\u0007\u0001\fC\u0003\\\u0013\u0001\u0007A\fC\u0003`\u0013\u0001\u0007\u0001-A\u0004nCb<\u0016-\u001b;\u0016\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\t1\fgn\u001a\u0006\u0002w\u0006!!.\u0019<b\u0013\ti\bPA\u0004J]R,w-\u001a:\u0002\u00115\f\u0007pV1ji\u0002\n\u0001\"\\5o\u0005f$Xm]\u0001\n[&t')\u001f;fg\u0002\n\u0001\"\\1y\u0005f$Xm]\u0001\n[\u0006D()\u001f;fg\u0002\n\u0011BZ3uG\"\u001c\u0016N_3\u0002\u0015\u0019,Go\u00195TSj,\u0007%\u0001\u000fjgR\u0013XO\\2bi&|gn\u00148GKR\u001c\u0007nU;qa>\u0014H/\u001a3\u0016\u0005\u0005=\u0001c\u0001\u0014\u0002\u0012%\u0019\u00111C\u0014\u0003\u000f\t{w\u000e\\3b]\u0006i\u0011N\\5uS\u0006$Xm\u00117pg\u0016$\"!!\u0007\u0011\u0007\u0019\nY\"C\u0002\u0002\u001e\u001d\u0012A!\u00168ji\u0006)1\r\\8tK\u0006q!M]8lKJ,e\u000e\u001a)pS:$HCAA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016C\u000591\r\\;ti\u0016\u0014\u0018\u0002BA\u0018\u0003S\u0011aB\u0011:pW\u0016\u0014XI\u001c3Q_&tG/A\u0003gKR\u001c\u0007\u000e\u0006\u0003\u00026\u0005M\u0003\u0003CA\u001c\u0003{\t\t%a\u0013\u000e\u0005\u0005e\"bAA\u001eO\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0012\u0011\b\u0002\u0004\u001b\u0006\u0004\b\u0003BA\"\u0003\u000fj!!!\u0012\u000b\u0005\u0019\\\u0015\u0002BA%\u0003\u000b\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000e\u0005\u0003\u0002N\u0005=S\"\u0001\u0001\n\u0007\u0005ESFA\u0005GKR\u001c\u0007\u000eR1uC\"9\u0011Q\u000b\fA\u0002\u0005]\u0013\u0001\u00044fi\u000eD'+Z9vKN$\b\u0003BA-\u0003KrA!a\u0017\u0002b5\u0011\u0011Q\f\u0006\u0005\u0003?\n)%\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\u0019'!\u0018\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005\u001d\u0014\u0011\u000e\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\t\u0019'!\u0018\u0002'\u0019,Go\u00195FCJd\u0017.Z:u\u001f\u001a47/\u001a;\u0015\r\u0005=\u0014QOA=!\r1\u0013\u0011O\u0005\u0004\u0003g:#\u0001\u0002'p]\u001eDq!a\u001e\u0018\u0001\u0004\t\t%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005mt\u00031\u0001\u0002~\u0005\u00112-\u001e:sK:$H*Z1eKJ,\u0005o\\2i!\r1\u0013qP\u0005\u0004\u0003\u0003;#aA%oi\u0006\tb-\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;\u0015\r\u0005=\u0014qQAE\u0011\u001d\t9\b\u0007a\u0001\u0003\u0003Bq!a\u001f\u0019\u0001\u0004\ti(A\u0006gKR\u001c\u0007n\u00144gg\u0016$H\u0003CA8\u0003\u001f\u000b\t*a%\t\u000f\u0005]\u0014\u00041\u0001\u0002B!9\u00111P\rA\u0002\u0005u\u0004bBAK3\u0001\u0007\u0011qN\u0001\u0011K\u0006\u0014H.[3ti>\u0013H*\u0019;fgR\fACZ3uG\",\u0005o\\2i\u000b:$wJ\u001a4tKR\u001cH\u0003BAN\u0003\u0007\u0004\u0002\"a\u000e\u0002>\u0005\u0005\u0013Q\u0014\t\u0005\u0003?\u000biL\u0004\u0003\u0002\"\u0006]f\u0002BAR\u0003gsA!!*\u00022:!\u0011qUAX\u001d\u0011\tI+!,\u000f\u0007e\nY+C\u0001P\u0013\tie*\u0003\u0002#\u0019&\u0011amS\u0005\u0005\u0003k\u000b)%A\u0004nKN\u001c\u0018mZ3\n\t\u0005e\u00161X\u0001!\u001f\u001a47/\u001a;G_JdU-\u00193fe\u0016\u0003xn\u00195SKN\u0004xN\\:f\t\u0006$\u0018M\u0003\u0003\u00026\u0006\u0015\u0013\u0002BA`\u0003\u0003\u0014a\"\u00129pG\",e\u000eZ(gMN,GO\u0003\u0003\u0002:\u0006m\u0006bBAc5\u0001\u0007\u0011qY\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b\u0003CA\u001c\u0003{\t\t%!3\u0011\t\u00055\u00131Z\u0005\u0004\u0003\u001bl#!C#q_\u000eDG)\u0019;b\u0003)\u0011W/\u001b7e\r\u0016$8\r\u001b\u000b\u0005\u0003'\f)\u0010\u0005\u0004\u0002V\u0006\r\u0018\u0011\u001e\b\u0005\u0003/\fyN\u0004\u0003\u0002Z\u0006ugbA\u001d\u0002\\&\t!%\u0003\u0002!C%\u0019\u0011\u0011]\u0010\u0002+\u0005\u00137\u000f\u001e:bGR4U\r^2iKJ$\u0006N]3bI&!\u0011Q]At\u0005Q\u0011Vm];mi^KG\u000f\u001b)beRLG/[8og*\u0019\u0011\u0011]\u0010\u0011\u000b\u0019\nY/a<\n\u0007\u00055xE\u0001\u0004PaRLwN\u001c\t\u0005\u0003+\f\t0\u0003\u0003\u0002t\u0006\u001d(\u0001\u0004*fa2L7-\u0019$fi\u000eD\u0007bBAc7\u0001\u0007\u0011q\u001f\t\t\u0003o\ti$!\u0011\u0002zB\u0019A&a?\n\u0007\u0005uxDA\nQCJ$\u0018\u000e^5p]\u001a+Go\u00195Ti\u0006$X-\u0001\ftQ>,H\u000e\u001a$pY2|w/\u001a:UQJ|G\u000f\u001e7f)!\tyAa\u0001\u0003\u0006\t%\u0001\"B.\u001d\u0001\u0004a\u0006b\u0002B\u00049\u0001\u0007\u0011\u0011`\u0001\u000bM\u0016$8\r[*uCR,\u0007bBA<9\u0001\u0007\u0011\u0011I\u0001\ti>\u001cFO]5oOR\ta\u0007")
public class RemoteLeaderEndPoint
implements LeaderEndPoint,
Logging {
    private final BlockingSend blockingSender;
    private final FetchSessionHandler fetchSessionHandler;
    private final KafkaConfig brokerConfig;
    private final ReplicaManager replicaManager;
    private final ReplicaQuota quota;
    private final Function0<MetadataVersion> metadataVersionSupplier;
    private final Integer maxWait;
    private final Integer minBytes;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public FetchSessionHandler fetchSessionHandler() {
        return this.fetchSessionHandler;
    }

    private Integer maxWait() {
        return this.maxWait;
    }

    private Integer minBytes() {
        return this.minBytes;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    @Override
    public boolean isTruncationOnFetchSupported() {
        return ((MetadataVersion)this.metadataVersionSupplier.apply()).isTruncationOnFetchSupported();
    }

    @Override
    public void initiateClose() {
        this.blockingSender.initiateClose();
    }

    @Override
    public void close() {
        this.blockingSender.close();
    }

    @Override
    public BrokerEndPoint brokerEndPoint() {
        return this.blockingSender.brokerEndPoint();
    }

    @Override
    public Map<TopicPartition, FetchResponseData.PartitionData> fetch(FetchRequest.Builder fetchRequest) {
        ClientResponse clientResponse;
        try {
            clientResponse = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequest);
        }
        catch (Throwable t) {
            this.fetchSessionHandler().handleError(t);
            throw t;
        }
        ClientResponse clientResponse2 = clientResponse;
        FetchResponse fetchResponse = (FetchResponse)clientResponse2.responseBody();
        if (!this.fetchSessionHandler().handleResponse(fetchResponse, clientResponse2.requestHeader().apiVersion())) {
            Errors errors = fetchResponse.error();
            Errors errors2 = Errors.FETCH_SESSION_TOPIC_ID_ERROR;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                throw Errors.forCode((short)fetchResponse.error().code()).exception();
            }
            return Map$.MODULE$.empty();
        }
        return (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)fetchResponse.responseData(this.fetchSessionHandler().sessionTopicNames(), clientResponse2.requestHeader().apiVersion())).asScala();
    }

    @Override
    public long fetchEarliestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffset(topicPartition, currentLeaderEpoch, -2L);
    }

    @Override
    public long fetchLatestOffset(TopicPartition topicPartition, int currentLeaderEpoch) {
        return this.fetchOffset(topicPartition, currentLeaderEpoch, -1L);
    }

    private long fetchOffset(TopicPartition topicPartition, int currentLeaderEpoch, long earliestOrLatest) {
        ListOffsetsRequestData.ListOffsetsTopic topic = new ListOffsetsRequestData.ListOffsetsTopic().setName(topicPartition.topic()).setPartitions(Collections.singletonList(new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(topicPartition.partition()).setCurrentLeaderEpoch(currentLeaderEpoch).setTimestamp(earliestOrLatest)));
        MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier.apply();
        ListOffsetsRequest.Builder requestBuilder = ListOffsetsRequest.Builder.forReplica((short)metadataVersion.listOffsetRequestVersion(), (int)this.brokerConfig.brokerId()).setTargetTimes(Collections.singletonList(topic));
        ListOffsetsResponse response = (ListOffsetsResponse)this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)requestBuilder).responseBody();
        ListOffsetsResponseData.ListOffsetsPartitionResponse responsePartition = (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$1(topicPartition, x$1))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchOffset$2(topicPartition, x$2))).get();
        Errors errors = Errors.forCode((short)responsePartition.errorCode());
        if (!Errors.NONE.equals(errors)) {
            throw errors.exception();
        }
        long l = metadataVersion.isAtLeast(MetadataVersion.IBP_0_10_1_IV2) ? responsePartition.offset() : Predef$.MODULE$.Long2long((Long)responsePartition.oldStyleOffsets().get(0));
        return l;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        if (partitions.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skipping leaderEpoch request since all partitions do not have an epoch");
            return Map$.MODULE$.empty();
        }
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection(partitions.size());
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, epochData) -> BoxesRunTime.boxToBoolean((boolean)RemoteLeaderEndPoint.$anonfun$fetchEpochEndOffsets$2(topics, topicPartition, epochData));
        Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        OffsetsForLeaderEpochRequest.Builder epochRequest = OffsetsForLeaderEpochRequest.Builder.forFollower((short)((MetadataVersion)this.metadataVersionSupplier.apply()).offsetForLeaderEpochRequestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)topics, (int)this.brokerConfig.brokerId());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Sending offset for leader epoch request ").append(epochRequest).toString());
        try {
            ClientResponse response = this.blockingSender.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)epochRequest);
            OffsetsForLeaderEpochResponse responseBody = (OffsetsForLeaderEpochResponse)response.responseBody();
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Received leaderEpoch response ").append(response).toString());
            return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)responseBody.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)offsetForLeaderTopicResult -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(offsetForLeaderTopicResult.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)offsetForLeaderPartitionResult -> {
                TopicPartition tp = new TopicPartition(offsetForLeaderTopicResult.topic(), offsetForLeaderPartitionResult.partition());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), offsetForLeaderPartitionResult);
            }, Buffer$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (Throwable t) {
            this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Error when sending leader epoch request for ").append(partitions).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            Errors error = Errors.forException((Throwable)t);
            return (Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                TopicPartition tp = (TopicPartition)x0$1._1();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(tp.partition()).setErrorCode(error.code()));
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitions) {
        None$ none$;
        void forKeyValue$extension_f;
        void forKeyValue$extension_$this;
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        FetchSessionHandler.Builder builder = this.fetchSessionHandler().newBuilder(partitions.size(), false);
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topicPartition, fetchState) -> {
            if (fetchState.isReadyForFetch() && !this.shouldFollowerThrottle($this.quota, (PartitionFetchState)fetchState, (TopicPartition)topicPartition)) {
                try {
                    long logStartOffset = $this.replicaManager.localLogOrException((TopicPartition)topicPartition).logStartOffset();
                    Optional lastFetchedEpoch = this.isTruncationOnFetchSupported() ? OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(fetchState.lastFetchedEpoch().map((Function1 & Serializable & scala.Serializable)x$3 -> RemoteLeaderEndPoint.$anonfun$buildFetch$2(BoxesRunTime.unboxToInt((Object)x$3))))) : Optional.empty();
                    builder.add(topicPartition, new FetchRequest.PartitionData((Uuid)fetchState.topicId().getOrElse((Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID), fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch())), lastFetchedEpoch));
                    return BoxedUnit.UNIT;
                }
                catch (KafkaStorageException kafkaStorageException) {
                    return partitionsWithError.$plus$eq(topicPartition);
                }
            }
            return BoxedUnit.UNIT;
        };
        Map<TopicPartition, PartitionFetchState> map = Implicits$.MODULE$.MapExtensionMethods(partitions);
        if (Implicits$MapExtensionMethods$.MODULE$ == null) {
            throw null;
        }
        MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
        FetchSessionHandler.FetchRequestData fetchData = builder.build();
        if (fetchData.sessionPartitions().isEmpty() && fetchData.toForget().isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            MetadataVersion metadataVersion = (MetadataVersion)this.metadataVersionSupplier.apply();
            FetchRequest.Builder requestBuilder = FetchRequest.Builder.forReplica((short)(metadataVersion.fetchRequestVersion() >= 13 && !fetchData.canUseTopicIds() ? (short)12 : metadataVersion.fetchRequestVersion()), (int)this.brokerConfig.brokerId(), (int)Predef$.MODULE$.Integer2int(this.maxWait()), (int)Predef$.MODULE$.Integer2int(this.minBytes()), (java.util.Map)fetchData.toSend()).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())).removed(fetchData.toForget()).replaced(fetchData.toReplace()).metadata(fetchData.metadata());
            none$ = new Some((Object)new AbstractFetcherThread.ReplicaFetch(fetchData.sessionPartitions(), requestBuilder));
        }
        None$ fetchRequestOpt = none$;
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    private boolean shouldFollowerThrottle(ReplicaQuota quota, PartitionFetchState fetchState, TopicPartition topicPartition) {
        return !fetchState.isReplicaInSync() && quota.isThrottled(topicPartition) && quota.isQuotaExceeded();
    }

    public String toString() {
        return new StringBuilder(37).append("RemoteLeaderEndPoint(blockingSender=").append(this.blockingSender).append(")").toString();
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$1(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$1) {
        String string = x$1.name();
        String string2 = topicPartition$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffset$2(TopicPartition topicPartition$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$2) {
        return x$2.partitionIndex() == topicPartition$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$fetchEpochEndOffsets$2(OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection topics$1, TopicPartition topicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition epochData) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopic topic = topics$1.find(topicPartition.topic());
        if (topic == null) {
            topic = new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic());
            topics$1.add((ImplicitLinkedHashCollection.Element)topic);
        }
        return topic.partitions().add(epochData);
    }

    public static final /* synthetic */ Integer $anonfun$buildFetch$2(int x$3) {
        return BoxesRunTime.boxToInteger((int)x$3);
    }

    public RemoteLeaderEndPoint(String logPrefix, BlockingSend blockingSender, FetchSessionHandler fetchSessionHandler, KafkaConfig brokerConfig, ReplicaManager replicaManager, ReplicaQuota quota, Function0<MetadataVersion> metadataVersionSupplier) {
        this.blockingSender = blockingSender;
        this.fetchSessionHandler = fetchSessionHandler;
        this.brokerConfig = brokerConfig;
        this.replicaManager = replicaManager;
        this.quota = quota;
        this.metadataVersionSupplier = metadataVersionSupplier;
        Logging.$init$(this);
        this.logIdent_$eq(logPrefix);
        this.maxWait = brokerConfig.replicaFetchWaitMaxMs();
        this.minBytes = brokerConfig.replicaFetchMinBytes();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
    }
}

